/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.file.MpegEncoding;
import org.tritonus.sampled.file.MpegFileFormatType;
import org.tritonus.sampled.file.TAudioFileFormat;
import org.tritonus.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private static final int SYNC = -2097152;
    private static final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2DOT5L3, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L1}, {MpegEncoding.MPEG2DOT5L3, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L1}, {MpegEncoding.MPEG2L3, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L1}, {MpegEncoding.MPEG1L3, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L1}};
    private static final float[][] sm_afSamplingRates = new float[][]{{11025.0f, 12000.0f, 8000.0f}, {0.0f, 0.0f, 0.0f}, {22050.0f, 24000.0f, 16000.0f}, {44100.0f, 48000.0f, 32000.0f}};

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, null);
    }

    private AudioFileFormat getAudioFileFormat(InputStream inputStream, byte[] byArray) throws UnsupportedAudioFileException, IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2048);
        byte[] byArray2 = new byte[4];
        pushbackInputStream.read(byArray2);
        if (byArray2[0] == 73 | byArray2[0] == 105 && byArray2[1] == 67 | byArray2[1] == 99 && byArray2[2] == 89 | byArray2[2] == 121) {
            byte[] byArray3 = this.syncHeader(pushbackInputStream);
            byArray2[0] = byArray3[byArray3.length - 4];
            byArray2[1] = byArray3[byArray3.length - 3];
            byArray2[2] = byArray3[byArray3.length - 2];
            byArray2[3] = byArray3[byArray3.length - 1];
            pushbackInputStream.unread(byArray2);
        } else {
            pushbackInputStream.unread(byArray2);
        }
        int n = pushbackInputStream.read();
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        int n4 = pushbackInputStream.read();
        if ((n | n2 | n3 | n4) < 0) {
            throw new EOFException();
        }
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        if (byArray != null) {
            byArray[0] = (byte)n;
            byArray[1] = (byte)n2;
            byArray[2] = (byte)n3;
            byArray[3] = (byte)n4;
        }
        if ((n5 & 0xFFE00000) != -2097152) {
            throw new UnsupportedAudioFileException("not a MPEG stream: no sync bits");
        }
        int n6 = n5 >> 19 & 3;
        if (n6 == 1) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int n7 = n5 >> 17 & 3;
        if (n7 == 0) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong layer");
        }
        AudioFormat.Encoding encoding = sm_aEncodings[n6][n7 - 1];
        int n8 = n5 >> 10 & 3;
        if (n8 == 3) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        float f = sm_afSamplingRates[n6][n8];
        int n9 = n5 >> 6 & 3;
        int n10 = n9 == 3 ? 1 : 2;
        AudioFormat audioFormat = new AudioFormat(encoding, f, -1, n10, -1, -1.0f, true);
        return new TAudioFileFormat(MpegFileFormatType.MPEG, audioFormat, -1, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        byte[] byArray = new byte[4];
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, byArray);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    private byte[] syncHeader(PushbackInputStream pushbackInputStream) throws IOException {
        boolean bl = false;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2048];
        int n = 0;
        int n2 = 0;
        int n3 = this.readBytes(pushbackInputStream, byArray, 0, 3);
        if (n3 != 3) {
            throw new EOFException();
        }
        byArray2[0] = byArray[0];
        byArray2[1] = byArray[1];
        byArray2[2] = byArray[2];
        n2 += 3;
        n = byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] << 0 & 0xFF;
        do {
            n <<= 8;
            if (this.readBytes(pushbackInputStream, byArray, 3, 1) != 1) {
                throw new EOFException();
            }
            byArray2[n2] = byArray[3];
            ++n2;
        } while (!(bl = this.isSyncMark(n |= byArray[3] & 0xFF)));
        byte[] byArray3 = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            byArray3[n4] = byArray2[n4];
            ++n4;
        }
        return byArray3;
    }

    private boolean isSyncMark(int n) {
        boolean bl = false;
        boolean bl2 = bl = (n & 0xFFF00000) == -1048576;
        if (bl) {
            boolean bl3 = bl = (n >>> 10 & 3) != 3;
        }
        if (bl) {
            boolean bl4 = bl = (n >>> 17 & 3) != 0;
        }
        if (bl) {
            bl = (n >>> 19 & 3) != 1;
        }
        return bl;
    }

    private int readBytes(PushbackInputStream pushbackInputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            while (n2 > 0) {
                int n4 = pushbackInputStream.read(byArray, n, n2);
                if (n4 != -1) {
                    n3 += n4;
                    n += n4;
                    n2 -= n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new IOException("STREAM ERROR");
        }
        return n3;
    }
}

