<?php

 # Version: Clatter/1.0.4
 # http://kimihia.org.nz/projects/clatter/

 # w.php - rotation / monitor / viewer

 header('Cache-Control: no-cache');
 header('Pragma: no-cache');
 header('Last-Modified: '. gmdate("D, d M Y H:i:s") .' GMT');

 define('ourself', 'w.php'. ( $user ? "?user=".urlencode($user) : '' ) .'#h' );

 define('refresh_rate',    20); # seconds before refreshing
 define('maxage',         400); # maximum history in time.
 define('maxidle', refresh_rate * 5);
                                # how long before a user disappears
                                # from the user list
 define('maxlines',        25); # maximum number of text lines

 # ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- 

 include ('functions.php');

 # ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- 

function is_interesting($datestamp) {
 # works out whether a conversation item is interesting or not

 return ( $datestamp > time() - maxage );
 # more recent that the old age limit

}

function is_awake($datestamp) {
 # works out whether someone is still in the room.
 # maxidle takes into account the speed at which
 # the room refreshes, and lets them miss four
 # refreshes before they disappear

 return ( $datestamp > time() - maxidle );
 # more recent that the old age limit

}

 # ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- 

if ( $user ) {

  if ( $fh = fopen('user.csv', 'a') ) {
   fputcsv($fh, array(time(), neaten($user?$user:'bob')) );
   fclose($fh);
  } else {
   print 'could not store user -->';
  }

} # user

if ( isset($data_talk) ) unset($data_talk);
if ( $fh = fopen('talk.csv', 'r') ) {

  while ( $data = fgetcsv($fh, 4096) )
    if ( is_interesting($data[0]) )
     $data_talk[] = $data;
  fclose($fh);

  # make sure we don't have too much chatter
  if ( count($data_talk) > maxlines ) {
    # oops, too much
    # we need to weed something out

    # skip forward into the array
    for ( $loop_i = count($data_talk) - maxlines; $loop_i > 0; $loop_i-- )
      next($data_talk);

    # the old code that was here to create a new array was unnecessary.
    # by simply skipping the pointer into the array in the above loop we will
    # start at the correct place when we later display it on screen.

  }

} else {

  print 'could not read talk.csv input';
  exit();

} # fopen (r)

if ( isset($data_user) ) unset($data_user);
if ( $fh = fopen('user.csv', 'r') ) {

  while ( $data = fgetcsv($fh, 4096) )
    if ( is_awake($data[0]) )
     $data_user[] = array(time() - $data[0], $data[1]);

  fclose($fh);

  # if we are not alone in here...
  if ( is_array($data_user) ) {

    if ( isset($new_user) ) unset($new_user);

    # now to remove duplicates, leaving only one of each person
    for ( $i = count($data_user) ; $i >= 0 ; $i-- ) {
     $b_duplicate = FALSE;

     # new_user does not contain any duplicates
     for ( $j = count($new_user) ; $j >= 0 ; $j-- )
       if ( $data_user[$i][1] == $new_user[$j][1] ) {
        $b_duplicate = TRUE;
	break;
       } # fi

     if ( (!$b_duplicate) && strlen($data_user[$i][1]) )
      $new_user[] = $data_user[$i];

    } # for $i

    # swap arrays over
    $data_user = $new_user;
    unset($new_user);

    # sort the list alphabetically. comment this section if you want the
    # traditional sorted by idle
    usort($data_user, "sort_users");

  } # is_array

} else {

  print 'could not read user.csv input';
  exit();

} # fopen (r)

 # ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- 

if ( $magic == 'rotate' ) {

 if ( $fh = fopen('talk.csv', 'w') ) {

  # clear out talk.csv and write only the relevant conversation into it
  for ( ; list(,$data) = each($data_talk) ; )
   fputcsv($fh, $data);

  fclose($fh);

 } # fopen (w)
 else
  print 'could not do talk.csv output';

 if ( $fh = fopen('user.csv', 'w') ) {

  # clear out user.csv and write only the relevant conversation into it
  for ( ; list(,$data) = each($data_user) ; )
   fputcsv($fh, $data);

  fclose($fh);

 } # fopen (w)
 else
  print 'could not do user.csv output';

 exit();

} # magic

 # ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- 

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="en">

<head>

 <title>Clatter</title>

 <meta http-equiv="refresh" content="<?php print refresh_rate ?>; url=<?php print ourself; ?>" />
 <meta http-equiv="Page-Enter" content="revealTrans(Duration=2,Transition=5)">

</head>

<body>

 <table width="100%" border="1" bordercolor="black" cellspacing="0" cellpadding="10">
 <tr>
  <td width="25%" valign="top" bgcolor="<?php

$background_colour = ( !is_array($data_talk) ? 'darkslateblue' : 'lightsteelblue' );

print $background_colour; ?>"><h1>Clatter</h1><ul><?php

if ( !is_array($data_user) )
 print '<li><em>the room is empty...</em></li>';
else
 for ( reset($data_user) ; list(,$data) = each($data_user) ; ) {
  list($idle, $user) = $data;
  print '<li title="idle '. $idle .' sec">'. $user .'</li>';
 }

  ?></ul></td>
  <td width="75%" valign="top" bgcolor="<?php print $background_colour; ?>">
  <ul>
  <?php

if ( !is_array($data_talk) )
 print '<li><em>nothing is stirring...</em></li>';
else
 # don't reset the data, or we will show too many comments
 for ( ; list(,$data) = each($data_talk) ; )
  print '<li><strong>'. $data[1] .'</strong>:&nbsp;'. $data[2] .'</li>';

  ?>

  </ul>
  <a id="h" name="h"></a>
  </td>
 </tr>
 </table>

</body>

</html>
