#!/usr/bin/perl
# Parse the form input.
&get_form;
#######################################################
#-----------------------------------------------------#
#          BS Text Gradient (version 1.0)             #
#-----------------------------------------------------#
# Copyright 1999 Brian Stanback  All Rights Reserved. #
#                                                     #
# Email: webmaster@stanback.net                       #
# Webpage: http://www.stanback.net                    #
#-----------------------------------------------------#
# You are free to change this script in any way you   #
# want, as long as the copyright and this message     #
# remain intact.  I will not be held responsable for  #
# any damage this script may cause. If you use this   #
# script I would  appreciate a link back to my site   #
# (stanback.net).  Enjoy! :-)                         #
#######################################################

# This script will take in a text string, red, blue, and green
# colors and return a "text gradient".  In other words, the text 
# string will fade from one selected color to the other.  This
# script does not require ssi.
# You shouldn't need to change anything except the form action on
# the gradient.html should be pointing to this script on your server.

#########################
# Declare the variables #
#########################
$i = 0;

$text_string = "$FORM{'text'}";
$num_chars = length($text_string);

$red1 = $FORM{'red1'};
$green1 = $FORM{'green1'};
$blue1 = $FORM{'blue1'};

$red2 = $FORM{'red2'};
$green2 = $FORM{'green2'};
$blue2 = $FORM{'blue2'};

$text_style = $FORM{'txtstyle'};
$text_size = $FORM{'txtsize'};
$bold = $FORM{'bold'};

@hex = ("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F");

#########################################
# Don't change anything below this line #
#########################################
# Print the correct mime type.
print "Content-type: text/html\n\n";

# Check to see if the form input is valid.
if ($num_chars < 2) {&error};
if (($red1 =~ /\D/)|($red1 < 0)|($red1 > 255)) {&error};
if (($red2 =~ /\D/)|($red2 < 0)|($red2 > 255)) {&error};
if (($green1 =~ /\D/)|($green1 < 0)|($green1 > 255)) {&error};
if (($green2 =~ /\D/)|($green2 < 0)|($green2 > 255)) {&error};
if (($blue1 =~ /\D/)|($blue1 < 0)|($blue1 > 255)) {&error};
if (($blue2 =~ /\D/)|($blue2 < 0)|($blue2 > 255)) {&error};

# Get the color for each charactor.
foreach $char (split (//, $text_string))
{
	# Do it for red.
	$diff = $red1 - $red2;
	$interval = $diff / ($num_chars - 1);
	$red_clr = int ($red1 - $interval * $i);
	
	# Do it for green.
	$diff = $green1 - $green2;
	$interval = $diff / ($num_chars - 1);
	$green_clr = int ($green1 - $interval * $i);
	
	# Do it for blue.
	$diff = $blue1 - $blue2;
	$interval = $diff / ($num_chars - 1);
	$blue_clr = int ($blue1 - $interval * $i);
	
	&to_hex ($red_clr);
	$hex_red = "$hex1$hex2";
	
	&to_hex ($green_clr);
	$hex_green = "$hex1$hex2";
	
	&to_hex ($blue_clr);
	$hex_blue = "$hex1$hex2";
	
	# Print out the code.
	$text = "$text<font color=\"#$hex_red$hex_green$hex_blue\">$char</font>";
	
	$i++;
}

# Print out the html code.
print "<HTML>\n<HEAD>\n";
print "<TITLE>Gradient Maker Results</TITLE>\n";
print "</HEAD>\n";
print "<BODY BGCOLOR=\"#C5C5C5\" TEXT=\"#000000\">\n";
print "<div align=\"Center\">\n";
print "<br><h1>Text Gradient Maker Results...</h1>\n";
print "<hr width=\"95%\" size=\"1\">\n";

if ($text_style =~ /default/i)
{
	print "<font size=\"$text_size\">";
}
else
{
	print "<font face=\"$text_style\" size=\"$text_size\">";
}
if ($bold =~ /yes/i)
{
	print "<strong>";
}
print "$text<br>";
if ($bold =~ /yes/i)
{
	print "</strong>";
}
print "</font>\n";

print "<hr width=\"95%\" size=\"1\">\n";
print "<strong>Cut & paste the source below into your html:</strong><br>\n";
print "<textarea name=\"source_code\" rows=\"7\" cols=\"38\">\n";

if ($text_style =~ /default/i)
{
	print "<font size=\"$text_size\">";
}
else
{
	print "<font face=\"$text_style\" size=\"$text_size\">";
}
if ($bold =~ /yes/i)
{
	print "<strong>";
}
print "$text";
if ($bold =~ /yes/i)
{
	print "</strong>";
}
print "</font>";

print "</textarea>\n";
print "</div>\n";
print "</BODY>\n</HTML>\n";

# Exit the program.
exit (0);

# Print an error.
sub error
{
	print "<html>\n";
	print "<head><title>Error!</title></head>\n";
	print "<body bgcolor=\"#C5C5C5\" text=\"#000000\">\n";
	print "<center>\n";
	print "<br><h1>Error In Form Input!</h1>\n";
	print "</center>\n";
	print "</body></html>\n";
	exit(0);
}

# Transfer RGB to hex.
sub to_hex
{
local $i, $n;
	$n = @_[0];
	$i = int ($n / 16);
	$hex1 = @hex[$i];
	$i = int ($n - 16 * $i);
	$hex2 = @hex[$i];
}

# Get the form input.
sub get_form
{
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	@pairs = split(/&/, $buffer);
	foreach $pair (@pairs) 
	{
		($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value =~ s/\|/ /g;
		$value =~ s/\&/ /g;
		$value =~ s/</ /g;
		$value =~ s/>/ /g;
		$value =~ s/\n/ /g;
		$value =~ s/<!--(.|\n)*-->/ /g;
		$FORM{$name} = $value;
	}
}
