#!/usr/bin/perl
########################################################
#		UniCount by Evil                       #
#              Copyright (c) 2000                      #
#	       	macabre@cfl.rr.com	               #
#        (http://unicount.linuxguru.net/)              #
########################################################




# log_file is the logical path to the log file
# you specified in conf.h
$log_file	= "/var/www/htdocs/.unicount.log";

# counter_file is the path to the counter data 
# file you specified in conf.h
$counter_file	= "/var/www/htdocs/.unicount.dat";





########################################################
# DO NOT EDIT ANYTHING BELOW THIS UNLESS YOU ARE       #
# ABSOLUTELY SURE WHAT YOU ARE DOING!                  #
########################################################
$version = "1.4.0";
$i = 0; # generic counter
$total_hits = 0;
open(LOG,"<$log_file") || error_out("Can't open $log_file: $!\n");
open(DATA,"<$counter_file") || error_out("Can't open $counter_file: $!\n");
@LOGS  = <LOG>;
$LOGS_COUNT = @LOGS;
@DATAS = <DATA>;
$DATAS_COUNT = @DATAS;

close(LOG);
close(DATA);

print_header();

sub error_out {
$reason = shift;
print "Content-type: text/html\n\n";
print <<"ERROR";
  <!doctype html public "-//W3C//DTD HTML 4.0 Transitional//EN">
  <html lang="en">
  <head>
  <title>UniCount Statistics</title>
  <meta http-equiv="pragma" content="no-cache">
  </head>
  <body text="#0000FF" bgColor="#FFFFFF" link="#0000FF" vlink="#6A6A6A" alink="#FF0000">
  <h1>$reason</h1>
  </body>
  </html>
ERROR
exit 1;
}

sub print_header {

print "Content-type: text/html\n\n";
print <<"1";
<!doctype html public "-//W3C//DTD HTML 4.0 Transitional//EN">
<html lang="en">
<head>
<title>UniCount v$version Statistics</title>
<meta http-equiv="pragma" content="no-cache">
<style type=\"text/css\">
<!--
#box {	border-style : groove;
	border-size  : 3px;
	border-height : 3px;
	border-width : 3px;
	border-color : #9A9A9A;
}	
<!-- end -->
</style>
</head>
<body text="#FFFFFF" bgColor="#5A5A5A" link="#00BBFF" vlink="#0011CC" alink="#FF0000">
<div align="center">
<h1 id=\"box\">UniCount v$version Statistics:</h1>
<br><hr width="350"><br>
<table id="box" border="0" cellpadding="2" cellspacing="3">
<tr align="center"><th colspan="3">Hit Statistics - $DATAS_COUNT entrie(s)</th></tr>
<tr align="left"><th colspan="2">Website</th><th>Document</th><th>Number of Hits</th></tr>
1
foreach $line(@DATAS) {
  $i++;
  ($website,$file,$hits) = split(/:/,$line,3);
  $total_hits += $hits;
  print "<tr align=\"left\">";
  $color_1 =  "<td bgColor=\"#616161\">$website</td><td bgColor=\"#6A6A6A\"><a href=\"$file\">$file</a></td><td bgColor=\"#000000\">$hits</td></tr>\n";
  $color_2 =  "<td bgColor=\"#616161\">$website</td><td bgColor=\"#000000\"><a href=\"$file\">$file</a></td><td bgColor=\"#6A6A6A\">$hits</td></tr>\n";
  print "<td bgColor=\"#2A2A2A\">$i</td>";
  $i%2 == 0 ? print $color_1 : print $color_2;
  
}
print "<tr align=\"center\"><td>&nbsp;</td><td>&nbsp;</td><th colspan=\"2\" align=\"left\">$total_hits total</th></tr>\n";
print <<"2";
</table>
<br><hr width="350"><br>
<table id="box" border="0" cellpadding="2" cellspacing="3">
<tr align="center"><th colspan="5">Log Statistics - $LOGS_COUNT entrie(s)</th></tr>
<tr align="left"><th colspan=\"2\">Date/Time</th><th>File Visited</th><th>IP Address/Port</th><th>Browser</th></tr>
2
$i = 0; # reset counter
foreach $line(@LOGS) {
  $i++;
  ($_date,$file,$ip,$browser) = split(/#/,$line,5);
  ($ip_addr,$port) = split(/:/,$ip,2);
  print "<tr align=\"left\">";
  $color_1 =  "<td bgColor=\"#6A6A6A\">$_date</td><td bgColor=\"#6A6A6A\"><a href=\"$file\">$file</a></td><td bgColor=\"#000000\">$ip_addr&nbsp;<b>/</b>&nbsp;$port</td><td bgColor=\"#000000\">$browser</td></tr>\n";
  $color_2 =  "<td bgColor=\"#000000\">$_date</td><td bgColor=\"#000000\"><a href=\"$file\">$file</a></td><td bgColor=\"#6A6A6A\">$ip_addr&nbsp;<b>/</b>&nbsp;$port</td><td bgColor=\"#6A6A6A\">$browser</td></tr>\n"; 
  print "<td bgColor=\"#2A2A2A\">$i</td>";
  $i%2 == 0 ? print $color_1 : print $color_2;
}
print <<"3";
</table>
<br><hr width="350"><br>
<address>UniCount v$version by Evil (<a href="mailto:macabre\@cfl.rr.com?subject=UniCount">macabre\@.cfl.rr.com</a>)</address>
<font size="-2">Copyright&copy; 2000 macabre\@cfl.rr.com<br>Licensed under the GNU General Public License</font>
<br><br>
</div>
</body>
</html>
3
exit 0;
}

__END__
