/*******************************
 * output.h: $Date: 2000/04/14 18:58:16 $
 * $Header: /root/Projects/unicount/RCS/output.h,v 1.3 2000/04/14 18:58:16 root Exp root $
 *
 * Changes Log:
 * $Log: output.h,v $
 * Revision 1.3  2000/04/14 18:58:16  root
 * Remove print_date()
 *
 * Revision 1.2  2000/02/14 07:03:14  root
 * Transfered function prototypes from unicount.c
 *
 * Revision 1.1  2000/02/14 06:59:44  root
 * Initial revision
 *
 */

#define _VERSION_ "1.4.0"
#if !defined(STDIO_H)
# include <stdio.h>
#endif

#if !defined(CONF_H)
# include "conf.h"
#endif
#if !defined(UNICOUNT_H)
# include "unicount.h"
#endif

#define DEBUG_INFO(f,l) { \
fprintf(stdout, \
"\n<pre>\n" \
"-------------------------------------------------------\n" \
"Debugging Information:\n" \
"\n\t- CGI Environment variables:\n" \
"\t\tQUERY_STRING = %s\n" \
"\t\tDOCUMENT_URI = %s\n" \
"\t\tHTTP_HOST    = %s\n" \
"\n\t- Macros as defined in conf.h:\n" \
"\t\tCOUNTER_DATA_FILE = %s\n" \
"\t\tLOGGING_FILE      = %s\n" \
"\n\t- System information:\n" \
"\t\tError number      = %d\n" \
"\t\tError description = %s\n" \
"\n\t- File information:\n" \
"\t\t<font color=\"#FF0000\">Approximate location of error: %s, line %d/%d</font>\n" \
"-------------------------------------------------------\n" \
"</pre>\n" \
,getenv("QUERY_STRING"),getenv("DOCUMENT_URI"),getenv("HTTP_HOST"),COUNTER_DATA_FILE, \
LOGGING_FILE,errno,sys_errlist[errno],f,(l-4),(l-3));}

#define CONSOLE_DEBUG_INFO {fprintf(stdout,"Passed ->%s:%d\n",__FILE__,__LINE__);}

extern void print_mime_header(void);
extern void print_version(void);
extern void script_error(char *, int, const char *, const char *, int);
extern void print_image(int);
extern void print_counter(int, long);
extern void print_text(int);
extern void print_html_comment(void);
extern void print_html_comment_footer();
extern void print_digit_tense(char, char);
extern void print_digit_tense_image(char, char);
extern void print_compile_time(char *);
