#!/bin/sh
#
# Simple installation script for UniCount
# - Evil (macabre@cfl.rr.com)
###########################################

FILE_ARRAY="Makefile include/conf.h include/unicount.h include/output.h include/logger.h include/access.h source/unicount.c source/output.c source/logger.c source/access.c"

# Check for argument
if [ ! $1 ]; then
  echo "Usage: $0 <destination directory>"
  exit 0
fi

# Make sure $1 is a directory
if [ ! -d $1 ]; then
  echo "*** $1 is not a directory. Installation aborted."
  exit 1
fi

echo "Beginning UniCount[1.4.0] installation process..."
echo "------------------------------------------"

# Check to make sure each file needed still exists:
for fname in $FILE_ARRAY ;
do
  if [ ! -e $fname ]; then
    echo "*** $fname not found. Installation aborted."
    exit 1
  fi
done

# Run 'make', exiting if an error occured
make all

if [ $? != 0 ]; then
  echo "*** Installation aborted due to compilation errors."
  exit 1
fi

mv unicount.cgi $1

# Clean up
make clean

echo "------------------------------------------"
echo "Installation complete.                    "
echo "You now have \"unicount.cgi\" in: $1      "
echo "------------------------------------------"
echo "Thank you for using UniCount!             "
# Install.sh #
