/*********************************************
 * unicount.c: $Date: 2000/08/16 16:51:00 $
 * $Header: /usr/src/Projects/unicount/RCS/unicount.c,v 1.1 2000/08/16 16:51:00 macabre Exp $
 *
 * unicount.c ($Author: macabre $)
 * Written by Evil (macabre@cfl.rr.com)
 * Copyright(c) 2000 macabre@cfl.rr.com
 * Licensed under the GNU license agreement.
 * For help on configuring, and installing,
 * please see the README file contained with
 * this package.
 *
 * Changes Log:
 * $Log: unicount.c,v $
 * Revision 1.9  2000/08/16 16:51:00  macabre
 * Added multiple web _site_ support.
 *
 * Revision 1.8  2000/04/24 22:25:16  root
 * Added QUIET_MODE handling.
 *
 * Revision 1.7  2000/04/23 20:19:06  root
 * Redid increment_counter.
 * Now supports multiple documents.
 *
 * Revision 1.6  2000/04/14 19:50:34  root
 * Added MAKE_HYPER_LINK handling.
 *
 * Revision 1.5  2000/04/14 17:52:42  root
 * Added statements to handle IMAGE_PAD* macros.
 *
 * Revision 1.4  2000/03/02 01:58:19  root
 * Added chop() routine.
 *
 * Revision 1.3  2000/02/17 04:19:17  root
 * Changed COUNTER_STYLE handling to something more accurate.
 * Added print_html_* functions.
 * Tweaked the code alot.
 *
 * Revision 1.2  2000/02/17 02:23:53  root
 * Added too much to log. (RCS just sucks)
 *
 * Revision 1.1  2000/02/13 05:25:53  root
 * Initial revision
 *
 *********************************************/

static const char rcsid[] = {

    "$Source: /usr/src/Projects/unicount/RCS/unicount.c,v $ <--> $Id: unicount.c,v 1.1 2000/08/16 16:51:00 macabre Exp $"
};
static const char rcs_header[] = {

    "$Header: /usr/src/Projects/unicount/RCS/unicount.c,v 1.1 2000/08/16 16:51:00 macabre Exp $"
};
static const char rcs_author[] =
    { "$UniCount: - by Evil (macabre@cfl.rr.com) $" };

#include "unicount.h"
#include "conf.h"
#if !defined(OUTPUT_H)
# include "output.h"
#endif
#if !defined(LOGGER_H)
# include "logger.h"
#endif
#if !defined(ACCESS_H)
# include "access.h"
#endif
#if !defined(STDIO_H)
# include <stdio.h>
#endif
#if !defined(STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(STRING_H)
# include <string.h>
#endif
#if !defined(ERRNO_H)
# include <errno.h>
#endif
#if !defined(TEXT)
# define TEXT 0
#endif
#if !defined(IMAGE)
# define IMAGE 1
#endif
#if !defined(SYS_STAT_H)
#include <sys/stat.h>
#endif
#if !defined(SYS_TYPES_H)
#include <sys/types.h>
#endif
#if !defined(FCNTL_H)
#include <fcntl.h>
#endif
#if !defined(UNISTD_H)
#include <unistd.h>
#endif
#include <ctype.h>

int main(void)
{
    long new_number = 0;
    char *compileDate = __DATE__;
    char *pQuery = (char *) malloc(sizeof(char) * 1024);
#if defined(RESTRICT_ACCESS)
    int access = 0;
#endif

/* Access check */
#if defined(RESTRICT_ACCESS)
    access = check_access();
    switch (access) {
    case ACCESS_DENIED:{
	    print_mime_header();
	    print_html_comment();
	    fprintf(stdout, "<b>[</b>"
		    "*** UniCount[%s]: ACCESS FROM %s DENIED ***"
		    "<b>]</b>", _VERSION_, getenv("HTTP_HOST"));
	    print_html_comment_footer();
#if defined(WANT_DEBUG)
	    DEBUG_INFO(__FILE__, __LINE__)
#endif
		return -1;
	}
    case ACCESS_GRANTED:{
	    break;
	}
    case ACCESS_ERROR:{
	    break;
	}
    }
#endif


    /* Turn off buffering to STDOUT */
    setvbuf(stdout, NULL, _IONBF, 0);

    /* If no QUERY_STRING is present, set pQuery to
       UNICOUNT_DEFAULT */

    pQuery = getenv("QUERY_STRING");
    if ((pQuery == NULL) || (strlen(pQuery) > 0)) {
	pQuery = "UNICOUNT_DEFAULT";
    }

    /* First, let's log the visitor. */

    if (LOGGING == 1) {
	int log_status = log_remote_addr(pQuery);
	if (log_status == -1)
	    return -1;
    }

    /* Increment the counter, storing the new number in new_number */
    new_number = increment_counter();

/* QUIET_MODE */
#if defined(QUIET_MODE)
#if !defined(HAVE_PHP)
    print_mime_header();
#endif
    print_html_comment();
    fprintf(stdout, "<!-- quiet mode -->");
    print_html_comment_footer();
    return 0;
#endif
/* END QUIET_MODE */

    /* Report an error in increment_counter() if one occured */
    if (new_number == -1)
	return -1;

    /* Time to print the counter to the browser */
    /* IMAGE */
    if (tolower(COUNTER_STYLE[0]) == 'i') {
#if !defined(HAVE_PHP)
	print_mime_header();
#endif
	print_html_comment();

#if defined(MAKE_HYPER_LINK)
	fprintf(stdout,
		"<a href=\"%s\" style=\"text-decoration : none;\">",
		MAKE_HYPER_LINK);
#endif


#if defined(IMAGE_PADLEFT) && defined(IMAGE_PADRIGHT)
	fprintf(stdout, "<img src=\"%s/%s\" height=\"%d\" width=\"%d\""
		" hspace=\"%d\" vspace=\"%d\" border=\"%d\" alt=\"\">",
		IMAGE_PATH, IMAGE_PADLEFT, IMAGE_HEIGHT, IMAGE_WIDTH,
		IMAGE_HSPACE, IMAGE_VSPACE, IMAGE_BORDER);
#endif

	print_counter(IMAGE, new_number);

#if defined(IMAGE_PADLEFT) && defined(IMAGE_PADRIGHT)
	fprintf(stdout, "<img src=\"%s/%s\" height=\"%d\" width=\"%d\""
		" hspace=\"%d\" vspace=\"%d\" border=\"%d\" alt=\"\">",
		IMAGE_PATH, IMAGE_PADRIGHT, IMAGE_HEIGHT, IMAGE_WIDTH,
		IMAGE_HSPACE, IMAGE_VSPACE, IMAGE_BORDER);
#endif

	if (DISPLAY_DATE == 1) {
	    fprintf(stdout, " ");
	    fprintf(stdout, DISPLAY_DATE_TEXT);
	    print_compile_time(compileDate);
	}
#if defined(MAKE_HYPER_LINK)
	fprintf(stdout, "</a>");
#endif

	print_html_comment_footer();
    }
    /* TEXT */
    else if (tolower(COUNTER_STYLE[0]) == 't') {
	print_mime_header();
	print_html_comment();

#if defined(MAKE_HYPER_LINK)
	fprintf(stdout,
		"<a href=\"%s\" style=\"text-decoration : none;\">",
		MAKE_HYPER_LINK);
#endif

	print_counter(TEXT, new_number);
	if (DISPLAY_DATE == 1) {
	    fprintf(stdout, " ");
	    fprintf(stdout, DISPLAY_DATE_TEXT);
	    print_compile_time(compileDate);
	}
#if defined(MAKE_HYPER_LINK)
	fprintf(stdout, "</a>");
#endif

	print_html_comment_footer();
    } else {			/* UNDEFINED */
	print_mime_header();
	print_html_comment();
	script_error("COUNTER_STYLE not recognized", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    /* Exit Success */
    return 0;
}


/* declen returns the decimal length of a long integer */
int declen(long num)
{
    long i = 1;
    int p = 0;
    if (num < 10) {
	return 1;
    }				/* The while loop obviously won't work on 1 digit */
    if (num == 10) {
	return 2;
    }				/* While loop won't work on 10 */
    if ((num % 1000 == 0) || (num == 100)) {
	p++;
    }				/* Increment p for numbers divisible by 1000 and equal to 100 */
    while (i < num) {
	i *= 10;
	p++;
    }
    return p;
}


/* Increments the counter                                *
 * (Opens/reads/closes/opens/writes to COUNTER_DATA_FILE */
long increment_counter(void)
{
    int fd, fd2;		/* We need to use descriptors so we can use file locking routines */
    FILE *fp, *fp2;		/* These will point to the above file descriptors */
    /* Note: fd2/fp2 will be write locked */

    struct flock fl;		/* For fcntl() */
    char *uri = "", *hits = "";
    char buffer[1024];		/* for read */
    char buffer2[WEBPAGE_BUFFER][1024];
    char buffer3[1024];		/* for write back */
    char *doc_uri = "";
    char *query_string = "";
    char *site_index = "";
    long num = 0;
    int i = 0, j = 0;		/* counters */
    int query_string_exists = 0;
    int temp_fs;		/* File descriptor for creating non-existent files */

    /* Load the file locking structure */

    fl.l_type = F_WRLCK;	/* Write lock */
    fl.l_whence = SEEK_SET;	/* start of file */
    fl.l_start = 0;
    fl.l_len = 0;
    fl.l_pid = getpid();

    /*--------------------------------------------------------*/


    if ((doc_uri = getenv("DOCUMENT_URI")) == NULL) {
	print_mime_header();
	print_html_comment();
	script_error("No DOCUMENT_URI set", errno, sys_errlist[errno],
		     __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    if (!(query_string = getenv("QUERY_STRING"))
	|| (strlen(query_string) == 0))
	query_string = "UNICOUNT_DEFAULT";

    if ((temp_fs = open(COUNTER_DATA_FILE, O_CREAT, UNICOUNT_FILE_MODE)) <
	0) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to create COUNTER_DATA_FILE", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }
    close(temp_fs);

    if ((fd = open(COUNTER_DATA_FILE, O_RDONLY)) < 0) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to open COUNTER_DATA_FILE for reading", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    /* Create a binary stream that points to fd */
    /* It will be assigned to fp                */
    if ((fp = fdopen(fd, "r")) == NULL) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to create file stream pointer fp", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }


    while (1) {
	if ((fgets(buffer, 1024, fp)) == NULL) {
	    break;
	}

	i++;			// increment i for buffer2


	if (strstr(buffer, doc_uri) && strstr(buffer, query_string)) {
	    query_string_exists = 1;
	    site_index = strtok(buffer, ":");
	    uri = strtok(NULL, ":");
	    if ((strcmp(uri, doc_uri) == 0)
		&& (strcmp(site_index, query_string) == 0)) {
		if ((hits = strtok(NULL, ":")) != NULL) {
		    num = atol(hits);
		    num++;
		    sprintf(buffer2[i], "%s:%s:%ld\n", site_index, uri,
			    num);
		}
	    } else {
		if ((hits = strtok(NULL, ":")) != NULL)
		    sprintf(buffer2[i], "%s:%s:%s", site_index, uri, hits);
	    }
	} else {
	    sprintf(buffer2[i], "%s", buffer);
	}

    }
    fclose(fp);

    if (query_string_exists == 0) {
	sprintf(buffer2[++i], "%s:%s:1\n", query_string, doc_uri);
	num = 1;
    }

    if ((fd2 = open(COUNTER_DATA_FILE, O_WRONLY)) < 0) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to open COUNTER_DATA_FILE for writing", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    /* Set file lock: */
    fcntl(fd2, F_SETLKW, &fl);

    /* Create a binary stream that points to fd2 */
    /* It will be assigned to fp2                */
    if ((fp2 = fdopen(fd2, "w")) == NULL) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to create file stream pointer \'fp2\'", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    /* Let's print the buffer into fp2, one line at a time */
    for (; j < (i + 1); j++) {
	strcpy(buffer3, buffer2[j]);
	fprintf(fp2, "%s", buffer3);
    }

    /* Unlock the file: */
    fl.l_type = F_UNLCK;
    fcntl(fd2, F_SETLK, &fl);


    fclose(fp2);
    close(fd2);

    return num;
}

/* char to int conversion. Only meant for integers 0-9 *
 * (That's all we need for this package)               */
int ctoi(char c)
{
    switch (c) {
    case '0':{
	    return 0;
	}
    case '1':{
	    return 1;
	}
    case '2':{
	    return 2;
	}
    case '3':{
	    return 3;
	}
    case '4':{
	    return 4;
	}
    case '5':{
	    return 5;
	}
    case '6':{
	    return 6;
	}
    case '7':{
	    return 7;
	}
    case '8':{
	    return 8;
	}
    case '9':{
	    return 9;
	}
    default:{
	    return (int) c;
	}
    }
}
char *chop(char *string)
{
    register int i = 0;
    while (string[i] != '\0') {
	if (string[i] == '\n')
	    string[i] = '\0';
	i++;
    }
    return string;
}

/* unicount.c */
