/* output.c: $Date: 2000/04/22 05:13:03 $ *
 * $Header: /root/Projects/unicount/RCS/output.c,v 1.9 2000/04/22 05:13:03 root Exp root $ 
 *
 * Changes Log:
 * $Log: output.c,v $
 * Revision 1.9  2000/04/22 05:13:03  root
 * Added HAVE_PHP handling.
 *
 * Revision 1.8  2000/04/14 18:58:08  root
 * Removed print_date()
 *
 * Revision 1.7  2000/04/14 18:53:11  root
 * Added print_compile_time routine.
 *
 * Revision 1.6  2000/02/25 18:35:10  root
 * Fixed digit tense bug. Now checks ones and tens place.
 *
 * Revision 1.5  2000/02/23 04:52:09  root
 * Added print_digit_tense() function.
 *
 * Revision 1.4  2000/02/22 21:14:36  root
 * Added print_digit_tense functionality and handling.
 *
 * Revision 1.3  2000/02/14 06:58:45  root
 * Added more routines.
 *
 * Revision 1.2  2000/02/14 06:56:50  root
 * unicount output routines.
 *
 */

#include "output.h"
#if !defined(STDIO_H)
# include <stdio.h>
#endif
#if !defined(STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(CONF_H)
# include "conf.h"
#endif
#if !defined(UNICOUNT_H)
# include "unicount.h"
#endif
#if !defined(ERRNO_H)
# include <errno.h>
#endif

#if !defined(TEXT)
# define TEXT 0
#endif
#if !defined(IMAGE)
# define IMAGE 1
#endif


/* Prints MIME header */
void print_mime_header(void)
{
#if !defined(HAVE_PHP)
    fflush(stdout);
    fprintf(stdout, "Content-type: text/html\n\n");
    return;
#endif
    return;
}

/* Prints Version information */
void print_version(void)
{
    fprintf(stdout, "-------------------------------------------- \
                  \nGNU UniCount v%s SSI website hit counter (image/text) \
                  \n\tby Evil (macabre@cfl.rr.com) \
                  \n--------------------------------------------\n", _VERSION_);
}

/* I request politely that you do not change the output of the next two functions */
void print_html_comment(void)
{
    fprintf(stdout,
	    "<!-- GNU UniCount v%s by Evil [macabre@cfl.rr.com] -->",
	    _VERSION_);
}

void print_html_comment_footer(void)
{
    fprintf(stdout, "<!-- /GNU UniCount -->");
}

/* Outputs errors */
void script_error(char *user_desc, int errnum, const char *errdesc,
		  const char *filename, int line)
{
    fprintf(stdout, "<b>[</b>&nbsp;");
#if (defined(EMAIL_ADDR) && defined(EMAIL_SUBJECT))
    fprintf(stdout, "<a href=\"mailto:%s?subject=%s-> Err(%d): %s (%s)\">",
	    EMAIL_ADDR, EMAIL_SUBJECT, errnum, user_desc, errdesc);
#endif
    fprintf(stdout, "UniCount[%s] CGI Error <sup>%d</sup> -> \"%s\": %s",
	    _VERSION_, errnum, user_desc, errdesc);
#if (defined(EMAIL_ADDR) && defined(EMAIL_SUBJECT))
    fprintf(stdout, "</a>");
#endif
    fprintf(stdout, "&nbsp;<b>]</b>");

#if defined(WANT_DEBUG)
    DEBUG_INFO(filename, line)
#endif
}

/* Prints a graphic digit */
void print_image(int num)
{
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
    fprintf(stdout,
	    "<img src=\"%s/%d.%s\" style=\"%s\" height=\"%d\" width=\"%d\""
	    " hspace=\"%d\" vspace=\"%d\" border=\"%d\" alt=\"%d\">",
	    IMAGE_PATH, num, IMAGE_EXT, STYLE_SHEET, IMAGE_HEIGHT,
	    IMAGE_WIDTH, IMAGE_HSPACE, IMAGE_VSPACE, IMAGE_BORDER, num);
#else
    fprintf(stdout, "<img src=\"%s/%d.%s\" height=\"%d\" width=\"%d\""
	    " hspace=\"%d\" vspace=\"%d\" border=\"%d\" alt=\"%d\">",
	    IMAGE_PATH, num, IMAGE_EXT, IMAGE_HEIGHT, IMAGE_WIDTH,
	    IMAGE_HSPACE, IMAGE_VSPACE, IMAGE_BORDER, num);
#endif
}

/* Prints a text digit */
void print_text(int num)
{
    fprintf(stdout, "%d", num);
}

void print_counter(int style, long num)
{
    int count = 0;
    char buffer[256];


/* PRINT TEXT PORTION */
    if (style == TEXT) {
	/* First print padding, if any. */
	count = declen(num);

#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 0)
	fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif


#if defined(TEXT_SPACE_CHAR)

#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif

	fprintf(stdout, "%c", TEXT_SPACE_CHAR);


#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif

#endif

	while (count < COUNTER_PADDING) {

#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif
	    fprintf(stdout, "%d", 0);

#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "</span>");
#endif


#if defined(TEXT_SPACE_CHAR)
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif


	    fprintf(stdout, "%c", TEXT_SPACE_CHAR);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "</span>");
#endif
#endif


	    ++count;
	}

	count = 0;		/* Reset Counter */
	sprintf(buffer, "%ld", num);	/* Store num in buffer */
	while (count < declen(num)) {	/* Print each digit individually */
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif
	    print_text(ctoi(buffer[count]));
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "</span>");
#endif
#if defined(TEXT_SPACE_CHAR)
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif


	    fprintf(stdout, "%c", TEXT_SPACE_CHAR);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	    fprintf(stdout, "</span>");
#endif
#endif
	    count++;
	}
	/* Print the digit tense if set */
	if (PRINT_DIGIT_TENSE != 0) {
	    /* buffer[strlen(buffer)-1] == ones place */
	    /* buffer[strlen(buffer)-2] == tens place */
	    print_digit_tense(buffer[strlen(buffer) - 1],
			      buffer[strlen(buffer) - 2]);
	}
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 0)
	fprintf(stdout, "</span>");
#endif

    }
/* END PRINT TEXT PORTION */

/* PRINT IMAGE PORTION */

    if (style == IMAGE) {
	/* First print padding, if any. */
	count = declen(num);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 0)
	fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif
	while (count < COUNTER_PADDING) {
	    print_image(0);
	    count++;
	}
	count = 0;
	sprintf(buffer, "%ld", num);
	while (count < strlen(buffer)) {
	    print_image(ctoi(buffer[count]));
	    count++;
	}
	if (PRINT_DIGIT_TENSE != 0) {
	    print_digit_tense_image(buffer[strlen(buffer) - 1],
				    buffer[strlen(buffer) - 2]);
	}
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 0)
	fprintf(stdout, "</span>");
#endif
    }
/* END PRINT IMAGE PORTION */
}

void print_digit_tense(char ones, char tens)
{
    int o = ctoi(ones);
    int t = ctoi(tens);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif
    if (t == 1) {
	fprintf(stdout, DIGIT_TENSE_0);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 0) {
	fprintf(stdout, DIGIT_TENSE_0);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 1) {
	fprintf(stdout, DIGIT_TENSE_1);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 2) {
	fprintf(stdout, DIGIT_TENSE_2);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 3) {
	fprintf(stdout, DIGIT_TENSE_3);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o >= 4 && o <= 9) {
	fprintf(stdout, DIGIT_TENSE_4_9);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
}

void print_digit_tense_image(char ones, char tens)
{
    int o = ctoi(ones);
    int t = ctoi(tens);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
    fprintf(stdout, "<span style=\"%s\">", STYLE_SHEET);
#endif
    if (t == 1) {
	fprintf(stdout, "<img src=\"%s\" alt=\"th\">",
		IMAGE_DIGIT_TENSE_0);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 0) {
	fprintf(stdout, "<img src=\"%s\" alt=\"th\">",
		IMAGE_DIGIT_TENSE_0);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 1) {
	fprintf(stdout, "<img src=\"%s\" alt=\"st\">",
		IMAGE_DIGIT_TENSE_1);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 2) {
	fprintf(stdout, "<img src=\"%s\" alt=\"nd\">",
		IMAGE_DIGIT_TENSE_2);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o == 3) {
	fprintf(stdout, "<img src=\"%s\" alt=\"rd\">",
		IMAGE_DIGIT_TENSE_3);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
    if (o >= 4 && o <= 9) {
	fprintf(stdout, "<img src=\"%s\" alt=\"th\">",
		IMAGE_DIGIT_TENSE_4_9);
#if (defined(STYLE_SHEET) && STYLE_SHEET_SCOPE == 1)
	fprintf(stdout, "</span>");
#endif
	return;
    }
}


void print_compile_time(char *date)
{
    char month[4];
    int dom = 0, year = 0;

    sscanf(date, "%s%d%d", month, &dom, &year);

    /* These seems very archiac, but oh well.. */

    /* Lets print the month first */
    if (strcmp(month, "Jan") == 0) {
	fprintf(stdout, " January");
    }
    if (strcmp(month, "Feb") == 0) {
	fprintf(stdout, " February");
    }
    if (strcmp(month, "Mar") == 0) {
	fprintf(stdout, " March");
    }
    if (strcmp(month, "Apr") == 0) {
	fprintf(stdout, " April");
    }
    if (strcmp(month, "May") == 0) {
	fprintf(stdout, " May");
    }
    if (strcmp(month, "Jun") == 0) {
	fprintf(stdout, " June");
    }
    if (strcmp(month, "Jul") == 0) {
	fprintf(stdout, " July");
    }
    if (strcmp(month, "Aug") == 0) {
	fprintf(stdout, " August");
    }
    if (strcmp(month, "Sep") == 0) {
	fprintf(stdout, " September");
    }
    if (strcmp(month, "Oct") == 0) {
	fprintf(stdout, " October");
    }
    if (strcmp(month, "Nov") == 0) {
	fprintf(stdout, " November");
    }
    if (strcmp(month, "Dec") == 0) {
	fprintf(stdout, " December");
    }

    /* Now lets print the day of month, followed by digit tense */
    fprintf(stdout, " %d", dom);
    if (dom == 1) {
	fprintf(stdout, "st");
    } else if (dom == 2) {
	fprintf(stdout, "nd");
    } else if (dom == 3) {
	fprintf(stdout, "rd");
    } else if (dom == 11) {
	fprintf(stdout, "st");
    } else if (dom == 12) {
	fprintf(stdout, "nd");
    } else if (dom == 13) {
	fprintf(stdout, "rd");
    } else if (dom == 21) {
	fprintf(stdout, "st");
    } else if (dom == 22) {
	fprintf(stdout, "nd");
    } else if (dom == 23) {
	fprintf(stdout, "rd");
    } else if (dom == 31) {
	fprintf(stdout, "st");
    } else {
	fprintf(stdout, "th");
    }

    fprintf(stdout, ", %d", year);
}
