/* logger.c: $Date: 2000/04/13 19:25:50 $
 * $Header: /root/Projects/unicount/RCS/logger.c,v 1.3 2000/04/13 19:25:50 root Exp root $
 * 
 * Changes Log:
 * $Log: logger.c,v $
 * Revision 1.3  2000/04/13 19:25:50  root
 * Fixed a small bug with displaying the time.
 *
 * Revision 1.2  2000/02/28 21:19:46  root
 * Added/tweaked log_remote_addr() function.
 *
 * Revision 1.1  2000/02/28 05:20:22  root
 * Initial revision
 *
 */

#include "logger.h"
#if !defined(UNICOUNT_H)
# include "unicount.h"
#endif
#if !defined(OUTPUT_H)
# include "output.h"
#endif
#if !defined(STDIO_H)
# include <stdio.h>
#endif
#if !defined(STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(STRING_H)
# include <string.h>
#endif
#if !defined(CONF_H)
# include "conf.h"
#endif
#if !defined(ERRNO_H)
# include <errno.h>
#endif
#if !defined(TIME_H)
# include <time.h>
#endif
#if !defined(SYS_STAT_H)
#include <sys/stat.h>
#endif
#if !defined(SYS_TYPES_H)
#include <sys/types.h>
#endif
#if !defined(FCNTL_H)
#include <fcntl.h>
#endif
#if !defined(UNISTD_H)
#include <unistd.h>
#endif

int log_remote_addr(char *pSite)
{
    int fd;
    FILE *out;			/* out will point to fd */
    struct flock fl;		/* For locking the logging file */
    char *ipv4_Addr;
    char *pBrowser;
    char *pURI;
    char time_buffer[128];
    char *remotePort;
    time_t tp;
    struct tm *td;
    int remote_port = 0;
    int temp_fs;		/* File descriptor for creating non existent files */


    /* Let's set up our locking structure: */

    /* Load the file locking structure */

    fl.l_type = F_WRLCK;	/* Write lock */
    fl.l_whence = SEEK_SET;	/* start of file */
    fl.l_start = 0;
    fl.l_len = 0;
    fl.l_pid = getpid();

   /*--------------------------------------------------------*/


    /* Load tp with seconds since Epoch */
    tp = time(NULL);

    /* Load td structure with localtime */
    td = localtime(&tp);

    /* Check for remote port */
    if ((remotePort = getenv("REMOTE_PORT")) == NULL) {
	remotePort = "0";
    }
    remote_port = atoi(remotePort);

    /* Check for REMOTE_ADDR */
    ipv4_Addr = getenv("REMOTE_ADDR");
    if ((ipv4_Addr == NULL) || (*ipv4_Addr == '\0'))
	ipv4_Addr = "UNKNOWN IP";

    /* Check for HTTP_USER_AGENT */
    pBrowser = getenv("HTTP_USER_AGENT");
    if ((pBrowser == NULL) || (*pBrowser == '\0'))
	pBrowser = "UNKNOWN BROWSER";


    /* Check for DOCUMENT_URI  */
    pURI = getenv("DOCUMENT_URI");
    if ((pURI == NULL) || (*pURI == '\0'))
	pURI = "UNKNOWN URI";

    /* Load time_buffer with a readable time display */
    strftime(time_buffer, (size_t) 128, "%A, %B %d %Y %T", td);


    if ((temp_fs = open(LOGGING_FILE, O_CREAT, UNICOUNT_FILE_MODE)) < 0) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to create LOGGING_FILE", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }
    close(temp_fs);

    if ((fd = open(LOGGING_FILE, O_WRONLY)) < 0) {
	print_mime_header();
	script_error("Unable to open LOGGING_FILE for appending", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	return -1;
    }

    /* Set file lock: */
    fcntl(fd, F_SETLKW, &fl);

    /* Create a binary stream that points to fd */
    /* It will be assigned to out                */

    if ((out = fdopen(fd, "w")) == NULL) {
	print_mime_header();
	print_html_comment();
	script_error("Unable to create file stream pointer \'out\'", errno,
		     sys_errlist[errno], __FILE__, __LINE__);
	print_html_comment_footer();
	return -1;
    }

    /* Position cursor to the end of the file (O_APPEND) */
    fseek(out, 0, SEEK_END);

    fprintf(out, "%s#%s:%s#%s:%d#%s\n", time_buffer, pSite, pURI,
	    ipv4_Addr, remote_port, pBrowser);

    /* Unlock the file: */
    fl.l_type = F_UNLCK;
    fcntl(fd, F_SETLK, &fl);

    fclose(out);
    close(fd);
    return 0;
}

/* logger.c */
