/******************************
 * access.c: $Date: 2000/09/01 21:13:00 $
 * $Header: /usr/src/Projects/unicount/RCS/access.c,v 1.1 2000/09/01 21:13:00 macabre Exp $
 *
 * Changes Log:
 * $Log: access.c,v $
 * Revision 1.1  2000/09/01 21:13:00  macabre
 * Initial revision
 *
 */


#include "access.h"
#if !defined(CONF_H)
# include "conf.h"
#endif
#if !defined(OUTPUT_H)
# include "output.h"
#endif
#if !defined(UNICOUNT_H)
# include "unicount.h"
#endif
#if !defined(STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(STRING_H)
#  include <string.h>
#endif


int check_access(void)
{
    char *host = getenv("HTTP_HOST");
    char *segment;


#if !defined(RESTRICT_ACCESS) || !defined(RESTRICT_ACCESS_SITES)
    return ACCESS_ERROR;
#endif
    if ((host == NULL) || (strlen(host) == 0))
	return ACCESS_ERROR;

    if ((segment = strstr(RESTRICT_ACCESS_SITES, host)) == NULL)
	return ACCESS_DENIED;
    else {
	return ACCESS_GRANTED;
    }

    return ACCESS_DENIED;
}
