/*****************************************
 * conf.h: $Date: 2000/09/03 08:36:06 $
 * $Header: /usr/src/Projects/unicount/RCS/conf.h,v 1.1 2000/09/03 08:36:06 macabre Exp $
 *
 * Configuration file for unicount.c
 *
 * Currently >45< macros
 *****************************************/
/* Please edit each macro very carefully *
 *****************************************/


/* WEBPAGE_BUFFER
 * This allows you to alter the maximum number of web *
 * pages that UniCount will allocate memory for. The  *
 * default is 4,096. The maximum number allowed       *
 * depends on your system's memory.                   *
 * The actual number of bytes allocated is:           *
 * WEBPAGE_BUFFER x 1024                              */
#define WEBPAGE_BUFFER 4096


/* WANT_DEBUG                                            *
 * Uncomment the following line if you wish UniCount to  *
 * print extra debugging information on the web document *
 * upon error. Please not this will print information    *
 * that you may not want the world to see such as where  *
 * your UniCount data files are located.                 */
//#define WANT_DEBUG


/* RESTRICT_ACCESS
 * Uncomment the following line if you wish to use a list *
 * of websites which are allowed to execute unicount.cgi  *
 * This list will be specified next.                      *
 * Note: This utilizes the HTTP_HOST CGI ENV variable.    */
//#define RESTRICT_ACCESS


/* ALLOW_SITES                                         *
 * (If you uncommented RESTRICT_ACCESS)                *
 * This is a list of websites which will be allowed to *
 * run unicount.cgi. Any unlisted sites who attempt to *
 * execute unicount.cgi will instead see an error.     */

#define RESTRICT_ACCESS_SITES  "127.0.0.1" \
		    	       "jim.bob.com" \
                    	       "somewhere.else.net" \
                    	       "mydomain.com" \
			       "localhost"

/* HAVE_PHP                                              *
 * Uncomment the following line if you will be invoking  *
 * UniCount from within a PHP file. Leave it commented   *
 * out if it will be invoked from an SHTML file.         *
 * Note: See the README file for details on how to       *
 * invoke this script using PHP.                         */
//#define HAVE_PHP


/* QUIET_MODE                                               *
 * Uncomment the following line to use QUIET_MODE.          *
 * QUIET_MODE will do everything normal EXCEPT print any    *
 * visible output to the user. If you would like to keep    *
 * track of hits on your webpages without the user knowing  *
 * it, you should use this feature.                         *
 * To view the number of counts for each page, and the log  *
 * of each visitor, run unicount-view.pl                    *
 * Information on configuring/using unicount-vew.pl can be  *
 * found in the README file.                                */
//#define QUIET_MODE 


/* EMAIL_ADDR: your email address                        *
 * If an error occurs when processing UniCount, the      *
 * error message displayed will be a hyper-link to your  *
 * email address. Uncomment the following line if you    *
 * would like to use this feature.                       *
 * Please note that EMAIL_ADDR and EMAIL_SUBJECT must    *
 * both be defined to utilize this feature.              */
//#define EMAIL_ADDR "foo@bar.com" 


/* EMAIL_SUBJECT: Email subject to use                   */
#define EMAIL_SUBJECT "UniCount Error"


/* COUNTER_STYLE: must be "text" to utilize a text-counter,
 * or "image" to utilize an image counter.
 * When using an image counter, you must have 10 images:
 * 0.gif, 1.gif, 2.gif,...,9.gif which must be located
 * in IMAGE_PATH, which you will set very shortly.         */
#define COUNTER_STYLE   "text"


/* COUNTER_PADDING: must be an integer (0-10 preferably) *
 * This is the number of 0's you wish to display before  *
 * the actual hit-number is displayed. ie:               *
 * 0000000143                                            *
 * Set to 0 to disreguard                                */
#define COUNTER_PADDING 0


/* COUNTER_DATA_FILE: the logical path and filename of   *
 * where you wish to store your counter-data file.       *
 * This ascii file holds the number of hits you've had   *
 * in each document invoking UniCount                    *
 * and is necessary for UniCount to work.                *
 * You must create this file yourself, and this file     *
 * MUST be chmod'd to 666 or 777. This is a necessary    *
 * disadvantage, so make sure noone knows where this     *
 * file is stored.                                       * 
 * Examples for creating file and changing attributes:   *
 *                                                       *
 * bash$ echo "" > /www/htdocs/counter.dat               *
 * bash$ chmod 666 /www/htdocs/counter.dat               *
 * bash$ touch /www/htdocs/counter.dat                   *
 *                                                       */
#define COUNTER_DATA_FILE "/var/www/htdocs/.unicount.dat"


/* IMAGE_PATH: the virtual path to your image directory. *
 * This is the path to where your images (0.gif-9.gif)   *
 * are stored.                                           */
#define IMAGE_PATH   "http://127.0.0.1/images/silver"


/* IMAGE_PADLEFT and IMAGE_PADRIGHT: these are images *
 * that will be displayed on the immediate left and   *
 * right sides of the counter. This is useful         *
 * if you want your counter to appear as one image.   *
 * (If the counter has a border, for instance)       *
 * Note: COUNTER_STYLE must be defined as "image" and *
 * these must be uncommented to utilize this feature  */
//#define IMAGE_PADLEFT  "padleft.gif"
//#define IMAGE_PADRIGHT "padright.gif"


/* IMAGE_EXT: the file extension of your image files */
#define IMAGE_EXT    "png"


/* The predefined height of each image */
#define IMAGE_HEIGHT 15


/* The predefined width of each image */
#define IMAGE_WIDTH  15


/* The amount of horizontal space you want between each *
 * image.                                               */
#define IMAGE_HSPACE 0


/* The amount of vertical space you want above each     *
 * image.                                               */
#define IMAGE_VSPACE 0


/* The width of the border to display around each image *
 * Set to 0 to disreguard                               */
#define IMAGE_BORDER 0


/* STYLE_SHEET
 * Uncomment this if you would like to use your own style *
 * sheet with the counter. This macro will                *
 * be used with the text counter as well as the image     *
 * counter. The default value is very cool looking.       *
 * NOTE: This feature uses the <span> tag.                */
//#define STYLE_SHEET "text-decoration : overline; border-height : 5px; border-style : groove;"


/* STYLE_SHEET_SCOPE                                      *
 * This macro is used with STYLE_SHEET to define the      *
 * scope of how the style sheets will be used. Set this   *
 * to 0 if you would like STYLE_SHEET to be used with     *
 * the entire counter as a whole. Set this to 1           *
 * if you would like STYLE_SHEET used with each image/    *
 * text digit of the counter independantly.               */
#define STYLE_SHEET_SCOPE 0 


/* DISPLAY_DATE: Displays date of compilation           *
 * Must be 0 (not set) or 1 (set)                       */
#define DISPLAY_DATE 1


/* DISPLAY_DATE_TEXT: text to display between hitcount  *
 * and the compilation date                             */
#define DISPLAY_DATE_TEXT "visitor since"


/* TEXT_SPACE_CHAR: [optional] character to display       *
 * between each text digit. For appearance purposes only  *
 * If you want to use this feature, uncomment the         *
 * following #define line.                                */
//#define TEXT_SPACE_CHAR '-'


/*-------------------------------------------------------------*
 * PRINT_DIGIT_TENSE:                                          *
 * This makes the counter a little fancy and dynamic appearing *
 * by placing a superset "st" after the last digit if it is 1, *
 * "nd" after 2, "rd" after 3, and "th" after 4 through 9      *
 * Set this to 1 to use, 0 to nullify.                         *
 * Try it out!                                                 *
 *-------------------------------------------------------------*/
#define PRINT_DIGIT_TENSE 1


/*--------------------------------------------------*
 * These are used if PRINT_DIGIT_TENSE is set to 1  *  
 * You can customize these if you want, but I think *
 * the current setting is nice looking.             *
 *--------------------------------------------------*/
/* Text counters: */
#define DIGIT_TENSE_0    "<sup>th</sup>"
#define DIGIT_TENSE_1    "<sup>st</sup>"
#define DIGIT_TENSE_2    "<sup>nd</sup>"
#define DIGIT_TENSE_3    "<sup>rd</sup>"
#define DIGIT_TENSE_4_9  "<sup>th</sup>"
/* Image counters: */
#define IMAGE_DIGIT_TENSE_0    "http://127.0.0.1/images/th.gif"
#define IMAGE_DIGIT_TENSE_1    "http://127.0.0.1/images/st.gif"
#define IMAGE_DIGIT_TENSE_2    "http://127.0.0.1/images/nd.gif"
#define IMAGE_DIGIT_TENSE_3    "http://127.0.0.1/images/rd.gif"
#define IMAGE_DIGIT_TENSE_4_9  "http://127.0.0.1/images/th.gif"


/*--------------------------------------------------*
 * Set this to 1 if you would like UniCount to log  *
 * each visitor's IP address, browser, and date to  *
 * a parsable ascii log file.                       *
 *--------------------------------------------------*/
#define LOGGING 1


/*--------------------------------------------------*
 * This is the logical path to the file you wish to *
 * store IP addresses of each visitor.              *
 * (Provided LOGGING is set to 1)                   *
 * This file must also be chmod'd to 666 or 777     *
 *--------------------------------------------------*/
#define LOGGING_FILE "/var/www/htdocs/.unicount.log"


/* MAKE_HYPER_LINK:                               * 
 * Uncomment this to make the entire counter a    *
 * hyper-link to a URL of your choice.            *
 * Please note that if you have COUNTER_STYLE     *
 * set to "text", UniCount will use style sheets  *
 * to ensure the counter is not underlined.       */
//#define MAKE_HYPER_LINK "http://unicount.linuxguru.net/"


/* conf.h  - Thanks for using UniCount!  - Evil */
