<?php

/*
    Paul Gareau - paul@xhawk.net
    Copyright (C) 2001 - Paul Gareau
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


###################################################
# simplemb v.1.1.0
#
# to use put the following lines in your code:    #
#
#    include("simplemb.inc.php");                 
#    do_board();                                  
#
#                                                 #
# make sure your data file can be written to      #
# by your server!                                 #
#                                                 #
# you can customize the look and feel of the      #
# script by changing the following variables      #
###################################################


########################
# EDIT THESE VARIABLES #
########################

$filename = 'board.txt';;
$dark_background = '#DDDDDD';
$light_background = '#EEEEEE';
$sfont = $font2;

#################
# MAIN FUNCTION #
#################

function do_board($num=20)
{
    global $show,
    $mb_submit,
    $name,
    $message,
    $PHP_SELF;

    global $filename,
    $dark_background,
    $light_background,
    $lfont,
    $sfont;

    if($mb_submit && $name && $message)     //add post to data file
    {
        $name = stripslashes(strip_tags($name));
        $message = stripslashes(strip_tags($message));
        $message = ereg_replace("[[:space:]]+", ' ', $message);
        $message = str_replace("|", '', $message);

        $ary_date = getdate(time());
        $date = $ary_date['mon'].'.'.$ary_date['mday'].'.'.$ary_date['year'];
        $new = $name.'|'.$date.'|'.$message;

        $fp = fopen($filename, "a");
        fwrite($fp, $new."\n");
        fclose($fp);

        echo
        "$sfont\n".
        "Your message was posted.\n".
        "<a href='$PHP_SELF'>Return to board</a>.\n";
    }
    elseif($show=="form")     //show post form
    {
        echo
        "$sfont\n".
        "Enter your name and message, then press 'submit' to post.\n".
        "<br>\n".
        "HTML tags will be stripped from your post.\n".
        "<br>\n".
        "<a href='$PHP_SELF'>Return to guest book</a>\n".
        "<form action='$PHP_SELF' method='post'>\n".
        "<table border=0 cellpadding=0 cellspacing=0><tr><td>\n".
        "$sfont\n".
        "Name: <input type='text' name='name' size='20'>\n".
        "<br>\n".
        "Message:\n".
        "<br>\n".
        "<textarea rows=5 cols=40 name='message' wrap='virtual'></textarea>\n".
        "</tr></td><tr><td align='center'>\n".
        "$sfont\n".
        "<input type='submit' value='submit' name='mb_submit'>\n".
        "<input type='reset' value='clear'>\n".
        "</td></tr></table>\n".
        "</form>\n";
    }
    else     //show posts
    {
        $ary_board = file($filename);
        $num_lines = count($ary_board);
        echo "<table border=0 cellpadding=5 cellspacing=0 width='100%'>\n";
        for($line_num=($num_lines>$num)?$num_lines-$num:0; $line_num < $num_lines; $line_num++)
        {
            if(! ereg("^[[:space:]]+$", $ary_board[$line_num]))
            {
                $ary_fields = explode("|", $ary_board[$line_num]);
                $name = $ary_fields[0];
                $date = $ary_fields[1];
                $message = $ary_fields[2];

                if(++$line % 2) $color = $dark_background;
                else $color = $light_background;

                echo
                "<tr><td bgcolor='$color'>\n".
                "$sfont\n".
                "<b>$name - $date</b>\n".
                "<br>\n".
                "$message\n".
                "</td></tr>\n";
            }
        }
        echo
        "</table><br>\n".
        "$sfont <a href='$PHP_SELF?show=form'>Post a message</a>\n";
    }
} //end function

?>

