// Scrolling Message V2.00
// R. BERTHOU

// Standard Java Imports
// import java.awt.*;

import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;


public class timage extends java.applet.Applet implements Runnable {

	// Declare the controlling thread for the applet

	Thread scrollingmessage;



	// Declare the details for the message to be displayed

	String	dir ;

	Image[] img ;		//
   int	  iImg  					 ; // Nombre d'image a afficher

	// Variables controlling the display of the message

	int 	x_coord,		// present x-position
			y_coord,		// present y-position
			iPas,			// Valeur du pas
         iPos,			//	Position dans le pas
			backcolour,	// (integer) background colour
			iScroll,		// (integer) Type de dfilement
			delay,		// scrolling speed
         sleep;		// delais d'affichage



	// for storing the dimensions of the applet

	int appletWidth, appletHeight;


   int  iNum = 0 ;

	// for double buffering to prevent flicker

	Image offScreenImage;

	Graphics offScreen;


	// Applet initialisation routine

	public void init() {

		// Temporary storage space
		String temp;


		// get the size of the applet
		appletWidth = size().width;
		appletHeight = size().height;


		// initialise the double buffering screen
		try {
			offScreenImage = createImage (appletWidth, appletHeight);
			offScreen = offScreenImage.getGraphics ();
		} catch (Exception e) {
			offScreen = null;
		}

		temp = getParameter("dir");
		dir = (temp == null) ? "./" : temp ;

		temp = getParameter("backcolour");
		backcolour= (temp==null) ? 0xffffff : Integer.parseInt( temp );

		// get the speed of the scrolling
		temp = getParameter("pas");
		iPas  = (temp==null) ? 10 : Integer.parseInt( temp );

		temp = getParameter("delay");
		delay= (temp==null) ? 100 : Integer.parseInt( temp );

		temp = getParameter("sleep");
		sleep= (temp==null) ? 1000 : Integer.parseInt( temp );

		temp = getParameter("tscr");
		iScroll= (temp==null) ? 1 : Integer.parseInt( temp );

		temp = getParameter("nbimg");
		iImg= (temp==null) ? 10 : Integer.parseInt( temp );

		img = new Image[iImg];
		for (int i = 0 ; i < iImg ; i++) {
	    	img[i] = getImage(getDocumentBase(), dir + "/img" + (i) + ".gif");
		}


} // end of init





	// control the starting of the applet

	public void start() {

		// Set the initial coordinates
		if (iScroll==1) {		// dfilement horizontal
			y_coord = 0 ;
			x_coord = 0 ;
      }
      else {					// dfilement vertical
			x_coord = 0 ;
			y_coord = 0 ;
      }

		// start the thread

		scrollingmessage = new Thread(this);

		scrollingmessage.start();

	} // end of start





	// control the stopping of the applet

	public void stop() {

		scrollingmessage.stop();

	} // end of stop





	// control the running of the applet

	public void run() {

		// set the priority of the thread to low

		Thread.currentThread().setPriority(Thread.MIN_PRIORITY);


		// loop continuously

		while(true) {

			// values for working out the constant delay

			long thisTick, waitTick;

			// calculate the tick to wait for
			waitTick = System.currentTimeMillis() + delay;

			// update the screen

			repaint ();

			if (iScroll==1) {
				x_coord += (appletWidth / iPas);
				if (x_coord>appletWidth) {
					x_coord = 0;
               iPos = 0 ;
					waitTick += sleep;
               iNum++ ;
               if (iNum==iImg)
               	iNum = 0 ;
            }

         }
         else {
				if (iScroll==2) {
					y_coord += (appletHeight / iPas) ;
					if (y_coord>appletHeight) {
						y_coord = 0 ;
                  iPos = 0 ;
						waitTick += sleep;
   	            iNum++ ;
      	         if (iNum>iImg)
         	      	iNum = 0 ;
            	}
	         }
            else {
					iPos++ ;
					if (iPos==iPas) {
						iPos = 0;
						waitTick += sleep;
      	         iNum++ ;
         	      if (iNum==iImg)
            	   	iNum = 0 ;
               }
            }
         }


			// delay for the appropriate amount of time
			thisTick = System.currentTimeMillis();

			if ( thisTick<waitTick )
				try {
					Thread.currentThread().sleep( (int)(waitTick-thisTick) );
				} catch (InterruptedException e) {}

		}

	} // end of run




	// Called when the applet needs to be painted
	// calls the flicker free updating system
	public void paint (Graphics g) {
		update(g);
	} // end of paint



	// Draw the applet without flicker
	public synchronized void update(Graphics g) {
		if (offScreen!=null) {
			paintApplet(offScreen);
			g.drawImage(offScreenImage,0,0,this);
		} else
			paintApplet(g);
	} // end of update




	// Paint the applet into whatever image
	public void paintApplet(Graphics g) {
		g.setColor(new Color(backcolour));
		g.drawImage(img[iNum],0,0, appletWidth, appletHeight, this);
		if (iScroll==3) {
			if (iPos < (iPas-1))
		 		g.fillRect(iPos * (appletWidth/iPas)  / 2,
   	      			  iPos * (appletHeight/iPas) / 2,
      	   			  appletWidth - ( iPos * appletWidth / iPas  ) ,
         				  appletHeight - ( iPos * appletHeight / iPas  ) );
      }
      else
	 		g.fillRect(x_coord,y_coord,appletWidth,appletHeight);

		// set the font in the graphics context


	} // end of paintApplet





	// Return the information on the applet

	public String getAppletInfo() {
		return "timage v1.01 * Image Applet by R. BERTHOU (1996) - E-Mail : rberthou@pratique.fr";
	} // end of getAppletInfo





	// Return the parameter information on the applet
	public String[][] getParameterInfo() {
		String[][] info = {
			{"dir",	 		"text",		"repertoire image"},
			{"nbimg",		"integer", 	"nb image"},
			{"backcolour", "integer", 	"rrggbb info"},
			{"pas",	 		"integer", 	"nb de pas"},
			{"delay", 		"integer", 	"msecs between jumps"},
			{"sleep", 		"integer", 	"msecs between image"},
			{"tscr", 		"integer", 	"2 for vertical scroll"}
		};
		return info;
	} // end of getParameterInfo


} // end of class ScrollingMessage