#!c:/win32app/perl/bin/perl 
#/program files/windows NT/Perl5/bin/perl 
#----------------------------------------------------- 
#          AjT RS Image Random Loader 0.1.1 
#         Copyright AjT Research Systems 1998 
#----------------------------------------------------- 
# 
# This program is free software; you can redistribute 
# it and/or modify it under the terms of the GNU 
# General Public License as published by the Free 
# Software Foundation; either version 2 of the License, 
# or (at your option) any later version. 
# 
# This program is distributed in the hope that it will 
# be useful, but WITHOUT ANY WARRANTY; without even 
# the implied warranty of MERCHANTABILITY or FITNESS 
# FOR A PARTICULAR PURPOSE.  See the GNU General Public 
# License for more details. 
# 
# You should have received a copy of the GNU General 
# Public License along with this program; if not, 
# write to the Free Software Foundation, Inc., 59 
# Temple Place - Suite 330, Boston, MA  02111, USA. 
# 
#----------------------------------------------------- 
# If you have any comments or suggestions please email 
# them to me so that they can be incorporated into any 
# further versions of the script. 
#----------------------------------------------------- 
# adam_trickett@bigfoot.com 
# http://www.darwin.ucr.edu/ 
#----------------------------------------------------- 

#----------------------------------------------------- 
# 
# In your HTML call it with: 
# <A HREF="/cgi-bin/irl.pl?img=image_file.txt">link</A> 
# 
# Or you can use: 
# <A HREF="/cgi-bin/irl.pl/imagename_file.txt">link</A> 
# 
# Add ssi=1 to use as a server side include instead 
# Add alt=  if you want to set the alt tag for SSI 
#----------------------------------------------------- 

use CGI qw(:standard); 
use strict; 
use CGI::Carp; 
use Image::Size; 
use vars qw($webpath $empty $realpath $filepath $d_list $alt_tag $list $image @image_list); 

#START 
#---------------- 
  DEFS(); 
  Read(); 
  Load_list(); 
  redirect_browser(); 
  exit; 
#---------------- 
#END 

#SUBROUTINES 
#------------------------------------------------- 

sub DEFS { 
# Definitaions live here 
# ---------------------- 

  $webpath  = "http://www.darwin.ucr.edu/img/";  # Place where your images live 
  $empty    = "perl_republic.gif";    # Image you get if there is a problem 
  $realpath = "d:/apache/img/";      # Place where images are in reality 
  $filepath = "d:/apache/temp/";    # Place where image file list is in reality 
  $d_list   = "image_file.txt";                 # Default File list 
  $alt_tag  = "Random Image";      # Default alt tag 
  $list     = undef; 
   
} 

sub Read { 
# Read info from browser 
# ---------------------- 

  my $path = undef; 

  # Try reading from a post or get 
  $list = param("img"); 

  # have a look in the path 
  $path = $ENV{"PATH_INFO"}; 
  unless ($path eq "") { 
    $path =~ s(/)(); 
    $list = $path; 
  }   

  if (param("alt")) { 
    $alt_tag = param("alt") 
  } 

  # Make sure whatever we got is there. 
  chdir($filepath); 
  unless ( -e $list) { 
    $list = $d_list 
  } 
} 

sub Load_list { 
# Load list of files to randomise 
# ------------------------------- 

  open (IMG_LIST, "<$list") || die "Error: Could not open file. $!"; 

  my $img_num = 0; 
  while (<IMG_LIST>) { 
    chomp(); 
    $image_list[$img_num] = $_; 
    $img_num ++; 
  } 

  close (IMG_LIST); 
} 

sub redirect_browser { 
# Print location header 
# --------------------- 

  $image = $empty; 

  my $img_num = rand(@image_list); 

  chdir($realpath); 
  if ( -e $image_list[$img_num] ) { 
    $image = $image_list[$img_num] 
  } 

if (param('ssi')) { 

  my $size_x = undef; 
  my $size_y = undef; 

  ($size_x, $size_y) = imgsize("$image"); 
  print "Content-type: text/html\n\n", 
        img ({src    => "$webpath$image", 
              alt    => "$alt_tag", 
              border => "0", 
              height => "$size_y", 
              width  => "$size_x"}); 
  } else { 
    print "Location: $webpath$image\n\n"; 
  } 
} 

