#!c:/perl/bin/perl.exe

##############################################################################
# MTVWebdesign FAQ Generator                        Version 2.1 (20003103)
# help.cgi: The help script
# Copyright 1999-2000 Maarten Veerman mtveerman@mindless.com
# MTVWebdesign:    http://mtvwebdesign.hypermart.net/ (http://mtvwebdesign.hypermart.net/scripts/)
##############################################################################
# COPYRIGHT NOTICE
# Copyright 1999-2000 Maarten Veerman  All Rights Reserved.
#
# FAQGen may be used and modified so long as this
# copyright notice and the comments above remain intact.  By using this
# code you agree to indemnify Maarten Veerman from any liability that
# might arise from its use.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  In other words, please ask first before you try and
# make money off of my program in any way.
#
# Obtain permission before redistributing this software over the Internet or
# in any other medium. In all cases copyright and header must remain intact
#
# Please send bug-reports to cgi-bugs@mtvwebdesign.hypermart.net
##############################################################################
#
# Script tested locally:
# Pentium 400Mhz, 128MB RAM, Windows 98, Apache 1.3.4 (win32), Perl, MS Internet Explorer 5.0, Netscape 4.05.
#
# Please do not remove or change the following 2 lines:
$scriptname = "FAQGen";
$version = "2.1";

use CGI::Carp qw(fatalsToBrowser); # Provides you with fatal error message if they occur.
require 'faq.conf';
require $mtvwebdesignlib;

%list = (
	'Why do I have to login?', 'username',
	'Where can I find my password?', 'username',
	'What is a category?','category',
	'What is the <i>General</i> Category?','general',
	'What do you mean with Q\&A couple?','qa',
	'How do I handle HTML in the answer?','html',
);

if ($ENV{'QUERY_STRING'}) {
	$var = lc $ENV{'QUERY_STRING'};
	&$var;
}
else {
	&main_page;
}
exit;

sub main_page {
	print "Content-type: text/html\n\n";
	&pageheader("Help for MTVWebdsigns News script");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Help for MTVWebdesign's FAQ script</h2>
			Here is a list of all the explanations for possible problems:<p>
			<ul>
			~;
			
			foreach $item (sort %list) {
				if ($list{$item} ne '') {
					print qq~
					<li> <a href="$ENV{'SCRIPT_NAME'}?$list{$item}">$item</a><br>
					~;
				}
			}
			
			print "</ul>";
			
		}
		print "$line";
	}
	&powered_by;
}

sub back_button {
	print qq~
	<p><center><table><tr><td><FORM action="$ENV{'script_name'}" method="post"><input type="submit" value="Help Main Page"></form></td><td><FORM><INPUT type="button" value="Back" onClick="history.go(-1)"></FORM></center></td></tr></table>
	~;
}

sub footer {
	print qq~
	<p align="right">All the information was valid at: 07/07/99
	</p>
	~;
}

sub username {
	print "Content-type: text/html\n\n";
	&pageheader("Login questions");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Login questions</h2>
			<ol>
			<li>Why do I have to login?<br>
			You need to login, because you are about to get the permission to change certain things on the system, like deleting Q&A couples, and even deleting complete FAQ pages, but you'll also get the ability to create new ones. You don't want everybody to be able to do this, or do you? Well, that's why you need to login.
			<li>Where can I find my password?</br>
			You can find your password in the configuration file.
			</ol>
			~;
		}
		print "$line";
	}
	&powered_by;
	&footer;
}

sub category {
	print "Content-type: text/html\n\n";
	&pageheader("What do you mean with Categories?");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>What do you mean with "<i>Categories</i>"?</h2>
			A category is a special place inside a FAQ page. For example: Let's say you have a FAQ page for programming on the web, and you have Q&A couples about HTML, JavaScript and even Perl. You don't want to place them all in one group, so we give you the ability to create categories for them. And all the Q&A couples will automatically be placed in the category where they belong. That means: the one you specified when you created the Q&A couple.
			~;
		}
		print "$line";
	}
	&powered_by;
	&footer;
}

sub general {
	print "Content-type: text/html\n\n";
	&pageheader("The General category");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Where does the <i>General</i> Category come from?</h2>
			The <i>General</i> category is automatically created when you create the FAQ page, and as long you you don't create any other categories in the FAQ page, you won't see it in the page. But when you do create other categories, the General category will be the place where you store you <i>general</i> Q&A couples.
			~;
		}
		print "$line";
	}
	&powered_by;
	&footer;
}

sub qa {
	print "Content-type: text/html\n\n";
	&pageheader("What doe you mean with Q&A couple?");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>What do you mean with Q&A couple?</h2>
			Question and Answer couple. They are always related to each other.....
			~;
		}
		print "$line";
	}
	&powered_by;
	&footer;
}

sub html {
	print "Content-type: text/html\n\n";
	&pageheader("How do I use HTML in the Answer?");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>How do I use HTML (and other characters) in the answer?</h2>
			If you are new to HTML, <a href="#1">click here.</a><br>
			If you are a web programmer, <a href="#2">click here.</a><br>
			<hr noshade>
			<a name="1"></a>
			<h3>New to HTML</h3>
			Welcome to the world of HTML! Every internet page you visit has HTML in it. That's the beauty of HTML. It's everywhere, and it's not really difficult to learn.<br>
			But how do you use it in the Answer? Well, just don't if you don't know how to use it. If you just type the answer, and you hit the [return] button sometimes, that's ok. The answer will be in the FAQ page the same way as you typed it.<p>
			If you do want to use some HTML, for just some nice effect, go for it, but be carefull to close all the TAGS you open, and <font color="#FF0000">DO NOT TYPE THE &lt;BR&gt; TAG IN THE ANSWER!</font> It'll make the answer look weird.
			<hr noshade>
			<a name="2"></a>
			<h3>Web programmer</h3>
			Well, if you are a web programmer, you might want to use HTML in your answer. Go for it, but just thing of this:<br>
			<font color="#FF0000">DO NOT TYPE THE &lt;BR&gt; TAG IN THE ANSWER!</font>. It'll make the anser look weird, since every time you hit the [return] key, the program will translate that into a &lt;BR&gt;. So if you need to start a new line, just hit the return button.<p>
			You might want to create a FAQ page for Perl programmers, of Java programmers, and you might ask yourself:<br>
			<b>Can I use certain characters?</b><br>
			Well, in most perl scripts, data is stored in files and later there is the ability to split that, because there are pipes all over the data: |<br>
			Not with this script. Answers will not be filtered in any way. So, go ahead and use those pipes and other characters!<p>
			BUT BEWARE! If you want to create a FAQ page for HTML programmers and you need to place some coding in the answer, make sure that you the &lt; and &gt; are: &amp;lt; and &amp;gt; or else you won't see them in the original answer, since they are read by the browser.
			~;
		}
		print "$line";
	}
	&powered_by;
	&footer;
}
