#!c:/perl/bin/perl

##############################################################################
# MTVWebdesign FAQ Generator                        Version 2.1 (20003103)
# admin.cgi: The admin script
# Copyright 1999-2000 Maarten Veerman mtveerman@mindless.com
# MTVWebdesign:    http://mtvwebdesign.hypermart.net/ (http://mtvwebdesign.hypermart.net/scripts/)
##############################################################################
# COPYRIGHT NOTICE
# Copyright 1999-2000 Maarten Veerman  All Rights Reserved.
#
# FAQGen may be used and modified so long as this
# copyright notice and the comments above remain intact.  By using this
# code you agree to indemnify Maarten Veerman from any liability that
# might arise from its use.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  In other words, please ask first before you try and
# make money off of my program in any way.
#
# Obtain permission before redistributing this software over the Internet or
# in any other medium. In all cases copyright and header must remain intact
#
# Please send bug-reports to cgi-bugs@mtvwebdesign.hypermart.net
##############################################################################
#
# Script tested locally:
# Pentium 400Mhz, 128MB RAM, Windows 98, Apache 1.3.4 (win32), Perl, MS Internet Explorer 5.0, Netscape 4.05.
#
# Please do not remove or change the following 2 lines:
$scriptname = "FAQGen";
$version = "2.1";
##############################################################################
# Please note that we abbreviate names of subroutines. This can be difficult when you want
# to edit the script. Therefor we included comments before every sub(group)
##############################################################################

# Configuration
use CGI::Carp qw(fatalsToBrowser); # Provides you with fatal error message if they occur.
require 'faq.conf';
require $mtvwebdesignlib;
require $dbunderpath;
$dbdir = &dbdir_;
require $dbunder;

# Main routine
main: {
	&getinput; 				# Get the input from the forms
	&GetCookies;			# Get Cookies (if there are any)
	&check_url;			# Check the referer
	
	# Check is the variable $db_dir end with a slash, else add on
	if ($db_dir !~ m/\/$/) {
		$db_dir = $db_dir . "/";
	}
	
	# Check is the user has already logged in, or tries to login.
	if (!$Cookies{'loggedin'} && lc $FORM{'action'} ne 'login') { &login; exit; }
	
	# For actions
	if (lc $FORM{'action'} eq 'login') { &check_login; }											#Checks the login
	elsif (lc $FORM{'action'} eq 'mainpage' || $Cookies{'loggedin'} && !$FORM{'action'}) {&mainpage;}		# Go to the mainpage if the form actions says so, or if there is a cookie and no form action
	elsif (lc $FORM{'action'} eq 'create_new_faq_page') { &createnewpage; }							# Create a new FAQ page
	elsif (lc $FORM{'action'} eq 'cnpn') { &cnpn; }		# Create new page now
	elsif (lc $FORM{'action'} eq 'cnc') { &cnc; }			# Create new category
	elsif (lc $FORM{'action'} eq 'cnc2') { &cnc2; }		# Create new category 2
	elsif (lc $FORM{'action'} eq 'cncn') { &cncn; }		# Create new category now
	elsif (lc $FORM{'action'} eq 'cnqa') { &cnqa; }		# Create new Q&A couple
	elsif (lc $FORM{'action'} eq 'cnqa2') { &cnqa2; }
	elsif (lc $FORM{'action'} eq 'cnqan') { &cnqan; }
	elsif (lc $FORM{'action'} eq 'mqa') { &mqa; }			# Modify Q&A Couple
	elsif (lc $FORM{'action'} eq 'mqa2') { &mqa2; }
	elsif (lc $FORM{'action'} eq 'mqa3') { &mqa3; }
	elsif (lc $FORM{'action'} eq 'mqan') { &mqan; }
	elsif (lc $FORM{'action'} eq 'dqa') { &dqa; }			# Delete Q&A Couple
	elsif (lc $FORM{'action'} eq 'dqa2') { &dqa2; }
	elsif (lc $FORM{'action'} eq 'dqan') { &dqan; }
	elsif (lc $FORM{'action'} eq 'dp') { &dp; }			# Delete FAQ page
	elsif (lc $FORM{'action'} eq 'dp2') { &dp2; }
	elsif (lc $FORM{'action'} eq 'cp') { &cp; }			# Change password
	elsif (lc $FORM{'action'} eq 'cpn') { &cpn; }
	elsif (lc $FORM{'action'} eq 'dc') { &dc; }			# Delete category
	elsif (lc $FORM{'action'} eq 'dc2') { &dc2; }
	elsif (lc $FORM{'action'} eq 'dcn') { &dcn; }
	elsif (lc $FORM{'action'} eq 'rc') { &rc; }				# Rename Category
	elsif (lc $FORM{'action'} eq 'rc2') { &rc2; }
	elsif (lc $FORM{'action'} eq 'rc3') { &rc3; }
	elsif (lc $FORM{'action'} eq 'rcn') { &rcn; }
	elsif (lc $FORM{'action'} eq 'moveqa') { &moveqa; }	# Move a Q&A Couple
	elsif (lc $FORM{'action'} eq 'moveqa2') { &moveqa2; }
	elsif (lc $FORM{'action'} eq 'moveqa3') { &moveqa3; }
	elsif (lc $FORM{'action'} eq 'moveqan') { &moveqan; }
	elsif (lc $FORM{'action'} eq 'rp') { &rp; }				# Rename FAQ Page
	elsif (lc $FORM{'action'} eq 'rp2') { &rp2; }
	elsif (lc $FORM{'action'} eq 'rpn') { &rpn; }
	else { &login; }								# Else go to the login screen
	
	exit;
}

##############################################################################
# This is the login subroutine. It'll print a nice page asking for a password. That's all.
##############################################################################
sub login {
	print "Content-type: text/html\n\n";
	&pageheader("Login page for $servicename admin functions");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Login</h2>
			Please enter your password and press the submit button.<p>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="login">
			<table border="0" cellpadding="2" cellspacing="2">
			<tr><td>Password:</td><td><input type="password" name="password"></td></tr>
			<tr><td colspan="2" align="center"><font color="#FF0000">Please note: Sometimes you will see a question mark: (?). You can click on that for extra explanation, or details.</font></td></tr>
			</table><br>
			<input type="submit">
			</form>
			~;
		}
		print "$line";
	}
	&powered_by;
}

##############################################################################
# Check the login.
# Encrypt the received password if $enc_pass is set. Else leave it plain.
# Than we check the 2 passwords. If they are incorrect, we are sent to an error page.
# If they are correct, a Cookie is set (so we know we are logged in), and we are sent to the
# mainpage
##############################################################################
sub check_login {
	$FORM{'password'} = crypt($FORM{'password'}, Mv) unless !$enc_pass; 		# Encrypt the password is needed
	if (!$FORM{'password'} && $passwd || lc $FORM{'password'} ne lc $passwd) {&errors("with the password")}
	&SetCookies('loggedin','1');
	&mainpage;
}

##############################################################################
# This subroutine will simply print the mainpage for the webmaster, providing options
# for the user in the form of anchors.
##############################################################################
sub mainpage {
	print "Content-type: text/html\n\n";
	&pageheader("What do you want to do?");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>What do you want to do?</h2>
			Please click on one of the following options to get things done!<p>
			~;
			
			# Warn is webmasterpassword is not encrypted.
			if (!$enc_pass) {
				print qq~
				<font color="red">WARNING: Your password is not encrypted and probably visible to the public. Please change your password and make sure you set the &quot;Encrypt Password&quot; option!</font>
				~;
			}
			
			print qq~
			<ol>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=create_new_faq_page&id=$id">Create a new FAQ page.</a><br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=cnc&id=$id">Create a new category for a FAQ page.</a> (<a href="$help_script?category" target="_new">?</a>)<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=cnqa&id=$id">Create a new Question and Answer couple for a FAQ page.</a><br>
			<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=mqa&id=$id">Modify a certain Q&A couple.</a> (<a href="$help_script?qa" target="_new">?</a>)<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=dqa&id=$id">Delete a certain Q&A couple.</a><br>
			<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=moveqa&id=$id">Move Q&A Couples to different Categories</a><br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=rc&id=$id">Rename a Category</a><br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=dc&id=$id">Delete a Category</a><br>
			<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=rp&id=$id">Rename a FAQ page.</a><br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=dp&id=$id">Delete a FAQ page.</a><br>
			<br>
			<li><a href="$ENV{'SCRIPT_NAME'}?action=cp&id=$id">Change your webmaster password</a><br>
			<br>
			<li><a href="$script_location">Click here to visit your FAQ pages.</a><br>
			</ol>
			~;
		}
		print "$line";
	}
	&powered_by;
}

##############################################################################
# Will print a nice page with a form where we can fill in a name for the new page
##############################################################################
sub createnewpage {
	print "Content-type: text/html\n\n";
	&pageheader("Create a new FAQ page.");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Create a new FAQ page</h2>
			Please answer the question below to create a new FAQ page.<p>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="cnpn">
			<input type="hidden" name="id" value="$id">
			<table border="0" cellpadding="2" cellspacing="2" width="70%">
			<tr><td>What will be the name of the new FAQ page? Please note that all the pages are called: <b>&quot;The</b> FAQ_NAME <b>FAQ's&quot;</b></td><td valign="top">The <input type="text" maxlength="20" name="realname"> FAQ's</td></tr>
			</table>
			<br><input type="submit">
			</form>
			
			~;
		}
		print "$line";
	}
	&powered_by;
}

##############################################################################
# This sub does some checks on the FAQ page name, and than creates it.
##############################################################################
sub cnpn {
	if (!$FORM{'realname'}) { &errors("with the realname") }
	
	&getname($FORM{'realname'});		# Get a name we can use for filename purposes
	
	&opendb;
	&CreateTable_("main","realname","lcname","categories");
	&CreateTable_("count","number");
	@count = &SelectFromTable_("count","*");
	if(!$count[1]) { &InsertIntoTable_("count","1"); }
	
	@check = eval(&CreateTable_("$FORM{'realname2'}","faqid","category","question","answer"));
	
	if ($en[0] == 2 || $en[0] == 6 || $en[0] == 8) { &closedb; &errors("with the realname")  }
	
	# Passed the check....
	# Let's create the new faq...
	# Add the new FAQ to the main database
	
	&InsertIntoTable_("main","$FORM{'realname'}","$FORM{'realname2'}","General");
	
	&closedb;
	
	# And we print a nice page....
	print "Content-type: text/html\n\n";
	&pageheader("Ready!");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Ready!</h2>
		You have succesfully created a new FAQ page. You can now enter new categories and Q&A's to it, by going to the <a href="$ENV{'SCRIPT_NAME'}?id=$id">main screen</a> and select the options you want.
		~;
	}
	print "$line";
}
&powered_by;
}

##############################################################################
# The following 3 subroutines take care of creating new categories in certain FAQ pages.
##############################################################################
sub cnc {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&cnc2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	# Print a nice page where the webmaster can choose where he wants the new category to be installed
	print "Content-type: text/html\n\n";
	&pageheader("Please select the faq page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="cnc2">
			<table border=0 cellpadding="2" cellspacing="2" width="70%">
			<tr><td>Please select the FAQ page where you want to add the new category.</td><td><select name="realname"><option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select>
			</td></tr>
			<tr><td colspan=2 align="center"><input type="submit"></td></tr></table></form>
			~;
		}
		print "$line";
	}
	&powered_by;
	
}
}

sub cnc2 {
if (!$FORM{'realname'}) {&mainpage; exit;}
&getname($FORM{'realname'});
if ($FORM{'realname2'} eq 'selectapage') {&cnc; exit; }

&opendb;
@cat = &SelectFromTable_("main","AND","categories","lcname|eq|$FORM{'realname2'}");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Create a new Category");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Create a new Category</h2>
		Please answer the question below.<Br>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="cncn">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<table border="1" cellpadding="2" cellspacing="0" width="30%"><tr><td valign="top">Here is a list of the current categories. (<a href="$help_script?general" target="_new">?</a>)</td><td valign="top">
		~;
		@cats = split(/\t/,$cat[1]);
		foreach $key (sort @cats) {
			print $key . "<br>\n";
		}
		print qq~
		</td></tr>
		<tr><td>Please enter the name of the new category</td><td valign="top"><input type="text" name="cat" maxlength="20"></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

exit;
}

sub cncn {
if (!$FORM{'realname'}) {&mainpage;}
&getname($FORM{'realname'});

# Create the new category.
$FORM{'cat'} =~ s/\t//ig;

if (!$FORM{'realname'}) { &errors("error1") }
if (!$FORM{'cat'}) { &errors("error2") }

&opendb;
@newcat = &SelectFromTable_("main","AND","categories","lcname|eq|$FORM{'realname2'}");
@cats = split(/\t/,$newcat[1]);
foreach $c (@cats) {
	if (lc $c eq lc $FORM{'cat'}) {
		$catthere=1;
	}
}
if (!$catthere) {
	push @cats, $FORM{'cat'};
	$categories = join "\t", @cats;
	@check = eval(&UpdateTableSet_("main","AND","categories=$categories","lcname|eq|$FORM{'realname2'}"));
}

&closedb;

&errors("catthere") unless !$catthere;
if ($check[0] == 1 || $check[0] == 4) { &errors("update problem"); }

print "Content-type: text/html\n\n";
&pageheader("New category created.");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>New category created</h2>
		You have succesfully created a new category for your <b>$FORM{'realname'}</b> FAQ page!<br>
		Please <a href="$ENV{'SCRIPT_NAME'}?action=cnc2&realname=$FORM{'realname'}&id=$id">click here</a> if you want to create an other category in <b>$FORM{'realname'}</b><br>
		Please <a href="$ENV{'SCRIPT_NAME'}?id=$id">click here</a> to go back to the main screen.
		~;
	}
	print "$line";
}
&powered_by;
exit;
}

##############################################################################
# The following 3 subroutines take care of creating a new Q&A couple
##############################################################################
sub cnqa {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&cnqa2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Please select the faq page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="cnqa2">
			<table border=0 cellpadding="2" cellspacing="2" width="70%">
			<tr><td>Please select the FAQ page where you want to add the new Q&A couple</td><td><select name="realname"><option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select>
			</td></tr>
			<tr><td colspan=2 align="center"><input type="submit"></td></tr></table></form>
			~;
		}
		print "$line";
	}
	&powered_by;
	
}
}

sub cnqa2 {
if (!$FORM{'realname'}) {&mainpage;}

&getname($FORM{'realname'});

if ($FORM{'realname2'} eq "selectapage") {&cnqa; exit;}

&opendb;
@cat = &SelectFromTable_("main","AND","realname,categories","lcname|eq|$FORM{'realname2'}");
&closedb;

@cate = split(/\/,$cat[1]);

print "Content-type: text/html\n\n";
&pageheader("Create a new Q&A Couple");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Create a new Q&A Couple</h2>
		Please fill out the form below, so we can process your Q&A couple which will be placed in <b>$cate[0]</b>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="cnqan">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<table border="1" cellspacing="0" cellpadding="2" width="50%" align="center">
		~;
		
		@cats = split(/\t/,$cate[1]);
		$num_keys = scalar @cats;
		
		if ($num_keys > 1) {
			print qq~
			<tr><td><b>Please select the category where you want the Q&A couple to be placed.</b></td><td><select name="cat"><option>Select a Category
			~;
			
			
			foreach $key (sort @cats) {
				print "<option value=\"" . $key . "\">" . $key . "\n";
			}
			
		}
		else {
			print "<input type=\"hidden\" name=\"cat\" value=\"General\">\n";
		}
		
		print qq~
		</select></tr>
		<tr><td colspan="2" align="center"><b>Please enter the question:</b></td></tr>
		<tr><td colspan="2" align="center"><input type="text" name="q" size="50"></td></tr>
		<tr><td colspan="2" align="center"><b>Please enter the answer: <br><font size="-1"><a href="$help_script?html" target="_new">How to use HTML and other characters: (?</a>)</font></b></td></tr>
		<tr><td colspan="2" align="center"><textarea name="a" cols="50" rows="10"></textarea></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub cnqan {
if (!$FORM{'realname'} || !$FORM{'cat'}) {&mainpage;}

&getname($FORM{'realname'});

if (lc $FORM{'cat'} eq "select a category") { $FORM{'cat'} = "General"; }

$FORM{'a'} =~ s/\//igs;
$FORM{'q'} =~ s/\//igs;
$FORM{'a'} =~ s/\n\n/\<p\>/sig;
$FORM{'a'} =~ s/\n/\<br\>/sig;

if (!$FORM{'q'}) { &errors("q"); }
if (!$FORM{'a'}) { &errors("a"); }

# Place the Q&A in the database table.
&opendb;
@number = &SelectFromTable_("count","*");
$old = $number[1];
$number[1]++;
@checknum = eval(&UpdateTableSet_("count",AND,"number=$number[1]","number|eq|$old"));
if ($check[0] == 1 || $check[0] == 2 || $check[0] == 3 || $check[0] == 4) { &closedb; &errors("inserting new qa"); }

@check = eval(&InsertIntoTable_("$FORM{'realname2'}","$number[1]","$FORM{'cat'}","$FORM{'q'}","$FORM{'a'}"));
&closedb;

if ($check[0] == 1 || $check[0] == 2 || $check[0] == 3 || $check[0] == 4) { &errors("inserting new qa"); }

print "Content-type: text/html\n\n";
&pageheader("Q\&A Couple added");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Q&A Couple added!</h2>
		You have succesfully added a new Q&A Couple!<br>
		<a href="$ENV{'SCRIPT_NAME'}?action=cnqa2&realname=$FORM{'realname'}">Click here</a> if you want to add an other Q&A Couple in the same FAQ page.<br>
		<a href="$ENV{'SCRIPT_NAME'}?id=$id">Click here</a> to go the main screen.<p>
		~;
		
	}
	print "$line";
}
&powered_by;
}

##############################################################################
# This sub will provide us with a name we can use for filename purposes
##############################################################################
sub getname {
local($x) = @_;
$FORM{'realname2'} = $x;
$FORM{'realname2'} =~ s/\W//ig;
$FORM{'realname2'} = lc $FORM{'realname2'}
}

##############################################################################
# The Next 4 subroutines take care of modifying a Q&A couple
# First we check if there is only 1 page, if not print a page where the webmaster can choose.
# Second, we display all the Questions on the selected page.
# Third, we allow the modification to take place
# Fourth, we modify the Q&A couple in the database.
##############################################################################
sub mqa {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&mqa2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Please select the faq page where the Q&A couple resides");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page for Q&A modification</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="mqa2">
			<table border=0 cellpadding="2" cellspacing="2" width="70%">
			<tr><td>Please select the FAQ page where the Q&A couple you want to modify resides.</td><td><select name="realname"><option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select>
			</td></tr>
			<tr><td colspan=2 align="center"><input type="submit"></td></tr></table></form>
			~;
		}
		print "$line";
	}
	&powered_by;
	
}

}

sub mqa2 {
if (!$FORM{'realname'}) {&mainpage;}
&getname($FORM{'realname'});

if ($FORM{'realname2'} eq 'selectapage') {&mqa; exit; }

&opendb;
@qa = &SelectFromTable_("$FORM{'realname2'}","AND","faqid,question");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Please select the Q&A couple you want to modify");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Select the question you want to modify</h2>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="mqa3">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		Please select the question you want to modify by clicking on the radio button (the small white circle) on the left of the questions.<p>
		<table cellspacing="0" cellpadding="2" border=1 align="center">
		~;
		
		for($i=1; $i < scalar @qa; $i++) {
			($code,$question) = split(/\/,$qa[$i]);
			print "<tr><td><input type=\"radio\" name=\"code\" value=\"" . $code . "\"></td><td>" . $question . "</td></tr>\n";
		}
		
		print qq~
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
		
	}
	print "$line";
}
&powered_by;

}

sub mqa3 {
if (!$FORM{'realname'}) {&mainpage;}
if (!$FORM{'code'}) {&mqa2; exit;}
&getname($FORM{'realname'});

&opendb;
@data = &SelectFromTable_("$FORM{'realname2'}","AND","question,answer","faqid|eq|$FORM{'code'}");
&closedb;

($q,$a) = split(/\/,$data[1]);
$a =~ s/\<br\>/\n/igs;

print "Content-type: text/html\n\n";
&pageheader("Modify the Q&A couple");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Modify the Q&A couple</h2>
		Please modify the Q&A couple the way you want it, and press the submit button.
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="mqan">
		<input type="hidden" name="code" value="$FORM{'code'}">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<table cellspacing="0" border="1" cellpadding="2" align="center">
		<tr><td colspan="2" align="center"><b>Please enter the question:</b></td></tr>
		<tr><td colspan="2" align="center"><input type="text" name="q" size="50" value="$q"></td></tr>
		<tr><td colspan="2" align="center"><b>Please enter the answer: <br><font size="-1"><a href="$help_script?html" target="_new">How to use HTML and other characters: (?)</a></font></b></td></tr>
		<tr><td colspan="2" align="center"><textarea name="a" cols="50" rows="10">$a</textarea></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;
}

sub mqan {
if (!$FORM{'realname'} || !$FORM{'code'}) { &errors("error3"); }
if (!$FORM{'q'}) { &errors("q"); }
if (!$FORM{'a'}) {&errors("a"); }
&getname("$FORM{'realname'}");

$FORM{'q'} =~ s/\t//ig;
$FORM{'a'} =~ s/\t//igs;
$FORM{'a'} =~ s/\n\n/\<p\>/sig;
$FORM{'a'} =~ s/\n/\<br\>/sig;

&opendb;
@check = eval(&UpdateTableSet_("$FORM{'realname2'}","AND","question=$FORM{'q'}|answer=$FORM{'a'}","faqid|eq|$FORM{'code'}"));
&closedb;

if ($check[0] == 1 || $check[0] == 4) { &errors("updateproblem"); }

print "Content-type: text/html\n\n";
&pageheader("Q&A Couple modified!");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Q&A Couple modified!</h2>
		You have succesfully modified the Q&A couple. Please <a href="$ENV{'SCRIPT_NAME'}?id=$id">click here</a> to go back to the main screen.
		~;
	}
	print "$line";
}
&powered_by;
}

##############################################################################
# The following 3 subroutines tak care of deleting a Q&A Couple
##############################################################################
sub dqa {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&dqa2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Please select the faq page where the Q&A couple resides");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select the page where the Q&A couple resides</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="dqa2">
			<table border=0 cellpadding="2" cellspacing="2" width="70%">
			<tr><td>Please select the FAQ page where the Q&A couple you want to delete resides.</td><td><select name="realname"><option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select>
			</td></tr>
			<tr><td colspan=2 align="center"><input type="submit"></td></tr></table></form>
			~;
		}
		print "$line";
	}
	
	
	&powered_by;
	
}

}

sub dqa2 {
if (!$FORM{'realname'}) {&mainpage;}
&getname($FORM{'realname'});

if ($FORM{'realname2'} eq 'selectapage') {&dqa; exit; }

&opendb;
@data = &SelectFromTable_("$FORM{'realname2'}","AND","faqid,question");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Please select the Q&A couples you want to delete");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Select the question(s) you want to delete</h2>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="dqan">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		Please select the question(s) you want to delete by checking the checkboxes on the left of the questions.<p>
		<table cellspacing="0" cellpadding="2" border=1 align="center">
		~;
		
		for($i=1;$i < scalar @data;$i++) {
			($code,$question) = split(/\/,$data[$i]);
			print "<tr><td><input type=\"checkbox\" name=\"code\" value=\"" . $code . "\"></td><td>" . $question . "</td></tr>\n";
		}
		
		print qq~
		<tr><td colspan="2" align="center"><font color="#FF0000"><b>Please not: All checked questions will be deleted!</b></font></td></tr>
		<tr><td colspan="2" align="center"><input type="submit" value="Delete!"></td></tr>
		</table>
		</form>
		~;
		
	}
	print "$line";
}
&powered_by;


}

sub dqan {
if (!$FORM{'realname'}) {&mainpage;}
if (!$FORM{'code'}) { &errors("error4"); }

&getname($FORM{'realname'});

&opendb;
@dels = split(/,/,$FORM{'code'});
foreach $c (@dels) {
	@check = eval(&DeleteFromTable_("$FORM{'realname2'}","AND","faqid|eq|$c"));
}
&closedb;

if ($check[0] != 0) { &errors("Deleting record"); }

print "Content-type: text/html\n\n";
&pageheader("Q&A couples deleted");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Q&A couples deleted</h2>
		You have succesfully deleted the selected Q&A couples. Please <a href="$ENV{'SCRIPT_NAME'}?id=$id">Click here</a> to get back to the main screen.
		~;
	}
	print "$line";
}
&powered_by;

}

##############################################################################
# The following 2 subroutines take care of completely deleting a FAQ page
##############################################################################
sub dp {

&opendb;
@del = &SelectOrderByFromTable_("realname","main","AND","realname,lcname");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("CAUTION!");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2><font color="#FF0000">CAUTION:</font> Delete a FAQ page?</h2>
		Please select the FAQ page you want to delete, or click the back button on your browser to go back!<p>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="dp2">
		<table border="1" cellspacing="0" cellpadding="2" width="40%">
		<tr><td>Please select the page you want to delete:</td><td><select name="realname">\n<option>Select a page
		~;
		for($i=1;$i < scalar @del; $i++) {
			($realname,$lcname) = split(/\/,$del[$i]);
			print "<option value=\"" . $lcname . "\">" . $realname . "\n";
		}
		
		print qq~
		</select>
		</td>
		</tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr></table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;
}

sub dp2 {
if (!$FORM{'realname'}) {&errors("error1"); }
&getname($FORM{'realname'});

&opendb;
@check = eval(&DeleteFromTable_("main","AND","lcname|eq|$FORM{'realname2'}"));
if ($check[0] != 0) { &closedb; &errors("deleting record");}
@check = eval(&DropTable_("$FORM{'realname2'}"));
&closedb;
if ($check[0] != 0) { &errors("drop table"); }

print "Content-type: text/html\n\n";
&pageheader("Deleted");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Deleted $FORM{'realname'}</h2>
		You succesfully deleted the <b>$FORM{'realname'}</b> FAQ page.
		<br>Please <a href="$ENV{'SCRIPT_NAME'}?id=$id">click here</a> to get back to the main page.
		~;
	}
	print "$line";
}
&powered_by;
}

##############################################################################
# The following 2 subroutines take care of changing the webmasterpassword.
# This is done by modifying the configuration file using regular expressions. Be carefull
# modifying these lines of code.
# If the webmaster want's the enc_pass option, we set that variable too inside the conf file.
##############################################################################
sub cp {
# Change webmaster password

print "Content-type: text/html\n";
&expires_header("now");
print "\n";
&pageheader("Change webmaster password");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Change webmaster password</h2>
		Please fill out the form below and press the submit button.
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="cpn">
		<input type="hidden" name="id" value="$id">
		<table cellpadding="5" cellspacing="0" border="1">
		<tr><td>Please enter your old password:</td><td><input type="password" name="oldpass"></td></tr>
		<tr><td>Please enter your new password:</td><td><input type="password" name="newpass1"></td></tr>
		<tr><td>Please enter your new password again:</td><td><input type="password" name="newpass2"></td></tr>
		<tr><td colspan="2" align="center">Please check this box if you want to encrypt your password (We strongly advice this!): <input type="checkbox" name="crypt" CHECKED></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub cpn {
# Change webmasterpassword now

if ($enc_pass) { $FORM{'oldpass'} = crypt($FORM{'oldpass'}, Mv); }
&errors("oldpass") if ($FORM{'oldpass'} ne $passwd);
&errors("newpass") if ($FORM{'newpass1'} ne $FORM{'newpass2'} || !$FORM{'newpass1'});

if ($FORM{'crypt'}) { $FORM{'newpass1'} = crypt($FORM{'newpass1'}, Mv); }


open(SETUP, "+<$config_file") || die "Cannot open $config_file";
flock(SETUP, 2) if $use_flock;

# Seek the beginning of the file.
seek (SETUP, 0, 0);
# Now place all the lines in an array....
@lines = <SETUP>;

# Seek the beginning of the file again.....
seek (SETUP, 0, 0);
# ....and empty the file.....
truncate (SETUP, 0);

foreach $line (@lines) {
	if ($line =~ /\$passwd\s*=\s*["\'][^"\']+["\']\;/) {
		print SETUP "\$passwd = \"$FORM{newpass1}\"\;\n";
		if ($FORM{'crypt'}) {
			print SETUP "\$enc_pass = \"1\"\;\n";
		}
	}
	elsif ($line =~ /\$enc_pass\s*=\s*["\'][^"\']+["\']\;/) {
		print SETUP "";
	}
	else {
		print SETUP "$line";
	}
}
flock(SETUP, 8) if $use_flock;
close(SETUP);

print "Content-type: text/html\n\n";
&pageheader("Password changed");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h1>Password changed</h1>
		Your webmaster password was succesfully changed! Please <a href="$ENV{'SCRIPT_NAME'}?$id">click here</a> to go back to the mainpage!
		~;
	}
	print "$line";
}
&powered_by;
exit;
}

##############################################################################
# The following 3subroutines take care of deleting categories
##############################################################################
sub dc {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&dc2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Select a page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="dc2">
			<table border="0" cellpadding="5" cellspacing="2">
			<tr><td>
			Please select the page where you want the category to be removed from:</td>
			<td><select name="realname">
			<option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select></td><tr><td colspan="2" align="center">
			<input type="submit"></td></tr></table>
			</form>
			~;
		}
		print "$line";
	}
	&powered_by;
}
}

sub dc2 {
# Select a category to delete
&mainpage unless $FORM{'realname'};
&getname($FORM{'realname'});

if ($FORM{'realname2'} eq 'selectapage') { &dc; exit; }

&opendb;
@cat = &SelectFromTable_("main","*","lcname|eq|$FORM{'realname2'}");
&closedb;

($realname,$lcname,$categories) = split(/\/,$cat[1]);

print "Content-type: text/html\n\n";
&pageheader("Remove Category from $FORM{'realname'}");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Select Category</h2>
		You are about to remove a category from the following page: <b>$realname</b><br>
		Please note that the Q&A couples in that category are placed in the <b>General</b> category.<p>
		
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="dcn">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<input type="hidden" name="id" value="$id">
		<table border="0" cellpadding="5" cellspacing="2">
		<tr><td>
		Please select the category you want to remove:</td><td>
		<select name="cat">
		<option>Select a Category
		~;
		
		@cats = split(/\t/,$categories);
		
		foreach $c (sort @cats) {
			if (lc $c ne "general") {
				print "<option value=\"" . $c . "\">" . $c . "\n";
			}
		}
		
		print qq~
		</select>
		</td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr></table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;
}

sub dcn {
# Delete Category Now!
if (!$FORM{'realname'}) { &dc; exit; }
if (!$FORM{'cat'}) {&dc2; exit; }
if ($FORM{'cat'} =~ /select a category/i) {&dc2; exit;}
&getname($FORM{'realname'});

&opendb;
@data = &SelectFromTable_("main","*","lcname|eq|$FORM{'realname2'}");
($realname,$lcname,$categories) = split(/\/,$data[1]);
@cats = split(/\t/,$categories);
foreach $c (@cats) {
	if ($c ne $FORM{'cat'}) {
		push @newcat, $c;
	}
	else {
		$catfound=1;
	}
}
if ($catfound) {
	$categories = join "\t", @newcat;
	@check = eval(&UpdateTableSet_("main","AND","categories=$categories","lcname|eq|$lcname"));
	if ($check[0] != 0) { &closedb; &errors("updateproblem"); }
	
	@check = eval(&UpdateTableSet_("$FORM{'realname2'}","AND","category=General","category|eq|$FORM{'cat'}"));
	if ($check[0] == 1) { &errors("updateproblem"); }
	
} # END OF CATFOUND
&closedb;

&errors("ncd") unless $catfound;

print "Content-type: text/html\n\n";
&pageheader("Category Deleted");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Category deleted</h2>
		The category you specified (<b>$FORM{'cat'}</b>) has been deleted succesfully, and the Q&A couples in that category were placed in the <b>General</b> category.<p>
		<a href="$ENV{'SCRIPT_NAME'}?action=dc2&realname=$FORM{'realname'}&id=$id">Click here</a> if you want to delete another category from <b>$FORM{'realname'}</b>, <br>
		<a href="$ENV{'SCRIPT_NAME'}?action=dc&id=$id">click here</a> if you want to delete another category from another FAQ page,<br>
		or <a href="$ENV{'SCRIPT_NAME'}?&id=$id">click here</a> to return to the main page.
		~;
	}
	print "$line";
}
&powered_by;
}

##############################################################################
# The following 4 subroutines take care of renaming categories
##############################################################################
sub rc {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&rc2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Select a page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="rc2">
			<table border="0" cellpadding="5" cellspacing="2">
			<tr><td>
			Please select the page where the category resides you want to rename: </td>
			<td><select name="realname">
			<option>Select a page
			~;
			for($i=1;$i < scalar @check; $i++) {
				($realname,$lcname) = split(/\/,$check[$i]);
				print "<option value=\"" . $lcname . "\">" . $realname . "\n";
			}
			print qq~
			</select></td><tr><td colspan="2" align="center">
			<input type="submit"></td></tr></table>
			</form>
			~;
		}
		print "$line";
	}
	&powered_by;
}
}

sub rc2 {
# Select a Category to rename
if (!$FORM{'realname'}) { &rc; exit; }
&getname($FORM{'realname'});
if ($FORM{'realname2'} eq "selectapage") { &rc; exit; }

&opendb;
@data = &SelectFromTable_("main","*","lcname|eq|$FORM{'realname2'}");
&closedb;

($realname,$lcname,$categories) = split(/\/,$data[1]);
@cats = split(/\t/,$categories);

print "Content-type: text/html\n\n";
&pageheader("Please select the category");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Select Category</h2>
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="rc3">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<input type="hidden" name="id" value="$id">
		<table border="0" cellpadding="5" cellspacing="2">
		<tr><td>
		Please select the category you want to rename:</td>
		<td>
		<select name="cat">
		<option>Select a Category
		~;
		
		foreach $c (sort @cats) {
			if (lc $c ne "general") {
				print qq~<option value="$c">$c\n~;
			}
		}
		
		print qq~
		</select></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub rc3 {
# Rename the category

local($warn) = @_;

if (!$FORM{'realname'}) { &rc; exit; }
&getname($FORM{'realname'});
if ($FORM{'realname2'} eq "selectapage") { &rc; exit; }

if ($FORM{'cat'} eq "Select a Category") {
	&rc2;
	exit;
}

print "Content-type: text/html\n\n";
&pageheader("Rename Category");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Rename Category</h2>
		~;
		if ($warn) {
			print qq~
			<font color="#FF0000">Warning: $warn</font><br>
			~;
		}
		print qq~
		You have chosen to rename the category <b>$FORM{'cat'}</b> on the <b>$FORM{'realname'}</b> FAQ page.
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="rcn">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<input type="hidden" name="oldcat" value="$FORM{'cat'}">
		<input type="hidden" name="id" value="$id">
		<table border="0" cellpadding="5" cellspacing="2">
		<tr><td>
		Please enter the new name of the category:</td><td><input type="text" name="newcat" value="$FORM{'cat'}"></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr></table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub rcn {
# Rename Category NOW!
if (!$FORM{'realname'}) { &rc; exit; }
&getname($FORM{'realname'});
$FORM{'newcat'} =~ s/\t//ig;
if (!$FORM{'newcat'}) { &rc3("Please enter a Category Name"); exit; }

&rc3("Please enter a valid Category Name") if ($FORM{'newcat'} !~ m/\w/ig);

&opendb;
@data = &SelectFromTable_("main","*","lcname|eq|$FORM{'realname2'}");

($realname,$lcname,$categories) = split(/\/,$data[1]);
@cats = split(/\t/,$categories);

foreach $c (@cats) {
	if (lc $c eq lc $FORM{'oldcat'}) {
		push @newcats, $FORM{'newcat'};
		$catremoved=1;
	}
	else {
		push @newcats, $c;
	}
}
if ($catremoved) {
	$categories = join "\t", @newcats;
	@check = eval(&UpdateTableSet_("main","AND","categories=$categories","lcname|eq|$FORM{'realname2'}"));
	if ($check[0] != 0) { &closedb; &errors("updateproblem"); }
	@check = eval(&UpdateTableSet_("$FORM{'realname2'}","AND","category=$FORM{'newcat'}","category|eq|$FORM{'oldcat'}"));
	if ($check[0] == 1) { &closedb; &errors("updateproblem"); }
}
&closedb;

if (!$catremoved) { &errors("nocatremoved"); }

print "Content-type: text/html\n\n";
&pageheader("Category renamed");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Category Renamed</h2>
		The category was succesfully renamed.<p>
		<a href="$ENV{'SCRIPT_NAME'}?action=rc2&realname=$FORM{'realname2'}&id=$id">Click here</a> to rename another category in <b>$realname</b><br>
		<a href="$ENV{'SCRIPT_NAME'}?action=rc&id=$id">Click here</a> to rename another category in another FAQ page<br>
		<a href="$ENV{'SCRIPT_NAME'}?id=$id">Click here</a> to go to the main page.
		~;
	}
	print "$line";
}
&powered_by;

}
##############################################################################
# The following 4 subroutines take care of moving Q&A couples between categories
##############################################################################
sub moveqa {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&moveqa2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Select a page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="moveqa2">
			<table border="0" cellpadding="5" cellspacing="2">
			<tr><td>
			Please select the page where the Q&A couples are you want to move:</td>
			<td><select name="realname">
			<option>Select a page
			~;
			for($i=1;$i < scalar @check; $i++) {
				($realname,$lcname) = split(/\/,$check[$i]);
				print "<option value=\"" . $lcname . "\">" . $realname . "\n";
			}
			print qq~
			</select></td><tr><td colspan="2" align="center">
			<input type="submit"></td></tr></table>
			</form>
			~;
		}
		print "$line";
	}
	&powered_by;
}
}

sub moveqa2 {
local($warn) = @_;
# Select the questions you want to move
if (!$FORM{'realname'}) { &moveqa; exit; }
&getname("$FORM{'realname'}");
if (!$FORM{'realname2'} eq "selectapage") { &moveqa; exit; }

print "Content-type: text/html\n\n";
&pageheader("Select the Q&A couples you want to move");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Select Q&A couples</h2>
		~;
		if ($warn) {
			print qq~<font color="#FF0000">$warn</font><br>~;
		}
		print qq~
		Please select the Q&A couples you want to move. Please note that only the Questions are displayed here.
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="moveqa3">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<input type="hidden" name="id" value="$id">
		<table border="1" cellspacing="0" cellpadding="4">
		~;
		
		&opendb;
		@cat = &SelectFromTable_("main","AND","categories","lcname|eq|$FORM{'realname2'}");
		
		@cats = split(/\t/,$cat[1]);
		foreach $c (sort @cats) {
			print qq~<tr><td colspan="2"><font size="+1">$c</font></td></tr>~;
			@qa = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question","category|eq|$c");
			for($i=1;$i < scalar @qa;$i++) {
				($faqid,$question) = split(/\/,$qa[$i]);
				print qq~<tr><td><input type="checkbox" name="q" value="$faqid"></td><td>$question</td></tr>~;
			}
		}
		
		&closedb;
		
		print qq~
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub moveqa3 {
# Select the categories
if (!$FORM{'realname'}) { &moveqa; exit; }
&getname("$FORM{'realname'}");
if (!$FORM{'realname2'} eq "selectapage") { &moveqa; exit; }

if (!$FORM{'q'}) {&moveqa2("Please make sure you select questions before pressing the submit button"); exit; }

print "Content-type: text/html\n\n";
&pageheader("Move Q&A Couples");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Move Q&A Couples</h2>
		Please select the new category for each question. Note that the pre-selected category is the category where the question resides now.
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="moveqan">
		<input type="hidden" name="q" value="$FORM{'q'}">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<input type="hidden" name="id" value="$id">
		<table border="1" cellspacing="0" cellpadding="4">
		~;
		
		@qs = split(/\,/,$FORM{'q'});
		
		&opendb;
		@cat = &SelectFromTable_("main","AND","categories","lcname|eq|$FORM{'realname2'}");
		
		@cats = split(/\t/,$cat[1]);
		foreach $q (@qs) {
			@data = &SelectFromTable_("$FORM{'realname2'}","AND","category,question","faqid|eq|$q");
			($category,$question) = split(/\/,$data[1]);
			print qq~<tr><td><select name=$q>~;
			foreach $c (sort @cats) {
				print qq~<option value="$c"~;
				if (lc $c eq lc $category) {
					print " SELECTED";
				}
				print qq~>$c~;
			}
			
			print qq~</select></td><td>$question</td></tr>~;
		}
		
		&closedb;
		print qq~
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
		
	}
	print "$line";
}
&powered_by;

}

sub moveqan {
if (!$FORM{'realname'}) { &moveqa; exit; }
&getname("$FORM{'realname'}");
if (!$FORM{'realname2'} eq "selectapage") { &moveqa; exit; }
if (!$FORM{'q'}) { &moveqa2; exit; }
# Do the moving

@qs = split(/\,/,$FORM{'q'});

&opendb;
foreach $q (@qs) {
	&UpdateTableSet_("$FORM{'realname2'}","AND","category=$FORM{$q}","faqid|eq|$q");
}
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Q&A Couples moved!");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Q&A Couples moved</h2>
		The Q&A couples were move succesfully.<p>
		<a href="$ENV{'SCRIPT_NAME'}?action=moveqa&id=$id">Click here</a> to move Q&A couples on another FAQ page<br>
		<a href="$ENV{'SCRIPT_NAME'}?id=$id">Click here</a> to go to the main page.
		~;
	}
	print "$line";
}
&powered_by;

}

##############################################################################
# The following 3 subroutines take care of renaming FAQ pages
##############################################################################
sub rp {
# In this sub we check if there is only one faq page or not.....
&opendb;
@check = &SelectFromTable_("main","*","realname,lcname");
&closedb;

$num_keys = scalar @check;

if ($num_keys == 2) {
	($rn,$lcn) = split(/\/,$check[1]);
	$FORM{'realname'} = $rn;
	&rp2;				# Let's go to the next sub if there is only 1 FAQ page.
	exit;
}
elsif ($num_keys == 1 || $check[0] == 1) { &errors("no live"); }				# Print an error if there aren't any FAQ pages

else {
	print "Content-type: text/html\n\n";
	&pageheader("Select a page");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Select a page</h2>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="rp2">
			<table border="0" cellpadding="5" cellspacing="2">
			<tr><td>
			Please select the page you want to rename:</td>
			<td><select name="realname">
			<option>Select a page
			~;
			for($i=1;$i < scalar @check;$i++) {
				@names = split(/\/,$check[$i]);
				print "<option value=\"" . $names[1] . "\">" . $names[0] . "\n";
			}
			print qq~
			</select></td><tr><td colspan="2" align="center">
			<input type="submit"></td></tr></table>
			</form>
			~;
		}
		print "$line";
	}
	&powered_by;
}
}

sub rp2 {
local($warn) = @_;
# Get new name
if (!$FORM{'realname'}) { &rp; exit; }
&getname($FORM{'realname'});
if ($FORM{'realname2'} eq 'selectapage') { &rp; exit; }

&opendb;
@data = &SelectFromTable_("main","AND","realname","lcname|eq|$FORM{'realname2'}");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Rename Page");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Rename Page</h2>
		~;
		
		if ($warn) {
			print qq~<font color="#FF0000">$warn</font><br>~;
		}
		
		print qq~
		Please fill out the form below:
		<form action="$ENV{'SCRIPT_NAME'}" method="post">
		<input type="hidden" name="action" value="rpn">
		<input type="hidden" name="id" value="$id">
		<input type="hidden" name="realname" value="$FORM{'realname'}">
		<table cellspacing="0" cellpadding="4">
		<tr><td>Please enter the new name:</td><td><input type="text" name="newname" value="$data[1]"></td></tr>
		<tr><td colspan="2" align="center"><input type="submit"></td></tr>
		</table>
		</form>
		~;
	}
	print "$line";
}
&powered_by;

}

sub rpn {
# Rename the page
if (!$FORM{'realname'}) { &rp; exit; }
&getname("$FORM{'realname'}");
if ($FORM{'newname'} !~ m/\w/i) { &rp2("Please enter a valid name"); exit;}

$FORM{'newname'} =~ s/\|//igs;

$oldname = $FORM{'realname2'};
&getname($FORM{'newname'});
$newname = $FORM{'realname2'};

&opendb;

@check = eval(&CreateTable_("$newname","faqid","category","question","answer"));
if ($check[0] != 0) { &closedb; &errors("createtable");}
@data = &SelectFromTable_("$oldname","*");
for($i=1;$i < scalar @data;$i++) {
	($faqid,$category,$question,$answer) = split(/\/,$data[$i]);
	&InsertIntoTable_("$newname","$faqid","$category","$question","$answer");
}
&UpdateTableSet_("main","AND","realname=$FORM{'newname'}|lcname=$newname","lcname|eq|$oldname");
&DropTable_("$oldname");
&closedb;

print "Content-type: text/html\n\n";
&pageheader("Page Renamed");
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		print qq~
		<h2>Page Renamed</h2>
		The FAQ page was successfully renamed.<p>
		Please <a href="$ENV{'SCRIPT_NAME'}?id=$id">click here</a> to go back to the main page.
		~;
	}
	print "$line";
}
&powered_by;

}

##############################################################################
# This subroutine takes care of error handling
##############################################################################
sub errors {
local($errors) = @_;
print "Content-type: text/html\n";
&expires_header;
print "\n";
&pageheader('An error occured');
foreach $line (@temptoken) {
	if ($line =~ m/$token/i) {
		
		if ($errors eq 'with the email address you gave') {
			print qq~
			<h2>Error with the email address you provided</h2>
			There is a problem witht the email address you gave. It's seems the the address is not valid.<br> Please click  BACK and try again.<p>
			Thank you.
			~;
		}
		
		elsif ($errors eq 'with the password') {
			print qq~
			<h2>Login problem</h2>
			There is a problem with the password. Please try again:<p>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="login">
			<table border="0" cellpadding="2" cellspacing="2">
			<tr><td>Password:</td><td><input type="password" name="password"></td></tr>
			</table><br>
			<input type="submit">
			</form>
			~;
		}
		
		elsif ($errors eq 'with the realname') {
			print qq~
			<h2>Problem with the name</h2>
			There is a problem with the name of the page. Either you didn't provide a name at all, or the name you provided is already in use in a somewhat shortened version. Please try again:<p>
			<form action="$ENV{'SCRIPT_NAME'}" method="post">
			<input type="hidden" name="action" value="cnpn">
			<input type="hidden" name="id" value="$id">
			<table border="0" cellpadding="2" cellspacing="2" width="70%">
			<tr><td>What will be the name of the new FAQ page? Please note that all the pages are called: <b>&quot;The</b> FAQ_NAME <b>FAQ's&quot;</b></td><td valign="top">The <input type="text" maxlength="20" name="realname"> FAQ's</td></tr>
			</table>
			<br><input type="submit">
			</form>
			
			~;
		}
		
		elsif ($errors eq 'q') {
			print qq~
			<h2>Question problem</h2>
			There is a problem with the question you gave. Please hit the back button below, and try again.
			~;
		}
		
		elsif ($errors eq 'a') {
			print qq~
			<h2>Answer problem</h2>
			There is a problem with the answer you gave. Please hit the back button below, and try again.
			~;
		}
		
		elsif ($errors eq "no live") {
			print qq~
			<h2>Error</h2>
			You should first create a FAQ page. <a href="$ENV{'SCRIPT_NAME'}?action=create_new_faq_page">Click here</a> to begin!
			~;
		}
		
		elsif ($errors eq "oldpass") {
			print qq~
			<h2>Problem with password</h2>
			The old password you provided is not correct. Please try again.
			~;
		}
		
		elsif ($errors eq "newpass") {
			print qq~
			<h2>Problem with new passwords</h2>
			The 2 new passwords you provided are not the same. Please try again.
			~;
		}
		
		elsif ($errors eq "error1") {
			print qq~
			<h2>Serious problem</h2>
			There is a serious problem, which might be a programming problem, or a database problem. Please try again.
			~;
		}
		
		elsif ($errors eq "error2") {
			print qq~
			<h2>No Category</h2>
			Please provide a category for further processing. We cannot go on at this point. Please hit the back button below.
			~;
		}
		
		elsif ($errors eq "error3") {
			print qq~
			<h2>Error</h2>
			There is a serious problem, which could be a bug in the programming, or a bug in the system. Please try again, by starting all over. <a href="$ENV{'SCRIPT_NAME'}?action=mqa">Click here.</a>
			~;
		}
		
		elsif ($errors eq "error4") {
			print qq~
			<h2>No Q&A couple to delete</h2>
			You didn't select any Q&A couple to be deleted. If you don't want to delete any, please <a href="$ENV{'SCRIPT_NAME'}?id=$id">click here</a> to go back to the main screen. Else, click the back button below.
			~;
		}
		
		elsif ($errors eq "ncd") {
			print qq~
			<h2>No category deleted</h2>
			Strangely enough there was a problem deleting the category you specified. Please try again.
			~;
		}
		
		elsif ($errors eq "catthere") {
			print qq~
			<h2>Category already exists</h2>
			The category you specified (<b>$FORM{'cat'}</b>) already exists in <b>$FORM{'realname'}</b>. <br>Please try again
			~;
		}
		
		elsif ($errors eq "update problem") {
			print qq~
			<h2>Update Problem</h2>
			I'm very sorry, but there was a problem updating the database. Either the table specified doesn't exist, or  there was no record to update. <br>Please try again $check[0]
			~;
		}
		
		elsif ($errors eq "nocatremoved") {
			print qq~
			<h2>No Category Renamed</h2>
			We were unable to rename the category since $FORM{'oldcat'} doesn't seem to be a valid category. Please try again.
			~;
		}
		
		elsif ($errors eq "inserting new qa") {
			print qq~
			<h2>Problem inserting new QA</h2>
			There was a problem with inserting the new Q&A couple. There are 4 possiblities:
			<ol>
			<li>Table does not exists
			<li>Primary Key violations
			<li>Foreign key violations
			<li>record already exists
			</ol>
			The problem is number $check[0].<p>Please try again.
			~;
		}
		
		elsif ($errors eq "updateproblem") {
			print qq~
			<h2>Problem updating record</h2>
			There was a problem updating the record. There are 2 possibilities:
			<p>
			Code 1: Table non-existent<br>
			Code 4: No records to update<p>
			You are dealing with a code $check[0].<p>Please try again.
			~;
		}
		
		elsif ($errors eq "deleting record") {
			print qq~
			<h2>Problem deleting a record</h2>
			There was a problem deleting the record. There are 3 possibilities:
			<p>
			Code 1: Table non-existent <br>
			Code 4: No record found matching conditions - delete did not occur <br>
			Code 5: Error conditions <p>
			You are dealing with a code $check[0].<p>Please try again.
			~;
		}
		
		elsif ($errors eq "drop table") {
			print qq~
			<h2>Problem dropping a table</h2>
			There was a problem dropping a table. There are 2 possibilities:
			<p>
			Code 1 - Table does not exist <br>
			Code 3 - Error: foreign key violations <p>
			You are dealing with a code $check[0].<p>Please try again.
			~;
		}
		
		elsif ($errors eq "createtable") {
			print qq~
			<h2>Problem creating a table</h2>
			There was a problem creating a table. There are 4 possibilities:
			<p>
			Code 2 - Table already exists - Try another name<br>
			Code 6 - field contains the separator char - Script problem. Reinstall original script<br>
			Code 7 - there are columns with the same name - Script problem. Reinstall original script<br>
			Code 8 - the table name doesn't begin with a letter - Enter a name which starts with a letter<p>
			You are dealing with a code $check[0].<p>Please try again.
			~;
		}
		
		else {
			print qq~
			<h2>Error: undefined!</h2>
			An error occured and freEcards does not know what caused the error. Please try again.
			~;
		}
		
		print qq~
		<center><FORM><INPUT type="button" value="Back" onClick="history.go(-1)"></FORM></center>
		~;
	}
	print "$line";
}
&powered_by;
exit; # Exit the script when an error occured.
}

sub opendb {
&LockAndOpen_("","FAQGen");
&CreateDatabase_;
}

sub closedb {
&UnlockAndCommit_;
}
