#!c:/perl/bin/perl

##############################################################################
# MTVWebdesign FAQ Generator                        Version 2.1 (20003103)
# faq.cgi: The main script
# Copyright 1999-2000 Maarten Veerman mtveerman@mindless.com
# MTVWebdesign:    http://mtvwebdesign.hypermart.net/ (http://mtvwebdesign.hypermart.net/scripts/)
##############################################################################
# COPYRIGHT NOTICE
# Copyright 1999-2000 Maarten Veerman  All Rights Reserved.
#
# FAQGen may be used and modified so long as this
# copyright notice and the comments above remain intact.  By using this
# code you agree to indemnify Maarten Veerman from any liability that
# might arise from its use.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  In other words, please ask first before you try and
# make money off of my program in any way.
#
# Obtain permission before redistributing this software over the Internet or
# in any other medium. In all cases copyright and header must remain intact
#
# Please send bug-reports to cgi-bugs@mtvwebdesign.hypermart.net
##############################################################################
#
# Script tested locally:
# Pentium 400Mhz, 128MB RAM, Windows 98, Apache 1.3.4 (win32), Perl, MS Internet Explorer 5.0, Netscape 4.05.
#
# Please do not remove or change the following 2 lines:
$scriptname = "FAQGen";
$version = "2.1";
##############################################################################
# Please note that we abbreviate names of subroutines. This can be difficult when you want
# to edit the script. Therefor we included comments before every sub(group)
##############################################################################

# Configuration
use CGI::Carp qw(fatalsToBrowser); # Provides you with fatal error message if they occur.
require 'faq.conf';
require $mtvwebdesignlib;
require $dbunderpath;
$dbdir = &dbdir_;
require $dbunder;

# The Main Routine
main: {
	&getinput;
	&check_url;
	
	$webmasteremail = $FORM{'webmasteremail'} || $webmasteremail;
	
	if (lc $FORM{'action'} eq 'logout') {&logout}
	elsif (lc !$FORM{'faqname'}) { &mainpage }
	else { &read_faq; }
	exit;
	
}

###################################################################
# This will print the mainpage. Either in a tokenfile (if specified) or just plain HTML.
# It'll print a list of all available FAQ pages, and if there aren't any, it'll redirect
# us to the error sub, which will print an error page telling us that there
# aren't any FAQ pages yet.
###################################################################
sub mainpage {
	local($warn) = @_;
	
	&opendb;
	@data = &SelectOrderByFromTable_("realname","main","AND","realname,lcname");
	&closedb;
	
	if (@data[0] == 1) { &errors('no faq pages') }
	
	print "Content-type: text/html\n\n";
	&pageheader("Available FAQ pages");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<h2>Available FAQ pages</h2>
			~;
			
			if ($warn) {
				print qq~<font color="#FF0000">$warn</font><br>~;
			}
			
			print qq~
			Here you find a list of all the faq pages on this system. Click on the titles to read them.<p>
			~;
			
			for ($i=1;$i < scalar @data;$i++) {
				($realname,$lcname) = split(/\/,$data[$i]);
				print "<li><a href=\"" . $ENV{'SCRIPT_NAME'} . "?faqname=" . $lcname . "\">" . $realname . "</a><br>\n";
			}
			
		}
		print "$line";
	}
	&powered_by;
}

###################################################################
# This will read the FAQ database and determine if there is any data.
# If there aren't any Q&A Couples, it'll print an error.
# After that, it checks if there are more than 1 categories. If so, we go to
# printpage1, else we go to
# printpage2
###################################################################
sub read_faq {
	&getname($FORM{'faqname'});
	
	&opendb;
	@page = &SelectFromTable_("main","AND","realname,lcname,categories","lcname|eq|$FORM{'realname2'}");
	($realname,$lcname,$categories) = split(/\/,$page[1]);
	print "Content-type: text/html\n\n";
	&pageheader("The $realname FAQ's");
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			print qq~
			<a name="index"></a>
			<h2>The $realname FAQ's</h2>
			~;
			
			@cats = split(/\t/,$categories);
			if (scalar @cats > 1) { $cs=1; } # There is more than 1 category.
			
			if ($cs) {
				# First we print the general category
				@data = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question,answer","category|eq|General");
				if (scalar @data > 1) {
					print qq~<h3>General questions</h3>~;
					print qq~<ol>~;
					for($i=1;$i < scalar @data;$i++) {
						($faqid,$question,$answer) = split(/\/,$data[$i]);
						print qq~<li><a href="\#$faqid">$question</a>~;
					}
					print qq~</ol>~;
				}
				foreach $cat (sort {uc($a) cmp uc($b)} @cats) {
					if (lc $cat ne "general") {
						@data = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question,answer","category|eq|$cat");
						if (scalar @data == 1) { next; }
						
						print qq~<h3>$cat</h3>~;
						print qq~<ol>~;
						for($i=1;$i < scalar @data;$i++) {
							($faqid,$question,$answer) = split(/\/,$data[$i]);
							print qq~<li><a href="\#$faqid">$question</a>~;
						}
						print qq~</ol>~;
					}
				}
				print "<hr noshade>";
				####
				# Now we can print the actual page.
				####
				
				# First we print the general category
				@data = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question,answer","category|eq|General");
				if (scalar @data > 1) {
					print qq~<h3>General questions</h3>~;
					for($i=1;$i < scalar @data;$i++) {
						($faqid,$question,$answer) = split(/\/,$data[$i]);
						print qq~<a name="$faqid"></a><b>Q: $question</b><p><b>A:</b> $answer<p align="right"><a href="\#index">Back to Index</a></p><hr noshade>~;
					}
				}
				foreach $cat (sort {uc($a) cmp uc($b)} @cats) {
					if (lc $cat ne "general") {
						@data = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question,answer","category|eq|$cat");
						if (scalar @data == 1) { next; }
						print qq~<h3>$cat</h3>~;
						for($i=1;$i < scalar @data;$i++) {
							($faqid,$question,$answer) = split(/\/,$data[$i]);
							print qq~<a name="$faqid"></a><b>Q: $question</b><p><b>A:</b> $answer<p align="right"><a href="\#index">Back to Index</a></p><hr noshade>~;
						}
					}
				}
			}
			else {
				# Just print a nice FAQ page.
				@data = &SelectOrderByFromTable_("question","$FORM{'realname2'}","AND","faqid,question,answer");
				
				print qq~
				<ol>
				~;
				for ($i=1;$i < scalar @data;$i++) {
					($faqid,$question,$answer) = split(/\/,$data[$i]);
					print qq~<li><a href="\#$faqid">$question</a>~;
				}
				print qq~
				</ol>
				<hr noshade>
				~;
				
				for ($i=1;$i < scalar @data;$i++) {
					($faqid,$question,$answer) = split(/\/,$data[$i]);
					print qq~<a name="$faqid"></a><b>Q: $question</b><p><b>A:</b> $answer<p align="right"><a href="\#index">Back to Index</a></p><hr noshade>~;
				}
				
			}
			
			print qq~
			If you still have a question and you cannot find the answer on this page, please let us know by emailing us at: <a href="mailto:$webmasteremail">$webmasteremail</a>.
			~;
			
		}
		print "$line";
	}
	&powered_by("nologout");
	
	&closedb;
}

###################################################################
# The following sub will truncate the realname of the FAQ page so we can use it
# for a filename. It'll return the variable $FORM{'realname2'}
###################################################################
sub getname {
	local($x) = @_;
	$FORM{'realname2'} = $x;
	$FORM{'realname2'} =~ s/\W//ig;
	$FORM{'realname2'} = lc $FORM{'realname2'}
}

###################################################################
# If an error occured, we are being redirected to this subroutine.
###################################################################
sub errors {
	local($errors) = @_;
	
	print "Content-type: text/html\n";
	&expires_header;
	print "\n";
	&pageheader('An error occured');
	foreach $line (@temptoken) {
		if ($line =~ m/$token/i) {
			
			if ($errors eq 'with the email address you gave') {
				print qq~
				<h2>Error with the email address you provided</h2>
				There is a problem witht the email address you gave. It's seems the the address is not valid.<br> Please click  BACK and try again.<p>
				Thank you.
				~;
			}
			
			elsif ($errors eq 'no faq pages') {
				print qq~
				There are no faq pages available at this moment. There are 2 reasons:<p>
				<ol>
				<li>The script is in it's testing period, and the webmaster did not create the rooms yet.
				<li>There is a problem with the following file: $db_dir$maindb.db
				</ol>
				<p>
				If you are the administrator of this service, you need to go to the admin script, and there you can create faq-pages.
				~;
			}
			
			elsif ($errors eq "error1") {
				print qq~
				<h2>No Q&A's</h2>
				I'm very sorry, but there are no Q&A's at this moment in this FAQ page. The webmaster has not yet completed the setup sequence.
				~;
			}
			
			else {
				print qq~
				<h2>Error: undefined!</h2>
				An error occured and freEcards does not know what caused the error. Please try again.
				~;
			}
			
			print qq~
			<center><FORM><INPUT type="button" value="Back" onClick="history.go(-1)"></FORM></center>
			~;
		}
		print "$line";
	}
	&powered_by;
	exit; # Exit the script when an error occured.
}

sub opendb {
	&LockAndOpen_("","FAQGen");
	&CreateDatabase_;
}

sub closedb {
	&UnlockAndCommit_;
}
