#!/usr/bin/perl
#######################
##  AutoRank v2.1.1  ##
###################################################
##  accounts.cgi - add accounts to the database  ##
###################################################

package acct;

use lib '.';                                      ## On NT you may need to use a full path here
use strict;
use cgiworks;

print "Content-type: text/html\n\n";
$HEADER = 1;

eval {
  require "$DDIR/vars.dat";
  main();
};

err("$@", 'accounts.cgi') if( $@ );
exit;

sub main {
  if( $ENV{'REQUEST_METHOD'} eq "GET" ) {
    display_add();
  }
  else {
    parsepost(1);
  
    my $call = lc( $FRM{'submit'} );
    $call =~ s/ /_/g;  
    *function = $call;
  
    derr(1001, "No Function Selected") unless( $call );
   
    &function();
  }
}

sub display_add {
  $TPL{'MAXT'} = $VAR::MT;
  $TPL{'MAXD'} = $VAR::MD;
  fparse('_account_add.htmlt');
}

sub add_account {
  verifyinput();
  sendemail() if( $OPT::EML );
  
  my $up = pack('u', $FRM{'pw_rq'});
  chomp($up);

  fjoin("$DDIR/members/$FRM{'un_rq'}.dat", $FRM{'st_rq'}, $FRM{'su_rq'}, $FRM{'sd_rq'}, $FRM{'em_rq'}, $FRM{'bu'}, crypt($FRM{'pw_rq'}, getsalt()), $up);
  fwrite("$DDIR/members/$FRM{'un_rq'}.cnt", '0|0');

  $TPL{'STL'} = $FRM{'st_rq'};
  $TPL{'SUL'} = $FRM{'su_rq'};
  $TPL{'SDS'} = $FRM{'sd_rq'};
  $TPL{'EML'} = $FRM{'em_rq'};
  $TPL{'BUL'} = $FRM{'bu'};
  $TPL{'PWD'} = $FRM{'pw_rq'};
  $TPL{'UNM'} = $FRM{'un_rq'};
  $TPL{'TUL'} = $VAR::IU . "?id=" . $FRM{'un_rq'};

  fparse('_account_added.htmlt');
}

sub sendemail {
  my $msg = "To: $FRM{'em_rq'}\nFrom: $VAR::EM\nSubject: Addition To Top List\n\n" .
            "Your information has been added to our database.\n" .
            "You can begin sending hits to the list at any time\n" .
            "and you will be listed, if you send enough hits, at the\n" .
            "next update.  Below is your linking information.\n\nURL to send hits to:\n" .
            $VAR::IU . "?id=$FRM{'un_rq'}\n\nYour User ID: $FRM{'un_rq'}\n" .
            "Your Password: $FRM{'pw_rq'}\n\nThanks for joining,\nTop List Webmaster\n" .
            "$VAR::HU/autorank.html";

  mail($VAR::ES, \$msg, \%TPL);
}

sub verifyinput {
  derr(1003, "Account Already Exists") if( -e "$DDIR/members/$FRM{'un_rq'}.dat" );
  derr(1004, "Invalid Site URL") if( $FRM{'su_rq'} !~ /^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+/ );
  derr(1004, "Invalid Banner URL") if( $FRM{'bu'} !~ /^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+/ && $FRM{'bu'} ne '' );
  derr(1005, "Invalid E-mail Address") if( $FRM{'em_rq'} !~ /^[\w\d][\w\d\,\.\-]*\@([\w\d\-]+\.)+([a-zA-Z]{3}|[a-zA-Z]{2})$/ );
  derr(1006, "Site Title Oversized") if( length($FRM{'st_rq'}) > $VAR::MT );
  derr(1006, "Site Description Oversized") if( length($FRM{'sd_rq'}) > $VAR::MD );
  derr(1006, "Username Malformed") if( length($FRM{'un_rq'}) > 8 || length($FRM{'un_rq'}) < 5 );
  derr(1008, "Invalid Character In Username") if($FRM{'un_rq'} !~ m/^[a-zA-Z0-9]*$/gi);
  derr(1006, "Password Malformed") if( length($FRM{'pw_rq'}) > 8 || length($FRM{'pw_rq'}) < 5 );
  derr(1007, "Passwords Don't Match") if( $FRM{'pw_rq'} ne $FRM{'vp_rq'} );

  for( keys %FRM ) {
    $FRM{$_} =~ s/\|//g;
    derr(1002, "Required Form Field Left Blank") if( $_ =~ /_rq$/ && $FRM{$_} eq "" );
  }
}