#!/usr/bin/perl
#######################
##  AutoRank v2.1.0  ##
###################################################
##  upgrade.cgi - upgrade from AutoRank 2.0.0    ##
###################################################

$DDIR = "./data";

print "Content-type: text/html\n\n";

eval {
  require "./sdata/variables.dat";
  main();
};

if( $@ ) {
  print "<b>Script Error:</b> $@";
  exit;
}

sub main {
  err("Database has already been upgraded") if( -e "$DDIR/done" );

  my $mems = dread($VARIABLES::MEMBER_DATA_DIR, '.mdf$');

  dcreate("$DDIR/members", 0777);

  for( @{ $mems } ) {
    my $md = fsplit("$VARIABLES::MEMBER_DATA_DIR/$_");
    my $mem = $_;
    $mem =~ s/\.mdf$//;

    fjoin("$DDIR/members/$mem.dat", $md->[5], $md->[4], $md->[6], $md->[7], $md->[8], $md->[9], '');
    fjoin("$DDIR/members/$mem.cnt", 0, 0);
  }

  fjoin("$DDIR/done", 'done');
  print "<pre>", scalar(@{ $mems }), " members upgraded to new database system.\nYou are now ready to continue the upgrade";
}

sub dread {
  my($dir, $patt) = @_;
  opendir(DIR, $dir) || err("Cannot read $dir");
  my @files = grep { /$patt/ } readdir(DIR);
  closedir(DIR);

  return \@files;
}

sub dcreate {
  my($dir, $perms) = @_;
  $perms = 0755 if( !defined $perms );
  if( !-e $dir ) {
    mkdir($dir, $perms) || err($!, $dir);
    chmod($perms, $dir) || err($!, $dir);
  }
}

sub fsplit {
  my($file) = shift;
  open(FILE, "$file") || err("Cannot read file $file");
  flock(FILE, 1);
  my @data = split(/\|/, <FILE>);
  close(FILE);

  return \@data;
}

sub fjoin {
  my($file, @data) = @_;
  open(FILE, ">$file") || err("Cannot write file $file");
  flock(FILE, 2);
  print FILE join('|', @data);
  close(FILE);
  chmod(0666, $file) if( -O $file );
}

sub err {
  my $msg = shift;
  print "<pre>$msg";
  exit -1;
}