#!/usr/bin/perl
#######################
##  AutoRank v2.1.1  ##
###################################################
##  setup.cgi - setup the script variables       ##
###################################################

package setup;

use lib '.';                                      ## On NT you may need to use a full path here
use strict;
use cgiworks;

print "Content-type: text/html\n\n";
$HEADER = 1;

eval {
  require "$DDIR/errors.dat";
  main();
};

err("$@", 'setup.cgi') if( $@ );
exit;

sub main {
  if( $ENV{'REQUEST_METHOD'} eq "GET" ) {
    first();
    fparse('_setup_login.htmlt');
  }
  else {
    parsepost();
    derr(1000, "Invalid Password") unless validpass(freadline("$DDIR/admin.epf"), $FRM{'pw'});
  
    my $call = lc( $FRM{'submit'} );
    $call =~ s/ /_/g;  
    *function = $call;
  
    derr(1001, "No Function Selected") unless( $call );
   
    &function();
  }
}

sub display_main {
  my @opt = qw(OPT_OUT OPT_EML);
  my $vars = freadall("$DDIR/vars.dat") if( -e "$DDIR/vars.dat" );

  for( @{ $vars } ) {
    $_ =~ m/\$([^\s]+) = '([^']*)'/;
    my($vrbl, $val) = ($1, $2);
    if( $vrbl ne "" ) {
      $vrbl =~ s/::/_/;
      $TPL{$vrbl} = $val;
    }
  }

  for( @opt ) {
    $TPL{$_} = getcb( $_, $TPL{$_} );
  }
  
  fparse('_setup_main.htmlt');
}

sub change_pass {
  derr(1007, "Passwords do not match") if( $FRM{'npw'} ne $FRM{'vpw'} );
  derr(1002, "No password entered") if( $FRM{'npw'} eq "" );
  fwrite("$DDIR/admin.epf", crypt($FRM{'npw'}, getsalt()));
  fparse('_setup_pass.htmlt');
}

sub check_input {
  my @req = qw( VAR_CU VAR_EM VAR_ES VAR_HD VAR_HU VAR_RR VAR_RS VAR_SL VAR_MD VAR_MT );
  for( @req ) {
    derr(1002, "Required Field Left Blank") if( $FRM{$_} eq "" );
  }

  derr(1009, "Invalid HTML Directory") if( $FRM{'VAR_HD'} =~ /^http:\/\// );
  derr(1010, "Invalid Site Title Max Length") if( $FRM{'VAR_MT'} < 1 );
  derr(1010, "Invalid Site Description Max Length") if( $FRM{'VAR_MD'} < 1 );
}

sub save_data {
  check_input();

  $FRM{'VAR_IU'} = $FRM{'VAR_CU'} . "/rankem.cgi";
  $FRM{'VAR_OU'} = $FRM{'VAR_CU'} . "/out.cgi";
  dcreate("$DDIR/members", 0777);
  fcreate("$FRM{'VAR_HD'}/autorank.html");
  fwrite("$DDIR/rerank", time) if( !-e "$DDIR/rerank" );
  fwrite("$DDIR/reset", time) if( !-e "$DDIR/reset" );
  fwrite("$DDIR/vars.dat", '1;') if( !-e "$DDIR/vars.dat" );
  
  open(VARS, ">$DDIR/vars.dat") || err($!, "vars.dat");
  for( sort keys %FRM ) {
    my $key = $_;
    $key =~ s/_/::/;
    $FRM{$_} =~ s/'//g;
    $FRM{$_} =~ s/\/$//g;
    print VARS "\$$key = '$FRM{$_}';\n" if( $_ =~ /_/ );
  }
  print VARS "1;\n";

  $TPL{'SDDIR'}  = dirtest($DDIR);
  $TPL{'MHDIR'}  = dirtest($FRM{'VAR_HD'});
  $TPL{'RERANK'} = $FRM{'VAR_CU'} . "/rerank.cgi";

  fparse('_setup_done.htmlt');
}

sub first {
  if( !-e "$DDIR/admin.epf" ) {
    fwrite( "$DDIR/admin.epf", crypt('admin', getsalt()) );
    print qq|<center><font face="Verdana" color="red" size="2"><b>Administrative password set to: admin</b></font></center>|;
  }
}

sub getcb {
  my($item, $value) = @_;
  $item =~ s/::/_/;
  return qq|<input type="checkbox" name="$item" value="1" checked>| if( $value eq '1');
  return qq|<input type="checkbox" name="$item" value="1">|;
}

sub dirtest {
  my $dir = shift;  
  open(FILE, ">$dir/test.file") || return "<font color='red'>Failed!</font><br>Could Not Create File<br>$!";
  print FILE "TEST PASSED!";
  close(FILE);
  
  unlink("$dir/test.file") || return "<font color='red'>Failed!</font><br>Could Not Remove File<br>$!";
  
  return "<font color='blue'>Passed</font>";
}