##########################################################
##  CGI Works Library v1.0.0                 4/14/2000  ##
##########################################################

package cgiworks;

use strict;
use Socket;
use Exporter;
use SelfLoader;
use vars qw( @ISA @EXPORT $VERSION $HEADER $OPSYS $TDIR $DDIR $ERRLOG %TPL %FRM %QRY );

@ISA     = qw( Exporter );
@EXPORT  = qw( $HEADER $DDIR %TPL %FRM %QRY derr err fcreate fremove freadline freadall fparse
               mode dbdelete dbinsert dbupdate dbselect dcreate dread timetostr fdate ftime vparse
               fjoin urlencode parseget parsepost getsalt validpass fappend fwrite fsplit mail );

$OPSYS   = 'UNIX';
$DDIR    = './data';
$TDIR    = './templates';
$VERSION = '1.0.0';
$ERRLOG  = 1;
$HEADER  = 0;

1;

__DATA__

###                                     ###
###  BEGIN FILE MANIPULATION FUNCTIONS  ###
###                                     ###

sub fcreate {
  my($file, $perms) = @_;
  $perms = 0666 if( !defined $perms );
  if( !-e $file ) {
    open(FILE, ">$file") || err($!, $file);
    close(FILE);
    chmod($perms, $file) || err($!, $file);
  }
}

sub fremove {
  my($file) = shift;
  unlink($file) || err($!, $file);
}

sub freadline {
  my($file) = shift;
  open(FILE, $file) || err($!, $file);
  flock(FILE, 1);
  my $line = <FILE>;
  close(FILE);
  chomp($line);

  return $line;
}

sub freadall {
  my($file) = shift;
  open(FILE, $file) || err($!, $file);
  flock(FILE, 1);
  my @lines = <FILE>;
  close(FILE);
  chomp(@lines);

  return \@lines;
}

sub freadalls {
  my($file, $line) = shift;
  open(FILE, $file) || err($!, $file);
  flock(FILE, 1);
  while( <FILE> ) {
    $line .= $_;
  }
  close(FILE);
  return \$line;
}

sub fwrite {
  my($file, $data) = @_;
  open(FILE, ">$file") || err($!, $file);
  flock(FILE, 2);
  print FILE $data;
  close(FILE);
  chmod(0666, $file) if( -O $file );
}

sub fappend {
  my($file, $data) = @_;
  open(FILE, ">>$file") || err($!, $file);
  flock(FILE, 2);
  print FILE $data;
  close(FILE);
  chmod(0666, $file) if( -O $file );
}

sub fsplit {
  my($file) = shift;
  open(FILE, "$file") || err($!, $file);
  flock(FILE, 1);
  my @data = split(/\|/, <FILE>);
  close(FILE);

  return \@data;
}

sub fjoin {
  my($file, @data) = @_;
  open(FILE, ">$file") || err($!, $file);
  flock(FILE, 2);
  print FILE join('|', @data);
  close(FILE);
  chmod(0666, $file) if( -O $file );
}

sub mode {
  my($file, $perms) = @_;
  if( -O $file ) {
    chmod($perms, $file) || err($!, $file);
  }
}

###                                 ###
###  BEGIN TEXT DATABASE FUNCTIONS  ###
###                                 ###

sub dbdelete {
  my( $db, $key ) = @_;
  my($line, $found) = (0, 0);

  while( -e "$db.tmp" ) {
    sleep(1);
    if( time - $^T >= 15 ) {
      unlink("$db.tmp") || err($!, "$db.tmp");
      last;
    }
  }

  open(DB, $db) || err($!, $db);
  flock(DB, 1);
  open(TMP, ">$db.tmp") || err($!, "$db.tmp");
  flock(TMP, 2);
  while( $line = <DB> ) {
    if( $line =~ /^$key\|/ ) {
      $found = 1;
      next;
    }
    print TMP $line;
  }
  close(DB);
  close(TMP);

  unlink($db) || err($!, $db);
  rename("$db.tmp", $db) || err($!, "$db.tmp");

  return $found;
}

sub dbinsert {
  my( $db, @data ) = @_;
  my $line;
  open(DB, "+<$db") || err($!, $db);
  flock(DB, 2);
  while( $line = <DB> ) {
    if( $line =~ /^$data[0]\|/ ) {
      return 0;
    }
  }
  print DB join('|', @data) . "\n";
  close(DB);
  return 1;
}

sub dbselect {
  my( $db, $key ) = @_;
  my $line;
  open(DB, $db) || err($!, $db);
  flock(DB, 1);
  while( $line = <DB> ) {
    if( $line =~ /^$key\|/ ) {
      my @data = split(/\|/, $line);
      return \@data;
    }
  }
  close(DB);
  return 0;
}

sub dbupdate {
  my( $db, $key, @data ) = @_;
  my($line, $found) = (0, 0);

  while( -e "$db.tmp" ) {
    sleep(1);
    if( time - $^T >= 30 ) {
      unlink("$db.tmp") || err($!, "$db.tmp");
      last;
    }
  }

  open(DB, $db) || err($!, $db);
  flock(DB, 1);
  open(TMP, ">$db.tmp") || err($!, "$db.tmp");
  flock(TMP, 2);
  while( $line = <DB> ) {
    if( $line =~ /^$key\|/ ) {
      $line = join('|', @data) . "\n";
      $found = 1;
    }
    print TMP $line;
  }
  close(DB);
  close(TMP);

  unlink($db) || err($!, $db);
  rename("$db.tmp", $db) || err($!, "$db.tmp");

  return $found;
}


###                                          ###
###  BEGIN DIRECTORY MANIPULATION FUNCTIONS  ###
###                                          ###

sub dcreate {
  my($dir, $perms) = @_;
  $perms = 0755 if( !defined $perms );
  if( !-e $dir ) {
    mkdir($dir, $perms) || err($!, $dir);
    chmod($perms, $dir) || err($!, $dir);
  }
}

sub dread {
  my($dir, $patt) = @_;
  opendir(DIR, $dir) || err($!, $dir);
  my @files = grep { /$patt/ } readdir(DIR);
  closedir(DIR);

  return \@files;
}


###                                          ###
###  BEGIN DATE/TIME MANIPULATION FUNCTIONS  ###
###                                          ###

sub timetostr {
  my $time = $_[0];
  my $days = int($time / (60*60*24));
  my $string = "";
  
  $string .= $days . "d " if ($days > 0);
  $time -= $days * 60*60*24;
  my $hours = int($time / (60*60));
  $string .= $hours."h " if ($hours > 0);
  $time -= $hours *60*60;
  my $minutes = int($time / 60);
  $string .= $minutes."m " if ($minutes > 0);
  $time -= $minutes * 60;
  my $seconds = $time . "s";
  $string .= $seconds;
  
  return $string;
}

sub fdate {
  my($format, $time) = @_;
  my %fmt  = ();
  my %mths = ( 0 => "January", 1 => "February", 2 => "March",     3 => "April",   4 => "May",       5 => "June",
               6 => "July",    7 => "August",   8 => "September", 9 => "October", 10 => "November", 11 => "December");
  my %days = ( 0 => "Sunday", 1 => "Monday", 2 => "Tuesday", 3 => "Wednesday", 4 => "Thursday", 5 => "Friday", 6 => "Saturday");
  $format  = "%n-%j-%y" if( !defined $format );
  $time    = time if( !defined $time );
  my @date = localtime($time);

  my $mth = $date[4] + 1;
  
  $fmt{'d'} = length($date[3]) < 2 ? "0" . $date[3] : $date[3];               ## day of the month, 2 digits with leading zeros; i.e. "01" to "31"
  $fmt{'j'} = $date[3];                                                       ## day of the month without leading zeros; i.e. "1" to "31"
  $fmt{'D'} = substr($days{$date[6]}, 0, 3);                                  ## day of the week, textual, 3 letters; i.e. "Fri"
  $fmt{'w'} = $days{$date[6]};                                                ## day of the week, textual, long; i.e. "Friday"
  $fmt{'M'} = substr($mths{$date[4]}, 0, 3);                                  ## month, textual, 3 letters; i.e. "Jan"
  $fmt{'F'} = $mths{$date[4]};                                                ## month, textual, long; i.e. "January"
  $fmt{'m'} = length($mth) < 2 ? "0" . $mth : $mth;                           ## month, 2 digits with leading zeros;; i.e. "01" to "12"
  $fmt{'n'} = $date[4] + 1;                                                   ## month without leading zeros; i.e. "1" to "12"
  $fmt{'Y'} = $date[5] + 1900;                                                ## year, 4 digits; i.e. "1999"
  $fmt{'y'} = substr($date[5] + 1900, 2, 2);                                  ## year, 2 digits; i.e. "99"

  for( keys %fmt ) {
    $format =~ s/%([a-zA-Z])/$fmt{$1}/gise;
  }
  return $format;
}

sub ftime {
  my($format, $time) = @_;
  my %fmt  = ();
  $format  = "%g:%i%a" if( !defined $format );
  $time    = time if( !defined $time );
  my @date = localtime($time);
  
  $fmt{'a'} = $date[2] < 12 ? "am" : "pm";                                    ## "am" or "pm"
  $fmt{'h'} = $date[2] > 12 ? $date[2] - 12 : $date[2];                       ## hour, 12-hour format; i.e. "01" to "12"
  $fmt{'h'} = 12 if( $fmt{'h'} == 0 );
  $fmt{'h'} = length( $fmt{'h'} ) < 2 ? "0" . $fmt{'h'} : $fmt{'h'};
  $fmt{'H'} = length($date[2]) < 2 ? "0" . $date[2] : $date[2];               ## hour, 24-hour format; i.e. "00" to "23"
  $fmt{'g'} = $date[2] > 12 ? $date[2] - 12 : $date[2];                       ## hour, 12-hour format without leading zeros; i.e. "1" to "12"
  $fmt{'g'} = 12 if( $fmt{'g'} == 0 );
  $fmt{'G'} = $date[2];                                                       ## hour, 24-hour format without leading zeros; i.e. "0" to "23"
  $fmt{'i'} = length($date[1]) < 2 ? "0" . $date[1] : $date[1];               ## minutes; i.e. "00" to "59"
  $fmt{'s'} = length($date[0]) < 2 ? "0" . $date[0] : $date[0];               ## seconds; i.e. "00" to "59"

  for( keys %fmt ) {
    $format =~ s/%([a-zA-Z])/$fmt{$1}/gise;
  }
  return $format;
}


###                                 ###
###  BEGIN INPUT PARSING FUNCTIONS  ###
###                                 ###

sub parsepost {
  my( $rmhtml ) = shift;
  my( $value, $name, $buffer );
  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  my @pairs = split(/&/, $buffer);
	
  for (@pairs) {
    ($name, $value) = split(/=/, $_);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/</&lt;/g if($rmhtml);
    $value =~ s/>/&gt;/g if($rmhtml);
    $FRM{$name} .= (defined $FRM{$name}) ? "," . $value : $value;
  }
}

sub parseget {
  my @pairs = split(/&/, $ENV{'QUERY_STRING'});
  my ($name, $value);
  
  for (@pairs) {
    ($name, $value) = split(/=/, $_);
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $QRY{$name} = $value;
  }
}

sub urlencode {
  my $url = shift;
  $url =~ s/([^\w\.\-])/sprintf("%s%x", '%', ord($1))/eg;
  return $url;
}


###                            ###
###  BEGIN PASSWORD FUNCTIONS  ###
###                            ###

sub validpass {
  my($cp, $pass) = @_;
  my $salt = substr($cp, 0, 2);
  $salt = substr($cp, 3, 2) if($cp =~ /^\$/);
  return crypt($pass, $salt) eq $cp;
}

sub getsalt {
  my @chars = ('a'..'z', 'A'..'Z', '0'..'9', '.', '/');
  return $chars[ int(rand( $#chars + 1 )) ] . $chars[ int(rand( $#chars + 1 )) ];
}


###                            ###
###  BEGIN TEMPLATE FUNCTIONS  ###
###                            ###

sub fparse {
  my($page, $fh, $line) = @_;  
  $fh = *STDOUT if(!$fh);

  open(FILE, "$TDIR/$page") || err($!, $page);
  while( $line = <FILE> ) {
    $line =~ s/#%(.*?)%#/$TPL{$1}/gise;
    print $fh $line;
  }
  close(FILE);
}

sub vparse {
  my($html, $fh) = @_;
  $fh = *STDOUT if(!$fh);
  $$html =~ s/#%(.*?)%#/$TPL{$1}/gise;
  print $fh $$html;
}


###                          ###
###  BEGIN E-MAIL FUNCTIONS  ###
###                          ###

sub mail {
  my($mailer, $msg, $tpl) = @_;
  $$msg =~ s/#%(.*?)%#/$tpl->{$1}/gise;
  $mailer =~ /\// ? shell($mailer, $msg) : smtp($mailer, $msg);
}

sub smtp {
  my($mailer, $msg) = @_;
  
  $$msg =~ /To:\s*([^\n]*)\nFrom:\s*([^\n]*)\n/i;
  my $from = $2;
  my $to   = $1;
  
  my $ip   = inet_aton($mailer);
  my $padd = sockaddr_in(25, $ip);
  socket(SMTP, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
  connect(SMTP, $padd) || err($!, "SMTP Socket");

  smtpcmd(\*SMTP, "HELO localhost\n");
  smtpcmd(\*SMTP, "RSET\n");
  smtpcmd(\*SMTP, "MAIL FROM: <$from>\n");
  smtpcmd(\*SMTP, "RCPT TO: <$to>\n");
  smtpcmd(\*SMTP, "DATA\n");
  smtpcmd(\*SMTP, "$$msg\n.\n");
  smtpcmd(\*SMTP, "QUIT\n");

  close(SMTP);
}

sub smtpcmd {
  my($sock, $cmd) = @_;
  send($sock, $cmd, 0);
}

sub shell {
  my($mailer, $msg) = @_;
  open(MAIL, "|$mailer -t >>$DDIR/sml.log") || err($!, $mailer);
  print MAIL $$msg;
  close(MAIL);
}


###                                 ###
###  BEGIN ERROR HANDLING ROUTINES  ###
###                                 ###

sub err {
  my($cause, $file, $fnct) = @_;
  my $usr  = (getpwuid( $< ))[0] if( $OPSYS eq "UNIX");
  my $grp  = (getgrgid( $) ))[0] if( $OPSYS eq "UNIX");
  my @cone = caller(1);
  my @ctwo = caller(2);
  chomp($cause);
  
  $fnct = "$cone[3] from $cone[1]\n";
  $fnct = "$cone[3] -> $ctwo[3] from $cone[1] line $cone[2]\n" if( $cone[3] =~ /cgiworks/ );
  $fnct = "Unknown\n" if( $fnct =~ /^\sfrom\s$/ );

  fappend("$DDIR/error.log", "[ " . fdate("%m-%d-%y") . " " . ftime("%H:%i") . " ]  [ $file ]  [ $cause ]  [ $fnct ]\n") if( $ERRLOG && $file !~ /error\.log/ );

  print "Content-type: text/html\n\n" if( !$HEADER && $ENV{'REQUEST_METHOD'} );
  print "<pre>\n" if( $ENV{'REQUEST_METHOD'} );
  print "A CGI ERROR HAS OCCURRED\n========================\n";
  print "Error Message     :  $cause\n";   
  print "Accessing File    :  $file\n";
  print "Calling Function  :  $fnct";
  print "Running as User   :  $usr\n" if( $OPSYS eq "UNIX");
  print "Running as Group  :  $grp\n" if( $OPSYS eq "UNIX");

  exit -1;
}

sub derr {
  my($num, $data) = @_;

  eval {
    require "$DDIR/errors.dat";
  };
  
  err($@, "errors.dat") if( $@ );
  $TPL{'SERR'}  = "Data Error: $data";
  $TPL{'LERR'}  = $err::code{$num};
  fparse("_error_data.htmlt");

  exit -1;
}