#!/usr/bin/perl
#######################
##  AutoRank v2.1.1  ##
###################################################
##  ar.pl - shared AutoRank functions            ##
###################################################

package ar;

use lib '.';                                      ## On NT you may need to use a full path here
use strict;
use cgiworks;

eval {
  require "$DDIR/vars.dat";
};

err("$@", 'ar.cgi') if( $@ );

1;

sub getsorted {
  my %memhash;
  my $mems = dread("$DDIR/members", '.cnt$');

  for( @{ $mems } ) {
    my $mem = $_;
    $mem =~ s/\.cnt$//;
    my $cnt = fsplit("$DDIR/members/$_");
    $memhash{$mem} = $cnt->[0];
  }

  return (sort { $memhash{$ar::b} <=> $memhash{$ar::a} } keys %memhash);
}

sub rerank {
  require "$DDIR/errors.dat";
  my($rank, $head, $foot);
  my @sorted = getsorted();
  my $total = scalar(@sorted) < $VAR::SL ? scalar(@sorted) : $VAR::SL;

  $head = freadall("$DDIR/header.txt");
  $foot = freadall("$DDIR/footer.txt");

  open(LIST, ">$VAR::HD/autorank.html") || err($!, "autorank.html");
  print LIST @{ $head };

  for ($rank = 1; $rank <= $total; $rank++) {
    my $md = fsplit("$DDIR/members/$sorted[$rank - 1].dat");
    my $cd = fsplit("$DDIR/members/$sorted[$rank - 1].cnt");

    if ($cd->[0] >= $VAR::MH) {
      print LIST qq|<tr bgcolor="$VAR::RC">\n<td align="center">\n<font face="$VAR::FF" size="$VAR::FS">$rank</font>\n</td>\n|;
      print LIST qq|<td align="center">\n<font face="$VAR::FF" size="$VAR::FS">\n|;
      print LIST qq|<a href="$VAR::OU?id=$sorted[$rank - 1]&url=|, urlencode($md->[1]), qq|" target="$VAR::TG">|;
      print LIST qq|<img src="$md->[4]" border="0"><br>| if($rank <= $VAR::BN && $md->[4]);       
      print LIST qq|$md->[0]</a><br>$md->[2]</font></td>\n<td align="center">\n<font face="$VAR::FF" size="$VAR::FS">$cd->[0]</font></td>\n|;
      print LIST qq|<td align="center"><font face="$VAR::FF" size="$VAR::FS">$cd->[1]</font></td>\n</tr>\n|;        
    }
  }
  
  print LIST @{ $foot };
  print LIST qq|\n<font face="Verdana,Arial" size="1">Last Updated: |, fdate(), qq| |,  ftime() ,qq|<br>\n|;
  print LIST scalar(@sorted), qq| Sites In Our Database\n\n$err::code{'1075'}|;
  close(LIST);

  fwrite("$DDIR/rerank", time);
}

sub resetcnt {
  my $cnt = dread("$DDIR/members", '.cnt$');

  for( @{ $cnt } ) {
    fwrite("$DDIR/members/$_", '0|0');
  }
}