#!/usr/local/bin/perl

use Msql;

#**********************************************************************
# Program: AMS Installer
# Author:  Andrew Cowan (for Radiation)
# Date:    Feb. 2, 1998 
# LastMod: Jan. 29, 1999 
#**********************************************************************
#* Configuration Section                                              *
#**********************************************************************

# Defs for mSQL version
$msql_host = "localhost";
$msql_db = "ams";

$old_img_dir = "./ams_image";
$template_file = "configure.tmpl";  # configuration template file
$shell_file = "ams_shell";          # shell script file
$rem_file = "ams_remote";           # remote script file
$outfile = "ams-defs.pl";           # configuration output file

@private_list = (
   'ams_init-MSQL.pl', 'change_admin.pl', 'register.pl', 'retriever.pl'
);

@cgi_list = (
   'ams_admin.cgi', 'ams_stats.cgi', 'ams_ssi.cgi', 'ams_shell.pl',
   'ams_cgi.cgi', 'ams_remote.pl', 'spider.pl'
);

@public_list = (
   'ams-defs.pl', 'ams-utils.pl', 'encrypt.pl'
);

# Expect text-strings for variable substitution

$PERL = "<!--PERL-->";
$IMGU = "<!--IMG_URL-->";         
$CGIU = "<!--CGI_URL-->";
$CGID = "<!--CGI_DIR-->";
$EMAIL = "<!--EMAIL-->";
$TYPE = "<!--INST_TYPE-->";
$MSQL = "<!--MSQL-->";

$CONT = "-- press a key to continue --";

#**********************************************************************
#* Main Installation Routine                                          *
#**********************************************************************

# Read in configuration template file and ams shell file
$old_isep = $/;
undef $/;
open(CF, "$template_file");
$template = <CF>;
close(CF);
open(SF, "${shell_file}.tmpl");
$shell = <SF>;
close(SF);
open(SF, "${rem_file}.tmpl");
$remote = <SF>;
close(SF);
$/ = $old_isep;

print <<"HEAD";


This program will install the AMS on your system. In order for this
installation to be successful you must have:

1) A perl interpreter version 5.001 or later. The Hyperthread uses
   /usr/bin/perl as the default location for the perl interpreter.
   If your perl interpreter is located anywhere else you will need
   to make changes to the .cgi and .pl files which use the default.
2) Access to a CGI-BIN directory. You will need to have write access
   to the CGI directory or the installation will fail.

When you are ready to proceed press a key, you will then be prompted
to supply information needed for the installation.

$CONT
 
HEAD

$response = <STDIN>;

print "I need to know the full pathname for your Perl 5 interpreter. \n" .
      "(e.g. /usr/local/bin/perl) \n\n";

while(1){
   $perl_path = &get_response("Perl 5 Interpreter: ");
   last if &yn("Your Perl 5 Interpreter: $perl_path");
}

print "Now we must setup the CGI directory and install the \n" .
      "perl files within it. We will also setup the database \n" .
      "directory and make sure permissions are set correctly. \n" .
      "(e.g. /home/myaccount/public_html/cgi-bin/ams/) \n\n";

while(1){
   $cgi_dir = &get_response("Directory for CGI files: ");
   last if &yn("CGI Directory: $cgi_dir");
}

print "\nI will now need the URL corresponding to the CGI \n" .
      "directory specified for the AMS installation. \n" .
      "(e.g. http://www.mydomain.com/cgi-bin/ams/) \n\n";

while(1){
   $cgi_url = &get_response("URL for CGI files: ");
   last if &yn("CGI URL: $cgi_url");
}

unless (-d "$cgi_dir"){
   if (&yn("\n${cgi_dir} does not exist, create now? ")){
      print "Creating CGI directory...            ";
      mkdir $cgi_dir, 0755 || die "Error: $! \n\n";
      print "done. \n";
   }else{
      print "As you wish, terminating installation... \n\n";
      exit(0);
   }
}

print "Creating DB directory...             ";
$db_dir = "${cgi_dir}/ams_db";
unless (-d "$db_dir"){
   mkdir $db_dir, 0777 || die "Error creating DB directory: $! \n\n";
}
chmod 0777, $db_dir;
print "done. \n";


print "\nNow I need to know the email address to use for an \n" .
      "administrative contact. \n\n";

while(1){
   $email = &get_response("Admin Email: ");
   last if &yn("Admin Email: $email");
}

print <<"IMAGE";

AMS comes with a set of image files, which are used for the CGI
administrator and report panels. These images must be placed in a 
web-readable non-cgi-bin directory.
(e.g. /home/myaccount/public_html/amslite_images)

IMAGE

while(1){
   $img_dir = &get_response("Directory for image files: ");
   last if &yn("Images Directory: $img_dir");
}

print "\nNext I need to know the URL that corresponds to this directory \n" .
      "(e.g. http://www.mydomain.com/amslite_images) \n\n";

while(1){
   $img_url = &get_response("URL for image files: ");
   last if &yn("Images URL: $img_url");
}

unless (-d "$img_dir"){
   if (&yn("\n${img_dir} does not exist, create now? ")){
      print "Creating Images directory...         ";
      mkdir $img_dir, 0755 || die "Error: $! \n\n";
      print "done. \n";
   }else{
      print "As you wish, terminating installation... \n\n";
      exit(0);
   }
}

print "Copying Image files...               ";
&copy_images;
print "done. \n\n";


print "\nCreating configuration file now...   ";
&create_config;
print "done. \n";


print "Copying CGI files...                 ";
&copy_cgi;
print "done. \n";

print "Initializing databases...           \n";

print "Connecting to mSQL server...        ";

$dbh = Connect Msql $msql_host;
SelectDB $dbh $msql_db;

unless ($dbh){
   print "[failed: Cannot connect to mSQL server]\n";
   exit(0);
}

print "[done] \n";

print "Creating table 'ads' ...          ";

$sth = Query $dbh "CREATE TABLE ads(
       adkey char(75) not null,
       adurl char(250),
       linkurl char(250),
       alt char(150),
       method char(2),
       imax char(12),
       start char(30),
       end char(30),
       expm char(15),
       expt char(15),
       clickm char(15),
       clickt char(15),
       extras char(200),
       tog char(1) )";

unless ($sth){
   print "[failed: Cannot create table 'ads'] \n";
   exit(0);
}

print "[done]\nCreating default ads entry...                ";

$sth = Query $dbh "INSERT INTO ads (adkey, adurl, linkurl, alt, method, imax,
       start, end, expm, expt, clickm, clickt, extras, tog)
       VALUES ('--Default--', 'http://www.radiation.com/ads/thisis.gif',
       'http://www.radiation.com/products/ams/', 'This is AMS', 'NC', '', '', 
       '', '0', '0', '0', '0', 'width=378 height=60 border=1', 'A')";

unless ($sth){
   print "[failed: Cannot insert '--Default--' ad] \n";
   exit(0);
}

print "[done]\nCreating advertiser group table...              ";

$sth = Query $dbh "CREATE TABLE groups(
       groupkey char(75) not null,
       glist char(1000) )";

unless ($sth){
   print "[failed: Cannot create table 'groups'] \n";
   exit(0);
}

print "[done]\nCreating default group entry...             ";

$sth = Query $dbh "INSERT INTO groups (groupkey, glist)
       VALUES ('--Default--', '--Default--')";

unless ($sth){
   print "[failed: Cannot insert '--Default--' group] \n";
   exit(0);
}

print "[done]\nCreating relations table...                 ";

$sth = Query $dbh "CREATE TABLE rels(
       relkey char(75) not null,
       rlist char(5000) )";

unless ($sth){
   print "[failed: Cannot create table 'rels'] \n";
   exit(0);
}

print "[done]\nCreating system DBM database...             ";

$sys_db = $db_dir . "/" . "ams_system";
dbmopen(%DB, $sys_db, 0666);
dbmclose(DB);

print "[done]\nCreating Passwords DBM database...           ";

$sth = Query $dbh "CREATE TABLE pwds(
       userid char(15) not null,
       password char(15) )";

unless ($sth){
   print "[failed: Cannot create table 'pwds'] \n";
   exit(0);
}

print "[done]\n";

chop($date = `date +"%b %d %Y"`);

print "Creating administrator login entry...         ";

dbmopen(%DB, $sys_db, 0666);
$DB{'USERID'} = "Admin";
$DB{'PASSWORD'} = "Ch6C6x/eskGR6";
$DB{'DATE'} = $date;
dbmclose(DB);

&set_permissions;

print "[done] \n\n";

print "To access the administration or statistics panel use the following:\n" .
   "Username:  Admin \n" .
   "Password: ChangeMe \n\n";

print "Installation Complete.\n\n";

print <<"REG";
This installation of LinkTrakker will run only after it has been
electronically registered with Radiation. If you have problems
running the register.pl script at this time you will be able to
run it manually by typing 'perl register.pl' at the prompt.

NOTE: You must have an active connection to the internet before
the registration process will be completed.

The register.pl script will guide you through the rest of the registration
process.

$CONT
REG

$response = <STDIN>;

print "Starting the registration process (register.pl) ... \n\n";

my $register_result = system("$perl_path register.pl");

exit(0);

# ************************************************************************
# End of Initialization Routine
# ************************************************************************

exit(0);

# ************************************************************************
# Sub Set_Permissions - Set write permissions for DBM files 
# ************************************************************************

sub set_permissions{

   opendir(DB, "$db_dir");
   my @db_files = readdir(DB);
   closedir(DB);

   foreach $db (@db_files){
      next if ($db eq '.' || $db eq '..');
      my $this = "${db_dir}/${db}";
      chmod 0666, $this; 
   }

}

# ************************************************************************
# Sub Create_Config - Create the configuration file from the template 
# ************************************************************************

sub create_config{

   # Install type specifier
   my $itype = "mSQL";

   # Add Msql use statement
   my $msql = "use Msql;";

   # Remove trailing slashes if present
   if ($img_url =~ m#/$#){ chop($img_url); }
   if ($img_dir =~ m#/$#){ chop($img_dir); }
   if ($cgi_url =~ m#/$#){ chop($cgi_url); }
   if ($cgi_dir =~ m#/$#){ chop($cgi_dir); }

   $email =~ s/\@/\\\@/;

   # Make substitutions in configuration template
   $template =~ s/$IMGU/$img_url/;
   $template =~ s/$CGIU/$cgi_url/;
   $template =~ s/$CGID/$cgi_dir/;
   $template =~ s/$EMAIL/$email/;
   $template =~ s/$TYPE/$itype/;
   $template =~ s/$MSQL/$msql/;
   $shell =~ s/$CGID/$cgi_dir/;
   $remote =~ s/$CGIU/$cgi_url/;

   open(OF, ">$outfile");
   print OF $template;
   close(OF);

   open(SF, ">${shell_file}.pl");
   print SF $shell;
   close(SF);

   open(SF, ">${rem_file}.pl");
   print SF $remote;
   close(SF);

}

# ************************************************************************
# Sub Copy_CGI - Copy CGI files to cgi_dir 
# ************************************************************************

sub copy_cgi{

   foreach $file (@private_list){
      chmod 0600, $file; 
      `cp $file $cgi_dir`;
   }

   foreach $file (@cgi_list){
      chmod 0755, $file; 
      `cp $file $cgi_dir`;
   }

   foreach $file (@public_list){
      chmod 0644, $file; 
      `cp $file $cgi_dir`;
   }

}

# ************************************************************************
# Sub Copy_Images - Copy image files to img_dir 
# ************************************************************************

sub copy_images{

   opendir(ID, "$old_img_dir");
   @img_files = readdir(ID);
   closedir(ID);

   foreach $file (@img_files){
      next if ($file eq '.' || $file eq '..');
      my $src = "${old_img_dir}/${file}";
      `cp $src $img_dir`;
   }

}

# ************************************************************************
# Sub Yn - Issue a prompt and get a yes or no response 
# ************************************************************************

sub yn{

   my $prompt = shift;
   my $response;

   print "${prompt} [y|n] ";
   chomp($response = <STDIN>);

   if ($response =~ /^y/i){ return 1; }

   return 0;

}

# ************************************************************************
# Sub Get_Response - Issue a prompt and get a response 
# ************************************************************************

sub get_response{

   my $prompt = shift;
   my $response;

   print $prompt;
   chomp($response = <STDIN>);

   return $response;

}

# ************************************************************************
# End of Module: Unix Installer 
# ************************************************************************

