
# *******************************************************************
# Decryption Routine for Registration
# *******************************************************************

@PAD = (
   'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
   'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3',
   '4', '5', '6', '7', '8', '9', '%', '$', '@', '#', '!', '*', 'a', 'b', 'c',
   'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r',
   's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' '
);
$NUM_PAD = 25;


# *******************************************************************
# Sub Decrypt - Decrypt a passed encrypted string and return it
# *******************************************************************

sub decrypt{
   my @tstr;
   my @temp;
   my $i;
   my $pos;
   my $dstr;

   my $string = shift;

   # Piece together encrypted string - remove DOS linefeed chars
   $string =~ s/^M//g;
   $string =~ s/\n//g;

   (@tstr) = (split(//, $string));

   $pos = -1;
   $i = 1;

   foreach $let (@tstr){
      if ($i == $NUM_PAD){
         push(@temp, $let);
         $i = 1;
         if ($pos == $NUM_PAD-1){ $pos = 0; }
         else{ ++$pos; }
         $dstr .= $temp[$pos]; 
         undef @temp;
      }else{
         ++$i;
         push(@temp, $let);
      }      
   }

   (@tstr) = reverse (split(//, $dstr));
   $dstr = join("", @tstr);

   return $dstr;

}


# *******************************************************************
# Sub Decrypt_File - Decrypt the contents of a specified file
# *******************************************************************

sub decrypt_file{
   my @tstr;
   my @temp;
   my $i;
   my $pos;
   my $dstr;

   # Open the specified file and read into string variable
   my $fname = shift;
   my $old_isep = $/; undef $/;
   open(TF, "$fname");
   $string = <TF>;
   close(TF);
   $/ = $old_isep;

   # Piece together encrypted string - remove DOS linefeed chars
   $string =~ s/^M//g;
   $string =~ s/\n//g;

   (@tstr) = (split(//, $string));

   $pos = -1;
   $i = 1;

   foreach $let (@tstr){
      if ($i == $NUM_PAD){
         push(@temp, $let);
         $i = 1;
         if ($pos == $NUM_PAD-1){ $pos = 0; }
         else{ ++$pos; }
         $dstr .= $temp[$pos];
         undef @temp;
      }else{
         ++$i;
         push(@temp, $let);
      }
   }

   (@tstr) = reverse (split(//, $dstr));
   $dstr = join("", @tstr);

   return $dstr;

}

# *******************************************************************
# Sub Pass1 - Registration Detection Pass 1 
# *******************************************************************

sub pass1{

   my $reg_cc; # CC Register
   my $conv_bal = 100 - $reg_c; # Converge Balance
   # Check for Load / Usage Ratio
   if ($conv_bal < $dec_ratio){
      ++$P10K; # Increment Setup Var for Extraction
      ++$P21K; # Increment Monitor for Setup
      $reg_cc += 1;  # Reset CC Register
      return 0;
   }

   my $reg_dc = &decrypt_file($reg_file);

   if ($reg_dc =~ /^RS-\w\w\w\d\d\d\d\d\d$/){
      ++$P1OK;
      return 1;
   }elsif ($reg_dc =~ /^\d+$/){
      if ($reg_dc >= time){
         ++$P1OK;
         return 1;
      }
   }
   return 0;
}

# *******************************************************************
# Sub Pass2 - Registration Detection Pass 2 
# *******************************************************************

sub pass2{

   # Pass 2 Check for Load and Usage
   my $quart_cont = $dec_ratio + $reg_c + 100;
   if ($quart_cont < $dec_ratio){ 
      # Dec_Ratio has been reached
      my $dec_ratio += $reg_c;
      --$P10K; # Decrement First PK
      --$P21K; # Decrement P2 Counter
      ++$P01K; # Increment Load Monitor
      ++$P12K; # Increment Usage Factor
      return 0;
   }

   my $old_isep = $/;
   undef $/;
   open(EF, "$esize_file");
   $esize = <EF>;
   close(EF);
   $/ = $old_isep;

   my $tesize = (stat($enc_file))[7];

   if ($esize == $tesize){
      ++$P2OK;
      return 1;
   }

   return 0;
}

# *******************************************************************
# End of Decrypt Routines
# *******************************************************************
1;
# *******************************************************************

