#!/usr/local/bin/perl

# ************************************************************************
# Program: AMS (Advertising Management System)
# Module:  Statistics Reporting 
# Author:  Andrew Cowan
# Date:    July 05, 1996
# ************************************************************************
# Required Modules 
# ************************************************************************

require 'ams-defs.pl';
require 'encrypt.pl';

# ************************************************************************
# Main Routine 
# ************************************************************************

# If mSQL installation, call connection routines
if ($install_type eq $INSTM){ &connect_db; }

print "Content-type: text/html \n\n";

unless (&pass1 && &pass2){
   print "Software Expired \n";
   exit(0);
}

&cgiparse;
&startup;

if ((!$mode) && (!$num_days)){
   &print_header2;
   &print_stat_entry;
   &print_footer;
   exit(0);
}else{
   $admin_mode = &check_stat_login;
}

if ($admin_mode){
   &admin_interpret;
}else{
   &display_user_info;
}

exit(0);

# ************************************************************************
# Subroutines Declarations Section 
# ************************************************************************

# ************************************************************************
# Startup - Assign variables from form fields 
# ************************************************************************

sub startup{

   unless ($P1OK && $P2OK){
      print "Software Expired \n";
      exit(0);
   }

   $mode = $elements{'mode'};
   if (!$mode){
      $mode = "Display Stats" if defined($elements{'dsmode.x'});
      $mode = "Show Groups" if defined($elements{'sgmode.x'});
      $mode = "Set Access" if defined($elements{'samode.x'});
   }
   $id = $elements{'id'};
   $pwd = $elements{'pwd'};
   $ad = $elements{'ad'};
   $ad_pwd = $elements{'ad_pwd'};
   $num_days = $elements{'num_days'};
   $order_by = $elements{'order_by'};

}

# ************************************************************************
# Admin_Interpret - Interpret commands for the administrator 
# ************************************************************************

sub admin_interpret{

   unless ($P1OK && $P2OK){
      print "Software Expired \n";
      exit(0);
   }

   if ($mode eq "MENU"){
      &print_header2;
      &print_stat_menu;
      &print_footer;
   }elsif ($mode eq "Display Ordered List"){
      &print_header2;
      &print_ordered_list;
      &print_stat_menu;
      &print_footer;
   }elsif (($mode eq "Show") || ((!$mode) && ($num_days))){
      if ($num_days =~ /\D/){
         &print_header2;
         print "<center><b><em>Error</em>: ";
         print "You did not enter a valid number of days</b></center> \n"; 
         &print_stat_menu;
         &print_footer;
      }else{
         &print_header2;
         &print_expire_list;
         &print_stat_menu;
         &print_footer;
      } 
   }elsif ($mode eq "Display Stats"){
      if ($ad){
         &print_header2;
         &print_stats;
         print "<center><table border=0 width=505><tr><td><hr></td></tr>" .
               "</table></center><p> \n";
         &print_stat_menu;
         &print_footer; 
      }else{
         &print_header2;
         print "<center><b><em>Error</em>: ";
         print "You must first select an advertiser from the list</b>" .
               "</center> \n";
         &print_stat_menu;
         &print_footer;
      }
   }elsif ($mode =~ "Set Access"){
      if ($ad){
         &print_header2;
         &print_access_form;
         &print_stat_menu;
         &print_footer; 
      }else{
         &print_header2;
         print "<center><b><em>Error</em>: ";
         print "You must first select an advertiser from the list</b>" .
               "</center> \n";
         &print_stat_menu;
         &print_footer;
      }
   }elsif ($mode eq "ACCESS"){
      if (!$ad_pwd){
         &print_header2;
         print "<center><b><em>Error</em>: ";
         print "You cannot set an empty password, Password unchanged</b>" .
               "</center> \n";
         &print_stat_menu;
         &print_footer;
      }else{
         &set_access;
         &print_header2;
         print "<center><b>New access password set for '<em>$ad</em>'</b>" .
               "</center> \n";
         &print_stat_menu;
         &print_footer;
      }
   }elsif ($mode eq "Show Groups"){
      if ($ad){
         &print_header2;
         &print_group_list;
         &print_stat_menu;
         &print_footer; 
      }else{
         &print_header2;
         print "<center><b><em>Error</em>: ";
         print "You must first select an advertiser from the list</b>" .
               "</center> \n";
         &print_stat_menu;
         &print_footer;
      }
   }

}

# ************************************************************************
# Display_User_Info - Display User Info for this advertiser 
# ************************************************************************

sub display_user_info{
   
   $ad = $id;
      
   &print_header2;
   &print_stats;
   &print_footer;

}

# ************************************************************************
# Print_Stat_Menu - Print menu for admin 
# ************************************************************************

sub print_stat_menu{

   &load_keys("ad");

   my ($ad_select) = "<select size=7 name=\"ad\"> \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";

   print <<"EOF";

<center>
<form method="post" action="$stats_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="Display Ordered List">

<table border=0 cellpaddng=2 cellspacing=2>
<tr>
<td valign=top>
<font size=+1>Advertiser Comparison</font><br>
<input type="radio" CHECKED name="order_by" value="by_exp"> By Exposures <br> 
<input type="radio" name="order_by" value="by_click"> By Click-Throughs <br>
<input type="radio" name="order_by" value="by_ratio"> By Click-Through to Exposure Ratio <br>
<input type="image" src="$imurl/showcomp.gif" border="0"> 
</form>
</td>
<td>
<img width=1 height=110 src="$imurl/pixel.gif">
</td>
<td valign=top>
<form method="post" action="$stats_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="Show">
<font size=+1>Advertiser Expirations</font><br>
Enter a number of days to<br>
show all advertisers<br>
expiring within that time.
<br>
<input type="text" name="num_days" size="3"> 
<input type="image" src="$imurl/showexp.gif" border="0" align="middle">
</form>
</td>
</tr>
<tr>
<td colspan=3>
<hr size=1>
</td>  
</tr>
<tr>
</table>

<table border=0 cellpaddng=5 cellspacing=5>
<tr>
<td align=center>
<form method="post" action="$stats_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<font size=-1><b>Advertiser List</b></font><br> 
$ad_select
</td>
<td valign=top>
<br>
<input type="image" src="$imurl/dispstat.gif" border="0" name="dsmode"> <br>
<input type="image" src="$imurl/dispgrp.gif" border="0" name="sgmode"><br>
<input type="image" src="$imurl/setacces.gif" border="0" name="samode">
</form>
</td>
</tr>
</table> 
</center><p>

EOF

}

# ************************************************************************
# Print_Access_Form - Print the form for changing a user's access 
# ************************************************************************

sub print_access_form{

   print <<"EOF";

<center>
<table border=0 cellspacing=4>
<tr>
<td>
<hr size=1>
</td>
</tr>
<tr>
<td valign=middle>
<b>Setting access password for '<em>$ad</em>'</b><p>
<form method="post" action="$stats_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="ACCESS">
<input type="hidden" name="ad" value="$ad">
<input type="password" name="ad_pwd" size=20> 
<input type="image" src="$imurl/setacces.gif" border=0>
</form>
</td>
</tr>
<tr>
<td>
<hr size=1>
</td>
</tr>
</table>
</center>
<br><br>

EOF

}

# ************************************************************************
# Set_Access - Set access password for a user account 
# ************************************************************************

sub set_access{

   my ($cpwd) = crypt($ad_pwd, $ad_pwd);

   if ($install_type eq $INSTM){
      # mSQL installation
      my $found;
      my $tad = $ad;
      $tad =~ s/'/\\'/g;
      $cpwd =~ s/'/\\'/g;
      $sth = Query $dbh "SELECT userid,password FROM pwds 
         WHERE userid = '$tad'";
      if ($sth){
         my ($tuid, $tpwd) = ($sth->FetchRow);
         ++$found if ($tuid eq $ad);
      }

      if ($found){
         # Update existing password entry
         $sth = Query $dbh "UPDATE pwds SET password = '$cpwd'
            WHERE userid = '$tad'"; 
      }else{
         # Create new password entry
         $sth = Query $dbh "INSERT INTO pwds (userid, password) VALUES
            ('$tad', '$cpwd')";
      }
   }else{
      # DBM version
      dbmopen(%PWD, $pwd_db, 0666);
      $PWD{$ad} = $cpwd;
      dbmclose(%PWD);
   }

}

# ************************************************************************
# Print_Group_List - Show all groups this advertiser belongs to 
# ************************************************************************

sub print_group_list{

   &load_keys("group");
   my (@belong_list);

   foreach $grp (@group_list){
      my (@vals) = &load_entry("group", $grp);
      foreach $this_ad (@vals){
         if ($this_ad eq $ad){
            push(@belong_list, $grp);
            last;
         }
      }
   }

   if ($#belong_list < 0){
      print "<center><b>Advertiser '<em>$ad</em>' does not belong to any " .
            "groups</b></center> \n";
   }else{
      print "<center><table border=0><tr><td> \n" .
            "<b>Advertiser '<em>$ad</em>' belongs to the following " .
            "groups:</b></td></tr>  \n";
      foreach $this_ad (@belong_list){
         print "<tr><td><ul><li><b>$this_ad </ul></td></tr> \n";
      }
      print "<tr><td><hr></td></tr></table></center> <p>\n"; 
   }

}

# ************************************************************************
# Print_Stats = Print the stats for an individual advertiser 
# ************************************************************************

sub print_stats{

   my (@vals) = &load_entry("ad", $ad);
   my ($exp_mth, $exp_tot, $click_mth, $click_tot) = 
     (@vals)[$EXPMTH_IDX, $EXPTOT_IDX, $CLICKMTH_IDX, $CLICKTOT_IDX];

   my $mth_ratio;
   if ($exp_mth != 0){
      $mth_ratio = (100 * ($click_mth / $exp_mth)); 
   }else{
      $mth_ratio = (0.0); 
   }
   $mth_ratio = sprintf("%.2f", $mth_ratio);

   my $tot_ratio;
   if ($exp_tot != 0){
      $tot_ratio = (100 * ($click_tot / $exp_tot)); 
   }else{
      $tot_ratio = (0.0);
   }
   $tot_ratio = sprintf("%.2f", $tot_ratio);

   my $type_tog = $vals[$TOG_IDX];
   my $text_seg;

   if ($type_tog eq 'H'){
      $text_seg = &load_fragment($vals[$ADBAR_IDX]);
   }else{
      $text_seg = <<"ADBAR_SEG";
<img border=0 src=\"$vals[$ADURL_IDX]\" $vals[$EXTRA_IDX]>
ADBAR_SEG
   }

   print <<"EOF";

<center>
<table border=0 cellpadding=2 cellspacing=2>
<tr><td colspan=3>
$text_seg
<br><hr>
</td></tr>
<tr><td colspan=3 align=center>
<b>Statistics for advertiser '<em>$ad</em>'</b><br><hr>
</td></tr> 
<tr><th></th><th>Month</th><th>Total</th></tr>
<tr><td><b>Exposures</b></td>
</td><td align=center>$exp_mth</td><td align=center>$exp_tot</td></tr>
<tr><td><b>Click-Throughs</b></td>
</td><td align=center>$click_mth</td><td align=center>$click_tot</td></tr>
<tr><td><b>Click Percentage</b></td>
</td><td align=center>$mth_ratio\%</td><td align=center>$tot_ratio\%</td></tr>
</table>
</center><p>

EOF

}

# ************************************************************************
# Get_Num_Days - Get num days till this ad's expiration date  
# ************************************************************************

sub get_num_days{

   my ($date2) = $_[0];
   my ($date1) = `date +"%b %d %Y"`;

   my (%NUM_MTH);
   my (%LAST_DAY);
   my ($next_num);
   my ($year_diff);
   my ($diff) = 0;

   %LAST_DAY = ("Jan", "31", "Feb", "28", "Mar", "31", "Apr", "30",
                "May", "31", "Jun", "30", "Jul", "31", "Aug", "31",
                "Sep", "30", "Oct", "31", "Nov", "30", "Dec", "31");

   foreach $mth (keys(%MTH_NUM)){
      $NUM_MTH{$MTH_NUM{$mth}} = $mth;
   }

   my ($mth1, $day1, $yr1) = (split(/ /, $date1));
   my ($mth2, $day2, $yr2) = (split(/ /, $date2));

   if ($yr2 > $yr1){
      $diff = $LAST_DAY{$mth1} - $day1;   
      if ($MTH_NUM{$mth1} < 12){ 
         $mth1 = $NUM_MTH{$MTH_NUM{$mth1} + 1}; 
         $day1 = 1;
      }else{
         $mth1 = "Jan"; 
         $day1 = 1;
      }
      while($mth1 ne "Jan"){
         if ($MTH_NUM{$mth1} < 12){
            $diff += $LAST_DAY{$mth1};     
            $mth1 = $NUM_MTH{$MTH_NUM{$mth1} + 1};
         }else{
            $diff += $LAST_DAY{$mth1};
            $mth1 = "Jan";
            $yr1 += 1;
         }
      }
      while($mth1 ne $mth2){
         if ($MTH_NUM{$mth1} < 12){
            $diff += $LAST_DAY{$mth1};     
            $mth1 = $NUM_MTH{$MTH_NUM{$mth1} + 1};
         }else{
            $diff += $LAST_DAY{$mth1};
            $mth1 = "Jan";
            $yr1 += 1;
         }
      }
      $diff += $day2;
      $day1 = $day2;
      if ($yr2 > $yr1){
         $year_diff = $yr2 - $yr1;
         $diff += ($year_diff * 365);
      }
   }elsif ($yr2 == $yr1){
      if ($MTH_NUM{$mth2} < $MTH_NUM{$mth1}){
         $diff = 0;
      }elsif ($MTH_NUM{$mth2} == $MTH_NUM{$mth1}){
         if ($day2 < $day1){ 
            $diff = 0; 
         }else{
            $diff = $day2 - $day1;
         }
      }else{
         $diff = $LAST_DAY{$mth1} - $day1;   
         if ($MTH_NUM{$mth1} < 12){ 
            $mth1 = $NUM_MTH{$MTH_NUM{$mth1} + 1}; 
            $day1 = 1;
         }else{
            $mth1 = "Jan"; 
            $day1 = 1;
         }
         while($mth1 ne $mth2){
            if ($MTH_NUM{$mth1} < 12){
               $diff += $LAST_DAY{$mth1};     
               $mth1 = $NUM_MTH{$MTH_NUM{$mth1} + 1};
            }else{
               $diff += $LAST_DAY{$mth1};
               $mth1 = "Jan";
               $yr1 += 1;
            }
         }
         $diff += $day2;
      }
   }else{
      $diff = 0;
   }

   return $diff;

}

# ************************************************************************
# Print_Expire_List - Print the list of ads expiring in set time 
# ************************************************************************

sub print_expire_list{

   &load_keys("ad");
   my (@expire_list);
   my (%expire_date);

   foreach $ad (@ad_list){
      my (@vals) = &load_entry("ad", $ad);
      if ($vals[$END_IDX] =~ /(\w\w\w)\s(\d\d)\s(\d\d\d\d)/){
         $vals[$END_IDX] = "$1 $2 $3";
         $diff = &get_num_days($vals[$END_IDX]);
         if ($diff <= $num_days){ 
            push(@expire_list, $ad); 
            $expire_date{$ad} = $vals[$END_IDX];
         }
      }
   }

   if ($#expire_list < 0){
      print "<center><b>No advertisements expire within $num_days days" .
            "</b></center> \n";
   }else{
      print "<center><b>The following advertisements expire within " .
            "$num_days days<p> \n" .
            "<table border=0 cellpadding=5 cellspacing=5><tr>" .
            "<th>Advertiser</th><th>Expiration Date</th></tr> \n";
      foreach $ad (@expire_list){
         print "<tr><td>$ad</td><td>$expire_date{$ad}</td></tr> \n";
      }
      print "</table></b> \n" .
            "<table border=0 width=505><tr><td><hr></td></tr></table>" .
            "</center><p> \n";;
   }

}

# ************************************************************************
# Print_Ordered_List - Print the list of advertisers by order specified 
# ************************************************************************

sub print_ordered_list{

   &load_keys("ad");

   my ($tot_exp_mth, $tot_exp_tot, $tot_click_mth, $tot_click_tot);

   my ($max) = 0;
   my (%BY_NAME) = (
      "by_exp" => "by exposure", "by_click" => "by click-throughs",
      "by_ratio" => "by click ratio"
   );

   print <<"EOF1";
<center><b>Advertiser List ordered $BY_NAME{$order_by}</b> <p>
<table border=0 cellpadding=5 cellspacing=5>
<tr><th>Advertiser</th><th colspan=3>Month</th><th colspan=3>Total</th></tr>
<tr><th></th><th>Exp</th><th>Click</th><th>Ratio</th>
<th>Exp</th><th>Click</th><th>Ratio</th></tr>

EOF1
   
   foreach $ad (@ad_list){
      my (@vals) = &load_entry("ad", $ad);
      ($exp_mth{$ad}, $exp_tot{$ad}, $click_mth{$ad}, $click_tot{$ad}) = 
        (@vals)[$EXPMTH_IDX, $EXPTOT_IDX, $CLICKMTH_IDX, $CLICKTOT_IDX];
      if ($exp_mth{$ad} != 0){ 
         $mth_ratio{$ad} = (100 * ($click_mth{$ad} / $exp_mth{$ad})); 
      }
      else{ $mth_ratio{$ad} = 0.0; }
      $mth_ratio{$ad} = sprintf("%.2f", $mth_ratio{$ad});
      if ($exp_tot{$ad} != 0){ 
         $tot_ratio{$ad} = (100 * ($click_tot{$ad} / $exp_tot{$ad})); 
      }
      else{ $tot_ratio{$ad} = 0.0; }
      $tot_ratio{$ad} = sprintf("%.2f", $tot_ratio{$ad});
      if ($order_by eq "by_exp"){
         if ($exp_mth{$ad} > $max){ $max = $exp_mth{$ad}; }
      }elsif ($order_by eq "by_click"){
         if ($click_mth{$ad} > $max){ $max = $click_mth{$ad}; }
      }else{
         if (($mth_ratio{$ad} * 100) > $max){ $max = ($mth_ratio{$ad} * 100); }
      }
      $tot_exp_mth += $exp_mth{$ad};
      $tot_exp_tot += $exp_tot{$ad};
      $tot_click_mth += $click_mth{$ad};
      $tot_click_tot += $click_tot{$ad};
   }

   for ($i = $max; $i >= 0; $i--){
      foreach $ad (@ad_list){
         if ((($order_by eq "by_exp") && ($exp_mth{$ad} == $i)) ||
            (($order_by eq "by_click") && ($click_mth{$ad} == $i)) ||
            (($order_by eq "by_ratio") && ((int($mth_ratio{$ad}*100)) == $i))){
            print "<tr><td>$ad</td>" .
                  "<td align=center>$exp_mth{$ad}</td>" .
                  "<td align=center>$click_mth{$ad}</td> \n" .
                  "<td align=center>$mth_ratio{$ad}\%</td>" .
                  "<td align=center>$exp_tot{$ad}</td> \n" .
                  "<td align=center>$click_tot{$ad}</td>" .
                  "<td align=center>$tot_ratio{$ad}\%</td></tr> \n";
         }
      }
   }
   
   print <<"EOF2";

<tr><td><hr></td><td><hr></td><td><hr></td><td><hr></td>
<td><hr></td><td><hr></td><td><hr></td></tr>
<tr><td>Total</td><td align=center>$tot_exp_mth</td>
<td align=center>$tot_click_mth</td><td></td>
<td align=center>$tot_exp_tot</td><td align=center>$tot_click_tot</td>
<td></td></tr>
</table>
<table border=0 width=505>
<tr><td><hr></td></tr>
</table>
</center><p>

EOF2

}

# ************************************************************************
# End of Statistics Module 
# ************************************************************************
