#!/usr/local/bin/perl

# ************************************************************************
# Program:   HTTP Retriever - Perl5.002 compliant socket handling
# Author:    Andrew Cowan
# Date:      Dec. 27, 1995
# Update:    June. 29, 1998
# ************************************************************************

require 5.002;

# ************************************************************************
# HTTP Retriever is copyright (C) 1995 GlobalMedia Design Inc., All Rights
# Reserved. Overall concept derived from libwww's _get_ program created by
# Roy Fielding; Socket-handling concepts derived from 'Programming Perl'
# by Larry Wall and Randall Schwartz (client.pl example in text).
# ************************************************************************
# Usage:
#
# Include this file as a requirement in your perl script
# e.g;. require 'retriever.pl';
#
# Then invoke by:
# $url_contents = &retrieve($url);
#
# ************************************************************************
# Configuration Section
# ************************************************************************

# Constant declarations 

$default = $port = 80;
$timeout = 15;
$VERBOSE = "OFF";

$from = "From: webmaster\@radzone.org";
$agent = "User-Agent: Radiation Retriever 1.1";

# ************************************************************************
# Subroutines Declaration Section 
# ************************************************************************

# ************************************************************************
# Retrieve - Start process of retrieving the specified url
# ************************************************************************

sub retrieve{

   my $url = shift;

   &parse_url($url);

   my $cont = &get_contents;

   return $cont;

}

# ************************************************************************
# Parse_Url - Split url into site, page and port (if need be) 
# ************************************************************************

sub parse_url{

   my $arg = $_[0];

   undef $file; # Clear for multiple usage

   (@url_segments) = (split(/\//, $arg));

   for ($i = 0; $i <= $#url_segments; $i++){
      $segment = $url_segments[$i];
      if ($i == 2){
         if ($segment =~ /:/){
            ($site, $port) = (split(/:/, $segment));
            $port = 80 if $port eq "";
         }else{
            $site = $segment;
         }
         exit(0) if $site eq "";
      }elsif ($i > 2){
         $file .= "/" . $segment; 
      }
   }

   $file .= " HTTP/1.0";

}

# ************************************************************************
# Get_Contents - Get the constants for defined url. 
# ************************************************************************

sub get_contents{

   use strict;
   use Socket;
   my ($remote,$port, $iaddr, $paddr, $proto, $line, $default); 
   my ($file, $from, $agent, $VERBOSE, $contents, $host);

   $host = "Host: ";
   $default = $main'default;
   $remote = $main'site;
   $port = $main'port;
   $file = $main'file;
   $from = $main'from;
   $agent = $main'agent;
   $VERBOSE = $main'VERBOSE;

   $iaddr   = inet_aton($remote) || die "ERR: Host Not Found";
   $paddr   = sockaddr_in($port, $iaddr); 
   $proto   = getprotobyname('tcp');                         

   # Create Host entry for HTTP 1.1 compliance

   $host .= ($port ne $default) ? "${remote}:${port}" : ${remote};

   # Check that we can create the socket

   socket(SOCK, PF_INET, SOCK_STREAM, $proto)  || die "ERR: $!";
   select(SOCK); $| = 1; select(STDOUT);
					  
   # Call up the server

   connect(SOCK, $paddr) || die "ERR: Could not Connect to Server";

   print SOCK "GET " . $file . "\r\n" . $from . "\r\n" . 
      $agent . "\r\n" . $host . "\r\n\r\n";

   my $old_isep = $/;
   undef $/;

   $contents = <SOCK>;

   $/ = $old_isep;

   close(SOCK);

   if ($VERBOSE eq "OFF"){
      my $clean = &clean_and_send($contents);
      return $clean;
   }else{
      return $contents;
   }


}

# ************************************************************************
# Clean_And_Send - Get rid of header garbage and send just the contents 
# ************************************************************************

sub clean_and_send{

   my ($arg) = shift;

   my $send = "";

   (@line_list) = (split(/\n/, $arg));
   local($mode) = "HEADER";
   foreach $line (@line_list){
      $send .= $line . "\n" if $mode eq "BODY";
      if (($mode eq "HEADER") && (($line eq "") || ($line eq "
"))){
         $mode = "BODY";
      }
   }

   return $send;

}

# ************************************************************************
# End of Program 
# ************************************************************************
