#!/usr/local/bin/perl

require 'ams-defs.pl';
require 'retriever.pl';

# ********************************************************************
# Program: Product Registration Utility
# Author:  Andrew Cowan
# Date:    June 30, 1998
# ********************************************************************
# Configuration Section
# ********************************************************************

$register_url = "http://www.gmdstudios.com/register-bin/register.cgi";
$readme_url = "http://www.gmdstudios.com/affil-bin/readme_maker.cgi";
$CONT = "-- press a key to continue --";

# ********************************************************************
# Main Routine
# ********************************************************************

# Grab install parameters from trakker-defs file
$inst_loc = $cgi_dir;
$url = $cgi_url;

# Register software
&register;

exit(0);

# ********************************************************************
# Sub Register - Get info from user and register w/ Radiation
# ********************************************************************

sub register{

   print <<"INTRO";

$PRODUCT $VERSION Registration Utility v1.0

This program will register your $PRODUCT with Radiation. In order to
complete registration of this product we will need some information
from you. The information you provide will be sent to Radiation and
may be useful in the event that you ever require technical support
for this product.

NOTE: This registration software requires that you have an active
connection to the internet established. Your software will not 
function until you have completed registration for this software.

$CONT

INTRO

   $response = <STDIN>;

   print "Please provide information for each of the following questions, \n" .
      "please answer to the best of your knowledge.\n\n";

   while(1){
      $company = &get_response("Company name: ");
      last if &yn("Your company name: $company");
   }

   while(1){
      $res_id = &get_response("If you have a special offer code enter, " .
                              "otherwise leave blank: ");
      last if &yn("Special offer code: $res_id");
   }

   while(1){
      $username = &get_response("Your full name: ");
      last if &yn("Your full name: $username");
   }

   while(1){
      $contact = &get_response("Contact email address: ");
      last if &yn("Your contact email address: $contact");
   }

   while(1){
      $webserver = &get_response("Webserver software: ");
      last if &yn("Your webserver software: $webserver");
   }

   while(1){
      $os = &get_response("Operating System: ");
      last if &yn("Your operating system: $os");
   }

   my $RURL = "${register_url}?company=${company}&contact=${contact}&username=${username}&webserver=${webserver}&os=${os}&inst_loc=${inst_loc}&url=${url}&product=${PRODUCT}&version=${VERSION}&res_id=${res_id}";

   $RURL =~ s/\s/\+/g;

   print "\nAttempting connection to the Radiation Software Registration Server... \n";

   $reg_content = &retrieve($RURL);

   if ($reg_content =~ /ERR:/){
      print <<"ERROR";
The following error has occured: [$reg_content]

Your software will not function until your registration has been
completed. If you are unsure about the cause of this error please
contact Radiation technical support and report the error message
displayed above.

ERROR
      exit(0);
   } 

   print "Connected to Registration Server... \n" .
      "Obtaining registration code.\n\n";

   print "Writing registration.key file to directory $inst_loc ...\n";

   my $dest_file = "${inst_loc}/registration.key";

   open(RF, ">$dest_file");
   print RF $reg_content;
   close(RF);

   my $fsize; # Used for storing file size for install check code

   # Check if file was written
   $fsize = (stat($dest_file))[7];

   if ($fsize <= 0){
      print "Could not write 'registration.key' file to $inst_loc \n";
      print "Writing 'registration.key' file to local directory ...\n";

      my $dest_file = "registration.key";

      open(RF, ">$dest_file");
      print RF $reg_content;
      close(RF);

      # Check if file was written
      $fsize = (stat($dest_file))[7];

      if ($fsize <= 0){
	 print "Could not write 'registration.key' file to local directory \n";
	 print "Make sure you have write permissions set appropriately and \n" .
	    "try registering again.\n\n";
         exit(0);
      }

      print "File 'registration.key' written to local directory. \n" .
	 "You will need to move this file to your installation directory \n" .
	 "before your software will function.\n\n";

   }

   print "Creating file 'esize.dat' in $inst_loc ...\n";

   my $esize = (stat('encrypt.pl'))[7];

   open(EF, ">$esize_file");
   print EF $esize;
   close(EF);

   $fsize = (stat($esize_file))[7];

   if ($fsize <= 0){
      print "Could not write 'esize.dat' file to $inst_loc \n";
      print "Creating file 'esize.dat' in local directory ...\n";

      $esize_file = "esize.dat";
      open(EF, ">$esize_file");
      print EF $esize;
      close(EF);
      
      $fsize = (stat($esize_file))[7];

      if ($fsize <= 0){
	 print "Could not write 'esize.dat' file to local directory \n";
	 print "Make sure you have write permissions set appropriately and \n" .
	    "try registering again.\n\n";
	 exit(0);
      }

      print "File 'esize.dat' written to local directory. \n" .
	 "You will need to move this file to your installation directory \n" .
	 "before your software will function.\n\n";
   }

   if ($res_id){
      print "\nAttempting connection to the Readme First File Maker ... \n";

      my $RMFURL = "${readme_url}?res_id=${res_id}&product=${PRODUCT}";

      $RMFURL =~ s/\s/\+/g;

      $rmf_content = &retrieve($RMFURL);

      print "Connected to Readme First File Maker ... \n" .
         "Obtaining readme_first file contents.\n\n";

      if ($rmf_content =~ /ERR_ID/){
         print "The special offer code you supplied was not found to be \n" .
            "valid, defaulting to normal trial period... \n\n";
      }else{
         print "Writing readme_first.txt to local directory ... \n" .
           "Be sure to read this file before doing anything... \n\n";

         my $rmf_file = "readme_first.txt";

         open(RF, ">$rmf_file");
         print RF $rmf_content;
         close(RF);
      } 

   }

   print "Registration complete. Enjoy your Radiation software!\n\n";

}

# ************************************************************************
# Sub Yn - Issue a prompt and get a yes or no response
# ************************************************************************

sub yn{

   my $prompt = shift;
   my $response;

   print "${prompt} [y|n] ";
   chomp($response = <STDIN>);

   if ($response =~ /^y/i){ return 1; }

   return 0;

}

# ************************************************************************
# Sub Get_Response - Issue a prompt and get a response
# ************************************************************************

sub get_response{

   my $prompt = shift;
   my $response;

   print "\n${prompt}";
   chomp($response = <STDIN>);

   return $response;

}

# ************************************************************************
# End of Registration Module for Radiation LinkTrakker
# ************************************************************************

