#!/usr/local/bin/perl

# ************************************************************************
# Program: AMS (Advertising Management System) - Shell Version
# Module:  Core Engine 
# Author:  Andrew Cowan
# Date:    June 29, 1996
# ************************************************************************
# Required Modules 
# ************************************************************************

push(@INC, '/home/gmd/public_html/gmd-bin/ams');
require 'ams-defs.pl';
require 'encrypt.pl';

# ************************************************************************
# Main Routine 
# ************************************************************************

unless (&pass1 && &pass2){
   print "<!-- Copy Expired -->\n";
   exit(0);
}

# If mSQL installation, call connection routines
if ($install_type eq $INSTM){ &connect_db; }

&startup;

(@ads_list) = &create_ads_list;
$ad = &find_ad(@ads_list);
&display_ad($ad);

exit(0);

# ************************************************************************
# Core Engine Subroutines Declarations 
# ************************************************************************

# ************************************************************************
# Startup - Parse form fields and assign needed variables 
# ************************************************************************

sub startup{

   chomp($date = &ctime(time));
   ($dow, $today_mth, $today_day, $time, $year) = (split(/\s+/, $date));
   if ($today_day < 10){
      $today_day = "0${today_day}" unless $today_day =~ /^0/;
   }
   $mode = $elements{'mode'};
   $ad = $elements{'ad'};

   # Check for command line argument to determine adbar

   if ($#ARGV == 0){ $script = $ARGV[0]; }
   else{ $script = $ENV{'SCRIPT_NAME'}; }
   dbmopen(%DB, $sys_db, 0644);
   ($set_mth, $set_day, $set_year) = (split(/ /, $DB{'DATE'}));
   if (($set_mth ne $today_mth) || ($set_year ne $year)){
      $DB{'DATE'} = "$today_mth $today_day $year";
      $reset = "TRUE";
   }
   dbmclose(%DB);

   &reset_month if $reset eq "TRUE";

}

# ************************************************************************
# Reset_Month - Reset stats for the month 
# ************************************************************************

sub reset_month{

   &load_keys("ad");

   foreach $this_ad (@ad_list){
      my (@vals) = &load_entry("ad", $this_ad);

      $vals[$EXPMTH_IDX] = 0;
      $vals[$CLICKMTH_IDX] = 0;

      if ($install_type eq $INSTM){
         $sth = Query $dbh "UPDATE ads SET expm='0',clickm='0'
                WHERE adkey = '$this_ad'";
      }else{
         my ($record) = pack($ad_format, @vals);
         dbmopen(%DB, $ad_db, 0644);
         $DB{$this_ad} = $record;
         dbmclose(%DB); 
      }
   }

}

# ************************************************************************
# Create_Ads_List - Create the list of ads using relations in database 
# ************************************************************************

sub create_ads_list{

   unless ($P1OK && $P2OK){
      print "<!-- Copy Expired -->\n";
      exit(0);
   }

   local(@page_list, @rule_list, @ad_list, %found);

   &load_relations;
   foreach $rel (@rel_key_list){
      local($rel_used) = "FALSE";
      local(@fields) = (split(/\t/, $rel_key{$rel}));
      local(@tmp_ad_list);
      local(@tmp_group_list);
      foreach $fld (@fields){
         if ($fld =~ /^PAGE:(.*)/){ 
            if (($rel_used eq "FALSE") && ($script eq $1)){
               $rel_used = "TRUE";
            }
         }
         elsif ($fld =~ /^RULE:(.*)/){ 
            my ($this_rule) = quotemeta($1);
            if ($this_rule =~ /^NOT\s+(.*)$/){
               $rel_used = "KEEP_FALSE" if $script =~ /$1/;
            }elsif (($rel_used eq "FALSE") && ($script =~ /$this_rule/)){
               $rel_used = "TRUE";
            }
         }
         elsif ($fld =~ /^AD:(.*)/){ push(@tmp_ad_list, $1); }
         elsif ($fld =~ /^GROUP:(.*)/){ push(@tmp_group_list, $1); }
      }
      if ($rel_used eq "TRUE"){
         foreach $grp (@tmp_group_list){
            local(@ads_in_group) = &load_entry("group", $grp);
            foreach $this_ad (@ads_in_group){
               if (!defined($found{$this_ad})){
                  push(@ad_list, $this_ad);
                  $found{$this_ad} = "TRUE";
               }
            }
         }
         foreach $this_ad (@tmp_ad_list){
            if (!defined($found{$this_ad})){
               push(@ad_list, $this_ad);
               $found{$this_ad} = "TRUE";
            }
         }
      }
   }

   return @ad_list;

}

# ************************************************************************
# Find_Ad - Find an ad from the ad pool 
# ************************************************************************

sub find_ad{

   local(@ad_list) = @_;
   local(@final_ad_list);

   foreach $this_ad (@ad_list){
      local(@vals) = &load_entry("ad", $this_ad);
      next unless $#vals > 0;

      if ($vals[$METHOD_IDX] eq "PH"){
         if ($vals[$EXPTOT_IDX] >= $vals[$MAX_IDX]){
            next; 
         }
      }elsif ($vals[$METHOD_IDX] eq "PC"){
         if ($vals[$CLICKTOT_IDX] >= $vals[$MAX_IDX]){
            next; 
         }
      }
      if ($vals[$START_IDX] =~ /\w+\s\d+\s\d+/){
         if (!&later_date($vals[$START_IDX])){
            next; 
         }
      }
      if ($vals[$END_IDX] =~ /\w+\s\d+\s\d+/){
         if (!&earlier_date($vals[$END_IDX])){
            next; 
         }
      }
      push(@final_ad_list, $this_ad);
   }

   if ($#final_ad_list < 0){
      if ($install_type eq $INSTM){
         $sth = Query $dbh "SELECT glist FROM groups
                WHERE groupkey = '--Default--'";
         if ($sth){ ($DEFAULT) = ($sth->FetchRow); }
      }else{
         dbmopen(%DB, $group_db, 0444);
         $DEFAULT = $DB{'--Default--'};
         dbmclose(%DB); 
      }
      my (@default_list) = (split(/\t/, $DEFAULT)); 
      @final_ad_list = @default_list;
   }

   srand;
   $index = int(rand($#final_ad_list+1));
   
   return $final_ad_list[$index];
 
}

# ************************************************************************
# Later_Date - Determine if today is later than a given date 
# ************************************************************************

sub later_date{

   local($date2) = $_[0];

   ($this_mth, $this_day, $this_year) = (split(/ /, $date2));
   ($this_year) = ($this_year =~ /(\d\d\d\d)/);

   if ($year > $this_year){
      return 1;
   }elsif ($year == $this_year){
      if ($MTH_NUM{$today_mth} > $MTH_NUM{$this_mth}){
         return 1;
      }elsif ($MTH_NUM{$today_mth} == $MTH_NUM{$this_mth}){ 
         if ($today_day >= $this_day){
            return 1;
         }
      }else{
         return 0;
      }
   }else{
      return 0;
   }

}

# ************************************************************************
# Earlier_Date - Determine if today is earlier than a given date 
# ************************************************************************

sub earlier_date{

   local($date2) = $_[0];

   ($this_mth, $this_day, $this_year) = (split(/ /, $date2));
   ($this_year) = ($this_year =~ /(\d\d\d\d)/);

   if ($year < $this_year){
      return 1;
   }elsif ($year == $this_year){
      if ($MTH_NUM{$today_mth} < $MTH_NUM{$this_mth}){
         return 1;
      }elsif ($MTH_NUM{$today_mth} == $MTH_NUM{$this_mth}){ 
         if ($today_day <= $this_day){
            return 1;
         }
      }else{
         return 0;
      }
   }else{
      return 0;
   }

}

# ************************************************************************
# Display_Ad - Display the ad and increment its exposure count 
# ************************************************************************

sub display_ad{

   local($ad) = $_[0];
   local(@vals) = &load_entry("ad", $ad);
   $ad_link = $ad; 
   $ad_link =~ s/ /+/g; 

   if ($ad){
      if ($vals[$TOG_IDX] eq 'H'){
         $tags = &load_fragment($vals[$ADURL_IDX]);
      }else{
         $tags = "<a href=\"$ams_url?mode=REDIR&ad=$ad_link\" target=\"New\">" .
            "<img src=\"$vals[$ADURL_IDX]\" " .
            "alt=\"$vals[$ALTTAG_IDX]\" $vals[$EXTRA_IDX]></a> \n";
      }
      print $tags;

      $vals[$EXPMTH_IDX] += 1;
      $vals[$EXPTOT_IDX] += 1;

      if ($install_type eq $INSTM){
         $sth = Query $dbh "UPDATE ads
                SET expm='$vals[$EXPMTH_IDX]',expt='$vals[$EXPTOT_IDX]'
                WHERE adkey = '$ad'";
      }else{
         dbmopen(%ADB, $ad_db, 0666);
         $ADB{$ad} = pack($ad_format, @vals);
         dbmclose(%ADB);
      }
   }

}

# ************************************************************************
# Do_Redirect - Increment click-through count and do redirection 
# ************************************************************************

sub do_redirect{

   my ($ad) = $_[0];
   my (@vals) = &load_entry("ad", $ad);

   $vals[$CLICKMTH_IDX] += 1;
   $vals[$CLICKTOT_IDX] += 1;

   if ($install_type eq $INSTM){
      $sth = Query $dbh "UPDATE ads
             SET clickm='$vals[$CLICKMTH_IDX]',clickt='$vals[$CLICKTOT_IDX]'
             WHERE adkey = '$ad'";
   }else{
      dbmopen(%ADB, $ad_db, 0666);
      $ADB{$ad} = pack($ad_format, @vals);
      dbmclose(%ADB);
   }
   
   print "Location: $vals[$LINKURL_IDX] \n\n";
    
}

# ************************************************************************
# End of Core Module 
# ************************************************************************
