#!/usr/local/bin/perl 

# ************************************************************************
# Program: AMS (Advertising Management System)
# Module:  Initialization Module (mSQL)
# Author:  Andrew Cowan
# Date:    December 18, 1998
# LastMod: January 29, 1999
# ************************************************************************
# Required Modules 
# ************************************************************************

use Msql;
require 'ams-defs.pl';

# ************************************************************************
# Main Routine 
# ************************************************************************


print "\nAMS Initialization Utility 1.0 \n";

print "Connecting to mSQL Server... \n";

$dbh = Connect Msql $msql_host;
SelectDB $dbh $msql_db;

unless ($dbh){
   print "mSQL Error: Cannot connect to mSQL server!\n";
   exit(0);
}

print "Creating table 'ads' ...          ";

$sth = Query $dbh "CREATE TABLE ads(
       adkey char(75) not null,
       adurl char(250),
       linkurl char(250),
       alt char(150),
       method char(2),
       imax char(12),
       start char(30),
       end char(30),
       expm char(15),
       expt char(15),
       clickm char(15),
       clickt char(15),
       extras char(200),
       tog char(1) )";

unless ($sth){
   print "mSQL Error: Cannot create table 'ads'! \n";
   exit(0);
}

$sth = Query $dbh "INSERT INTO ads (adkey, adurl, linkurl, alt, method, imax,
       start, end, expm, expt, clickm, clickt, extras, tog)
       VALUES ('--Default--', 'http://www.radiation.com/ads/thisis.gif',
       'http://www.radiation.com/products/ams/', 'This is AMS', 'NC', '', '', 
       '', '0', '0', '0', '0', 'width=378 height=60 border=1', 'A')";

unless ($sth){
   print "mSQL Error: Cannot insert '--Default--' ad ! \n";
   exit(0);
}

print "[Done] \nCreating Advertiser Group DBM database...    ";

$sth = Query $dbh "CREATE TABLE groups(
       groupkey char(75) not null,
       glist char(1000) )";

unless ($sth){
   print "mSQL Error: Cannot create table 'groups' ! \n";
   exit(0);
}

$sth = Query $dbh "INSERT INTO groups (groupkey, glist)
       VALUES ('--Default--', '--Default--')";

unless ($sth){
   print "mSQL Error: Cannot insert '--Default--' group ! \n";
   exit(0);
}

print "[Done] \nCreating Relation DBM database...            ";

$sth = Query $dbh "CREATE TABLE rels(
       relkey char(75) not null,
       rlist char(5000) )";

unless ($sth){
   print "mSQL Error: Cannot create table 'rels' ! \n";
   exit(0);
}

print "[Done] \nCreating System DBM database...              ";

dbmopen(%DB, $sys_db, 0666);
dbmclose(DB);

print "[Done] \nCreating Passwords DBM database...           ";

$sth = Query $dbh "CREATE TABLE pwds(
       userid char(15) not null,
       password char(15) )";

unless ($sth){
   print "mSQL Error: Cannot create table 'pwds' ! \n";
   exit(0);
}

system("chmod 666 ./ams_db/*");

print "[Done] \nCreating Administrator access to system...   ";

chop($date = `date +"%b %d %Y"`);

dbmopen(%DB, $sys_db, 0666);
$DB{'USERID'} = "Admin";
$DB{'PASSWORD'} = "Ch6C6x/eskGR6";
$DB{'DATE'} = $date;
dbmclose(DB);

system("chmod 777 ams_db; chmod 666 ams_db/*");

print "[Done] \nYour username is 'Admin' and your password 'ChangeMe'\n";
print "Initialization Complete \n\n";

exit(0);

# ************************************************************************
# End of Initialization Module 
# ************************************************************************
