
# ************************************************************************
# Program: AMS (Advertising Management System)
# Module:  Global Definitions
# Author:  Andrew Cowan
# Date:    June 19, 1996
# ************************************************************************
#
# Version 1.7 - Added NOT functionality to rules within relations
# Version 1.8 - Removed border=0 as default border for adbars.
#               Set default billing method to No Charge.
#               Fixed bug with regards to removed ads, broken graphics.
# Version 2.* - Various minor improvements and bug tweaks made.
# Version 3.0 - Added toggleable for DBM/mSQL installations
#               Trialware code added. Fixed rule-matching bug in ssi and shell
#               modules. Added remote serving/spider capability, so ads can
#               be served from remote AMS installations.
#
# ************************************************************************
# Call required scripts 
# ************************************************************************


require 'ctime.pl';
require 'ams-utils.pl';

# ************************************************************************
# Global Definitions
# ************************************************************************

# Installation type - DBM or mSQL
$install_type = "DBM";

# Defs for mSQL version
$msql_host = "localhost";
$msql_db = "ams";

# Grab the Document Root from the environment variable
$ROOT_DIR = $ENV{'DOCUMENT_ROOT'};

# Uncomment the following line if you use a Netsite webserver. This will
# allow the script to parse needed environment information.
#$SSI_MODE = "PATH";

# General Definitions, including urls, directory definitions, database
# filenames, packing formats, etc...
$default = "--Default";

$cgi_url = "http://gmd/gmd-bin/ams";
$cgi_dir = "/home/gmd/public_html/gmd-bin/ams";
$imurl = "http://gmd/~gmd/ams";
$admin_email = "icculus\@gmdstudios.com";

$ams_url = "${cgi_url}/ams_ssi.cgi";
$admin_url = "${cgi_url}/ams_admin.cgi";
$stats_url = "${cgi_url}/ams_stats.cgi";


$remote_host = $ENV{'REMOTE_HOST'};

$db_dir = "${cgi_dir}/ams_db";
$sys_db = $db_dir . "/" . "ams_system";
$pwd_db = $db_dir . "/" . "access";
$ad_db = $db_dir . "/" . "ads";
$group_db = $db_dir . "/" . "groups";
$rel_db = $db_dir . "/" . "rels";
$ad_format = "a75 a100 a100 a2 L a30 a30 L L L L a200 a1";

# Trialware definitions section
$reg_file = "${cgi_dir}/registration.key";
$esize_file = "${cgi_dir}/esize.dat";
$enc_file = "${cgi_dir}/encrypt.pl";

# Sept. 16 : Added Alt tag in third position for database record
# Oct. 18  : Added Extra img tag information field
# May 21   : Added Toggle button for Adbar or Html fragment choice

# Array indices for the ads database unpacked information

$ADURL_IDX = 0;
$LINKURL_IDX = 1;
$ALTTAG_IDX = 2;
$METHOD_IDX = 3;
$MAX_IDX = 4;
$START_IDX = 5;
$END_IDX = 6;
$EXPMTH_IDX = 7;
$EXPTOT_IDX = 8;
$CLICKMTH_IDX = 9;
$CLICKTOT_IDX = 10;
$EXTRA_IDX = 11;
$TOG_IDX = 12;

# Associative Arrays

%METHOD_NAME = ("PH", "Per Hit", "PC", "Per Click", "FR", "Flat Rate",
                "NC", "No Charge");

%TYPE_NAME = ("ad", "Advertiser", "group", "Advertiser Group", 
              "rel", "Relation");

%MTH_NUM = ("Jan", "1", "Feb", "2", "Mar", "3", "Apr", "4",
            "May", "5", "Jun", "6", "Jul", "7", "Aug", "8",
            "Sep", "9", "Oct", "10", "Nov", "11", "Dec", "12"); 

%MTH_CVT = ("JAN", "Jan", "FEB", "Feb", "MAR", "Mar", "APR", "Apr",
            "MAY", "May", "JUN", "Jun", "JUL", "Jul", "AUG", "Aug",
            "SEP", "Sep", "OCT", "Oct", "NOV", "Nov", "DEC", "Dec");

# Do not modify the following four declarations
$PRODUCT = "AMS";
$VERSION = "3.0";

$INSTD = "DBM";
$INSTM = "mSQL";

# ************************************************************************
# End of Global Definitions Module 
# ************************************************************************
