
# ************************************************************************
# Program: AMS (Advertising Management System)
# Module:  Shared Utilities 
# Author:  Andrew Cowan
# Date:    June 19, 1996
# LastMod: Jan. 29, 1999
# ************************************************************************
# Global Subroutines 
# ************************************************************************

# ************************************************************************
# Load_Fragment - Load the html fragment
# ************************************************************************

sub load_fragment{

   my $filename = "${ROOT_DIR}${_[0]}";
   my $fragment;

   open(HF, "$filename");
   while(<HF>){ $fragment .= $_; }
   close(HF);

   return $fragment;

}

# ************************************************************************
# Load_Keys - Load one or all database keys 
# ************************************************************************

sub load_keys{

   local($which) = $_[0];

   undef @ad_list;
   undef @group_list;
   undef @rel_list;

   if ($which eq "ad"){
      if ($install_type eq $INSTM){
         # mSQL Version follows
         $sth = Query $dbh "SELECT adkey FROM ads";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@ad_list, $key);
            }
         }
      }else{
         # DBM version follows
         dbmopen(%DB, $ad_db, 0644);
         while(($key, $val) = each(%DB)){ push(@ad_list, $key); }
         dbmclose(DB);
      }
      @ad_list = sort(@ad_list);
   }elsif ($which eq "group"){
      if ($install_type eq $INSTM){
         # mSQL Version follows
         $sth = Query $dbh "SELECT groupkey FROM groups";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@group_list, $key);
            }
         }
      }else{ 
         # DBM version follows
         dbmopen(%DB, $group_db, 0644);
         while(($key, $val) = each(%DB)){ push(@group_list, $key); }
         dbmclose(DB);
      }
      @group_list = sort(@group_list);
   }elsif ($which eq "rel"){  
      if ($install_type eq $INSTM){
         # mSQL Version follows
         $sth = Query $dbh "SELECT relkey FROM rels";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@rel_list, $key);
            }
         }
      }else{
         # DBM version follows
         dbmopen(%DB, $rel_db, 0644);
         while(($key, $val) = each(%DB)){ push(@rel_list, $key); }
         dbmclose(DB);
      }
      @rel_list = sort(@rel_list);
   }elsif (($which eq "all") || (!$which)){
      if ($install_type eq $INSTM){
         # mSQL Version follows
         $sth = Query $dbh "SELECT adkey FROM ads";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@ad_list, $key);
            }
         }
         $sth = Query $dbh "SELECT groupkey FROM groups";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@group_list, $key);
            }
         }
         $sth = Query $dbh "SELECT relkey FROM rels";
         if ($sth){
            while((@row) = ($sth->FetchRow)){
               my $key = @row[0];
               push(@rel_list, $key);
            }
         }
      }else{ 
         # DBM Version follows
         dbmopen(%DB, $ad_db, 0644);
         while(($key, $val) = each(%DB)){ push(@ad_list, $key); }
         dbmclose(DB);
         dbmopen(%DB, $group_db, 0644);
         while(($key, $val) = each(%DB)){ push(@group_list, $key); }
         dbmclose(DB);
         dbmopen(%DB, $rel_db, 0644);
         while(($key, $val) = each(%DB)){ push(@rel_list, $key); }
         dbmclose(DB);
      }
      @ad_list = sort(@ad_list);
      @group_list = sort(@group_list);
      @rel_list = sort(@rel_list);
   } 

}

# ************************************************************************
# Load_Entry - Load a database entry 
# ************************************************************************

sub load_entry{

   my ($type, $which) = (@_);
   my (@values);

   if ($install_type eq $INSTM){
      # mSQL Version follows
      if ($type eq "ad"){
         $sth = Query $dbh "SELECT adurl,linkurl,alt,method,imax,start,
             end,expm,expt,clickm,clickt,extras,tog FROM ads
             WHERE adkey='$which'";
         if ($sth){
            (@values) = ($sth->FetchRow);
            return @values;
         }else{
            return undef;
         }
      }elsif ($type eq "group"){
         $sth = Query $dbh "SELECT glist FROM groups
             WHERE groupkey='$which'";
         if ($sth){
            my $record = ($sth->FetchRow)[0];
            (@values) = (split(/\t/, $record));
            return @values;
         }else{
            return undef;
         }
      }elsif ($type eq "rel"){
         $sth = Query $dbh "SELECT rlist FROM rels
             WHERE relkey='$which'";
         if ($sth){
            my $record = ($sth->FetchRow)[0];
            (@values) = (split(/\t/, $record));
            return @values;
         }else{
            return undef;
         }
      }
   }else{
      # DBM Version follows
      if ($type eq "ad"){
         dbmopen(%DB, $ad_db, 0644);
         if (defined($DB{$which})){
            $record = $DB{$which}; 
         }else{
            dbmclose(DB);
   	    return undef; 
         }
         dbmclose(DB);
         (@values) = unpack($ad_format, $record);
         foreach (@values){
            s/[\0]//g;
         }
         return @values;
      }elsif ($type eq "group"){
         dbmopen(%DB, $group_db, 0644);
         $record = $DB{$which};
         dbmclose(DB);
         (@values) = (split(/\t/, $record));
         return @values;
      }elsif ($type eq "rel"){  
         dbmopen(%DB, $rel_db, 0644);
         $record = $DB{$which};
         dbmclose(DB);
         (@values) = (split(/\t/, $record));
         return @values;
      } 
   }

}

# ************************************************************************
# Load_Relations - Load all relations from DBM 
# ************************************************************************

sub load_relations{

   if ($install_type eq $INSTM){
      # mSQL version follows
      $sth = Query $dbh "SELECT relkey,rlist FROM rels";
      if ($sth){
         while((@row) = ($sth->FetchRow)){
            my ($key, $val) = (@row);
            $val =~ s/^M//g;
            push(@rel_key_list, $key);
            $rel_key{$key} = $val;
         }
      }
   }else{
      # DBM version
      dbmopen(%DB, $rel_db, 0644);
      foreach $key (keys %DB){
         my $val = $DB{$key};
         $val =~ s/
//g;
         push(@rel_key_list, $key);
         $rel_key{$key} = $val;            
      }
      dbmclose(DB);
   }

}

# ************************************************************************
# Print_Header - Print the standard page header to the browser 
# ************************************************************************

sub print_header{

   local($title) = $_[0];

   $title = "Advertising Management System" unless $title;
   if ($title ne "NO_HEAD"){
      $header_ins = "<h3>$title</h3> \n";
   }else{
      $title = "Advertising Management System";
   }

   print <<"EOF";

<html><head><title>$title</title></head>
<body bgcolor=#FFFFFF background="$imurl/bg1.gif" link=#006384 vlink=#002939 text=#333333>

<center>
<img src="$imurl/head.gif">
$header_ins
</center>

EOF

}

# ************************************************************************
# Print_Header2 - Print the standard stats page header to the browser 
# ************************************************************************

sub print_header2{

   local($title) = $_[0];
   $title = "AMS: Statistical Reporting" unless $title;

   if ($title ne "NO_HEAD"){
      $header_ins = "<h3>$title</h3> \n";
   }else{
      $title = "AMS: Statistical Reporting";
   }

   print <<"EOF";

<html><head><title>$title</title></head>
<body bgcolor=#FFFFFF background="$imurl/bg1.gif" link=#006384 vlink=#002939 text=#333333>

<center>
<img src="$imurl/head.gif">
$header_ins
</center>

EOF

}

# ************************************************************************
# Print_Footer - Print the standard page footer to the browser 
# ************************************************************************

sub print_footer{

   print <<"EOF";

<center>
<font size=-1>
<i>Radiation AMS</i> is &copy copyright 1996 by<br>
<a href="http://www.radzone.org/gmd/">GlobalMedia Design Inc.</a>.  
All rights reserved.
</font>
</center>

</body></html>

EOF

}

# ************************************************************************
# Print_Admin_Footer - Print the admins page footer to the browser 
# ************************************************************************

sub print_admin_footer{

   print <<"EOF";

<center>
<font size=+1>
<a href="${stats_url}?mode=MENU&id=$id&pwd=$pwd">AMS Statistics System</a>
</font>
<p>
<font size=-1>
<i>Radiation AMS</i> is &copy copyright 1996 by<br>
<a href="http://www.radzone.org/gmd/">GlobalMedia Design Inc.</a>.  
All rights reserved.
</font>
</center>

</body></html>

EOF

}

# ************************************************************************
# Print_Entry - Print the entry form to the browser 
# ************************************************************************

sub print_entry{

   print <<"EOF";

<html><head><title>Advertising Management System</title></head>
<body bgcolor=#FFFFFF background="$imurl/bg1.gif" link=#006384 vlink=#002939 text=#333333>

<center>
<img src="$imurl/head.gif">
<h3>Advertising Management System</h3></center>

<center><b>You have entered a <em>private</em> webspace, you must have
authorization to proceed<br>any further. Please enter your login id and
password to access this system</b>

<form method="post" action="$admin_url">
<input type="hidden" name="mode" value="MENU"> 
<input type="text" name="id" size="20"> 
<input type="password" name="pwd" size="20"> <p>
<input type="image" src="$imurl/verify.gif" border="0" value="Verify Authorization"> 
</form>
</center>

<center>
<font size=-1>
<i>Radiation AMS</i> is &copy copyright 1996 by<br>
<a href="http://www.radzone.org/gmd/">GlobalMedia Design Inc.</a>.  
All rights reserved.
</font>
</center>

</body></html>

EOF

}

sub print_old_entry{

   print <<"EOF";

<html><head><title>Advertising Management System</title></head>
<body bgcolor=#FFFFFF link=#006384 vlink=#002939 text=#333333>

<center><h3>Advertising Management System</h3></center>
<p><hr><p>

<center><b>You have entered a <em>private</em> webspace, you must have
authorization to proceed<br>any further. Please enter your login id and
password to access this system</b>

<form method="post" action="$admin_url">
<input type="hidden" name="mode" value="MENU"> 
<input type="text" name="id" size="20"> 
<input type="password" name="pwd" size="20"> <p>
<input type="submit" value="Verify Authorization">
</form>
</center>

<p><hr><p>

<center><font size=-2>AMS is a 
<a href="http://www.radzone.org/gmd-bin/radiation">Radiation</a>
production.<br>This software is &copy copyright 1996 by<br>
<a href="http://www.radzone.org/gmd/">GlobalMedia Design Inc.</a>.
All rights reserved.</font></center>

</body></html>

EOF

}

# ************************************************************************
# Print_Stat_Entry - Print the statistics entry form to the browser 
# ************************************************************************

sub print_stat_entry{

   print <<"EOF";

<center><b>You have entered a <em>private</em> webspace, you must have
authorization to proceed<br>any further. Please enter your login id and
password to access this system</b>

<form method="post" action="$stats_url">
<input type="hidden" name="mode" value="MENU"> 
<input type="text" name="id" size="20"> 
<input type="password" name="pwd" size="20"> <p>
<input type="image" src="$imurl/verify.gif" border=0 value="Verify Authorization">
</form>
</center>

EOF

}

# ************************************************************************
# Check_Login - Check for authorized login id and password
# ************************************************************************

sub check_login{
   
   dbmopen(%SYS, $sys_db, 0644);
   local($admin_id) = $SYS{'USERID'}; 
   local($admin_pwd) = $SYS{'PASSWORD'}; 
   dbmclose(SYS);

   my ($cpwd) = crypt($pwd, $pwd);

   return if (($id eq $admin_id) && ($cpwd eq $admin_pwd));

   print <<"EOF";

<html><head><title>AMS: Unauthorized Access</title></head>
<body bgcolor=#FFFFFF background="$imurl/bg1.gif" link=#006384 vlink=#002939 text=#333333>

<center>
<img src="$imurl/head.gif"><br>
<h3>Unauthorized Access</h3>
</center>

<center><b>The login id and password entered are not valid for access
to this system. Your<br>authorization is declined, please contact
<a href="mailto:$admin_email">the administrator</a> if you feel this is<br>
in error! An unauthorized access attempt is being logged from
<em>$remote_host</em>.</b></center>

<br><p>

EOF

   &print_footer;

   exit(0);
 
}

# ************************************************************************
# Check_Stat_Login - Check for authorized login id and password for stats
# ************************************************************************

sub check_stat_login{
  
   dbmopen(%SYS, $sys_db, 0644);
   local($admin_id) = $SYS{'USERID'}; 
   local($admin_pwd) = $SYS{'PASSWORD'}; 
   dbmclose(SYS);

   my ($cpwd) = crypt($pwd, $pwd);

   if (($id eq $admin_id) && ($cpwd eq $admin_pwd)){
      return 1;
   }
  
   my ($valid_user) = "FALSE";

   if ($install_type eq $INSTM){
      # mSQL version
      $sth = Query $dbh "SELECT userid,password FROM pwds WHERE userid = '$id'";
      if ($sth){
         my ($tid, $acct_pwd) = ($sth->FetchRow);
         if ($tid eq $id){
            if ($cpwd eq $acct_pwd){
               $valid_user = "TRUE";
            }
         }
      }
   }else{
      # DBM version
      dbmopen(%PWD, $pwd_db, 0644);
      if (defined($PWD{$id})){
         my ($acct_pwd) = $PWD{$id}; 
         if ($cpwd eq $acct_pwd){
            $valid_user = "TRUE";
         }
      }
      dbmclose(PWD);
   }

   if ($valid_user eq "TRUE"){
      return 0;
   }
   
   print <<"EOF";

<html><head><title>AMS :: Unauthorized Access</title></head>
<body bgcolor=#FFFFFF background="$imurl/bg1.gif" link=#006384 vlink=#002939 text=#333333>

<center>
<img src="$imurl/head.gif">
<h3>AMS: Unauthorized Access</h3></center>

<center><b>The login id and password entered are not valid for access
to this system. Your<br>authorization is declined, please contact
<a href="mailto:$admin_email">the administrator</a> if you feel this is<br>
in error! An unauthorized access attempt is being logged from
<em>$remote_host</em>.</b></center>

<br><br>

EOF

   &print_footer;

   exit(0);
 
}

# ************************************************************************
# Connect_Db - Connect to the mSQL server/database
# ************************************************************************

sub connect_db{

   $dbh = Connect Msql $msql_host;
   SelectDB $dbh $msql_db;

}

# ************************************************************************
# Urldecode Routines
# ************************************************************************
# Copyright & Disclaimer. (James Tappin)
#       This set of routines may be freely distributed, modified and
#       used, provided this copyright & disclaimer remains intact.
#       This package is used at your own risk, if it does what you
#       want, good; if it doesn't, modify it or use something else--but
#       don't blame me. Support level = negligable (i.e. mail bugs but
#       not requests for extensions)
# ************************************************************************

sub cgiparse {

  if ($ENV{'REQUEST_METHOD'} eq "POST") {
	read(STDIN, $data, $ENV{'CONTENT_LENGTH'});
  }
  elsif ($ENV{'REQUEST_METHOD'} eq "GET") {
	$data = $ENV{'QUERY_STRING'};
  }
  else {
	#
	#  Bad request method report and exit.
	#
	&method_error;
  }

  %elements = &url_decode(split(/[&=]/,$data));
  @lists = &url_decode(split(/[&=]/,$data));
  %elements;
}

sub method_error {

  print "\nCGI Script Requires use of method POST or GET.\n";
  exit;
}


sub url_decode {
    foreach (@_) {
        tr/+/ /;
        s/%(..)/pack("c",hex($1))/ge;
    }
    @_;
}

# ************************************************************************
1; # Return true value to caller script
# ************************************************************************
# End of Shared Utilities Module 
# ************************************************************************
