#!/usr/local/bin/perl

# ************************************************************************
# Program:   HTTP Requester Perl5 compliant socket handling
# Author:    Andrew Cowan
# Date:      Dec. 27, 1995
# Update:    Dec. 28, 1995
# ************************************************************************
# HTTP Requester is copyright (C) 1995 GlobalMedia Design Inc., All Rights
# Reserved. Overall concept derived from libwww's _get_ program created by
# Roy Fielding; Socket-handling concepts derived from 'Programming Perl'
# by Larry Wall and Randall Schwartz (client.pl example in text).
# ************************************************************************

# ************************************************************************
# Retriever Subroutines Declaration Section 
# ************************************************************************

# ************************************************************************
# Retrieve - Retrieve the url
# ************************************************************************

sub retrieve{

   undef $file_contents;

   my($surl) = $_[0];

   &parse_url($surl);
   $file_contents = &get_contents;

}

# ************************************************************************
# Parse_Url - Split url into site, page and port (if need be) 
# ************************************************************************

sub parse_url{

   undef $file;

   local($arg) = $_[0];

   (@url_segments) = (split(/\//, $arg));

   for ($i = 0; $i <= $#url_segments; $i++){
      $segment = $url_segments[$i];
      if ($i == 2){
         if ($segment =~ /:/){
            ($site, $port) = (split(/:/, $segment));
            $port = 80 if $port eq "";
         }else{
            $site = $segment;
         }
         exit(0) if $site eq "";
      }elsif ($i > 2){
         $file .= "/" . $segment; 
      }
   }
   #$file .= "/" if (!($file =~ /\.htm/));
   $file = "/" if $file eq "";
   $file .= " HTTP/1.0";

}

# ************************************************************************
# Get_Contents - Get the constants for defined url. 
# ************************************************************************

sub get_contents{

   use strict;
   use Socket;
   my ($remote,$port, $iaddr, $paddr, $proto, $line); 
   my ($file, $from, $agent, $VERBOSE, $contents);

   $remote = $main'site;
   $port = $main'port || 80;
   $file = $main'file;
   $from = $main'from;
   $agent = $main'agent;
   $VERBOSE = 'ON';

   $iaddr   = inet_aton($remote) || return -1;
   $paddr   = sockaddr_in($port, $iaddr); 
   $proto   = getprotobyname('tcp');                         

   # Check that we can create the socket

   socket(SOCK, PF_INET, SOCK_STREAM, $proto) || return -2;
   select(SOCK); $| = 1; select(STDOUT);
					  
   # Call up the server

   connect(SOCK, $paddr) || return -3;

   print SOCK "GET " . $file . 
	   "\r\n" . $from . "\r\n" . $agent . "\r\n\r\n";

   while(<SOCK>){
      $contents .= $_;
   }
   close(SOCK);

   if ($VERBOSE eq "OFF") { $contents = &clean_and_send($contents); }

   return &clean_and_send($contents);

}

# ************************************************************************
# Clean_And_Send - Get rid of header garbage and send just the contents 
# ************************************************************************

sub clean_and_send{

   local($arg) = $_[0];
   local($send_back);

   (@line_list) = (split(/\n/, $arg));
   local($mode) = "HEADER";
   foreach $line (@line_list){
      $send_back .= $line . "\n" if $mode eq "BODY";
      if (($mode eq "HEADER") && (($line eq "") || ($line eq "
"))){
         $mode = "BODY";
      }
   }

   return $send_back;

}

# ************************************************************************
1; # Must return a true value
# ************************************************************************
# End of Program 
# ************************************************************************
