#!/usr/local/bin/perl

# ************************************************************************
# Program: AMS (Advertising Management System)
# Module:  Administration System 
# Author:  Andrew Cowan
# Date:    June 19, 1996
# ************************************************************************
# Required Modules 
# ************************************************************************

require 'ams-defs.pl';
require 'encrypt.pl';

# ************************************************************************
# Main Routine 
# ************************************************************************

# If mSQL installation, call connection routines
if ($install_type eq $INSTM){ &connect_db; }

print "Content-type: text/html \n\n";

unless (&pass1 && &pass2){
   print "Software Expired \n";
   exit(0);
}

&cgiparse;
&startup;

if ((!$mode) && (!$new_name)){
   &print_entry;
   exit(0);
}else{
   &check_login;
}

&interpret;

exit(0);

# ************************************************************************
# Administration Subroutines Declarations 
# ************************************************************************

# ************************************************************************
# Startup - Parse form fields and assign needed variables 
# ************************************************************************

sub startup{

   unless ($P1OK && $P2OK){
      print "Software Expired \n";
      exit(0);
   }

   $date = `date +"%b %d %Y"`;
   ($month, $day, $year) = (split(/ /, $date));

   $id = $elements{'id'};
   $pwd = $elements{'pwd'};

   $new_id = $elements{'new_id'};
   $new_pwd = $elements{'new_pwd'};
   $mode = $elements{'mode'};
   if (!$mode){
      $mode = "Edit Entry" if defined($elements{'edit.x'});
      $mode = "Display Entry" if defined($elements{'disp.x'});
      $mode = "Remove Entry" if defined($elements{'remove.x'});
   }
   $submode = $elements{'submode'};
   $new_type = $elements{'new_type'};
   $new_name = $elements{'new_name'};
   $ad = $elements{'ad'} unless $elements{'ad'} eq "[None]";
   $group = $elements{'group'} unless $elements{'group'} eq "[None]";
   $rel = $elements{'rel'} unless $elements{'rel'} eq "[None]";
   $ad_url = $elements{'ad_url'};
   $link_url = $elements{'link_url'};
   $alt_tag = $elements{'alt_tag'};
   $extra_info = $elements{'extra_info'};

   $type_tog = $elements{'type_tog'};
   if ($type_tog){ $type_chk{$type_tog} = "CHECKED"; }
   else{ $type_chk{"A"} = "CHECKED"; }

   $method = $elements{'method'};
   if ($method){ $meth_chk{$method} = "CHECKED"; }
   else{ $meth_chk{'NC'} = "CHECKED"; }

   $max_qty1 = $elements{'max_qty1'};
   $max_qty2 = $elements{'max_qty2'};
   if (defined($elements{'max_qty'})){
      $max_qty = $elements{'max_qty'};
   }elsif (($max_qty1) || ($max_qty2)){
      $max_qty = $max_qty1 if $max_qty1; 
      $max_qty = $max_qty2 if $max_qty2; 
   }
   $start_on = $elements{'start_on'};
   $end_on = $elements{'end_on'};
   $startmonth = $elements{'startmonth'} || $month;
   $startday = $elements{'startday'} || $day;
   $startyear = $elements{'startyear'} || $year;
   
   $endmonth = $elements{'endmonth'};
   $endday = $elements{'endday'};
   $endyear = $elements{'endyear'};
   if (defined($elements{'start'})){
      $start = $elements{'start'};
   }elsif (($startmonth) && ($startday) && ($startyear)){
      if (defined($start_on)){
         $start = $startmonth . " " . $startday . " " . $startyear; 
      }else{
         $start = $month . " " . $day . " " . $year;
      }
   }
   if (defined($elements{'end'})){
      $end = $elements{'end'} if (defined($end_on));
   }elsif (($endmonth) && ($endday) && ($endyear)){
      $end = $endmonth . " " . $endday . " " . $endyear if (defined($end_on));
   }
   $exp_mth = $elements{'exp_mth'};
   $exp_tot = $elements{'exp_tot'};
   $click_mth = $elements{'click_mth'};
   $click_tot = $elements{'click_tot'};
   $reset1 = $elements{'reset1'} if $elements{'reset1'};
   $reset2 = $elements{'reset2'} if $elements{'reset2'};

   if ($start){
      my ($st_mth, $st_day, $st_year) = (split(/ /, $start));
      $st_mth =~ tr/a-z/A-Z/;
      $start = $MTH_CVT{$st_mth} . " " . $st_day . " " . $st_year;
   }
   if ($end){
      my ($end_mth, $end_day, $end_year) = (split(/ /, $end));
      $end_mth =~ tr/a-z/A-Z/;
      $end = $MTH_CVT{$end_mth} . " " . $end_day . " " . $end_year;
   }
 
}

# ************************************************************************
# Interpret - Interpret the command 
# ************************************************************************

sub interpret{

   unless ($P1OK && $P2OK){
      print "Software Expired \n";
      exit(0);
   }

   if ($mode eq "MENU"){
      &print_header("Administrator Main Panel");
      &print_admin_menu;
      &print_admin_footer;
   }elsif ($mode =~ "Edit Default Group"){
      &print_header("AMS :: Edit Default Group");
      &print_default_group_form;
      &print_admin_footer;
   }elsif ($mode =~ "Set Admin Login"){
      &print_header("AMS :: Change Admin Login");
      &print_login_form;
      &print_admin_menu;
      &print_admin_footer;
   }elsif ($mode eq "LOGIN"){
      &print_header("NO_HEAD");
      if (($new_id) && ($new_pwd)){
         dbmopen(%SYS, $sys_db, 0666);
         $SYS{'USERID'} = $new_id;
         $SYS{'PASSWORD'} = crypt($new_pwd, $new_pwd);
         dbmclose(%SYS);
         $id = $new_id;
         $pwd = $new_pwd;
         print "<p><center><b>New administrator login info has been saved</b> " .
               "</center><p> \n";
      }else{
         print "<p><center><b><em>Error</em>: "; 
         print "You must supply a new userid AND new password</b></center><p> \n"; 
      }
      &print_admin_menu;
      &print_admin_footer;
   }elsif (($mode eq "Add") || ((!$mode) && ($new_name))){
      if (!$new_name){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You must first enter a new entry name</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }else{
         &print_header("NO_HEAD");
         &print_new_ad_form if $new_type eq "ad"; 
         &print_new_group_form if $new_type eq "group"; 
         &print_new_rel_form if $new_type eq "rel"; 
         &print_admin_footer;
      }
   }elsif ($mode eq "ADD"){
      &print_header("NO_HEAD");
      &new_ad if $new_type eq "ad";
      &new_group if $new_type eq "group";
      &new_rel if $new_type eq "rel";
      print "<p><center><b>New entry '<em>$new_name</em>' has been " .
            "added</b></center><p> \n";
      &print_admin_menu; 
      &print_admin_footer;
   }elsif ($mode eq "EDIT"){
      &print_header("NO_HEAD");
      &edit_ad if $new_type eq "ad";
      &edit_group if $new_type eq "group";
      &edit_rel if $new_type eq "rel";
      print "<p><center><b>Entry '<em>$new_name</em>' has been " .
            "modified and saved</b></center><p> \n";
      &print_admin_menu; 
      &print_admin_footer;
   }elsif ($mode eq "Edit Entry"){
      if ((!$ad) && (!$group) && (!$rel)){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You must first choose an advertiser, group or relation " .
               "to edit</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }elsif (($ad && $group) || ($ad && $rel) || ($group && $rel)){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You may only edit one entry at a time</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }else{
         &print_header("NO_HEAD");
         &print_edit_ad_form if $ad; 
         &print_edit_group_form if $group; 
         &print_edit_rel_form if $rel; 
         &print_admin_footer;
      }
   }elsif ($mode eq "Display Entry"){
      if ((!$ad) && (!$group) && (!$rel)){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You must first choose an advertiser, group or relation " .
               "to display</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }elsif (($ad && $group) || ($ad && $rel) || ($group && $rel)){
         &print_header("Administrator Main Panel");
         print "<p><center><b><em>Error</em>: ";
         print "You may only display one entry at a time</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }else{
         &print_header("NO_HEAD");
         &print_ad_listing if $ad; 
         &print_group_listing if $group; 
         &print_rel_listing if $rel; 
         &print_admin_menu;
         &print_admin_footer;
      }
   }elsif ($mode eq "Remove Entry"){
      if ((!$ad) && (!$group) && (!$rel) && (!$new_name)){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You must first choose an advertiser, group or relation " .
               "to remove</b></center><p> \n";
         &print_admin_menu;
         &print_admin_footer;
      }elsif (($ad && $group) || ($ad && $rel) || ($group && $rel)){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You may only remove one entry at a time</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }elsif ($ad eq "--Default--"){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You may edit the default advertisement, but not remove it" .
               "</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }elsif ($group eq "--Default--"){
         &print_header("NO_HEAD");
         print "<p><center><b><em>Error</em>: ";
         print "You may edit the default group, but not remove it" .
               "</b></center><p> \n"; 
         &print_admin_menu;
         &print_admin_footer;
      }else{
         my ($remove_type);
         my ($name);
         &print_header("NO_HEAD"); 
         if ($submode eq "Yes"){
            &do_remove($new_type, $new_name);
            print "<p><center><b>$TYPE_NAME{$new_type} entry '<em>$new_name</em>' " .
                  "has been removed</b></center><p> \n";
         }elsif ($submode eq "No"){
            print "<p><center><b>$TYPE_NAME{$new_type} entry '<em>$new_name</em>' " .
                  "has NOT been removed</b></center><p> \n";
         }else{
            if ($ad){ $remove_type = "ad"; $name = $ad; }
            elsif ($group){ $remove_type = "group"; $name = $group; }
            else{ $remove_type = "rel"; $name = $rel; }
            &print_remove_form($remove_type, $name);
         }
         &print_admin_menu;
         &print_admin_footer;
      }
   }

}

# ************************************************************************
# Print_Login_Form - Print the form for changing login access 
# ************************************************************************

sub print_login_form{

   print <<"EOF";

<center>
<b>Enter a new Administrator's Userid and Password below</b> <br>
<form method="post" action="$admin_url">
<input type=hidden name=mode value="LOGIN">
<input type=hidden name=id value="$id">
<input type=hidden name=pwd value="$pwd">
<input type="text" name="new_id" value="$id"> 
<input type="password" name="new_pwd" value="$pwd"> <br>
<input type="image" src="$imurl/change.gif" border="0" value="Change Login">
</form>
<p><hr width=505><p>
</center>

EOF

}

# ************************************************************************
# Print_Ad_Listing - Print the advertising listing 
# ************************************************************************

sub print_ad_listing{

   my (@vals) = &load_entry("ad", $ad);

   my $type_tog = $vals[$TOG_IDX];
   my $text_seg;
   my $url_seg;

   if ($type_tog eq 'A'){
      $text_seg = <<"ADBAR_SEG";

<tr><td valign=top colspan=3>
<b>URL for Adbar</b>: $vals[$ADURL_IDX] <br>
<b>URL for Link</b>: $vals[$LINKURL_IDX] <p>

<a href=\"$vals[$LINKURL_IDX]\" target=\"New\">
<img src=\"$vals[$ADURL_IDX]\" alt=\"$vals[$ALTTAG_IDX]\" $vals[$EXTRA_IDX]></a>

</td>
</tr>

<tr>
<td valign=top colspan=3>
<b>Alt Tag</b>: $vals[$ALTTAG_IDX]
</td>
</tr>

ADBAR_SEG
   }elsif ($type_tog eq 'H'){
      my $fragment = &load_fragment($vals[$ADURL_IDX]);
      $url_seg = <<"URL_SEG";
<tr>
<td valign=top colspan=4>
<b>URL for HTML Fragment</b>: $vals[$ADURL_IDX] 
</td>
</tr>
URL_SEG
      $text_seg = <<"HTML_SEG";
<tr>
<td>
</td>
<td valign=top>
$fragment
</td>
</tr>
HTML_SEG
   }

   print <<"EOF";

<center>
<b>Advertising listing: '<em>$ad</em>'</b> <p>


<table border=0 cellpadding=5 cellspacing=5>
$text_seg
</table>

<table border=0 cellpadding=5 cellspacing=5>
$url_seg
<tr>
<td valign=top>
<b>Billing Method</b>: $METHOD_NAME{$vals[$METHOD_IDX]} <br>
<b>Maximum Quantity</b>: $vals[$MAX_IDX] <br>
<b>Start Date</b>: $vals[$START_IDX] <br>
<b>End Date</b>: $vals[$END_IDX]
</td>
<td align=center valign=top>
<img width=1 height=75 src="$imurl/pixel.gif">
</td> 
<td valign=top> 
<b>Exposures/Month</b>: $vals[$EXPMTH_IDX] <br>
<b>Exposures Total</b>: $vals[$EXPTOT_IDX] <br>
<b>Click-Throughs/Month</b>: $vals[$CLICKMTH_IDX] <br>
<b>Click-Throughs Total</b>: $vals[$CLICKTOT_IDX] 
</td></tr>
<tr><td colspan=4><hr></td></tr>
</table>
</center>

EOF

}

# ************************************************************************
# Print_Group_Listing - Print the advertising group listing 
# ************************************************************************

sub print_group_listing{

   my (@vals) = &load_entry("group", $group);

   print <<"EOF1";

<center>
<table border=0 cellpadding=3 cellspacing=3>
<tr>
<td valign=top>
<b>Advertisers included in group: '<em>$group</em>'</b>
</td>
</tr>
<tr>
<td valign=top>

EOF1

   foreach $val (@vals){
      print "<li><b>$val</b> \n";
   }

   print <<"EOF2";

</td></tr>
<tr><td><hr></td></tr>
</table>
</center>

EOF2

}

# ************************************************************************
# Print_Rel_Listing - Print the relation listing 
# ************************************************************************

sub print_rel_listing{

   my (@vals) = &load_entry("rel", $rel);

   foreach $val (@vals){
      if ($val =~ /^AD:(.*)/){ push(@ad_list, $1) if $1; }
      elsif ($val =~ /^PAGE:(.*)/){ push(@page_list, $1) if $1; }
      elsif ($val =~ /^RULE:(.*)/){ push(@rule_list, $1) if $1; }
      elsif ($val =~ /^GROUP:(.*)/){ push(@group_list, $1) if $1; }
   }

   print <<"EOF";

<center>
<b>Relation listing: '<em>$rel</em>'</b> <p>

<table border=0>

EOF

   print "<tr><td valign=top><b>Advertisers in Relation</b>:</td><td> \n"; 
   if ($#ad_list < 0){ print "<i>None</i> \n"; }
   else{
      foreach $ad (@ad_list){
         print "<li><b>$ad</b> \n";
      }
   }
   print "</td></tr><tr><td colspan=2><hr size=1></td></tr> \n" .
         "<tr><td><b>Advertiser Groups in Relation</b>:</td><td> \n"; 
   if ($#group_list < 0){ print "<i>None</i> \n"; }
   else{
      foreach $group (@group_list){
         print "<li><b>$group</b> \n";
      }
   }
   print "</td></tr><tr><td colspan=2><hr size=1></td></tr> \n" .
         "<tr><td><b>Pages Defined in Relation</b>:</td><td> \n"; 
   if ($#page_list < 0){ print "<i>None</i> \n"; }
   else{
      foreach $page (@page_list){
         print "<li><b>$page</b> \n";
      }
   }
   print "</td></tr><tr><td colspan=2><hr size=1></td></tr> \n" .
         "<tr><td><b>Rules Defined in Relation</b>:</td><td> \n"; 
   if ($#rule_list < 0){ print "<i>None</i> \n"; }
   else{
      foreach $rule (@rule_list){
         print "<li><b>$rule</b> \n";
      }
   }
   print "</td></tr><tr><td colspan=2><hr></td></tr></table></center> \n";

}

# ************************************************************************
# Print_Remove_Form - Print the form for removing an entry 
# ************************************************************************

sub print_remove_form{

   my ($type, $name) = @_;

   print <<"EOF";

<center>
<form method="post" action="$admin_url">
<b>Remove $TYPE_NAME{$type} entry '<em>$name</em>'? </b>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="$mode">
<input type="hidden" name="new_type" value="$type">
<input type="hidden" name="new_name" value="$name">
<input type="submit" name="submode" value="Yes"> 
<input type="submit" name="submode" value="No">
</form>
</center>

EOF

}

# ************************************************************************
# Do_Remove - Remove an entry 
# ************************************************************************

sub do_remove{

   my ($type, $name) = @_;
   my ($table, $key);

   if ($install_type eq $INSTM){
      # mSQL version
      if ($type eq "ad"){ 
         $table = "ads";
         $key = "adkey";
      }elsif ($type eq "group"){ 
         $table = "groups"; 
         $key = "groupkey";
      }else{ 
         $table = "rels";
         $key = "relkey";
      }

      $sth = Query $dbh "DELETE FROM $table WHERE $key = '$name'"
   }else{
      # DBM version
      if ($type eq "ad"){ $db = $ad_db; }
      elsif ($type eq "group"){ $db = $group_db; }
      else{ $db = $rel_db; }

      dbmopen(%DB, $db, 0666);
      delete $DB{$name};
      dbmclose(%DB);
   }

}

# ************************************************************************
# Print_New_Ad_Form - Print the form for adding an advertiser 
# ************************************************************************

sub print_new_ad_form{

   my (%start_mth_sel) = ($startmonth => "SELECTED");
   my (%end_mth_sel) = ($endmonth => "SELECTED");

   print <<"EOF";

<center>
<b>New Advertiser Entry: <em>$new_name</em></b>
</center><br><br>

<center>
<table border=0 cellpadding=2 cellspacing=2>
<tr>
<td colspan=4>  
<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="ADD">
<input type="hidden" name="new_name" value="$new_name">
<input type="hidden" name="new_type" value="$new_type">

<font size=+1>Toggle Button for adbar/html Fragment:</font><br>
<input $type_chk{"A"} type="radio" name="type_tog" value="A"> Adbar
<input $type_chk{"H"} type="radio" name="type_tog" value="H"> HTML Fragment
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td colspan=4>
<font size=+1>URL For Ad-Bar (or) Relative URL For HTML Fragment:</font><br>
<input type="text" name="ad_url" value ="$ad_url" size="60"> <p>
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td colspan=4>
<font size=+1>URL For Link:</font><br>
<input type="text" name="link_url" value="$link_url" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td colspan=4>
<font size=+1>Alt Tag:</font><br>
<input type="text" name="alt_tag" value="$alt_tag" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td colspan=4>
<font size=+1>Extra IMG Tag Information:</font><br>
<input type="text" name="extra_info" value="$extra_info" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td valign=top>
<font size=+1>Billing Method:</font>
</td>
</tr>

<tr>
<td valign=top>
<input type="radio" $meth_chk{'PH'} name="method" value="PH"> Per Exposure<br> 
<font size=-1>Maximum #</font><input type="text" name="max_qty1" value="$max_qty1" size="4">
</td>
<td valign=top>
<input type="radio" $meth_chk{'PC'} name="method" value="PC"> Per Click-Through <br>
<font size=-1>Maximum #</font><input type="text" name="max_qty2" value="$max_qty2" size="4">
</td>
<td valign=top>
<input type="radio" $meth_chk{'FR'} name="method" value="FR"> Flat Rate 
</td>
<td valign=top> 
<input type="radio" $meth_chk{'NC'} name="method" value="NC"> No Charge 
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td valign=top colspan=2>
<input type="checkbox" name="start_on"> <font size=+1>Start Date:</font>
<br>
<font size=-1>(Optional: check the box if you want to<br>
set a start date other than today.)</font><br> 
<select name="startmonth">
<option $start_mth_sel{'Jan'} value="Jan">January
<option $start_mth_sel{'Feb'} value="Feb">February
<option $start_mth_sel{'Mar'} value="Mar">March
<option $start_mth_sel{'Apr'} value="Apr">April
<option $start_mth_sel{'May'} value="May">May
<option $start_mth_sel{'Jun'} value="Jun">June
<option $start_mth_sel{'Jul'} value="Jul">July
<option $start_mth_sel{'Aug'} value="Aug">August
<option $start_mth_sel{'Sep'} value="Sep">September
<option $start_mth_sel{'Oct'} value="Oct">October
<option $start_mth_sel{'Nov'} value="Nov">November
<option $start_mth_sel{'Dec'} value="Dec">December
</select>
<input size="2" name="startday" value="$startday">
<input size="4" name="startyear" value="$startyear">
</td>
<td valign=top colspan=2>
<input type="checkbox" name="end_on"><font size=+1>End Date:</font><br>
<font size=-1>(Optional: check the box if you want to<br>
set a specific ending date.)</font><br>
<select name="endmonth">
<option $end_mth_sel{'Jan'} value="Jan">January
<option $end_mth_sel{'Feb'} value="Feb">February
<option $end_mth_sel{'Mar'} value="Mar">March
<option $end_mth_sel{'Apr'} value="Apr">April
<option $end_mth_sel{'May'} value="May">May
<option $end_mth_sel{'Jun'} value="Jun">June
<option $end_mth_sel{'Jul'} value="Jul">July
<option $end_mth_sel{'Aug'} value="Aug">August
<option $end_mth_sel{'Sep'} value="Sep">September
<option $end_mth_sel{'Oct'} value="Oct">October
<option $end_mth_sel{'Nov'} value="Nov">November
<option $end_mth_sel{'Dec'} value="Dec">December
</select>
<input size="2" name="endday" value="$endday">
<input size="4" name="endyear" value="$endyear">
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td align=center colspan=4>
<input type="image" src="$imurl/submitad.gif" border="0" value="Edit Advertising Entry">
</form>
</td>
</tr>
</table>
</center

<p><br>

EOF

}

# ************************************************************************
# Print_Edit_Ad_Form - Print the form for editing an advertiser 
# ************************************************************************

sub print_edit_ad_form{

   my (@vals);

   if ($mode eq "EDIT"){
      $vals[$ADURL_IDX] = $ad_url;
      $vals[$LINKURL_IDX] = $link_url;
      $vals[$ALTTAG_IDX] = $alt_tag;
      $vals[$MAX_IDX] = $max_qty;
      $vals[$START_IDX] = $start;
      $vals[$END_IDX] = $end;
      $vals[$EXTRA_IDX] = $extra_info;
      $vals[$TOG_IDX] = $type_tog;
      $ad = $new_name;
   }else{
      (@vals) = &load_entry("ad", $ad);
      undef %meth_chk;
      undef %type_chk;
      $meth_chk{$vals[$METHOD_IDX]} = "CHECKED";
      $exp_mth = $vals[$EXPMTH_IDX];
      $exp_tot = $vals[$EXPTOT_IDX];
      $click_mth = $vals[$CLICKMTH_IDX];
      $click_tot = $vals[$CLICKTOT_IDX];
      $type_tog = $vals[$TOG_IDX];
      $type_chk{$type_tog} = "CHECKED";
   }
   my (%max_cnt) = ($vals[$METHOD_IDX] => $vals[$MAX_IDX]);
   my ($start_month, $start_day, $start_year) = 
      ($vals[$START_IDX] =~ /^(\S+)\s(\d+)\s(\d+)/);
   my ($end_month, $end_day, $end_year) = 
      ($vals[$END_IDX] =~ /^(\S+)\s(\d+)\s(\d+)/);
   my (%start_mth_sel) = ($start_month => "SELECTED");
   my (%end_mth_sel) = ($end_month => "SELECTED");

   if ($vals[$START_IDX]){ $start_on_chk = 'CHECKED'; }
   else{ $start_on_chk = ''; }
   if ($vals[$END_IDX]){ $end_on_chk = 'CHECKED'; }
   else{ $end_on_chk = ''; }

   print <<"EOF";

<center><b>Editing Advertiser Entry: <em>$ad</em></b></center>

<center>
<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="EDIT">
<input type="hidden" name="new_name" value="$ad">
<input type="hidden" name="new_type" value="ad">

<table border=0 cellpadding=2 cellspacing=2>
<tr>
<td colspan=4>
<font size=+1>Toggle Button for adbar/html Fragment:</font><br>
<input $type_chk{"A"} type="radio" name="type_tog" value="A"> Adbar
<input $type_chk{"H"} type="radio" name="type_tog" value="H"> HTML Fragment
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td colspan=4>
<font size=+1>URL For Ad-Bar (or) Relative URL For HTML Fragment:</font><br>
<input type="text" name="ad_url" value="$vals[$ADURL_IDX]" size="60"> <p>
</td></tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr> 

<tr>
<td colspan=4>
<font size=+1>URL For Link:</font><br>
<input type="text" name="link_url" value="$vals[$LINKURL_IDX]" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td colspan=4>
<font size=+1>Alt Tag:</font><br>
<input type="text" name="alt_tag" value="$vals[$ALTTAG_IDX]" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td colspan=4>
<font size=+1>Extra IMG Tag Information:</font><br>
<input type="text" name="extra_info" value="$vals[$EXTRA_IDX]" size="60"> <p>
</td>
</tr>

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td valign=top colspan=4>
<font size=+1>Billing Method:</font>
</td>
</tr> 

<tr>
<td valign=top>
<input type="radio" $meth_chk{'PH'} name="method" value="PH"> Per Exposure<br> 
<font size=-1>Maximum #</font><input type="text" name="max_qty1" value="$max_cnt{'PH'}" size="4">
</td>
<td valign=top>
<input type="radio" $meth_chk{'PC'} name="method" value="PC"> Per Click-Through<br> 
<font size=-1>Maximum #</font><input type="text" name="max_qty2" value="$max_cnt{'PC'}" size="4">
</td>
<td valign=top>
<input type="radio" $meth_chk{'FR'} name="method" value="FR"> Flat Rate 
</td>
<td valign=top>
<input type="radio" $meth_chk{'NC'} name="method" value="NC"> No Charge 
</td></tr>

<tr>
<td valign=top colspan=2>
<input type="checkbox" $start_on_chk name="start_on"><font size=+1>Start Date:</font><br>
<font size=-1>(Optional: check the box if you want to<br>
set a start date other than today.)</font><br>
<select name="startmonth">
<option $start_mth_sel{'Jan'} value="Jan">January
<option $start_mth_sel{'Feb'} value="Feb">February
<option $start_mth_sel{'Mar'} value="Mar">March
<option $start_mth_sel{'Apr'} value="Apr">April
<option $start_mth_sel{'May'} value="May">May
<option $start_mth_sel{'Jun'} value="Jun">June
<option $start_mth_sel{'Jul'} value="Jul">July
<option $start_mth_sel{'Aug'} value="Aug">August
<option $start_mth_sel{'Sep'} value="Sep">September
<option $start_mth_sel{'Oct'} value="Oct">October
<option $start_mth_sel{'Nov'} value="Nov">November
<option $start_mth_sel{'Dec'} value="Dec">December
</select>
<input size="2" name="startday" value="$start_day">
<input size="4" name="startyear" value="$start_year">
</td> 
<td valign=top colspan=2>
<input type="checkbox" $end_on_chk name="end_on"><font size=+1>End Date:</font><br>
<font size=-1>(Optional: check the box if you want to<br>
set a specific ending date.)</font><br>
<select name="endmonth">
<option $end_mth_sel{'Jan'} value="Jan">January
<option $end_mth_sel{'Feb'} value="Feb">February
<option $end_mth_sel{'Mar'} value="Mar">March
<option $end_mth_sel{'Apr'} value="Apr">April
<option $end_mth_sel{'May'} value="May">May
<option $end_mth_sel{'Jun'} value="Jun">June
<option $end_mth_sel{'Jul'} value="Jul">July
<option $end_mth_sel{'Aug'} value="Aug">August
<option $end_mth_sel{'Sep'} value="Sep">September
<option $end_mth_sel{'Oct'} value="Oct">October
<option $end_mth_sel{'Nov'} value="Nov">November
<option $end_mth_sel{'Dec'} value="Dec">December
</select>
<input size="2" name="endday" value="$end_day">
<input size="4" name="endyear" value="$end_year">
</td>
</tr>  

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>

<tr>
<td colspan=4>
<input type="checkbox" name="reset1" value="TRUE">
<font size=+1>Reset Exposure Counters</font>
<img align=top width="1" height="25" src="$imurl/pixel.gif">
<input type="checkbox" name="reset2" value="TRUE">
<font size=+1>Reset Click-Through Counters</font>
</td>
</tr>   

<tr>
<td colspan=4>
<hr size=1>
</td>
</tr>  

<tr>
<td align=center colspan=4> 
<input type="hidden" name="exp_mth" value="$exp_mth">
<input type="hidden" name="exp_tot" value="$exp_tot">
<input type="hidden" name="click_mth" value="$click_mth">
<input type="hidden" name="click_tot" value="$click_tot">

<br>

<input type="image" src="$imurl/submitad.gif" border="0" value="Edit Advertising Entry">
</td>
</tr>
</table>
</form>
</center>

EOF

}

# ************************************************************************
# Print_New_Group_Form - Print the form for adding a group
# ************************************************************************

sub print_new_group_form{
  
   &load_keys("ad");
 
   my ($ad_select) = "<select multiple size=5 name=\"ad_list\"> \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";

   print <<"EOF";

<center><b>New Group Entry: <em>$new_name</em></b>
</center><p>

<center>
<table border=0 cellpadding=4 cellspacing=4>
<tr>
<td colspan=2>
<hr size=1>
</td>
</tr>
<tr>
<td valign=top>
<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="ADD">
<input type="hidden" name="new_name" value="$new_name">
<input type="hidden" name="new_type" value="$new_type">
$ad_select
</td>
<td valign=top>
Select all advertisers for this group<br>
and press the '<em>Create Group</em>' button<p>

<center>
<input type="image" src="$imurl/addgrp.gif" border="0" value="Create Group">
</center>
</form>
</td>
</tr>
<tr>
<td colspan=2>
<hr size=1>
</td>
</tr>
</table>
</center><p> 

EOF

}

# ************************************************************************
# Print_Edit_Group_Form - Print the form for editing a group
# ************************************************************************

sub print_edit_group_form{
  
   my (@alist) = &load_entry("group", $group);
   foreach $ad (@alist){
      $ad_sel{$ad} = "SELECTED";
   }
   &load_keys("ad");
   
   my ($ad_select) = "<select multiple size=5 name=\"ad_list\"> \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option $ad_sel{$ad} value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";
 
   print <<"EOF";

<center>
<b>Editing Group Entry: <em>$group</em></b>
</center><p>

<center>
<table border=0 cellpadding=4 cellspacing=4>
<tr>
<td colspan=2>
<hr size=1>
</td>
</tr>
<tr> 
<td valign=top>
<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="EDIT">
<input type="hidden" name="new_name" value="$group">
<input type="hidden" name="new_type" value="group">
$ad_select
</td>
<td valign=top>
Select all advertisers for this group<br>
and press the '<em>Edit Group</em>' button<p>

<center>
<input type="image" src="$imurl/edgroup.gif" border="0" value="Edit Group">
</center>
</form>
</td>  
</tr>
<tr>
<td colspan=2> 
<hr size=1>
</td>
</tr>
</table>
</center><p>

EOF

}

# ************************************************************************
# Print_New_Rel_Form - Print the form for adding a relation 
# ************************************************************************

sub print_new_rel_form{
  
   &load_keys("all");
 
   my ($ad_select) = "<select multiple size=5 name=\"ad_list\"> \n";
   $ad_select .= "<option value=\"[None]\"> [None] \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option $ad_sel{$ad} value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";
   my ($group_select) = "<select multiple size=5 name=\"group_list\"> \n";
   $group_select .= "<option value=\"[None]\"> [None] \n";
   foreach $group (@group_list){
      $group_select .= "<option $group_sel{$group} value=\"$group\"> $group \n";
   }
   $group_select .= "</select> \n";

   print <<"EOF";

<center><b>New Relation Entry: <em>$new_name</em></b></center>

<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="ADD">
<input type="hidden" name="new_name" value="$new_name">
<input type="hidden" name="new_type" value="$new_type">

<center>
<table border=0 cellpadding=4 cellspacing=4>
<tr>
<td colspan=2>
<hr size=1>
</td>
</tr>
<tr><td valign=top>
<font size=-1><b>Advertiser List</b></font> <br>
$ad_select
<p></td><td valign=top>
<font size=-1><b>Group List</b></font> <br>
$group_select
<p></td></tr>
<tr>
<td colspan=2> 
<b>Enter a list of page urls for this relation, one per line<br>
[Each url should be relative to this server's document root]</b><br>
<textarea name="page_block" rows=5 cols=50>$page_block</textarea> <p>
</td>
</tr>
<tr>
<td colspan=2> 
<b>Enter a list of rules for this relation, one per line<br>
[Each rule should be relative to this server's document root]</b><br>
<textarea name="rule_block" rows=5 cols=50>$rule_block</textarea> <p>
</td>
</tr>
<td colspan=2 align=center>
<input type="image" src="$imurl/edrelat.gif" border="0" value="Edit Relation">
<br>
<hr size=1>
</form>
</td>
</tr>
</table>
</center><p>

EOF

}

# ************************************************************************
# Print_Edit_Rel_Form - Print the form for editing a relation 
# ************************************************************************

sub print_edit_rel_form{
  
   &load_keys("all");

   my (@vals);

   if ($mode ne "EDIT"){
      (@vals) = &load_entry("rel", $rel);
      $page_block = $rule_block = "";
      foreach $this_val (@vals){
         if ($this_val =~ /^AD:(.*)/){
            $ad_sel{$1} = "SELECTED";
         }elsif ($this_val =~ /^GROUP:(.*)/){
            $group_sel{$1} = "SELECTED";
         }elsif ($this_val =~ /^PAGE:(.*)/){
            $page_block .= $1 . "\n";       
         }elsif ($this_val =~ /^RULE:(.*)/){
            $rule_block .= $1 . "\n";       
         }
      }
   }else{
      $rel = $new_name;
   }  
 
   my ($ad_select) = "<select multiple size=5 name=\"ad_list\"> \n";
   $ad_select .= "<option value=\"[None]\"> [None] \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option $ad_sel{$ad} value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";
   my ($group_select) = "<select multiple size=5 name=\"group_list\"> \n";
   $group_select .= "<option value=\"[None]\"> [None] \n";
   foreach $group (@group_list){
      $group_select .= "<option $group_sel{$group} value=\"$group\"> $group \n";
   }
   $group_select .= "</select> \n";

   print <<"EOF";

<center><b>Editing Relation Entry: <em>$rel</em></b></center>

<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<input type="hidden" name="mode" value="EDIT">
<input type="hidden" name="new_name" value="$rel">
<input type="hidden" name="new_type" value="rel">

<center>
<table border=0 cellpadding=4 cellspacing=4>
<tr>
<td colspan=2>
<hr size=1>
</td>
</tr>
<tr><td valign=top>
<font size=-1><b>Advertiser List</b></font> <br>
$ad_select
<p></td><td valign=top>
<font size=-1><b>Group List</b></font> <br>
$group_select
<p></td></tr>
<tr>
<td colspan=2>
<b>Enter a list of page urls for this relation, one per line<br>
[Each url should be relative to this server's document root]</b><br>
<textarea name="page_block" rows=5 cols=50>$page_block</textarea> <p>
</td>
</tr>
<tr>
<td colspan=2>
<b>Enter a list of rules for this relation, one per line<br>
[Each rule should be relative to this server's document root]</b><br>
<textarea name="rule_block" rows=5 cols=50>$rule_block</textarea> <p>
</td>
</tr>
<td colspan=2 align=center>
<input type="image" src="$imurl/edrelat.gif" border="0" value="Edit Relation">
<br>
<hr size=1>
</form>
</td>
</tr>
</table>
</center><p> 

EOF

}

# ************************************************************************
# New_Ad - Handle the new ad 
# ************************************************************************

sub new_ad{

   if ((!$ad_url) || (!$link_url && $type_tog eq 'A')){
      print "<center><b>A relative url must be entered for the ad-bar " .
            "and an absolute url must be<br>entered for the link. Please " .
            "make sure these fields are filled before proceeding!</b>" .
            "</center><p> \n";
      &print_new_ad_form;
      &print_admin_footer;
      exit(0); 
   }

   $new_name =~ s/['"\[\]\{\}\\\/\(\)\+\=\@\!\#\$\%\^\&\*\?\<\>]//g;
   $new_name =~ s/\s/_/g;

   if ($install_type eq $INSTM){
      # mSQL version
      $new_name =~ s/'/\\'/g;
      $adurl =~ s/'/\\'/g;
      $link_url =~ s/'/\\'/g;
      $alt_tag =~ s/'/\\'/g;
      $extra_info =~ s/'/\\'/g;
      $sth = Query $dbh "INSERT INTO ads (adkey, adurl, linkurl, alt, method, 
         imax, start, end, expm, expt, clickm, clickt, extras, tog)
         VALUES ('$new_name', '$ad_url', '$link_url', '$alt_tag', '$method',
         '$max_qty', '$start', '$end', '0', '0', '0', '0', '$extra_info', 
         '$type_tog')";
   }else{
      # DBM version
      my ($record) = pack($ad_format, $ad_url, $link_url, $alt_tag, $method,
         $max_qty, $start, $end, 0, 0, 0, 0, $extra_info, $type_tog);
  
      dbmopen(%DB, $ad_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# Edit_Ad - Edit the ad entry
# ************************************************************************

sub edit_ad{

   if ((!$ad_url) || (!$link_url && $type_tog eq 'A')){
      print "<center><b>A relative url must be entered for the ad-bar " .
            "and an absolute url must be<br>entered for the link. Please " .
            "make sure these fields are filled before proceeding!</b>" .
            "</center><p> \n";
      &print_edit_ad_form;
      &print_admin_footer;
      exit(0); 
   }

   if ($reset1){ $exp_mth = $exp_tot = 0; }
   if ($reset2){ $click_mth = $click_tot = 0; }

   if ($install_type eq $INSTM){
      # mSQL version
      $new_name =~ s/'/\\'/g;
      $adurl =~ s/'/\\'/g;
      $link_url =~ s/'/\\'/g;
      $alt_tag =~ s/'/\\'/g;
      $extra_info =~ s/'/\\'/g;
      $sth = Query $dbh "UPDATE ads SET adurl='$ad_url', linkurl='$link_url',
         alt='$alt_tag', method='$method', imax='$max_qty', start='$start',
         end='$end', expm='$exp_mth', expt='$exp_tot', clickm='$click_mth',
         clickt='$click_tot', extras='$extra_info', tog='$type_tog' 
         WHERE adkey='$new_name'";
   }else{
      # DBM version
      my ($record) = pack($ad_format, $ad_url, $link_url, $alt_tag, $method, 
         $max_qty, $start, $end, $exp_mth, $exp_tot, $click_mth, $click_tot, 
         $extra_info, $type_tog);
   
      dbmopen(%DB, $ad_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# New_Group - Handle the new group 
# ************************************************************************

sub new_group{

   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "ad_list"){ push(@group_ad_list, $lists[$i+1]); }
   }

   if ($#group_ad_list < 0){
      print "<p><center><b><em>Error:</em> At least one advertiser must be select " .
            "to create a group, Group not created</b></center><p>"; 
      &print_admin_menu;
      &print_admin_footer;
      exit(0); 
   }

   my ($record);
   foreach $this_ad (@group_ad_list){
      $record .= $this_ad . "\t"; 
   }     
   chop($record);

   if ($install_type eq $INSTM){
      # mSQL version
      $new_name =~ s/'/\\'/g;
      $record =~ s/'/\\'/g;
      $sth = Query $dbh "INSERT INTO groups (groupkey, glist) VALUES
         ('$new_name', '$record')";
   }else{
      # DBM installation 
      dbmopen(%DB, $group_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# Edit_Group - Edit the group entry 
# ************************************************************************

sub edit_group{

   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "ad_list"){ push(@group_ad_list, $lists[$i+1]); }
   }

   if ($#group_ad_list < 0){
      print "<p><center><b><em>Error:</em> At least one advertiser must be " .
            "selected for a group, Group not modified</b></center><p>"; 
      &print_admin_menu;
      &print_admin_footer;
      exit(0); 
   }

   my ($record);
   foreach $this_ad (@group_ad_list){
      $record .= $this_ad . "\t"; 
   }     
   chop($record);

   if ($install_type eq $INSTM){
      # mSQL version
      $new_name =~ s/'/\\'/g;
      $record =~ s/'/\\'/g;
      $sth = Query $dbh "UPDATE groups SET glist='$record' 
         WHERE groupkey = '$new_name'";
   }else{
      # DBM installation
      dbmopen(%DB, $group_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# New_Rel - Handle the new relation 
# ************************************************************************

sub new_rel{

   my ($page_block) = $elements{'page_block'};
   my ($rule_block) = $elements{'rule_block'};

   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "ad_list"){ 
         push(@rel_ad_list, $lists[$i+1]) unless $lists[$i+1] eq "[None]"; 
         $ad_sel{$lists[$i+1]} = "SELECTED";
      }
   }
   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "group_list"){ 
         push(@rel_group_list, $lists[$i+1]) unless $lists[$i+1] eq "[None]"; 
         $group_sel{$lists[$i+1]} = "SELECTED";
      }
   }

   if ((($#rel_ad_list < 0) && ($#rel_group_list < 0)) ||
      ((!$page_block) && (!$rule_block))){
      print "<center><b>You must specify at least one advertiser or one " .
            "group<br>of advertisers <em>And</em> at least one page or one " .
            "rule.</b></center><p> \n";
      &print_new_rel_form;
      &print_admin_footer;
      exit(0); 
   }

   my (@rel_page_list) = (split(/\n/, $page_block));
   my (@rel_rule_list) = (split(/\n/, $rule_block));
   my ($record);
 
   foreach $page (@rel_page_list){
      $page =~ s/[
\n]//g;
      $record .= "PAGE:" . $page . "\t";
   }
   foreach $rule (@rel_rule_list){
      $rule =~ s/[
\n]//g;
      $record .= "RULE:" . $rule . "\t";
   }
   foreach $this_ad (@rel_ad_list){
      $record .= "AD:" . $this_ad . "\t";
   }
   foreach $this_group (@rel_group_list){
      $record .= "GROUP:" . $this_group . "\t";
   }
   chop($record);

   if ($install_type eq $INSTM){
      # mSQL installation
      $new_name =~ s/'/\\'/g;
      $record =~ s/'/\\'/g;
      $sth = Query $dbh "INSERT INTO rels (relkey, rlist) VALUES
         ('$new_name', '$record')";
   }else{
      # DBM installation
      dbmopen(%DB, $rel_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# Edit_Rel - Edit the relation entry 
# ************************************************************************

sub edit_rel{

   my ($page_block) = $elements{'page_block'};
   my ($rule_block) = $elements{'rule_block'};

   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "ad_list"){ 
         push(@rel_ad_list, $lists[$i+1]) unless $lists[$i+1] eq "[None]"; 
         $ad_sel{$lists[$i+1]} = "SELECTED";
      }
   }
   for ($i = 0; $i <= $#lists; $i++){
      if ($lists[$i] eq "group_list"){ 
         push(@rel_group_list, $lists[$i+1]) unless $lists[$i+1] eq "[None]"; 
         $group_sel{$lists[$i+1]} = "SELECTED";
      }
   }

   if ((($#rel_ad_list < 0) && ($#rel_group_list < 0)) ||
      ((!$page_block) && (!$rule_block))){
      print "<center><b>You must specify at least one advertiser or one " .
            "group<br>of advertisers <em>And</em> at least one page or one " .
            "rule.</b></center><p> \n";
      &print_edit_rel_form;
      &print_admin_footer;
      exit(0); 
   }

   my (@rel_page_list) = (split(/\n/, $page_block));
   my (@rel_rule_list) = (split(/\n/, $rule_block));
   my ($record);
 
   foreach $page (@rel_page_list){
      $page =~ s/
//g;
      $record .= "PAGE:" . $page . "\t";
   }
   foreach $rule (@rel_rule_list){
      $rule =~ s/
//g;
      $record .= "RULE:" . $rule . "\t";
   }
   foreach $this_ad (@rel_ad_list){
      $record .= "AD:" . $this_ad . "\t";
   }
   foreach $this_group (@rel_group_list){
      $record .= "GROUP:" . $this_group . "\t";
   }
   chop($record);

   if ($install_type eq $INSTM){
      # mSQL installation
      $new_name =~ s/'/\\'/g;
      $record =~ s/'/\\'/g;
      $sth = Query $dbh "UPDATE rels SET rlist='$record' 
         WHERE relkey = '$new_name'";
   }else{
      # DBM Version
      dbmopen(%DB, $rel_db, 0666);
      $DB{$new_name} = $record;
      dbmclose(%DB);
   }

}

# ************************************************************************
# Print_Admin_Menu - Print the administrator's menu to the browser 
# ************************************************************************

sub print_admin_menu{

   &load_keys("all");

   my ($ad_select) = "<select size=5 name=\"ad\"> \n";
   #$ad_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select><p>";
   my ($group_select) = "<select size=5 name=\"group\"> \n";
   #$group_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $group (@group_list){
      $group_select .= "<option value=\"$group\"> $group \n";
   }
   $group_select .= "</select><p>";
   my ($rel_select) = "<select size=5 name=\"rel\"> \n";
   #$rel_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $rel (@rel_list){
      $rel_select .= "<option value=\"$rel\"> $rel \n";
   }
   $rel_select .= "</select><p>";

   print <<"EOF";

<center>
<table border=0 cellpaddng=4 cellspacing=4>
<tr>
<form method="post" action="$admin_url">
<td valign=top align=center>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<b>Advertisers</b><br>
$ad_select
<input type="image" src="$imurl/display.gif" border="0" name="disp"><br>
<input type="image" src="$imurl/edit.gif" border="0" name="edit"><br>
<input type="image" src="$imurl/remove.gif" border="0" name="remove"><br>
<input type="hidden" name="group" value="[None]">
<input type="hidden" name="rel" value="[None]"> 
</td>
</form>

<td align=center>
<img width=1 height=200 src="$imurl/pixel.gif">
</td>

<form method="post" action="$admin_url">
<td valign=top align=center>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<b>Groups</b><br>
$group_select
<input type="image" src="$imurl/display.gif" border="0" name="disp"><br>
<input type="image" src="$imurl/edit.gif" border="0" name="edit"><br>
<input type="image" src="$imurl/remove.gif" border="0" name="remove"><br>
<input type="hidden" name="ad" value="[None]">
<input type="hidden" name="rel" value="[None]">
</td>
</form>

<td align=center>
<img width=1 height=200 src="$imurl/pixel.gif">
</td>

<form method="post" action="$admin_url">
<td valign=top align=center>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<b>Relations</b><br>
$rel_select
<input type="image" src="$imurl/display.gif" border="0" name="disp"><br>
<input type="image" src="$imurl/edit.gif" border="0" name="edit"><br>
<input type="image" src="$imurl/remove.gif" border="0" name="remove"><br>
<input type="hidden" name="group" value="[None]">
<input type="hidden" name="ad" value="[None]">  
</td>
</form>
</tr>

<tr>
<td colspan=5>
<hr size=1>
</td>
</tr>

<tr>
<form method="post" action="$admin_url">
<td valign=top colspan=2>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<b>Add A New Entry</b><br>
<input type="radio" checked name="new_type" value="ad"> Advertiser<br>
<input type="radio" name="new_type" value="group"> Group<br>
<input type="radio" name="new_type" value="rel"> Relation
</td>
<td valign=top align=center colspan=3>
<font size=-1><b>
To enter a new entry first choose the type<br>
of entry on the left, then enter the entry<br>
name below and press the '<em>Add</em>' button.</b></font><br>
<input type="text" name="new_name" size="20">
<font size=-1>
<input type="image" src="$imurl/add.gif" border="0" align="middle" name="mode" value="Add">
</font> 
</td>
</form>
</tr>

<tr>
<td colspan=5>
<hr size=1>
</td>
</tr>  

<tr> 
<form method="post" action="$admin_url">
<td align=center colspan=5>
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd"> 
<input type="hidden" name="mode" value="Set Admin Login"> 
<font size=-1>
<input type="image" src="$imurl/change.gif" border="0" value="  Change Administration Login  ">
</font>
</td>
</form>
</tr>
</table><p>
<br>       

EOF

}

sub print_old_admin_menu{

   &load_keys("all");

   my ($ad_select) = "<select size=5 name=\"ad\"> \n";
   $ad_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $ad (@ad_list){
      $ad_select .= "<option value=\"$ad\"> $ad \n";
   }
   $ad_select .= "</select> \n";
   my ($group_select) = "<select size=5 name=\"group\"> \n";
   $group_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $group (@group_list){
      $group_select .= "<option value=\"$group\"> $group \n";
   }
   $group_select .= "</select> \n";
   my ($rel_select) = "<select size=5 name=\"rel\"> \n";
   $rel_select .= "<option selected value=\"[None]\"> [None] \n";
   foreach $rel (@rel_list){
      $rel_select .= "<option value=\"$rel\"> $rel \n";
   }
   $rel_select .= "</select> \n";

   print <<"EOF";

<center>
<form method="post" action="$admin_url">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="pwd" value="$pwd">
<table border=0 cellpaddng=4 cellspacing=4>
<tr><td valign=top align=center>
<font size=-1><b>Group List</b></font><br>
$group_select
</td><td valign=top align=center>
<font size=-1><b>Advertiser List</b></font><br>
$ad_select
</td><td valign=top align=center>
<font size=-1><b>Relation List</b></font><br>
$rel_select
</td></tr>
<tr><td colspan=3 valign=top align=center>
<font size=-1>
<input type="submit" name="mode" value="Remove Entry">
<input type="submit" name="mode" value="Edit Entry">
<input type="submit" name="mode" value="Display Entry">
</font>
</table>
<hr width=505>
<table border=0 cellpaddng=5 cellspacing=5>
<tr><td valign=top>
<font size=-1><b>New Entry Type</b></font><br>
<input type="radio" checked name="new_type" value="ad"> Advertiser Entry <br>
<input type="radio" name="new_type" value="group"> Group Entry <br>
<input type="radio" name="new_type" value="rel"> Relation Entry
</td><td valign=top align=center>
<font size=-1><b>
To enter a new entry first choose the type<br>
of entry on the left, then enter the entry<br>
name below and press the '<em>Add</em>' button.</b></font><br>
<input type="text" name="new_name" size="20"> 
<font size=-1>
<input type="submit" name="mode" value="Add">
</font>
</td><td>
<font size=-1>
<input type="submit" name="mode" value="  Set Admin Login  "><br>
<input type="submit" name="mode" value="Edit Default Group">
</font>
</td></tr> 
</table>
</form>
</center>

EOF

}

# ************************************************************************
# End of Administration Module 
# ************************************************************************
