#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Hyperseek Search Engine: SQL Table Builder                       #
# VERSION : 2000.1.54                                                        #
#                                                                            #
##############################################################################
#                                                                            #
#  __  __                                                  __                #
# /\ \/\ \                                                /\ \               #
# \ \ \_\ \  __  __  _____     __  _ __  ____    __     __\ \ \/'\           #
#  \ \  _  \/\ \/\ \/\ '__`\ /'__`Y\`'__Y',__\ /'__`\ /'__`\ \ , <           #
#   \ \ \ \ \ \ \_\ \ \ \L\ Y\  __| \ \/\__, `Y\  __//\  __/\ \ \\`\         #
#    \ \_\ \_\/`____ \ \ ,__| \____\ \_\/\____| \____\ \____\\ \_\ \_\       #
#     \/_/\/_/`/___/> \ \ \/ \/____/\/_/\/___/ \/____/\/____/ \/_/\/_/       #
#                /\___/\ \_\                                                 #
#                \/__/  \/_/                                                 #
#                                     ___      __      __      __            #
#                                   /'___`\  /'__`\  /'__`\  /'__`\          #
#                                  /\_\ /\ \/\ \/\ \/\ \/\ \/\ \/\ \         #
#                                  \/_/// /_\ \ \ \ \ \ \ \ \ \ \ \ \        #
#                                     // /_\ \ \ \_\ \ \ \_\ \ \ \_\ \       #
#                                    /\______/\ \____/\ \____/\ \____/       #
#                                    \/_____/  \/___/  \/___/  \/___/        #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

package IWEB;

BEGIN { 
   use Cwd;
}

BEGIN {
   $directory = cwd;
   $directory =~ s/\/utilities//g;
   push @INC,$directory;
   push @INC, "..";
}

BEGIN { use IWeb::iweb; }


use vars qw($TEXT $INT $SQL);

    IWEB::Read_Config();

    if($global{'sql_driver'} eq "Informix") { 
      $TEXT = "CHAR(2000)";
      $INT = "INTEGER";   
    }
    if($global{'sql_driver'} eq "oracle") { 
      $TEXT = "VARCHAR(2000)";
      $INT = "NUMBER";    
    } 
    if($global{'sql_driver'} eq "InterBase") { 
      $TEXT = "VARCHAR(2000)";
      $INT = "INT";
    }
    else {
      $TEXT = "TEXT";
      $INT = "INT";
    }

    print "Content-Type: text/plain\n\n";
    print "Getting Started...\n\n";

    IWEB::SQL_Connect();

      if($ARGV[0] =~ "jackhammer" || $ENV{'QUERY_STRING'} =~ "jackhammer") { IWEB::Jackhammer_Tables(); }
      elsif($ARGV[0] =~ "filex" || $ENV{'QUERY_STRING'} =~ "filex") { IWEB::Filex_Tables(); }
      elsif($ARGV[0] =~ "survey" || $ENV{'QUERY_STRING'} =~ "survey") { IWEB::Survey_Tables(); }
      elsif($ARGV[0] =~ "hyperseek" || $ENV{'QUERY_STRING'} =~ "hyperseek") { IWEB::Hyperseek_Tables(); }
      elsif($ARGV[0] =~ "iforum" || $ENV{'QUERY_STRING'} =~ "iforum") { IWEB::Forum_Tables(); }
      else {
         IWEB::Generic_Tables();
         IWEB::Bannermaster_Tables();
      }

   print "\n\n";
   print "-----------------------------------\n";
   print "-------    COMPLETE   -------------\n";
   print "-----------------------------------\n";

   IWEB::Quit();



sub Generic_Tables {

   print "Doing Generic/Global Tables\n";
   print "-----------------------------------\n";

   $SQL = qq!
	CREATE TABLE accounts (
		acct_id CHAR(80) NOT NULL,
		acct_password CHAR(20) NOT NULL,
		acct_type CHAR(20),
		contact_email CHAR(100),
		url CHAR(200),
		contact_name CHAR(50),
		address CHAR(75),
		city CHAR(50),
		state CHAR(5),
		zip CHAR(10),
		country CHAR(30),
		phone CHAR(20),
		fax CHAR(20),
                sub_threads $TEXT,
                sub_topics $TEXT,
                theme CHAR(50),
                days_to_show CHAR(5),
                num_posts $INT,
                num_visits $INT,
                last_visit $INT,
                comments $TEXT,
		cc_number CHAR(20),
		cc_date CHAR(7),
		cc_type CHAR(20),
		cc_name CHAR(50),
		total_paid DECIMAL(9,2),
		current_balance DECIMAL(9,2),
		last_pd_date CHAR(10),
                create_date CHAR(10),
                user_icon CHAR(128),
                field1 CHAR(100),
                field2 CHAR(100),
                field3 CHAR(100),
                field4 CHAR(100),
                field5 CHAR(100)
	)
   !;
   if($dbh->do($SQL)) { print "Members Table Created\n"; }
   else { print "Members Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE UNIQUE INDEX acct_idx1 on accounts(acct_id)";
      if($dbh->do($SQL)) { print "Members Index Created\n"; }
      else { print "Members Index Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE acct_inbox (
		msg_id CHAR(20) NOT NULL,
		acct_id CHAR(20) NOT NULL,
		post_date CHAR(20),
		posted_by CHAR(20),
                is_read $INT,
		subject CHAR(100),
		msg_text $TEXT
	)
   !;
   if($dbh->do($SQL)) { print "InBox Table Created\n"; }
   else { print "InBox Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX inbox1 on acct_inbox(acct_id)";
      if($dbh->do($SQL)) { print "InBox Index Created\n"; }
      else { print "InBox Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX inbox2 on acct_inbox(msg_id)";
      if($dbh->do($SQL)) { print "InBox Index 2 Created\n"; }
      else { print "InBox Index 2 Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE table_def (
        table_name VARCHAR(50) NOT NULL,
        schema_name VARCHAR(50) NOT NULL,
        field_name VARCHAR(100),
        form_order $INT,
        table_order $INT,
        form_prompt VARCHAR(255),
        system VARCHAR(1),
        col_type VARCHAR(25),
        col_length VARCHAR(10),
        is_required VARCHAR(1),
        default_value $TEXT,
        input_type VARCHAR(50),
        regex VARCHAR(100)
      )
   !;

   if($dbh->do($SQL)) { print "Schema Table Created\n"; }
   else { print "Schema Table Not Created $DBI::errstr.\n"; }

   print "Global Tables Complete\n\n";


}

sub Hyperseek_Tables {

   print "Doing Hyperseek Tables\n";
   print "-----------------------------------\n";

   $SQL = qq!
	CREATE TABLE hyperseek_links (

		id $INT NOT NULL PRIMARY KEY,
		category $TEXT,
		extra_link CHAR(120),
		rank DECIMAL(15,5) NOT NULL,
		qualifier CHAR(120),
		email CHAR(100) NOT NULL,
		title CHAR(80),
		url CHAR(120) NOT NULL,
		description $TEXT,
		keywords $TEXT,
		desc_image CHAR(120),
		title_tag CHAR(120),
		site_icon CHAR(120),
		name CHAR(50),
		address CHAR(75),
		city CHAR(50),
		state CHAR(5),
		zip CHAR(10),
		country CHAR(30),
		phone CHAR(20),
		fax CHAR(20),
		startdate CHAR(20),
		enddate CHAR(20),
		price CHAR(20),
		account CHAR(30) NOT NULL,
		xfactor CHAR(20),
		field1 CHAR(255),
		field2 CHAR(255),
		field3 CHAR(255),
		field4 CHAR(255),
		field5 CHAR(255),
		field6 CHAR(255),
		field7 CHAR(255),
		field8 CHAR(255),
		field9 CHAR(255),
		field10 CHAR(255)
	)
   !;
   if($dbh->do($SQL)) { print "Hyperseek Links Table Created\n"; }
   else { print "Hyperseek Links Table Not Created $DBI::errstr.\n"; }
   
   $SQL = qq!
        CREATE TABLE hs_related (
            category_id $INT NOT NULL PRIMARY KEY,
            related_id $INT NOT NULL
        )
   !;
   if($dbh->do($SQL)) { print "Hyperseek Related Categories Table Created\n"; }
   else { print "Hyperseek Related Categories Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE hyperseek_keys (
		keyword CHAR(50) NOT NULL,
		id $INT NOT NULL,
                price DECIMAL(9,2) NOT NULL,
                xfactor INT NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "Hyperseek Keys Table Created\n"; }
   else { print "Hyperseek Keys Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE hyperseek_cats (
		category CHAR(120) NOT NULL,
		id $INT NOT NULL,
                price DECIMAL(9,2)
	)
   !;
   if($dbh->do($SQL)) { print "Hyperseek Cats Table Created\n"; }
   else { print "Hyperseek Cats Table Not Created $DBI::errstr.\n"; }



   $SQL = qq!
	CREATE TABLE hyperseek_stats (

		id $INT NOT NULL,
		category CHAR(120) NOT NULL,
                hits $INT,
                top_votes $INT,
                rate_votes $INT,
                rate_score $INT,
                av_links $INT
	)
   !;
   if($dbh->do($SQL)) { print "Hyperseek Stats Table Created\n"; }
   else { print "Hyperseek Stats Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE hyperseek_results (
         cookie_id $INT NOT NULL,
         id_set $TEXT,
         key hsr1 (cookie_id)
      )
   !;

   if($dbh->do($SQL)) { print "Hyperseek Resuls Table Created<BR><BR>\n\n"; }
   else { print "Hyperseek Results Table NOT Created $DBI::errstr.<BR><BR>\n\n"; }



   ### Indexes ###
   $SQL = "CREATE INDEX hsl_email on hyperseek_links(email)";
     if($dbh->do($SQL)) { print "Hyperseek Email Index Created\n"; }
     else { print "Hyperseek Email Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_url on hyperseek_links(url)";
     if($dbh->do($SQL)) { print "Hyperseek URL Index Created\n"; }
     else { print "Hyperseek URL Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_acct1 on hyperseek_links(account)";
     if($dbh->do($SQL)) { print "Hyperseek Account Index Created\n"; }
     else { print "Hyperseek Account Index Not Created $DBI::errstr.\n"; }


   $SQL = "CREATE INDEX hsl_pos1 on hyperseek_links(rank)";
     if($dbh->do($SQL)) { print "Hyperseek Rank Index Created\n"; }
     else { print "Hyperseek Rank Index Not Created $DBI::errstr.\n"; }


   $SQL = "CREATE INDEX hsl_stat on hyperseek_stats(id)";
     if($dbh->do($SQL)) { print "Hyperseek Stats ID Index Created\n"; }
     else { print "Hyperseek Stats ID Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_stat2 on hyperseek_stats(category)";
     if($dbh->do($SQL)) { print "Hyperseek Stats Category Index Created\n"; }
     else { print "Hyperseek Stats Category Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_keys1 on hyperseek_keys(keyword)";
     if($dbh->do($SQL)) { print "Hyperseek Keys Index Created\n"; }
     else { print "Hyperseek Keys Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_keys2 on hyperseek_keys(price,xfactor)";
     if($dbh->do($SQL)) { print "Hyperseek Price Index Created\n"; }
     else { print "Hyperseek Price Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_keys3 on hyperseek_keys(id)";
     if($dbh->do($SQL)) { print "Hyperseek Key ID Index Created\n"; }
     else { print "Hyperseek Key ID Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_cats1 on hyperseek_cats(category)";
     if($dbh->do($SQL)) { print "Hyperseek Cats ID Index Created\n"; }
     else { print "Hyperseek Cats ID Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_cats2 on hyperseek_cats(id)";
     if($dbh->do($SQL)) { print "Hyperseek Cats ID 2 Index Created\n"; }
     else { print "Hyperseek Cats ID 2 Index Not Created $DBI::errstr.\n"; }


   print "Hyperseek Tables Done\n\n";

}




sub Jackhammer_Tables {


   print "Creating Jackhammer Tables\n";
   print "-----------------------------------\n";

   $SQL = qq!
	CREATE TABLE acct_deposits (
		acct_id CHAR(20) NOT NULL,
		amount DECIMAL(9,2) NOT NULL,
		tax DECIMAL(9,2)
	)
   !;
   if($dbh->do($SQL)) { print "Jackhammer Deposits Table Created\n"; }
   else { print "Jackhammer Deposits Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE acct_finances (
		acct_id CHAR(20) NOT NULL,
		deposit_date $INT NOT NULL,
		amount DECIMAL(9,2) NOT NULL,
		tax_amount DECIMAL(9,2),
		source CHAR(50)
	)
   !;
   if($dbh->do($SQL)) { print "Jackhammer Finances Table Created\n"; }
   else { print "Jackhammer Finances Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE hyperseek_forbid (
		id CHAR(20) NOT NULL,
		word CHAR(50) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "Jackhammer Forbid Table Created\n"; }
   else { print "Jackhammer Forbid Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE jh_bids_pending (
		account CHAR(20) NOT NULL,
		linkid CHAR(20) NOT NULL,
		num_words INT
	)
   !;
   if($dbh->do($SQL)) { print "Jackhammer Pending Bids Table Created\n"; }
   else { print "Jackhammer Pending Bids Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE go_hits (
		link_id $INT NOT NULL,
		word CHAR(225) NOT NULL,
                price DECIMAL(4,2) NOT NULL,
                hit_date $INT NOT NULL,
                num_hits $INT,
		affiliate CHAR(50) NOT NULL,
		commission CHAR(10),
                paid_flag CHAR(3)
	)
   !;
   if($dbh->do($SQL)) { print "Jackhammer Hits Table Created\n"; }
   else { print "Jackhammer Hits Table Not Created $DBI::errstr.\n"; }

   ## NEW
   $SQL = qq!
         CREATE TABLE affiliate_info (
                affiliate CHAR(80) NOT NULL PRIMARY KEY,
                payment_type CHAR(20),
                payment_trigger CHAR(20),
                search_amount decimal(9,2),
                click_amount CHAR(20),
                allowed_referers TEXT,
                minimum_payment decimal(9,2),
                application_date CHAR(20),
                approval_date CHAR(20),
                notes TEXT
         )
   !;
   if($dbh->do($SQL)) { print "Jackhammer Affiliate Info Table Created\n"; }
   else { print "Jackhammer Affiliate Info Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
         CREATE TABLE affiliate_searches (
                affiliate CHAR(80) NOT NULL,
                search_date CHAR(8) NOT NULL,
		commission CHAR(10),
                search_count $INT,
                paid_flag CHAR(3)
         )
   !;
   if($dbh->do($SQL)) { print "Jackhammer Affiliate Searches Table Created\n"; }
   else { print "Jackhammer Affiliate Searches Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_affs1 on affiliate_searches(affiliate,search_date)";
     if($dbh->do($SQL)) { print "Jackhammer Affiliate Searches Index Created\n"; }
     else { print "Jackhammer Affiliate Searches Index Not Created $DBI::errstr.\n"; }


   ## NEW
   $SQL = qq!
         CREATE TABLE affiliate_payments (
                affiliate CHAR(80) NOT NULL,
                paid_date CHAR(20) NOT NULL,
		paid_amount DECIMAL(9,2),
                due_amount DECIMAL(9,2),
                balance DECIMAL(9,2),
                period_start CHAR(20),
                period_end CHAR(20),
                tstamp INT NOT NULL,
                comments $TEXT
         )
   !;
   if($dbh->do($SQL)) { print "Jackhammer Affiliate Payments Table Created\n"; }
   else { print "Jackhammer Affiliate Payments Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_pay1 on affiliate_payments(affiliate,paid_date)";
     if($dbh->do($SQL)) { print "Jackhammer Affiliate Payments Index Created\n"; }
     else { print "Jackhammer Affiliate Payments Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_pay2 on affiliate_payments(affiliate,tstamp)";
     if($dbh->do($SQL)) { print "Jackhammer Affiliate Payments Index 2 Created\n"; }
     else { print "Jackhammer Affiliate Payments Index 2 Not Created $DBI::errstr.\n"; }

   ## NEW
   $SQL = qq!
         CREATE TABLE affiliate_access (
                affiliate CHAR(80),
                ip_number CHAR(30) NOT NULL,
                link_id INT NOT NULL,
                link_id_count INT,
		search_terms CHAR(224) NOT NULL,
                num_searches INT
         )
   !; 

   if($dbh->do($SQL)) { print "Jackhammer Affiliate Access Table Created\n"; }
   else { print "Jackhammer Affiliate Access Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_access1 on affiliate_access(ip_number,link_id)";
     if($dbh->do($SQL)) { print "Jackhammer Affiliate Access Index Created\n"; }
     else { print "Jackhammer Affiliate Access Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_access2 on affiliate_access(ip_number,search_terms)";
     if($dbh->do($SQL)) { print "Jackhammer Affiliate Access Index 2 Created\n"; }
     else { print "Jackhammer Affiliate Access Index 2 Not Created $DBI::errstr.\n"; }

   ### Indexes ###
   $SQL = "CREATE INDEX hsl_ghits on go_hits(link_id,hit_date)";
     if($dbh->do($SQL)) { print "Jackhammer Hits Index Created\n"; }
     else { print "Jackhammer Hits Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_ghits2 on go_hits(affiliate,hit_date)";
     if($dbh->do($SQL)) { print "Jackhammer Hits Index2 Created\n"; }
     else { print "Jackhammer Hits Index2 Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_gdep on acct_deposits(acct_id)";
     if($dbh->do($SQL)) { print "Jackhammer Deposits Index Created\n"; }
     else { print "Jackhammer Deposits Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsl_forbid on hyperseek_forbid(id)";
     if($dbh->do($SQL)) { print "Jackhammer Forbidden Index Created\n"; }
     else { print "Jackhammer Forbidden Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX jh_bids on jh_bids_pending(account,linkid)";
     if($dbh->do($SQL)) { print "Jackhammer Pending Bids Index Created\n"; }
     else { print "Jackhammer Pending Bids Index Not Created $DBI::errstr.\n"; }


   $SQL = "CREATE INDEX hsl_finance on acct_finances(acct_id,deposit_date)";
     if($dbh->do($SQL)) { print "Jackhammer Finances Index Created\n"; }
     else { print "Jackhammer Finances Index Not Created $DBI::errstr.\n"; }



   print "Jackhammer Tables Done\n\n";

}



sub Forum_Tables {

   print "Doing Forum Tables\n";
   print "-----------------------------------\n";

   $SQL = qq!
	CREATE TABLE forums (
		forum CHAR(50) NOT NULL,
		category CHAR(120) NOT NULL,
		forum_name CHAR(100),
		moderators CHAR(120),
                private CHAR(20),
                private_password CHAR(20),
                num_posts $INT,
		description $TEXT
	)
   !;
   if($dbh->do($SQL)) { print "iForums Forums Table Created\n"; }
   else { print "iForums Forums Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE forum_stats (
		forum CHAR(50) NOT NULL,
		thread $INT NOT NULL,
		subject CHAR(255),
                name CHAR(50),
                teaser CHAR(50),
                num_posts $INT,
                last_post $INT,
                wants_email CHAR(100)
	)
   !;
   if($dbh->do($SQL)) { print "iForums Stats Table Created\n"; }
   else { print "iForums Stats Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE forum_keys (
		forum CHAR(50) NOT NULL,
		message_no $INT NOT NULL,
		keyword CHAR(20) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "iForums Keys Table Created\n"; }
   else { print "iForums Keys Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE forum_cats (
		category CHAR(120) NOT NULL,
		forum CHAR(50) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "iForums Categories Table Created\n"; }
   else { print "iForums Categories Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE forum_cat_def (
		category CHAR(200) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "iForums Cat Def Table Created\n"; }
   else { print "iForums Cat Def Table Not Created $DBI::errstr.\n"; }



   $SQL = qq!
	CREATE TABLE messages (
		forum char(50) NOT NULL,
		thread $INT NOT NULL,
                message_no $INT NOT NULL,
                subject CHAR(255),
                author_name CHAR(50),
                author_email CHAR(100),
                msg_date CHAR(15),
                message_text $TEXT,
                thread_index CHAR(100),
                reply_to INT
	)
   !;
   if($dbh->do($SQL)) { print "iForums Messages Table Created\n"; }
   else { print "iForums Messages Table Not Created $DBI::errstr.\n"; }




    $SQL = qq!
        CREATE TABLE forum_groups (
            forum_group CHAR(50) NOT NULL
        )
   !;
   if($dbh->do($SQL)) { print "iForums Groups Table Created\n"; }
   else { print "iForums Groups Table Not Created $DBI::errstr.\n"; }

    $SQL = qq!
        CREATE TABLE threads_read (
            userid CHAR(20) NOT NULL,
            thread_id $INT NOT NULL
        )
   !;
   if($dbh->do($SQL)) { print "iForums Threads Read Table Created\n"; }
   else { print "iForums Threads Read Table Not Created $DBI::errstr.\n"; }



    $SQL = qq!
        CREATE TABLE user_groups (
            forum_group CHAR(50) NOT NULL,
            userid CHAR(50) NOT NULL
        )
   !;
   if($dbh->do($SQL)) { print "iForums User Groups Table Created\n"; }
   else { print "iForums User Groups Table Not Created $DBI::errstr.\n"; }


   ### Indexes ###
   $SQL = "CREATE UNIQUE INDEX forum1 on forums(forum)";
     if($dbh->do($SQL)) { print "iForums Forums Index Created\n"; }
     else { print "iForums Forums Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum2 on forum_keys(forum,message_no,keyword)";
     if($dbh->do($SQL)) { print "iForums Forum Keys Index Created\n"; }
     else { print "iForums Forum Keys Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum3 on messages(forum,thread,message_no)";
     if($dbh->do($SQL)) { print "iForums Threads Index Created\n"; }
     else { print "iForums Threads Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum5 on forums(category)";
     if($dbh->do($SQL)) { print "iForums Category Index Created\n"; }
     else { print "iForums Category Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum6 on forum_stats(forum,thread)";
     if($dbh->do($SQL)) { print "iForums Stats Index Created\n"; }
     else { print "iForums Stats Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum7 on forum_cats(category)";
     if($dbh->do($SQL)) { print "iForums Cats Index Created\n"; }
     else { print "iForums Cats Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum8 on threads_read(userid)";
   if($dbh->do($SQL)) { print "iForums Threads Read Index 1 Created\n"; }
   else { print "iForums Threads Read Index 1 Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX forum9 on threads_read(thread_id)";
   if($dbh->do($SQL)) { print "iForums Threads Read Index 2 Created\n"; }
   else { print "iForums Threads Read Index 2 Not Created $DBI::errstr.\n"; }


   print "Done Forums\n\n";
}



sub Bannermaster_Tables {

   print "Doing Bannermaster Tables\n";
   print "-----------------------------------\n";


   $SQL = qq!
	CREATE TABLE bm_group_def (
            group_name CHAR(120) NOT NULL,
            last_shown $INT
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Group Def Table Created\n"; }
   else { print "Bannermaster Group Def Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE bm_click (
            click_key CHAR(120) NOT NULL,
            account CHAR(50)
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Clicks Table Created\n"; }
   else { print "Bannermaster Clicks Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE bm_groups (
		group_name CHAR(120) NOT NULL,
		account CHAR(50) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Groups Table Created\n"; }
   else { print "Bannermaster Groups Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
	CREATE TABLE campaigns (
		account CHAR(50) NOT NULL,
		login CHAR(50), 
		camp_pass CHAR(50), 
		target CHAR(50), 
		redirect_url CHAR(255), 
		alt_text CHAR(255), 
		under_text CHAR(255), 
		banner_type CHAR(50), 
		banner CHAR(255), 
		width $INT,
		height $INT,
		banner_text $TEXT,
		expiration_type CHAR(50), 
		num_clicks $INT,
		clicks_allowed $INT,
		num_impressions $INT,
		imp_allowed $INT,
		start_date CHAR(15), 
		end_date CHAR(15) 
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Accounts Table Created\n"; }
   else { print "Bannermaster Accounts Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE bm_stats (
		account CHAR(50) NOT NULL,
		stat_date CHAR(15) NOT NULL,
                clicks $INT,
                impressions $INT
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Stats Table Created\n"; }
   else { print "Bannermaster Stats Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
	CREATE TABLE bm_click_stats (
		account CHAR(50) NOT NULL,
		click_date CHAR(15) NOT NULL,
                referer CHAR(224) NOT NULL
	)
   !;
   if($dbh->do($SQL)) { print "Bannermaster Click Stats Table Created\n"; }
   else { print "Bannermaster Click Stats Table Not Created $DBI::errstr.\n"; }


   ### Indexes ###
   $SQL = "CREATE INDEX bm_acct on campaigns(account)";
     if($dbh->do($SQL)) { print "Bannermaster Accounts Index Created\n"; }
     else { print "Bannermaster Accounts Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX bm_st_acct on bm_stats(account,stat_date)";
     if($dbh->do($SQL)) { print "Bannermaster Stats Index Created\n"; }
     else { print "Bannermaster Stats Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX bm_grp_acct on bm_groups(group_name)";
     if($dbh->do($SQL)) { print "Bannermaster Groups Index Created\n"; }
     else { print "Bannermaster Groups Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX bm_grp_def on bm_group_def(group_name)";
     if($dbh->do($SQL)) { print "Bannermaster Group Def Index Created\n"; }
     else { print "Bannermaster Group Def Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX bms_click on bm_click(click_key)";
     if($dbh->do($SQL)) { print "Bannermaster Click Key Index Created\n"; }
     else { print "Bannermaster Click Key Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX bms_click2 on bm_click_stats(account,click_date)";
     if($dbh->do($SQL)) { print "Bannermaster Click Stats Index Created\n"; }
     else { print "Bannermaster Click Stats Index Not Created $DBI::errstr.\n"; }


    print "Bannermaster tables Done\n\n";

}


sub Extra_Indexes {

   print "Doing Hyperseek Additional Indexing\n";
   print "-----------------------------------\n";

   $SQL = "CREATE INDEX hscity on hyperseek_links(city)";
     if($dbh->do($SQL)) { print "Hyperseek City Index Created\n"; }
     else { print "Hyperseek City Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hsstate on hyperseek_links(state)";
     if($dbh->do($SQL)) { print "Hyperseek State Index Created\n"; }
     else { print "Hyperseek State Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX hszip on hyperseek_links(zip)";
     if($dbh->do($SQL)) { print "Hyperseek Zip Index Created\n"; }
     else { print "Hyperseek Zip Index Not Created $DBI::errstr.\n"; }

    print "Hyperseek Extra Indexing Done\n\n";

}



sub Filex_Tables {


   print "Doing File Exchange Tables \n";
   print "-----------------------------------\n";

	 $SQL = qq!
      CREATE TABLE file_areas (
			    area_name CHAR(50) NOT NULL PRIMARY KEY
			)
	 !;
   if($dbh->do($SQL)) { print "File Exchange Areas Table Created\n"; }
   else { print "File Exchange Areas Table Not Created $DBI::errstr.\n"; }


   $SQL = qq!
    CREATE TABLE file_library (
	    file_id INT NOT NULL PRIMARY KEY,
	    area_name CHAR(50) NOT NULL,
	file_title CHAR(50) NOT NULL,
          file_name CHAR(128) NOT NULL,
		upload_date $INT NOT NULL,
		uploaded_by CHAR(20) NOT NULL,
		num_downloads $INT NOT NULL,
		description $TEXT
			)
	 !;

   if($dbh->do($SQL)) { print "File Exchange Main Table Created\n"; }
   else { print "File Exchange Main Table Not Created $DBI::errstr.\n"; }

	 $SQL = "CREATE INDEX filex1 ON file_library(area_name,file_title)";
   if($dbh->do($SQL)) { print "File Exchange Index1 Index Created\n"; }
   else { print "File Exchange Index1 Index Not Created $DBI::errstr.\n"; }

	 $SQL = "CREATE INDEX filex2 ON file_library(area_name,upload_date)";
   if($dbh->do($SQL)) { print "File Exchange Index2 Index Created\n"; }
   else { print "File Exchange Index2 Index Not Created $DBI::errstr.\n"; }

	 $SQL = "CREATE INDEX filex3 ON file_library(area_name,uploaded_by)";
   if($dbh->do($SQL)) { print "File Exchange Index3 Index Created\n"; }
   else { print "File Exchange Index3 Index Not Created $DBI::errstr.\n"; }

	 $SQL = "CREATE INDEX filex4 ON file_library(area_name,num_downloads)";
   if($dbh->do($SQL)) { print "File Exchange Index4 Index Created\n"; }
   else { print "File Exchange Index4 Index Not Created $DBI::errstr.\n"; }

}

sub Survey_Tables {


   print "Doing iSurvey Tables \n";
   print "-----------------------------------\n";

   $SQL = qq!
      CREATE TABLE surveys (
         survey_id INT NOT NULL PRIMARY KEY,
         survey_name CHAR(50) NOT NULL,
         description TEXT,
         start_date CHAR(11),
         end_date CHAR(11),
         public CHAR(1),
         maillist CHAR(1),
         result_mail CHAR(1),
         minimum_votes INT,
         redirect_url CHAR(255),
         allow_anonymous CHAR(1),
         num_questions INT,
         template CHAR(100),
         status CHAR(20)
      )
	 !;
   if($dbh->do($SQL)) { print "Surveys Table Created\n"; }
   else { print "Surveys Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE survey_questions (
         survey_id INT NOT NULL,
         question_id INT NOT NULL,
         question TEXT,
         response_type CHAR(10),
         input_type CHAR(20),
         input_values TEXT,
         required CHAR(1),
         dependancy INT,
         dependancy_value CHAR(200)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Questions Table Created\n"; }
   else { print "Survey Questions Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX sv1 ON survey_questions(survey_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Question Index1 Index Created\n"; }
   else { print "Survey Question Index1 Index Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE survey_results (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         question_id INT NOT NULL,
         rcount INT,
         answer CHAR(255)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Results Table Created\n"; }
   else { print "Survey Questions Results Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX sv2 ON survey_results(survey_id,join_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Results Index1 Index Created\n"; }
   else { print "Survey Results Index1 Index Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE survey_detail (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         session_id INT NOT NULL,
         question_id INT NOT NULL,
         answer CHAR(255)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Detail Table Created\n"; }
   else { print "Survey Questions Detail Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX svd1 ON survey_detail(survey_id,join_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Detail Index1 Index Created\n"; }
   else { print "Survey Detail Index1 Index Not Created $DBI::errstr.\n"; }


   $SQL = "CREATE INDEX svd2 ON survey_detail(session_id)";
   if($dbh->do($SQL)) { print "Survey Detail Index2 Index Created\n"; }
   else { print "Survey Detail Index2 Index Not Created $DBI::errstr.\n"; }


   ## ARCHIVE TABLES ##
   $SQL = qq!
      CREATE TABLE a_surveys (
         survey_id INT NOT NULL PRIMARY KEY,
         survey_name CHAR(50) NOT NULL,
         description TEXT,
         start_date CHAR(11),
         end_date CHAR(11),
         public CHAR(1),
         maillist CHAR(1),
         result_mail CHAR(1),
         minimum_votes INT,
         redirect_url CHAR(255),
         allow_anonymous CHAR(1),
         num_questions INT,
         status CHAR(20)
      )
	 !;
   if($dbh->do($SQL)) { print "Surveys Archive Table Created\n"; }
   else { print "Surveys Archive Table Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE a_survey_questions (
         survey_id INT NOT NULL,
         question_id INT NOT NULL,
         question TEXT,
         response_type CHAR(10),
         input_type CHAR(20),
         input_values TEXT,
         required CHAR(1),
         dependancy INT,
         dependancy_value CHAR(200)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Questions Archive Table Created\n"; }
   else { print "Survey Questions Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX a_sv1 ON a_survey_questions(survey_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Question Archive Index1 Index Created\n"; }
   else { print "Survey Question Index1 Index Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE a_survey_results (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         question_id INT NOT NULL,
         rcount INT,
         answer CHAR(255)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Results Archive Table Created\n"; }
   else { print "Survey Questions Results Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX a_sv2 ON survey_results(survey_id,join_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Results Archive Index1 Index Created\n"; }
   else { print "Survey Results Index1 Index Not Created $DBI::errstr.\n"; }

   $SQL = qq!
      CREATE TABLE a_survey_detail (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         session_id INT NOT NULL,
         question_id INT NOT NULL,
         answer CHAR(255)
      )
	 !;
   if($dbh->do($SQL)) { print "Survey Detail Table Created\n"; }
   else { print "Survey Questions Detail Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX a_svd1 ON a_survey_detail(survey_id,join_id,question_id)";
   if($dbh->do($SQL)) { print "Survey Detail Index1 Index Created\n"; }
   else { print "Survey Detail Index1 Index Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX a_svd2 ON a_survey_detail(session_id)";
   if($dbh->do($SQL)) { print "Survey Detail Index2 Index Created\n"; }
   else { print "Survey Detail Index2 Index Not Created $DBI::errstr.\n"; }

   $SQL = qq!
     CREATE TABLE survey_access (
       survey_id INT NOT NULL,
        ip_number CHAR(15) NOT NULL
     )
   !;

   if($dbh->do($SQL)) { print "Survey Access Table Created\n"; }
   else { print "Survey Access Table Not Created $DBI::errstr.\n"; }

   $SQL = "CREATE INDEX svacc ON survey_access(survey_id,ip_number)";
   if($dbh->do($SQL)) { print "Survey Access Index Index Created\n"; }
   else { print "Survey Access Index Index Not Created $DBI::errstr.\n"; }

}
