#!/usr/local/bin/perl

##############################################################################
# PROGRAM : .htaccess / Directory Protection Manager                         #
# VERSION : 1.00                                                             #
#                                                                            #
# NOTES   :                                                                  #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996 -> 2014                                                 #
#           John C. Cokos, The CCS Network, The Interactive Web              #
#           All Rights Reserved.                                             #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
##############################################################################

BEGIN { push @INC,"."; }
BEGIN { push @INC,".."; }

use vars qw ( %input $action $PROG_URL $OUT $account %list
              $passfile $groupfile $basedir %glist %Tree
              $name $password $group
            );


   %input = &parse_form("input");
   $action = $input{'action'};
   $name=$input{'name'};
   $password=$input{'pass'};
   $group=$input{'group'};

   require("IWeb/data.path");

   open(FILE,"$data_dir/global.config");
      while(<FILE>) {
        chomp;
        ($var,$val)=split(/\=/,$_,2);
        $global{$var}=$val;
      } 
   close(FILE);

   $PROG_URL=$ENV{'SCRIPT_NAME'};

   #load the user Profile
   if(-e "./account.pass") { $account=1; require("./account.pass"); }
   else { $account=0; }

    if ($action eq "newpass") {
        &password_menu;
    }

    elsif ($action eq "savepass") {
        &WritePass;
    }

    elsif ($action eq "cngpass") {
        &password_menu1;
    }

    elsif ($action eq "changepass") {
        &changePass;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "rempass") {
        &password_menu2;
    }

    elsif ($action eq "delpass") {
        &removePass;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "addtogroup") {
        &password_menu3;
    }

    elsif ($action eq "addpgroup") {
        &addtoGroup;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "newgroup") {
        &group_menu;
    }

    elsif ($action eq "makenewgroup") {
        &WriteNewGroup;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "delgroup") {
        &del_group_menu;
    }

    elsif ($action eq "dodelgroup") {
        &LoadGpFile;
        $glist{$input{'group'}}="";    
        &WriteGroupFile;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "delfromgroup") {
        &delfrom_group;
    }

    elsif ($action eq "delfromgp") {
        &del_from_group;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "addaccess") {
        &list_dirs;
    }

    elsif ($action eq "add_access") {
        &WriteAccess;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "delaccess") {
        &list_dirs_del;
    }

    elsif ($action eq "del_access") {
        unlink ("$input{'htfile'}/.htaccess");
        $OUT .= "<h2>DONE</h2>$input{'htfile'}/.htaccess removed\n";
    }

    elsif ($action eq "changeaccess") {
        &list_dirs_htaccess;
    }

    elsif ($action eq "change_access") {
        &WriteAccess;
        $OUT .= "<h2>DONE</h2>\n";
    }

    elsif ($action eq "save_config") {
        &save_config;
        $OUT .= "<h2>Configuration Saved...</h2>\n";
        $OUT .= "You'll need to delete the \"account.pass\" file (located in the same directory \n";
        $OUT .= "as this .cgi) in order to reset or change these values.  Once you've deleted the file, simply\n";
        $OUT .= "reload this program to be prompted to reset them.";
    }

    if(! $account) { &setup_account; }

    &display_menu;

    exit(0);


################################ subs ##############################

sub display_menu {

   print "Content-Type: text/html\n\n";

   print qq!


<HTML><HEAD><TITLE>WEB based Password system</TITLE></HEAD>
<style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3"><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>.htaccess Management</b>
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">

          <TABLE WIDTH="100%" CELLSPACING="0" CELLPADDING="2" >
            <TR>
              <TD VALIGN="TOP">
                <FONT FACE="verdana,arial,helvetica" SIZE=-1>
                <IMG SRC="$global{'button_dir'}/folder.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<B>Groups</B>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=newgroup">Create Group</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=delgroup">Delete Group</A>

                <BR><BR><IMG SRC="$global{'button_dir'}/folder.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<B>Users</B>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=newpass">Add New User</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=addtogroup">Add User to Group</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=cngpass">Change User's Password</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=rempass">Remove a User</A>
                
                <BR><BR><IMG SRC="$global{'button_dir'}/folder.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<B>Protect Directories</B>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=addaccess">Protect a Directory</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=delaccess">Un-Protect a Directory</A>
                <BR><IMG SRC="$global{'button_dir'}/tline.gif" WIDTH=12 HEIGHT=12><IMG SRC="$global{'button_dir'}/openfolder.gif" WIDTH=15 HEIGHT=11>&nbsp;&nbsp;<A HREF="$PROG_URL?action=changeaccess">Change a Directory's Group</A>
                <BR><BR>

              </TD>
              <TD VALIGN="TOP"> 
                 $OUT
              </TD> 
            </TR>
          </TABLE>

                  </FONT>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>

   !;

}



sub list_dirs_htaccess {

   my($key);

   &GetTree;

   $OUT .= "<H2><CENTER>Change Password group</CENTER></H2><BLOCKQUOTE>";
   $OUT .= "<FORM ACTION=\"$PROG_URL\" METHOD=\"post\">\n";
   $OUT .= "Directory to Change:<select name=htfile>\n";

   foreach $key (sort keys(%Tree)) {
     $OUT .=  "$Tree{$key}";
   }
   $OUT .= "\n</select><br>New Password Group for Directory:<select name=group>\n";

   &LoadGpFile;
   foreach $key (sort keys(%glist)) {
     $OUT .= "<option value=\"$key\">$key \n"; 
   }

   $OUT .= qq!
      </select>
      <br>Title for Password Dialog:<input type=text name=title size=40 max=40><br>
      
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="change_access" name=action>
      </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Change Group" TYPE="submit"></CENTER>
      </FORM>
   !;

}

sub list_dirs_del {

   my($key);

   &GetTree;
   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Delete Password Protect </CENTER></H2><P>
      <BLOCKQUOTE>
   !;

   $OUT .= "Directory to remove Password protection:<select name=htfile>\n";
   foreach $key (sort keys(%Tree)) {
     $OUT .= "$Tree{$key}";
   }

   $OUT .= qq!
      </select>
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="del_access" name=action>
      </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Remove Passwords from Directory" TYPE="submit"></CENTER>
      </FORM>
   !;

}

sub list_dirs {

   my($key);

   &GetTree;
   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Password Protect a directory</CENTER></H2>
      <BLOCKQUOTE>
      Directory to Password protect:<select name=htfile>
   !;

   foreach $key (sort keys(%Tree)) {
      $OUT .= "$Tree{$key}";
   }
   $OUT .= "\n</select>\n";
   $OUT .= "<br><b>Note, this .cgi program must have write access in the directory you select in \n";
   $OUT .= "    order to protect it!</b><BR><BR>\n";

   $OUT .= "<br>Password Group for Directory:<select name=group>\n";

   &LoadGpFile;
   foreach $key (sort keys(%glist)) {
     $OUT .= "<option value=\"$key\">$key \n"; 
   }

   $OUT .=qq!
      </select>
      <br>Title for Password Dialog:<input type=text name=title size=40 max=40><br>
      
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="add_access" name=action>
      </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Add Passwords to Directory" TYPE="submit"></CENTER>
      </FORM>
   !;

}


sub group_menu {

   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Create new Group</CENTER></H2>
      <BLOCKQUOTE>
      New Group to Add:<input type=text name=group size=8 max=16>(no spaces)<br>
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="makenewgroup" name=action>
      <BLOCKQUOTE>
      <CENTER><INPUT VALUE="Add Group" TYPE="submit"></CENTER>
      </FORM>
   !;
      
}

sub password_menu3 {

   my($key);

   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Add user to Group</CENTER></H2>
      <BLOCKQUOTE>
      User Name to Add:
   !;

   &LoadPwFile;
   $OUT .= "<select name=name>\n";
   foreach $key (sort keys(%list)) {
       $OUT .= "<option value=\"$key\">$key\n";
   }

   $OUT .= "</select><br>\n";
   $OUT .= "\n group to add the user to:<select name=group>\n";

   &LoadGpFile;
   foreach $key (sort keys(%glist)) {
     $OUT .= "<option value=\"$key\">$key \n"; 
   }

   $OUT .= qq!
      </select><br><input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="addpgroup" name=action>
      <BLOCKQUOTE>
      <CENTER><INPUT VALUE="Add User To Group" TYPE="submit"></CENTER>
      </FORM>
   !;
      
}

sub password_menu2 {

   my($key);

   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Delete user</CENTER></H2>
      <BLOCKQUOTE>
      User Name to Delete:
   !;

   &LoadPwFile;
   $OUT .= "<select name=name>\n";

   foreach $key (sort keys(%list)) {
       $OUT .= "<option value=\"$key\">$key\n";
   }

   $OUT .= qq!
      </select><br>
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="delpass" name=action>
         </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Delete User" TYPE="submit"></CENTER>
      </FORM>
   !;
      
}

sub password_menu1 {

   my($key);

   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Change Password</CENTER></H2>
      <BLOCKQUOTE>
      User Name:
   !;

   &LoadPwFile;

   $OUT .= "<select name=name>\n";

   foreach $key (sort keys(%list)) {
       $OUT .= "<option value=\"$key\">$key\n";
   }

   $OUT .= qq!
       </select><br>
       NEW Password:<input type=text name=pass size=8 max=16>(no spaces)<br>
       <input type=hidden value="$input{'account'}" name=account>
       <input type=hidden value="changepass" name=action>
       </BLOCKQUOTE>
       <CENTER><INPUT VALUE="Change Password" TYPE="submit"></CENTER>
       </FORM>
   !;
      
}


sub password_menu {

    $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Add new User</CENTER></H2>
      <BLOCKQUOTE>
        User Name:<input type=text name=name size=8 max=16>(no spaces)<br>
      Password:<input type=text name=pass size=8 max=16>(no spaces)<br>
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="savepass" name=action>
      </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Add User" TYPE="submit"></CENTER>
      </FORM>
   !;
      
}


sub del_group_menu {

   my($key);

   $OUT .= qq!
      <FORM ACTION="$PROG_URL" METHOD="POST">
      <H2><CENTER>Delete Group</H2><B>Warning</B> this is not Un-doable</CENTER>
      <BLOCKQUOTE>
      Group to delete:<select name=group>
   !;

   &LoadGpFile;
   foreach $key (sort keys(%glist)) {
     $OUT .= "<option value=\"$key\">$key \n"; 
   }

   $OUT .= qq!
      </select>
      <input type=hidden value="$input{'account'}" name=account>
      <input type=hidden value="dodelgroup" name=action>
      </BLOCKQUOTE>
      <CENTER><INPUT VALUE="Delete Group" TYPE="submit"></CENTER>
      </FORM>
   !;
      
}



sub GetTree {

   my (%List,$a,$tmp,$key);

   open(TREE, "find $basedir -type d -print |");
   while (<TREE>) {
      $List{$_} = $_; #one line per element
   }
   close (TREE);


   foreach $key (sort keys(%List)) {
      ($a,$tmp) = split($basedir,$List{$key});
      $tmp =~ s/\s+//g;
      $tmp="/" if(! $tmp);
      chomp($key);
      $Tree{$key}= "<option value=\"$key\">$tmp\n";
   }
   return(0);

}



sub WriteAccess {

   my $outfile="$input{'htfile'}/.htaccess";

   $OUT .= "<h2>Writing HTACCESS entry</H2>$outfile";

   open (INDEX, ">$outfile");
      print INDEX "AuthUserFile $passfile\n";
      print INDEX "AuthGroupFile $groupfile\n";
      print INDEX "AuthName \"$input{'title'}\"\n";
      print INDEX "AuthType Basic\n";

      print INDEX "<Limit GET>\n";
      print INDEX "require group $input{'group'}\n";
      print INDEX "</Limit>\n";
   close (INDEX);
   $OUT .= "<B>Done.</B>";

}


sub addtoGroup {

   &LoadGpFile;
   if ($glist{$group}) {
      $glist{$group}="$name $glist{$group}";
      &WriteGroupFile;
   }
   return(1);
}


sub WriteGroupFile  {

   my($key);

   open(HTGROUP, ">$groupfile");
   foreach $key (sort keys(%glist)) {
     if($glist{$key}) {
          print HTGROUP "$key:$glist{$key}\n";  # print it
     }
   }
   close(HTGROUP);
   return(1);

}


sub LoadGpFile {

   my($gname,$users);

   open(HG, "$groupfile") || open(HG, ">$groupfile");
   while (<HG>) {
        chop;
        ($gname,$users) = split(':',$_);
        $glist{$gname} = $users;
   }
   return(1);

}


sub WriteNewGroup {

   open (GROUP, ">>$groupfile"); #|| $OUT .= "can\'t append .htgroup file";
   print GROUP "$group: x\n";
   close (GROUP);
   return(1);
}


sub MakeNewPassword  {

   my(@saltchars,$salt,$cpw);

   srand($$|time);                                 # random seed
   @saltchars=(a..z,A..Z,0..9,'.','/');            # valid salt chars
   $salt=$saltchars[int(rand($#saltchars+1))];     # first random salt char
   $salt.=$saltchars[int(rand($#saltchars+1))];    # second random salt char
   $cpw = crypt($password,$salt);

   return($cpw);
}


sub changePass {

   &LoadPwFile;

   my $cpass = &MakeNewPassword;

   if ($list{$name}) {
      $list{$name}=$cpass;
      &WriteNewFile;
      return;
   }
   else {
    $OUT .= "<br> This user is not currently in the password file!\n<br> not changed!<p>\n";
   }
   return;

}


sub removePass {

   &LoadPwFile;

   if ($list{$name}) {
      $list{$name}="";
      &WriteNewFile;
      return(1);
   }
   else {
      $OUT .= "<br> This user is not currently in the password file!<br> not removed!<p>\n";
      return(0);
   }
   return;

}


sub LoadPwFile {

   my($tname,$tpw);

   open(HP, "$passfile") || open(HP, ">$passfile");
   while (<HP>) {
     chop;
     ($tname,$tpw) = split(':',$_);
     $list{$tname} = $tpw;
   }
   return(1);

}

sub WriteNewFile {

   my($key);

   open(HTPASSWD, ">$passfile");
   foreach $key (sort keys(%list)) {
      if($list{$key}) {
         print HTPASSWD "$key:$list{$key}\n";  # print it
      } 
   }
   close(HTPASSWD);

   return(1);

}


sub WritePass {

   my ($cpass);

   $OUT .= "<h2>Adding user to  .htpassword</h2>";

   &LoadPwFile;

   $cpass = &MakeNewPassword;

   if ($list{$name}) {
      $OUT .= "<br>USER EXISTS IN PASSWORD FILE!<br>USER NOT ADDED!\n";
      return(0);
   }
   else {
      $list{$name}=$cpass;
      &WriteNewFile;
      return(1);
   }

   $OUT .= "<h2>DONE</h2>\n";

   return;
}


sub setup_account {

   $OUT = qq!
      <center><h3>Account Information not setup</h3></center>
      <form action="$PROG_URL" METHOD="post">
      <blockquote>
         .htpasswd Location: <input name="passfile" value="$passfile"><BR>
          &nbsp;&nbsp;<I>Ex: /home/sites/yourdomain/www/.htpasswd</I><BR><BR>

         .htgroup Location: <input name="groupfile" value="$groupfile"><BR>
          &nbsp;&nbsp;<I>Ex: /home/sites/yourdomain/www/.htgroup</I><BR><BR>

         <B>We recommend that you place these 2 files OUTSIDE your web tree</B>
         <BR><BR>

         Base Directory: <input name="basedir" value="$basedir"><BR>
          &nbsp;&nbsp;<I>Ex: /home/sites/yourdomain/www .. (no trailing "/")</I><BR><BR>

         <B>** Note **</B> These must be the FULL Operating System paths

         <input type="hidden" name="action" value="save_config">
      </blockquote>
      <center><input type="submit" value="Save Configuration"></center>
      </form>
   !;

   $account=0;
}


sub save_config {

   my $passfile=$input{'passfile'};
   my $groupfile=$input{'groupfile'};
   my $basedir=$input{'basedir'};

   open(ACCT,">./account.pass");
      print ACCT "\$passfile = \"$passfile\";\n";
      print ACCT "\$groupfile = \"$groupfile\";\n";
      print ACCT "\$basedir = \"$basedir\";\n";
      print ACCT "1;";
   close(ACCT);

   if(-e "./account.pass") { $account=1; }

}


sub parse_form{

  my $returnval = $_[0];
  my($name,$buffer,$pair,@pairs,$encoded_value,$value,%input,%encoded);

  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  if (length($buffer) < 5) {
     $buffer = $ENV{QUERY_STRING};
  }
  @pairs=split(/&/,$buffer);
  foreach $pair(@pairs) {
     ($name, $value)=split(/=/,$pair);
     $encoded_value = $value;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][A-F0-9])/pack("C",hex($1))/eg;
     if(! $input{$name}) {
	$input{$name} = $value;
	$encoded{$name} = $encoded_value;
     }
     else {
  	$input{$name} = $input{$name}." ".$value;
  	$encoded{$name} = $encoded{$name}." ".$encoded_value;
     }
  }

  if($returnval eq "input") { return %input; }
  if($returnval eq "encoded") { return %encoded; }

}
