#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Bannermaster Signup Program                                      #
# VERSION : 4.08                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

package IWEB;

## These cannot be combined into a single BEGIN, as there are dependencies
## Between them ... this is, and must stay "linear"

## First 2 Begin Blocks Pulls in the iweb.pm file, setting the major globals
BEGIN { 
   use Cwd;
}

BEGIN {
   $directory = cwd;
   $directory =~ s/\/admin//g;
   push @INC,$directory;
   push @INC,"."; 
   push @INC,"..";
}

## Third Begin Block Pulls in the iWeb module if needed and starts logging
BEGIN {
   use IWeb::iweb;
}

## Get the right module for the database in use.
BEGIN {

   IWEB::Read_Config();

   if($global{'DB_Format'} eq "SQL") {
      eval("use IWeb::bm_adminsql");
      IWEB::SQL_Connect();
   }
   else {
      eval("use IWeb::bm_adminascii");
   }
}

use File::Copy;

##############################################################################
# BEGIN OF ACTUAL PROGRAM CODE
##############################################################################

  undef %input;
  undef %bannermaster;

  IWEB::Read_Config();

  IWEB::Read_Language("global");

  %input=IWEB::parse_form("input");

  #### What are we doing ???
  $action = $input{'action'};

   %passcookie= IWEB::split_cookie( $ENV{'HTTP_COOKIE'}, 'admin' );
   $bannermaster{'password'} = $passcookie{'password'};
   if ($bannermaster{'password'} ne $global{'admin_pw'}) { 
       IWEB::iWeb_Header(IWEB::ERROR("Access Denied"));
       IWEB::Quit(); 
   }

  ### If not readonly, or password is ok, do the right thing...
  if ($action eq "admin") { IWEB::bm_admin(); }
  elsif ($action eq "menu")   {IWEB::nav_bar();}

  ## Group Management Stuff
    elsif ($action eq "Define Groups") {IWEB::Define_Groups();}
    elsif ($action eq "Save Groups") {IWEB::Save_Groups();}
    elsif ($action eq "Update Group Record") {IWEB::Update_Group_Record();}
    elsif ($action eq "Group Manager") {IWEB::Group_Manager();}
    elsif ($action eq "Assign Groups") {IWEB::Assign_Groups();}
    elsif ($action eq "Save Assignment") {IWEB::Save_Group_Assignment();}

  ## Account Management Stuff
    elsif ($action eq "Review") {IWEB::Review_Pending();}
    elsif ($action eq "PendingList") {IWEB::List_Pending();}
    elsif ($action eq "Delete Account") {IWEB::Delete_Pending();}

    elsif ($action eq "Edit Campaign") {IWEB::Campaign_Form("Save Campaign Modification");}
    elsif ($action eq "Add Campaign") {IWEB::Campaign_Form("Save New Campaign");}
    elsif ($action eq "Save New Campaign") {IWEB::Save_Campaign(1);}
    elsif ($action eq "Save Campaign Modification") {IWEB::Save_Campaign(0);}
    elsif ($action eq "Save Pending Campaign") {IWEB::Save_Campaign(2);}

    elsif ($action eq "Edit Account") {IWEB::Account_Form("Save Account Modification");}
    elsif ($action eq "Add Account") {IWEB::Account_Form("Save New Account");}
    elsif ($action eq "Save New Account") {IWEB::Save_Account(1);}
    elsif ($action eq "Save Account Modification") {IWEB::Save_Account(0);}
    elsif ($action eq "Account_to_BM") {IWEB::Account_to_BM();}

    elsif ($action eq "List Accounts") {IWEB::List_Accounts();}
    elsif ($action eq "List Campaigns") {IWEB::List_Campaigns();}
    elsif ($action eq "Delete Campaign") {IWEB::Delete_Campaign();}
    elsif ($action eq "DeleteAccount") {IWEB::Delete_Account();}
    elsif ($action eq "Disable") {IWEB::Disable_This_Campaign();}
    elsif ($action eq "Re-Enable") {IWEB::Enable_Campaign();}
    elsif ($action eq "Re-Initialize") {IWEB::Init_Campaign();}
    elsif ($action eq "Cleanup") {IWEB::Cleanup_Old_Clicks();}

    elsif ($action eq "Edit Acceptance Email") { IWEB::Edit_Email(); }
    elsif ($action eq "Save Email") { IWEB::Save_Email(); }

    elsif ($action eq "SE_Groups") { IWEB::SE_Groups(); }

    else { IWEB::iWeb_Header("What?"); }

IWEB::Quit(); 

###########################################################################

sub bm_admin {


   ## Stats
   my($cleanup);

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Get_Grand_Totals();  IWEB::SQL_Group_Option_List(); }
   else { IWEB::Ascii_Get_Grand_Totals(); IWEB::Ascii_Group_Option_List(); }

   if($input{'win'}) { $bannermaster{'float'}="<A HREF=\"javascript:CloseWin()\">Dock</A>"; }
   else { $bannermaster{'float'} = "<A HREF=\"javascript:OpenWin()\">Float</A>"; $bannermaster{'buffer'}="<BR><BR>"; }

   if($global{'DB_Format'} ne "SQL") { $cleanup = qq! <A HREF="$PROG_URL?action=Cleanup" TARGET=\"main\">Cleanup Click Logs</A><BR> !; }
   print "Content-Type: text/html\n\n";
   print qq!

     <HTML><HEAD><TITLE>Bannermaster Admin</TITLE></HEAD>
     <SCRIPT LANGUAGE="javascript">
        function OpenWin() {
           X=window.open("$PROG_URL?action=admin&win=1","X","toolbar=no,scrollbars=auto,directories=no,resizable=yes,menubar=no,width=620,height=250")
        }
        function CloseWin() {
           opener.location.href="$PROG_URL?action=admin";
           self.close();
        }
     </SCRIPT>
     <style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
     <BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
       $bannermaster{'buffer'}
       <CENTER>
         <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH="590"><TR><TD>
         <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
             <TR BGCOLOR="#cccc99">
                <TD WIDTH="140">
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                <B>Bannermaster</B></FONT>
                </TD>
                <TD ALIGN="left" COLSPAN="3">
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                <B>Grand total stats</B>:</FONT> 
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#003366">
                   Imp: $bannermaster{'gt_impressions'} / Clk: $bannermaster{'gt_clicks'} ... <B>$bannermaster{'gt_ratio'}</B>
                </FONT>             
                </TD>
             </TR>
             <TR>
                <TD ROWSPAN=2 BGCOLOR="#cccccc" WIDTH="140" VALIGN="top">
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                <B>BM Help</B></FONT><BR><BR>
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="1" COLOR="#000000">
                &#149; <A HREF="$global{'html_dir'}/bannermaster/" TARGET=\"main\">Help Index</A><BR>
                &#149; <A HREF="$global{'html_dir'}/bannermaster/account_form.html" TARGET=\"main\">Adding accounts</A><BR>
                &#149; <A HREF="$global{'html_dir'}/bannermaster/usage.html" TARGET=\"main\">Usage</A><BR>
                <HR>
                <CENTER>$bannermaster{'float'}</CENTER>
                <HR>
                </TD></FONT>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                <A HREF="$PROG_URL?action=Define+Groups" TARGET=\"main\">Define Groups</A><BR>
                $cleanup 
                </FONT> 
                </TD>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                Accounts: <A HREF="$PROG_URL?action=List+Accounts" TARGET="main">List</A> ... 
                          <A HREF="$PROG_URL?action=Add+Account" TARGET="main">Add</A><BR>

                Campaigns: <A HREF="$PROG_URL?action=List+Campaigns" TARGET="main">List</A> ... 
                          <A HREF="$PROG_URL?action=Add+Campaign" TARGET="main">Add</A><BR><BR>

                <A HREF="$admin_url?action=edit_file&filename=adreport" TARGET=\"main\">Edit Report Template</A>
                </FONT> 
                </TD>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                </TD>
             </TR>
             <TR>
                <TD COLSPAN=2 BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
 	          <FORM ACTION="$PROG_URL" METHOD="POST" TARGET=\"main\">
                    Group Manager
	            <INPUT TYPE="image" SRC="$global{'button_dir'}/go.gif" BORDER=0><BR>
                    <SELECT NAME="group">
                    <OPTION VALUE="default">Default Group
                    $bannermaster{'group_list'}
                    </SELECT>
 	            <INPUT TYPE="hidden" NAME="action" VALUE="Group Manager">
                  </FORM>
                  </FONT>
                </TD>
             </TR>
         </TABLE>
         </TD></TR></TABLE></TABLE>
       </CENTER>
     </BODY>
     
    !;

    IWEB::Quit(); 


}


sub Delete_Campaign {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Delete_Campaign(); }
   else { IWEB::Ascii_Delete_Campaign(); }

   IWEB::List_Campaigns();
   IWEB::Quit();
}

sub Save_Campaign {

   my $newacct = $_[0];

   ## Pending Stuff
   if($newacct == 2) {
       IWEB::Email_Pending();
       IWEB::Delete_Pending();   
   }

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Save_Campaign($newacct); }
   else { IWEB::Ascii_Save_Campaign($newacct); }

   IWEB::iWeb_Header(IWEB::ok_box("OK","Campaign Saved","history.go(-2)"));
   IWEB::Quit(); 

}



sub Delete_Account {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Delete_Account(); }
   else { IWEB::Ascii_Delete_Account(); }

   IWEB::List_Accounts();
   IWEB::Quit(); 
}

sub Save_Account {

   my $newacct = $_[0];
   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Save_Account($newacct); }
   else { IWEB::Ascii_Save_Account($newacct); }

   IWEB::iWeb_Header(IWEB::ok_box("OK","Account Saved","history.go(-2)"));

   IWEB::Quit(); 

}

sub Disable_This_Campaign {

   my $acct_name = $input{'account'};
   open (DIS, ">$data_dir/bannermaster/campaigns/$acct_name.DISABLED");
   close (DIS);

   IWEB::List_Campaigns(); 
  
   IWEB::Quit(); 

}

sub Enable_Campaign {

    my $acct_name = $input{'account'};

    unlink "$data_dir/bannermaster/campaigns/$acct_name.DISABLED";

    IWEB::List_Campaigns(); 

    IWEB::Quit(); 

}


sub List_Pending {

   ## Pending
   $bannermaster{'num_pending'} = 0;
   open(PND,"$data_dir/bannermaster/pending/accounts.temp");
     while(<PND>) {
        chomp;
        $bannermaster{'num_pending'}++;
        $bannermaster{'aname'} = $_;
        $_=IWEB::urlencode($_);
        $bannermaster{'acct_list'} .= "<LI><A HREF=\"$PROG_URL?action=Review&pending_acct=$_\">$bannermaster{'aname'}</A><P>\n";
     }
   close(PND);

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Pending Accounts","","/bannermaster/pending.html");

   print qq!
      <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
      <OL>
         $bannermaster{'acct_list'} 
      </OL>
      </FONT>
   !;

   print IWEB::Admin_Footer();

   IWEB::Quit();

}


sub Update_Group_Record {

    if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Update_Group_Record(); }
    else { IWEB::Ascii_Update_Group_Record(); }

   IWEB::Group_Manager();
}

sub Assign_Groups {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Assign_Groups(); }
   else { IWEB::Ascii_Assign_Groups(); }

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Assign Groups","","/bannermaster/assign_groups.html");

   print qq!

    <FORM ACTION="$PROG_URL" METHOD="post">
      <TABLE BORDER=0><TR><TD>
        <FONT COLOR="maroon"><B>Group Assignments for $input{'account'}...</B></FONT></TD></TR>
        <TR BGCOLOR="#e0e0e0"><TD>
        <PRE>
$bannermaster{'grplisting'}
        </PRE>  
        <INPUT NAME="account" TYPE="hidden" VALUE="$input{'account'}"></CENTER>
        <CENTER><INPUT NAME="action" TYPE="submit" VALUE="Save Assignment"></CENTER>
      </TD></TR></TABLE>
    </FORM>
   !;
  
   print IWEB::Admin_Footer();

   IWEB::Quit(); 

}


sub Save_Group_Assignment {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Save_Group_Assignment(); }
   else { IWEB::Ascii_Save_Group_Assignment(); }

   IWEB::iWeb_Header(IWEB::ok_box("Group Assignment","Group Assignment for $input{'account'} complete","history.go(-2)"));

   IWEB::Quit(); 
}


################################################################################
# Bannermaster Admin Forms
################################################################################

sub Define_Groups {

    if($global{'DB_Format'} eq "SQL") { $bannermaster{'group_list'} = IWEB::SQL_Group_List(); }
    else { $bannermaster{'group_list'} = IWEB::Ascii_Group_List(); }

    print "Content-Type: text/html\n\n";
    print IWEB::Admin_Header("Define Bannermaster Groups","","/bannermaster/define_groups.html");
    print qq!

    <FORM ACTION="$PROG_URL" METHOD="post">
        <FONT COLOR="maroon"><B>Group Listing...</B></FONT>
        <TABLE>
        $bannermaster{'group_list'}
        </TABLE>
        <BR><BR>
        <CENTER>Add New Group: <INPUT NAME="add" NAME=\"group\"><BR><BR>
        <INPUT NAME="action" TYPE="submit" VALUE="Save Groups">

        <BR><BR><CENTER>
          <A HREF="$PROG_URL?action=SE_Groups" TARGET=\"main\">Create Groups from your Search Engine Categories</A>
        </CENTER>
    !;

    print IWEB::Admin_Footer();

    IWEB::Quit();      

}

sub Save_Groups {


    if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Save_Groups(); }
    else { IWEB::Ascii_Save_Groups(); }

    IWEB::Define_Groups();
}

sub Group_Manager {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Get_Group_Data(); }
   else { IWEB::Ascii_Get_Group_Data(); }

   my $account;

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Group Manager: $bannermaster{'group'}","","/bannermaster/groupmgr.html");

       print "<FORM ACTION=\"$PROG_URL\" METHOD=\"post\">\n";
       print "<CENTER><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=80%>\n";
       print "<TR>\n";
       
       $Columns = 0;
       foreach $account( sort keys %accounts ) {
          if($account) {
             print "<TD><FONT COLOR=\"black\">\n";
             ### Now see if it needs to be checked...
             if ($groups{$account}) { 
                   print "<INPUT TYPE=\"checkbox\" NAME=\"account\" VALUE=\"$account\" CHECKED>$account\n";
             }
             else {
                   print "<INPUT TYPE=\"checkbox\" NAME=\"account\" VALUE=\"$account\">$account\n";
             }

             print "</FONT></TD>\n";
             $bannermaster{'Count'}++;
             if ($bannermaster{'Count'} >= 3) { 
                $bannermaster{'Count'} = 0;
                print "</TR><TR BGCOLOR=\"#e0e0e0\">\n"; 
             }
          }
       }
       print "</TD></TR><TR><TD COLSPAN=3>\n";
       print "<INPUT NAME=\"group\" TYPE=\"hidden\" VALUE=\"$bannermaster{'group'}\">\n";
       print "<CENTER><INPUT NAME=\"action\" TYPE=\"submit\" VALUE=\"Update Group Record\">\n";
       print "</TD></TR></TABLE>\n";
       print "</CENTER>\n";

   print IWEB::Admin_Footer();

   IWEB::Quit(); 

}

sub Account_Form {

   my $formaction = @_[0];

   if($global{'DB_Format'} eq "SQL") { 
      IWEB::SQL_Get_Account();
   }
   else { 
      IWEB::Ascii_Get_Account();
   }

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Account","","/bannermaster/account_form.html");

   print qq!

    <FORM ACTION="$PROG_URL" METHOD="post">
    <TABLE BORDER=0 WIDTH=90%>
         <TR><TD>Account Login ID:</TD><TD><INPUT NAME="acct_id" VALUE="$account{'acct_id'}"></TD></TR>
         <TR><TD>Login Password:</TD><TD><INPUT NAME="acct_password" VALUE="$account{'acct_password'}"></TD></TR>

         <TR><TD>Contact Name:</TD><TD><INPUT NAME="contact_name" VALUE="$account{'contact_name'}"></TD></TR>
         <TR><TD>Contact Email:</TD><TD><INPUT NAME="contact_email" VALUE="$account{'contact_email'}"></TD></TR>
         <TR><TD>Address:</TD><TD><INPUT NAME="address" VALUE="$account{'address'}"></TD></TR>
         <TR><TD>City:</TD><TD><INPUT NAME="city" VALUE="$account{'city'}"></TD></TR>
         <TR><TD>State:</TD><TD><INPUT NAME="state" VALUE="$account{'state'}"></TD></TR>
         <TR><TD>Zip:</TD><TD><INPUT NAME="zip" VALUE="$account{'zip'}"></TD></TR>
         <TR><TD>Phone:</TD><TD><INPUT NAME="phone" VALUE="$account{'phone'}"></TD></TR>
         <TR><TD>Fax:</TD><TD><INPUT NAME="fax" VALUE="$account{'fax'}"></TD></TR>
         <TR><TD VALIGN="top">Comments:</TD><TD><TEXTAREA NAME="comments" COLS=30 ROWS=8>$account{'comments'}</TEXTAREA></TD></TR>

         <TR><TD COLSPAN=2><CENTER><INPUT TYPE="submit" VALUE="Save Account Info"></CENTER>
             <INPUT TYPE="hidden" NAME="action" VALUE="$formaction">
         </TD></TR>
     </TABLE>
   !;

   print IWEB::Admin_Footer();

   IWEB::Quit(); 

}


sub List_Accounts {

   my $list;

   if($global{'DB_Format'} eq "SQL") { $list = IWEB::SQL_Get_Account_List(); }
   else { $list = IWEB::Ascii_Get_Account_List(); }

   print "Content-Type: Text/html\n\n";
   print IWEB::Admin_Header("List of Accounts",'','/bannermaster/account_list.html');
   print "<BR><BR>$list<BR><BR>\n";
   print IWEB::Admin_Footer();
   IWEB::Quit();

}


sub List_Campaigns {

   if($global{'DB_Format'} eq "SQL") { $list = IWEB::SQL_Get_Campaign_List(); }
   else { $list = IWEB::Ascii_Get_Campaign_List(); }

    print "Content-Type: text/html\n\n";
    print IWEB::Admin_Header("Campaign Manager","95%","/bannermaster/campaign_list.html");

    print qq!

    <BR>$bannermaster{'message'}<BR>
      <CENTER>
      <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=3 WIDTH=100%>
        <TR>
          <TD><CENTER>Account</CENTER></TD>
          <TD><CENTER>Shown</CENTER></TD>
          <TD><CENTER>Clicked<CENTER></TD>
          <TD><CENTER>Ratio<CENTER></TD>
          <TD><CENTER>Expiration (Current)</CENTER></TD>
          <TD><CENTER>Admin</CENTER></TD>
        </TR>
        $bannermaster{'tablerows'}
      </TABLE>
    !;


    print IWEB::Admin_Footer();

    IWEB::Quit();

}

sub Campaign_Form {

   my $formaction = @_[0];
   my $acctlist;

   if($global{'DB_Format'} eq "SQL") { 
      IWEB::SQL_Get_Campaign() if($formaction !~ "Pending");
      $acctlist = IWEB::SQL_Account_Option_List(); 
   }
   else { 
      IWEB::Ascii_Get_Campaign() if($formaction !~ "Pending");
      $acctlist = IWEB::Ascii_Account_Option_List(); 
   }

   if($account{'banner_type'} eq "TEXT") { 
      $bannermaster{'tchk'}="CHECKED"; 
      $bannermaster{'ichk'}=""; 
   }
   else { 
      $bannermaster{'ichk'}="CHECKED"; 
      $bannermaster{'tchk'}=""; 
   }

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Campaign","","/bannermaster/campaign_form.html");

   print qq!

    <FORM ACTION="$PROG_URL" METHOD="post">
    <TABLE BORDER=0><TR><TD>
        <CENTER><IMG SRC="$account{'banner'}"></CENTER>
        <PRE>
     Campaign Name:   <INPUT NAME="acct_name" VALUE="$account{'acct_name'}">   
     Account:         <SELECT NAME="acct_login">
                      <OPTION VALUE="$account{'acct_login'}" SELECTED>$account{'acct_login'}</OPTION>
                      $acctlist
                      </SELECT>

     Target:         <SELECT NAME="target">
        <OPTION VALUE="$account{'target'}" SELECTED>$account{'target'}
        <OPTION VALUE="NONE">No Target (Current Window/Frame)
        <OPTION VALUE="_top">Top of Current Window
        <OPTION VALUE="_blank">Blank Window (Always a new one)
        <OPTION VALUE="new">New Window (Re-use same)
        </SELECT>

     Redirect URL:   <INPUT NAME="redirect_url" VALUE="$account{'redirect_url'}">
     ALT Text:       <INPUT NAME="alt_text" VALUE="$account{'alt_text'}">
     "Under Text"    <INPUT NAME="under_text" VALUE="$account{'under_text'}">

     <U>Banner Definition</U>
     Please enter the Banner image location
     or HTML to use for a text banner.
     <B>One or the other please...</B>

     Banner Type: <INPUT TYPE="radio" NAME="banner_type" VALUE="IMAGE" $bannermaster{'ichk'}>Image or <INPUT TYPE="radio" NAME="banner_type" VALUE="TEXT" $bannermaster{'tchk'}>Text  

     Banner  :       <INPUT NAME="banner" VALUE="$account{'banner'}">
       Enter the full URL
       here, including the "http://..."

     Text Banner:
     <TEXTAREA NAME="banner_text" ROWS=5 COLS=50 WRAP="virtual">$account{'banner_text'}</TEXTAREA>
     ** Use "CLICK" in your HREF tags ...
        ie: &lt;A HREF="CLICK"&gt;Click Here&lt;/A&gt;
        If you do not do this, we cannot track
        the number of click-throughs

     Size: <INPUT NAME="banner_width" SIZE=3 VALUE="$account{'banner_width'}"> x <INPUT NAME="banner_height" SIZE=3 VALUE="$account{'banner_height'}">
     Enter the size of the banner.  This is necessary
     for BOTH HTML and Image banners.

     <U>Account Paramaters</U>
     Campaign Type:  <SELECT NAME="expiration_type">
        <OPTION SELECTED>$account{'expiration_type'}
        <OPTION VALUE="clicks">Number of Clicks
        <OPTION VALUE="impressions">Number of Impressions
        <OPTION VALUE="date">Time Period
        </SELECT> 

        Max Clicks:       <INPUT NAME="num_clicks" VALUE="$account{'num_clicks'}">

        Max Impressions:  <INPUT NAME="num_impressions" VALUE="$account{'num_impressions'}">

        Date Range:       <INPUT NAME="start_date" SIZE=12 VALUE="$account{'start_date'}"> -> <INPUT NAME="end_date" SIZE=12 VALUE="$account{'end_date'}">
           (Enter in mm/dd/yyyy format)

        </PRE>  
        <CENTER><INPUT TYPE="submit" VALUE="Save Account Info"></CENTER>
        <INPUT TYPE="hidden" NAME="action" VALUE="$formaction">
      </TD></TR></TABLE>
   !;

   print IWEB::Admin_Footer();

    IWEB::Quit(); 

}


sub Review_Pending {

   my @lines;

   open ("ACT", "$data_dir/bannermaster/pending/$input{'pending_acct'}.temp");
      @lines = <ACT>;
   close(ACT);

   $lines[0] =~ s/\n//g;

   ($account{'acct_name'}, 
   $account{'acct_login'}, 
   $account{'acct_password'}, 
   $account{'target'}, 
   $account{'redirect_url'}, 
   $account{'alt_text'}, 
   $account{'under_text'}, 
   $account{'banner_type'}, 
   $account{'banner'}, 
   $account{'banner_width'}, 
   $account{'banner_height'}, 
   $account{'banner_text'}, 
   $account{'expiration_type'}, 
   $account{'num_clicks'}, 
   $account{'num_impressions'}, 
   $account{'start_date'}, 
   $account{'end_date'} ) = split(/\|/,$lines[0]);

  IWEB::Campaign_Form("Save Pending Campaign");

  IWEB::Quit(); 

}


sub Email_Pending {

   $acct_name = $input{'acct_name'};
   $acct_login      = $input{'acct_login'};
   $acct_password      = $input{'acct_password'};

   $subject = "Site Accepted";
   $from = $global{'email'};
   $to = $acct_login;

   open ("MAIL", "$data_dir/bannermaster/bannermaster.send");
      @lines=<MAIL>;
   close(MAIL);
            
   $body = "";
   for $m (0 .. $#lines) {
       $lines[$m] =~ s/\[ACCOUNT\]/$acct_name/g;
       $lines[$m] =~ s/\[LOGIN\]/$acct_login/g;
       $lines[$m] =~ s/\[PASSWORD\]/$acct_password/g;
       $body .= "$lines[$m]";
   }

   IWEB::SendMail($to,$subject,$from,$global{'mail_cmd'},$body);


}


sub Delete_Pending {

   $acct_name = $input{'acct_name'};

   ## Get rid of the record.
   unlink("$data_dir/bannermaster/pending/$acct_name.temp");

   ## Go through the pending list and remove it.

    open ("DAT", "$data_dir/bannermaster/pending/accounts.temp");
         @lines = <DAT>;
    close(DAT);
 
    open(NEW,">$data_dir/bannermaster/pending/accounts.temp");
    for $y (0 .. $#lines) {
       $lines[$y] =~ s/\n//g;
       if ($lines[$y] !~ $acct_name) {
           print NEW "$lines[$y]\n";   
       }
    }
    close(NEW); 


}


###########################################################################
#                 ___         __              _
#                /   |   ____/ / ____ ___    (_) ____
#               / /| |  / __  / / __ `__ \  / / / __ \
#              / ___ | / /_/ / / / / / / / / / / / / / _   _   _
#             /_/  |_| \__,_/ /_/ /_/ /_/ /_/ /_/ /_/ (_) (_) (_)
#
###########################################################################




sub Edit_Email {


  $n='\r\n';
  open(MAIL,"$data_dir/bannermaster/bannermaster.send");
     @lines = <MAIL>;
     for $x(0 .. $#lines) {
        $EMAIL .= $lines[$x];
     }
     $EMAIL =~ s/\cM//g;
  close(MAIL);


  print "Content-type: text/html\n\n";
  print IWEB::Admin_Header("Custom Email","","/bannermaster/email.html");

  print qq!
    <form NAME="head_foot" METHOD="POST" ACTION="$PROG_URL" ENCTYPE="x-www-form-urlencoded">
      <B><U>Custom Email:</B></U><BR>
        <BLOCKQUOTE>
        Enter the Text to be sent in the email that your new members will recieve when you approve their listing. 
        <PRE>
    You can use the following "Special" Variable in your email, 
    to personalize it....

    -- VARIABLE --      -- MEANING --
    ---------------   -----------------------------------------
    [ACCOUNT]           The Account Name for this Member
    [LOGIN]             The Login ID for this Member
    [PASSWORD]          The Password for this Member

        </PRE></BLOCKQUOTE>
      <TEXTAREA NAME="email_text" COLS=65 ROWS=20>$EMAIL</TEXTAREA><BR><HR><BR>

      <CENTER><INPUT TYPE="submit" NAME="action" VALUE="Save Email"></CENTER>

      <BLOCKQUOTE>
      <PRE>
      </PRE>
      </BLOCKQUOTE>
    </FORM>

  !;

   print IWEB::Admin_Footer();

   IWEB::Quit(); 


}



sub Save_Email {

    $EMAIL = $input{'email_text'};
    $HEADER =~ s/\cM//g;

    open(MAIL,">$data_dir/bannermaster/bannermaster.send");
       print MAIL "$EMAIL";
    close(MAIL);

    print IWEB::iWeb_Header(IWEB::ok_box("OK","Your custom email has been saved","history.go(-2)"));

    IWEB::Quit(); 

}

sub Init_Campaign {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Init_Campaign(); }
   else { IWEB::Ascii_Init_Campaign(); }

   IWEB::List_Campaigns();

}

sub SE_Groups {

   my $created = IWEB::Create_Hyperseek_Banner_Groups();

   print "Content-Type: text/html\n\n";
   print IWEB::Admin_Header("Banner Groups Created");
   print $created;
   print IWEB::Admin_Footer();

   IWEB::Quit();

}


sub Cleanup_Old_Clicks {

    print "Content-Type: text/html\n\n";
    print "Bannermaster Cleanup...<BR><BR>n";

    opendir(FILES, "$data_dir/bannermaster/rotation/");
    while($bannermaster{'file'} = readdir(FILES)) {
      if($bannermaster{'file'} =~ /\.*\.click/) {
           $bannermaster{'filename'} = "$data_dir/bannermaster/rotation/$bannermaster{'file'}";
           my ($dev,$ino,$mode,$nlink,$uid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat("$bannermaster{'filename'}");
           $mtime = $^T - $ctime;
           $bannermaster{'hours'} = int($mtime / 3600);
           if($bannermaster{'hours'} >= 2) {
              print "Deleting: $bannermaster{'filename'} ($bannermaster{'hours'} hours old).<BR>\n";
              unlink $bannermaster{'filename'};
           }
      }
    }
    closedir(FILES);

    IWEB::Quit(); 


}


sub Account_to_BM {


   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Account_to_BM(); }
   else { IWEB::Ascii_Account_to_BM(); }

}
