##############################################################################
# PROGRAM : CGI Programmers Toolkit                                          #
# VERSION : 3.15                                                             #
#                                                                            #
##############################################################################
#    ____      ____      ______                                              #
#   /\  _`\   /\  _`\   /\__  _\                                             #
#   \ \ \/\_\ \ \ \L\_\ \/_/\ \/                                             #
#    \ \ \/_/_ \ \ \L_L    \ \ \                                             #
#     \ \ \L\ \ \ \ \/, \   \_\ \__                                          #
#      \ \____/  \ \____/   /\_____\                                         #
#       \/___/    \/___/    \/_____/                                         #
#                                                                            #
#    ______                    ___     __              __                    #
#   /\__  _\                  /\_ \   /\ \        __  /\ \__                 #
#   \/_/\ \/     ___      ___ \//\ \  \ \ \/'\   /\_\ \ \ ,_\                #
#      \ \ \    / __`\   / __`\ \ \ \  \ \ , <   \/\ \ \ \ \/                #
#       \ \ \  /\ \L\ \ /\ \L\ \ \_\ \_ \ \ \\`\  \ \ \ \ \ \_               #
#        \ \_\ \ \____/ \ \____/ /\____\ \ \_\ \_\ \ \_\ \ \__\              #
#         \/_/  \/___/   \/___/  \/____/  \/_/\/_/  \/_/  \/__/              #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw( urlencode lock unlock parse_form split_cookie split_sub_cookie 
                 join_cookie Cookie_Date SendMail ERROR ok_box Long_Date Short_Date 
                 US_Date US_Date_and_Time REFERER Not_Alpha Make_Alpha Remove_Non_Alpha
                 Not_Valid_Email Not_Valid_URL Remove_HTML_Tags Spelling_Errors
                 Bad_Words_Present Invalid_IP ccs_js_array Browsersniff ns_ver randomize_array
                 Encrypt Decrypt EKey generate_password
               );

sub urlencode {

   my($toencode) = $_[0];

   $toencode =~ s/([^a-zA-Z0-9_\-.])/uc sprintf("%%%02x",ord($1))/eg;
   return $toencode;
}



# Search for the lockfile and block until it dissapears
sub lock {

    my $LOCKFILE = $_[0] || "LOCKIT";
    my $LOCKDIR = "$data_dir/locks";
    my $LOCK_PATH = "$LOCKDIR/$LOCKFILE.lck";
    my $time = time;

    my($opened,$how_long,$SLEEP_COUNT);
    undef $opened;
    undef $how_long;
    undef $SLEEP_COUNT;

    open(LCK,$LOCK_PATH);
      while(<LCK>) { $opened = $_; last; }
    close(LCK);
        
    $how_long = $time-$opened;

    ## Unless the lock file is a minute old...##
    if ($how_long <= 60) {
        while (-e "$LOCK_PATH" || $how_long >= 60) {
           $SLEEP_COUNT++;
           sleep 1;
           if ($SLEEP_COUNT == 15) {
               $! = "Persistent lock file $LOCK_PATH exists.";
               return 0;
           }
        }
    }

    open (LOCK, "> $LOCK_PATH") || return 0;
       print LOCK $time;
    close (LOCK);

    return(1);
}

# Kill the lock file
sub unlock {

   my $LOCKFILE = $_[0] || "LOCKIT";
   my $PID = $$;
   my $LOCKDIR = "$data_dir/locks";
   my $LOCK_PATH = "$LOCKDIR/$LOCKFILE.lck";

   return (unlink $LOCK_PATH);
}






##############################################################################
#                    ____                      _
#                   / __ \ ____ _ _____ _____ (_)____   ____ _
#                  / /_/ // __ `// ___// ___// // __ \ / __ `/
#                 / ____// /_/ // /   (__  )/ // / / // /_/ /
#                /_/     \__,_//_/   /____//_//_/ /_/ \__, /
#                                                    /____/
#
##############################################################################
sub parse_form{

  my $returnval = $_[0];
  my($name,$buffer,$pair,@pairs,$encoded_value,$value,%input,%encoded);

  if ($ARGV[0] =~ /^\?(.*)/) { $ENV{'QUERY_STRING'} = $1; }

  $buffer='';
  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  if (length($buffer) < 5) {
     $buffer = $ENV{'QUERY_STRING'};
  }
  else { $ENV{'QUERY_STRING'}=$buffer; }
  @pairs=split(/&/,$buffer);
  foreach $pair(@pairs) {
     ($name, $value)=split(/=/,$pair);
     $encoded_value = $value;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][A-F0-9])/pack("C",hex($1))/eg;
     $name =~ tr/+/ /;
     $name =~ s/%([a-fA-F0-9][A-F0-9])/pack("C",hex($1))/eg;
     if(! $input{$name}) {
	$input{$name} = $value;
	$encoded{$name} = $encoded_value;
     }
     else {
  	$input{$name} = $input{$name}." ".$value;
  	$encoded{$name} = $encoded{$name}." ".$encoded_value;
     }
  }

  if($returnval eq "input") { return %input; }
  if($returnval eq "encoded") { return %encoded; }

}


##############################################################################
#                    ______               __    _
#                   / ____/____   ____   / /__ (_)___   _____
#                  / /    / __ \ / __ \ / //_// // _ \ / ___/
#                 / /___ / /_/ // /_/ // ,<  / //  __/(__  )
#                 \____/ \____/ \____//_/|_|/_/ \___//____/
#
##############################################################################

   ## Sample code to set a cookie....
   ## Note: separate cookie values with a ":"
   #  $newcookie= "voted\~Yes:iscool\~No";
   #  print "Set-Cookie: COOKIENAME=$newcookie;";
   #  print " expires=", &Cookie_Date( time + 31536000 , 1 ), "; path=/\n";

   ## Sample code to get a cookie
   #  %bbscookie= &split_cookie( $ENV{ 'HTTP_COOKIE' }, 'COOKIENAME' );
   #  $bbscookie{'voted'} and $bbscookie{'cool'} are the values...

sub split_cookie {

   # put cookie into array
   my( $incookie, $tag )= @_;
   my( %cookie,$tester,@temp,$temp,$temp2 );

   $tester= $incookie;
   @temp = split( /; /, $incookie );
   foreach ( @temp ) {
      ( $temp, $temp2 )= split( /=/ );
      $cookie{$temp}= $temp2;
   }
   return IWEB::split_sub_cookie( $cookie{$tag} );
}

sub split_sub_cookie {
   my( $cookie )= @_;
   my( %newcookie,@temp,$temp,$temp2 );
   @temp = split( /\|/, $cookie );
   foreach ( @temp ) {
      ( $temp, $temp2 )= split( /~/ );
      $newcookie{ $temp }= $temp2;
   }
   return %newcookie;
}

sub join_cookie {
   my( %set )= @_;
   my( $newcookie, $key );
   foreach $key( keys %set ) {
      $newcookie.= "$key\~$set{ $key }:";
   }
   return $newcookie;
}

sub Cookie_Date {

   my( $time, $format )= @_;

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= localtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);

   $mday = "0$mday" if ($mday < 10);

   $year = $year + 1900;

   my( @months )= ( "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );

   my( @weekday )=( "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" );

   my $month = $months[$mon];                                            
                                                                      
   return "$weekday[$wday], $mday-$month-$year $hour\:$min\:$sec GMT";

}

sub SendMail {

   my $COMMAND=$_[3];

   my $log;

   if($COMMAND =~ /smtp/i) { $log = IWEB::SM_TCPIP(@_); }
   else { $log = IWEB::SM_Normal(@_); }

   # print "Sendmail Log: $log\n";

}

sub SM_Normal {

   my($TO,@TO,$SUBJECT,$REPLYTO,$COMMAND,$THEMESSAGE,$returnval);       

   $TO=$_[0];  @TO=split('\0',$TO);
   $SUBJECT=$_[1];
   $REPLYTO=$_[2];
   $COMMAND=$_[3];
   $THEMESSAGE = $_[4];

   my $log =  "Sending via standard means: $TO, $SUBJECT, $REPLYTO, $COMMAND<BR>\n";
      open (SENDMAIL, "| $COMMAND") || die IWEB::ERROR("Sending of mail failed");
         print SENDMAIL "To: $TO\n";
         print SENDMAIL "From: $REPLYTO\n";
         print SENDMAIL "Subject: $SUBJECT\n";
         print SENDMAIL "$THEMESSAGE\n";
      close SENDMAIL;

   return $log;

}

##############################################
# SUB: Send E-mail  (using tcp/ip)
#
# Takes:
# (To, Subject, From, IP ADDRESS of SMTP host, Message)

sub SM_TCPIP {

   my($TO,@TO,$SUBJECT,$REPLYTO,$REMOTE,$THEMESSAGE);
   my($sockaddr,$a);

   use Socket;
   use FileHandle();

   $TO=$_[0];
   $SUBJECT=$_[1];
   $REPLYTO=$_[2];
   $REMOTE = $_[3];
   $THEMESSAGE = $_[4];

   my $CRLF = "\n";

   my @str = split(/\:/,$REMOTE);
   $REMOTE = $str[1];

   my $log = "Sending via $REMOTE\n";

   my $addr = $REMOTE;
   my $port = 25;

   my $proto = getprotobyname ('tcp');
   my $iaddr = inet_aton($addr);
   my $paddr = sockaddr_in($port, $iaddr);

   my $s = FileHandle::new('FileHandle');

    my($oldfh) = select($s); $| = 1; select($oldfh);

    socket($s, PF_INET, SOCK_STREAM, $proto);
    connect($s, $paddr);

    print $s "helo localhost$CRLF";
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like 'helo localhost' ($_)\n  "; }    
    $log .= "Hello: $_\n  ";

    print $s "mail from: <$REPLYTO>$CRLF";
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like 'mail from: $from' ($_)\n  ;" }
    $log .= "Mail from $REPLYTO: $_\n  ";

    print $s "rcpt to: <$TO>$CRLF";
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like 'rcpt to: $_'' ($_)\n  "; }
    $log .= "rcpt to: <$TO>$CRLF $_\n  ";

    print $s "data$CRLF";
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like message: $_'' ($_)\n  "; }
    $log .= "Start Data Stream: $_\n  ";

    print $s "To: $TO$CRLF";
    print $s "From: $REPLYTO$CRLF";
    print $s "Subject: $SUBJECT$CRLF$CRLF";
    print $s $THEMESSAGE;
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like message: $_'' ($_)\n  "; }
    $log .= "Sending ($THEMESSAGE): $_\n  ";

    print $s $CRLF, '.', $CRLF;
    $_ = <$s>; if (/^[45]/) { close $s; chomp; $log .= "Mailer ($$): Didn't like end of msg ($_)\n  "; }

    print $s "quit", $CRLF;
    $log .= "Quit: $_\n  ";

    close $s;

    $log =~ s/\</\&lt;/g;
    $log =~ s/\>/\&gt;/g;
    $log =~ s/\n/\<BR\>/g;
    $log = "<HR>Done:<BR>$log<HR>";

    return ($log);

}



sub ERROR {

   my($ERROR_MESSAGE) = $_[0];
   my($CONTENT) ;       

   if(-e "$data_dir/templates/error.txt") {
     open(ERR,"$data_dir/templates/error.txt");
       while(<ERR>) { $CONTENT .= $_; }
     close(ERR);
   }

   else {

     $CONTENT = qq^
<HTML>
<HEAD>
  <TITLE>CGI Error</TITLE>
</HEAD>
<BODY BGCOLOR=\"white\">
   <CENTER>
   <BR><BR><BR>
   <TABLE BORDER=2 CELLSPACING=0 CELLPADDING=0 WIDTH=300>
     <TR><TD WIDTH=300> 

       <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
          <TR><TD> 
            <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
               <TR BGCOLOR="red"><TD> 
               <FONT FACE="Arial,Helvetica" COLOR="black" SIZE=+1>Unexpected Error.
            </TD><TR></TABLE>
          </TD></TR>

          <TR><TD> 
            <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%"><TR BGCOLOR="silver"><TD> 
              <FONT COLOR="maroon">
              <BR><B>
              <!-- ERROR -->
              </B><BR><BR><I>
              <CENTER><A HREF="javascript:history.go(-1)">Return to Previous Screen</A></I></CENTER></FONT><BR><BR>
            </TD><TR></TABLE>

        </TD><TR></TABLE>
    </TD><TR></TABLE>
</BODY>
</HTML>
      ^;

   }

      $CONTENT =~ s/(<!-- ERROR -->)/$ERROR_MESSAGE<BR>/g; 

   return($CONTENT);


}






##############################################################################
#                          ____   __ __
#                         / __ \ / //_/
#                        / / / // ,<
#                       / /_/ // /| | _  _  _  _
#                       \____//_/ |_|(_)(_)(_)(_)
#
##############################################################################
sub ok_box {

   my($t) = $_[0];
   my($m) = $_[1];
   my($c) = $_[2];
   my($CONTENT) ;       

   $CONTENT = qq!
<HTML>
<HEAD>
  <TITLE>$t</TITLE>
</HEAD>
<BODY BGCOLOR="white">
  <FORM><CENTER>
        <TABLE BORDER=2 CELLSPACING=0 CELLPADDING=0 WIDTH=300>
          <TR><TD WIDTH=300> 

        <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
          <TR><TD> 
            <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
               <TR BGCOLOR="$global{'title_color'}"><TD> 
               <FONT FACE="Arial,Helvitica" COLOR="$global{'ttxt_color'}" SIZE=+1>$t
            </TD><TR></TABLE>
          </TD></TR>

          <TR><TD> 
            <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%"><TR BGCOLOR="$global{'win_color'}"><TD> 
              <FONT FACE="Arial,Helvitica" COLOR="$global{'text_color'}" SIZE=-1>
              $m
              <CENTER>
                <BR><BR>
                <INPUT TYPE="button" NAME="b_ok" VALUE=" -  OK  - " onClick="$c"></CENTER>
            </TD><TR></TABLE>

        </TD><TR></TABLE>
   </TD><TR></TABLE></FORM>
</BODY>
</HTML>
   !;

   return($CONTENT);


}


sub Long_Date {

   my($time) = shift;

   $time = time if(! int($time));

   if($global{'gmt_offset'} ne '') {
       $factor = $global{'gmt_offset'};
       $factor =~ s/\-//g;
       $factor =~ s/\+//g;
       if($global{'gmt_offset'} < 0) { $time = $time - (3600 * $factor); } 
       if($global{'gmt_offset'} > 0) { $time = $time + (3600 * $factor); } 
   }

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= gmtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);
   $mon = "0$mon" if ($mon < 10);
   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);
   my( @months )= ( "$language{'january'}", "$language{'february'}", "$language{'march'}", "$language{'april'}", 
                    "$language{'may'}", "$language{'june'}", "$language{'july'}", "$language{'august'}", 
                    "$language{'september'}", "$language{'october'}", "$language{'november'}", "$language{'december'}" );

   my( @weekday )=( "$language{'monday'}", "$language{'tuesday'}", "$language{'wednesday'}",
                    "$language{'thursday'}", "$language{'friday'}", "$language{'saturday'}", "$language{'sunday'}" );

   $year += 1900;
   return "$weekday[$wday -1] $months[$month -1] $mday, $year $hour\:$min";

}


sub Short_Date {

   my($time) = @_;
   my($factor);
   $time = time if(! int($time));

   if($global{'gmt_offset'} ne '') {
       $factor = $global{'gmt_offset'};
       $factor =~ s/\-//g;
       $factor =~ s/\+//g;
       if($global{'gmt_offset'} < 0) { $time = $time - (3600 * $factor); } 
       if($global{'gmt_offset'} > 0) { $time = $time + (3600 * $factor); } 
   }

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= gmtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);
   $mon = "0$mon" if ($mon < 10);
   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);
   my( @months )= ( "$language{'january'}", "$language{'february'}", "$language{'march'}", "$language{'april'}", 
                    "$language{'may'}", "$language{'june'}", "$language{'july'}", "$language{'august'}", 
                    "$language{'september'}", "$language{'october'}", "$language{'november'}", "$language{'december'}" );

   my( @weekday )=( "$language{'monday'}", "$language{'tuesday'}", "$language{'wednesday'}",
                    "$language{'thursday'}", "$language{'friday'}", "$language{'saturday'}", "$language{'sunday'}" );


   $year += 1900;
   return "$weekday[$wday -1] $months[$month -1] $mday, $year";

}

sub Euro_Date {

   my($time) = @_;
   my($factor);
   $time = time if(! int($time));

   if($global{'gmt_offset'} ne '') {
       $factor = $global{'gmt_offset'};
       $factor =~ s/\-//g;
       $factor =~ s/\+//g;
       if($global{'gmt_offset'} < 0) { $time = $time - (3600 * $factor); } 
       if($global{'gmt_offset'} > 0) { $time = $time + (3600 * $factor); } 
   }

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= gmtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);
   $mon = "0$mon" if ($mon < 10);
   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);
   my( @months )= ( "$language{'january'}", "$language{'february'}", "$language{'march'}", "$language{'april'}", 
                    "$language{'may'}", "$language{'june'}", "$language{'july'}", "$language{'august'}", 
                    "$language{'september'}", "$language{'october'}", "$language{'november'}", "$language{'december'}" );

   my( @weekday )=( "$language{'monday'}", "$language{'tuesday'}", "$language{'wednesday'}",
                    "$language{'thursday'}", "$language{'friday'}", "$language{'saturday'}", "$language{'sunday'}" );


   $year += 1900;
   return "$mday $months[$month -1], $year";

}



sub US_Date {

   my($time) = @_;
   $time = time if(! int($time));

   if($global{'gmt_offset'} ne '') {
       $factor = $global{'gmt_offset'};
       $factor =~ s/\-//g;
       $factor =~ s/\+//g;
       if($global{'gmt_offset'} < 0) { $time = $time - (3600 * $factor); } 
       if($global{'gmt_offset'} > 0) { $time = $time + (3600 * $factor); } 
   }

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= gmtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);
   $mon = "0$mon" if ($mon < 10);
   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);

   $year += 1900;
   return "$month/$mday/$year";

}

sub US_Date_and_Time {

   my($time) = @_;
   $time = time if(! int($time));

   if($global{'gmt_offset'} ne '') {
       $factor = $global{'gmt_offset'};
       $factor =~ s/\-//g;
       $factor =~ s/\+//g;
       if($global{'gmt_offset'} < 0) { $time = $time - (3600 * $factor); } 
       if($global{'gmt_offset'} > 0) { $time = $time + (3600 * $factor); } 
   }

   my( $sec, $min, $hour, $mday, $mon, $year,
          $wday, $yday, $isdst )= gmtime( $time );

   $sec = "0$sec" if ($sec < 10);
   $min = "0$min" if ($min < 10);
   $hour = "0$hour" if ($hour < 10);
   $mon = "0$mon" if ($mon < 10);
   $mday = "0$mday" if ($mday < 10);

   my( $month )= ($mon + 1);

   $year += 1900;
   return "$month/$mday/$year \@ $hour\:$min ";

}

sub REFERER {
   return $ENV{'HTTP_REFERER'};
}

sub Not_Alpha {

  ## This returns "1 or True if the string FAILS ....
  ## Example:  if ( &Not_Alpha($some_text) ) { &ERROR_PAGE; }

  my($string_to_check) = $_[0];

  if ($string_to_check =~ tr/;<>*|`&$!#()[]{}:"\///) { return(1); }
  else { return(0); }


}

sub Make_Alpha {

  ## This returns a reformatted string
  ## Example:  $mystring = &Make_Alpha($mystring);

  my($string_to_change) = $_[0];

  ## Accent Removal for builder ##
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//a/g;
     $string_to_change =~ s//c/g;
     $string_to_change =~ s//e/g;
     $string_to_change =~ s//e/g;
     $string_to_change =~ s//e/g;
     $string_to_change =~ s//e/g;
     $string_to_change =~ s//i/g;
     $string_to_change =~ s//i/g;
     $string_to_change =~ s//i/g;
     $string_to_change =~ s//i/g;
     $string_to_change =~ s//o/g;
     $string_to_change =~ s//n/g;
     $string_to_change =~ s//o/g;
     $string_to_change =~ s//o/g;
     $string_to_change =~ s//o/g;
     $string_to_change =~ s//o/g;

  $string_to_change =~ tr/a-zA-Z0-9/_/cs;
  $string_to_change =~ s/ /_/g;


  return $string_to_change;
}

sub Remove_Non_Alpha {

  ## This returns a reformatted string
  ## Example:  $mystring = &Remove_Non_Alpha($mystring);

  my($string_to_change) = $_[0];

  # $string_to_change =~ tr/a-zA-Z0-9+$/ /c;

  my $allowed = $language{allowed_chars};
     $allowed =~ s/\./\\\./g;

  my $compare = "a-zA-Z0-9$allowed";
  $_ = $string_to_change;
  eval "tr/$compare/ /c";

  return $_;
}

sub Not_Valid_Email {

    ## This returns "1 or True if the address FAILS ....
    ## Example:  if ( &Not_Valid_Email($some_address) ) { &ERROR_PAGE; }
    ## Note that the basis of this function is copyright Matthew M. Wright
    ##      we merely changed the return order and the variable names.

    my($email_address_to_check) = $_[0];

    if ($email_address_to_check =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/ || 
        ($email_address_to_check !~ /^.+\@localhost$/ && 
         $email_address_to_check !~ /^.+\@\[?(\w|[-.])+\.[a-zA-Z]{2,3}|[0-9]{1,3}\]?$/)) {
        return(1);
    }

    else {
        return(0);
    }

}


sub Not_Valid_URL {

  
   ## This returns "1 or True if the address FAILS ....
   ## Example:  if ( &Not_Valid_URL($some_url) ) { &ERROR_PAGE; }

   my($url_to_check) = $_[0];

   if ($url_to_check !~ /^mailto:.*\@\S+\./ && $url_to_check !~ /^news:/ && $url_to_check !~ /^(f|ht)tp:\/\/\S+\.\S+/  && $url_to_check !~ /^https:\/\/\S+\.\S+/) { return(1); }
   else { return(0); }

}


sub Remove_HTML_Tags {

   my($string_to_modify) = $_[0];
   
   $string_to_modify =~ s/<[^>]+>//ig;
   return($string_to_modify);


}



sub Spelling_Errors  {

   ## Paramaters: String to check, path to dictionary ( no trailing slash )
   ## This returns "1 or True if there are spelling errors...
   ## And always returns $Spelling_Error_Message Global Variable which contains
   ## informative text about the spelling errors, warnings, and status.
   ## Example:  if ( &Spelling_Errors($text_string,"./data/dictionary") ) { &ERROR("$Spelling_Error_Message"); }

   my($d) = $_[0];
   my($dictionary) = $_[1];
   my($word,$firstchar,%bad,$badwords,$msg);       
   $d=~tr/A-Z/a-z/;
   $d=~tr/a-z/ /cs;


   foreach $word(split(/\s+/,$d)) {
     $firstchar = substr($word,0,1);
     open(DICT,"$dictionary/$firstchar");
       while(<DICT>) {
          if($_ !~ /$word/) { $badwords++; $bad{$word}++; }
       }
     close(DICT);
   }

   
   if($badwords) { 
         $msg = "<BR><B>Spelling Error(s) found...<BR>The following words seem to be spelled incorrectly:<BR><BLOCKQUOTE>"; 
         foreach $word(sort keys %bad) { $msg .= "$word<BR>"; }
         $msg .= "</BLOCKQUOTE>\n";
   }
   else { $badwords = 0; $msg = "OK"; }

   return ($badwords,$msg);
}


sub Bad_Words_Present {

   ## Paramaters: String to check, path to badwords file
   ## This returns "1 or True if there are spelling errors...
   ## And always creates $Bad_Word_Message Global Variable which contains
   ## informative text about the spelling errors, warnings, and status.
   ## Example:  if ( &Bad_Words_Present($text_string, "./data/badwords.txt") ) { &ERROR("$Bad_Words_Message"); }

   my($d) = $_[0];
   my($bw_file) = $_[1];
   my($word,$badwords,%bad,%list,$msg,$me);       

   $d=~tr/A-Z/a-z/;
   $d=~tr/a-z/ /cs;

   open(BAD,"$bw_file");
       while(<BAD>) {
          chomp;
          $list{$_}++;
       }
   close(BAD);

   foreach $word(split(/\s+/,$d)) {
      if($list{$word}) { $badwords++; $bad{$word}++; }
   }

   if($badwords) {
      $msg = "The following unpermitted words were found:<BR><BLOCKQUOTE>\n";
      foreach $word(keys %bad) { $msg .= "$word<BR>\n"; }
      $msg .= "</BLOCKQUOTE>\n";
   }

   return ($badwords,$msg);
}


sub Invalid_IP {


   ## Paramaters: Comma separated list if valid IPs (a single string...)
   ## This returns "1 or True if the test fails
   ## Example:  
   ##
   ## $my_ip_list = "128.0.0.1,localhost,my_compuer";
   ## if ( &Invalid_IP($my_ip_list) ) { &ERROR("Invalid IP"); }

    my($param) = $_[0];
    my(@referers) = split(/\,/,$param);
    my($valid) = 1;
    my($referer);       

    if ($ENV{'HTTP_REFERER'}) {
        foreach $referer (@referers) {
            if ($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$referer|i) {
                $valid = 0;
                last;
            }
        }
    }
    else {
        $valid = 0;
    }

    
    return($valid);
}


##############################################################################
sub ccs_js_array{

   my $out;       

   $out .= "function MakeArray(n) {\n";
   $out .= "    this.length = n;\n";
   $out .= "    for (var k = 1;k <= n; k++)\n";
   $out .= "        this[k] = null;\n";
   $out .= "} \n\n";

   return($out);

}


##############################################################################
## Better Browser Detection
##############################################################################
# Copyleft 1997, Jason Costomiris <jcostom@sjis.com>
# $CGI::MozSniff::VERSION = '0.07';
# We've taken the CGI::MozSniff and ported to fit the needs of this toolkit.
# All credit for the this code goes to Jason.

# Call it like this: ($Browser,$Version)=&Browsersniff;
# Returns the following:
# Browser Name (all caps): NETSCAPE,OPERA,MSIE,or OTHER
# Version Number (as a decimal): 4.01, etc.

sub Browsersniff {

	my $ua = $ENV{HTTP_USER_AGENT};
        my($i);       
	$ua ||= shift;
	if ($ua =~ /Mozilla/) {
		my $ver = IWEB::ns_ver($ua);
		if ($ver >= 4) {
			if ($ua =~ /MSIE/) {
				my $navtype = $ua;
				$navtype =~ s/.*\(//;
				$navtype =~ s/\).*//;
				my @nav = split(/;/, $navtype);
				for ($i = 0 ; $i<=$#nav ; $i++){
					$nav[$i] =~ s/^\s//;
					$nav[$i] =~ s/\s$//;
				}
				my $msie = $nav[1];
				$msie =~ s/^MSIE //;
				return("MSIE",$msie);
			}
			return("NETSCAPE",$ver);
		} elsif ($ver >= 3) {
			if ($ua =~ /Opera/) {
				my $navtype = $ua;
				$navtype =~ s/.*\(//;
				$navtype =~ s/\).*//;
				my @nav = split(/;/, $navtype);
				for ($i = 0 ; $i<=$#nav ; $i++){
					$nav[$i] =~ s/^\s//;
					$nav[$i] =~ s/\s$//;
				}
				$_ = $nav[1];
				/Opera\//;
				my $opera = $';
				return("OPERA",$opera);
			} else {
				return("NETSCAPE",$ver);
			}
		} elsif ($ver >= 2) {
			if ($ua =~ /MSIE/) {
				my $navtype = $ua;
				$navtype =~ s/.*\(//;
				$navtype =~ s/\).*//;
				my @nav = split(/;/, $navtype);
				for ($i = 0 ; $i<=$#nav ; $i++){
					$nav[$i] =~ s/^\s//;
					$nav[$i] =~ s/\s$//;
				}
				my $msie = $nav[1];
				$msie =~ s/^MSIE //;
				if ($ua =~ /AOL/) {
					return("AOLMSIE",$msie);
				} else {
					return("MSIE",$msie);
				}
			} else {
				return("NETSCAPE",$ver);
			}
		}
	} else {
		# Yeesh.  I need to get some other browsers in here.
		return("OTHER","1");
	}
		
}

sub ns_ver {
	# Internal sub to rip out the Mozilla version number.
	my $ver = shift;
	$ver =~ s/Mozilla\///;
	$ver =~ s/\s.*//;
	return($ver);
}


sub randomize_array {

    ## Called like this: &randomize_array(\@array);
    srand(time);

    my @array = @_;
    my $i;       
    for ($i = $#array+1; --$i;) {
      my $j = int rand($i+1);
      next if $i == $j;
      @array[$i,$j]=@array[$j,$i];
    }

    return @array;

}


### Encryption Routines used with permission from Matt Wright
### and Craig Patchett, from the book: CGI/Perl Cookbook
### Buy it !!

sub Encrypt {

    my($text, $key) = @_;
    my($response) = '';
    my($i, $j, $num, $result);

    $key = "hyperseek2000";
    
    # Save the string lengths to speed things up slightly
    
    my($text_len) = length($text);
    my($key_len) = length($key);
    
    # Process each character in $string
    
    for ($i = 0; $i < $text_len; ++$i) {
    
        # Convert the character to ASCII, offset from space
        
        $num = ord(chop($text)) - 32;
        
        # If $key is longer than $string, stack characters
        
        for ($j = $i; $j < $key_len; $j += $text_len) {
            
            # Offset the original character by the key character and key length
            
            $num += ord(substr($key, $j, 1)) + $key_len;
        }
        
        # Bring it back into the printable ASCII range
        
        $num = $num % 95 + 32;
        
        # Convert :,",' where appropriate
        if ($num == 58) { $num = 127 };
        if ($num == 34) { $num = 128 };
        if ($num == 39) { $num = 31 };
        
        # Convert it to an ASCII character
        
        $result .= pack("c", $num);
    }
    
    # Return the result
    
    return($result);
}


sub Decrypt {
    my($text, $key) = @_;
    my($response) = '';
    my($i, $j, $num, $result);
    
    $key = "hyperseek2000";

    # Save the string lengths to speed things up slightly
    
    my($text_len) = length($text);
    my($key_len) = length($key);
    
    # Process each character in $string
    
    for ($i = $text_len - 1; $i >= 0; --$i) {
    
        # Convert the character to ASCII
        
        $num = ord(chop($text));
        
        # Change back to ':' if appropriate
        if ($num == 127) { $num = 58 }
        if ($num == 128) { $num = 34 };
        if ($num == 31) { $num = 39 };
        
        
        # Convert to 0-95 range
        
        $num -= 32;
        
        # If $key is longer than $string, stack characters
        
        for ($j = $i; $j < $key_len; $j += $text_len) {
            
            # Offset the original character by the key character and key length
            
            $num -= ord(substr($key, $j, 1)) + $key_len;
        }
        
        # Bring it back into the printable ASCII range
        
        $num = $num % 95 + 32;
        
        # Convert it to an ASCII character
        
        $result .= pack("c", $num);
    }
    
    # Return the result
    
    return($result);
}

# Routines "backwards" and "readline" borrowed from Backwards.pm
# Copyright (C) 1999 Uri Guttman. All rights reserved.
# mail bugs, comments and feedback to uri@sysarch.com

sub backwards {

	my( $class, $filename ) = @_ ;

	my( $handle, $seek_pos, $read_size, $self ) ;

	$handle = gensym() ;

	unless( sysopen( $handle, $filename, O_RDONLY ) ) {
		return ;
	}

	seek( $handle, 0, 2 ) ;
	$seek_pos = tell( $handle ) ;

	$read_size = $seek_pos % $max_read_size || $max_read_size ;

	$self = {
			'file_name'	=> $filename,
			'handle'	=> $handle,
			'read_size'	=> $read_size,
			'seek_pos'	=> $seek_pos,
			'lines'		=> [],
	} ;

	return( bless( $self, $class ) ) ;
}


sub readline {

	my( $self, $line_ref ) = @_ ;

	my( $handle, $lines_ref, $seek_pos, $read_cnt, $read_buf,
	    $file_size, $read_size, $text ) ;

	$lines_ref = $self->{'lines'} ;

	while( 1 ) {


		if ( @{$lines_ref} > 1 ) {

			return( pop @{$lines_ref} ) ;
		}

		$seek_pos = $self->{'seek_pos'} ;

		if ( $seek_pos == 0 ) {

			return( pop @{$lines_ref} ) ;
		}

		$handle = $self->{'handle'} ;
		$read_size = $self->{'read_size'} ;

		$self->{'read_size'} = $max_read_size ;

		$seek_pos -= $read_size ;
		$self->{'seek_pos'} = $seek_pos ;
		seek( $handle, $seek_pos, 0 ) ;

		$read_cnt = sysread( $handle, $read_buf, $read_size ) ;

		$text = $read_buf . ( pop @{$lines_ref} || '' ) ;

		@{$lines_ref} = $text =~ m[(^.*\n|^.+)]mg ;

	}
}



sub generate_password {

   my($factor) = $_[0];
   my(@chars,$change_password,$i);

   @chars=("a".."n","p".."z",1..9);
   srand( $factor ^ ($$ + ($$ << 15)) );
   $change_password="";
   for ($i=1;$i<=6;$i++){ 
        $change_password .= $chars[rand(@chars)];
   }

   return($change_password);

}

1;
