
##############################################################################
# PROGRAM : Bannermaster Module                                              #
# VERSION : 4.08                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#


   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw(Use_Account  Ascii_Use_Account  SQL_Use_Account  Group_Banner  
                bmPANIC  bmCLICK_PANIC  bm_LoadAccount  Ascii_LoadAccount  
                SQL_LoadAccount  bm_LoadGroup  Ascii_LoadGroup  SQL_LoadGroup  
             );

##############################################################################
#  Show a banner for a specific account
##############################################################################
sub Use_Account {
   if($global{'DB_Format'} eq "SQL") { return(IWEB::SQL_Use_Account()); }
   else { return(IWEB::Ascii_Use_Account()); }
}

sub Ascii_Use_Account {

   ### Make sure it's not disabled ....
   $bannermaster{'disabled'} = "$data_dir/bannermaster/campaigns/$bannermaster{'account'}.DISABLED";
   $bannermaster{'actfile'} = "$data_dir/bannermaster/campaigns/$bannermaster{'account'}.dat";

   if (-e "$bannermaster{'disabled'}" || ! -e "$bannermaster{'actfile'}") {
      $debug_text .= "Failed to use $bannermaster{'account'} .... reverting to default\n";
      $bannermaster{'group'}="default";
      return(IWEB::Group_Banner()); 
   }
   else {
      ### Update the Account and Get the banner file.
      $debug_text .= "Forcing use of $bannermaster{'account'}\n";
      $bannermaster{'group'}="bannermastersingleaccountok";
      return(IWEB::Group_Banner()); 
   }

}

sub SQL_Use_Account {

   ### Make sure it's not disabled ....
   $bannermaster{'disabled'} = "$data_dir/bannermaster/campaigns/$bannermaster{'account'}.DISABLED";

   $SQL = "SELECT count(*) FROM campaigns WHERE account='$bannermaster{'account'}'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR($SQL);
      while (@rows = $sth->fetchrow_array) { $bannermaster{'count'} = $rows[0]; }

   if (-e "$bannermaster{'disabled'}" || $bannermaster{'count'} < 1) {
      $debug_text .= "Failed to use $bannermaster{'account'} .... reverting to default\n";
      $bannermaster{'group'}="default";
      return(IWEB::Group_Banner()); 
   }
   else {
      ### Update the Account and Get the banner file.
      $debug_text .= "Forcing use of $bannermaster{'account'}\n";
      $bannermaster{'group'}="bannermastersingleaccountok";
      return(IWEB::Group_Banner()); 
   }

}

##############################################################################
#  Show a banner for a specific group / default group
##############################################################################
sub Group_Banner {

   my(%grplookup,$acct,$tword);      

   # Expects the following to be set.
   # $bannermaster{'group'} ... Group to use.
   # $bannermaster{'targeted'} ... boolean: 1 or 0

   # 1. Figure out which group to actually try and use.

   if($bannermaster{'group'} eq "bannermastersingleaccountok") {
      $bannermaster{'singleaccount'}=1;
   }

   ## UK Targeting
   # if ( $ENV{'REMOTE_HOST'} =~ /\.uk/ ) { $bannermaster{'group'} = "UK"; $bannermaster{'targeted'} = 1; }

   elsif ( ($hyperseek{'search'} eq "T" || $input{'Category'}) && !($bannermaster{'targeted'})) {

       $bannermaster{'sent'} = $hyperseek{'original_terms'};
       $bannermaster{'sent'} =~ s/\+//g;
       $bannermaster{'sent'} =~ s/\-//g;
       $bannermaster{'sent'} =~ s/ /_/g;

       $bannermaster{'sent'} =~ s/\:/_/g if($global{'bm_recursive'} ne "YES");

       $debug_text .= "Got: $bannermaster{'sent'}\n";

       if ($bannermaster{'sent'} =~ "\"") {
          foreach $w ( split(/\"/,$bannermaster{'sent'}) ) {
            $w =~ s/ /_/g;
            $grplookup{$w}++;
          }
       }
       $bannermaster{'sent'} =~ s/\"//g;
       foreach $w( split(/\s+/,$bannermaster{'sent'}) ) {
          $w =~ s/ /_/g;
          $grplookup{$w}++;
       }


       if($global{'bm_recursive'} eq "YES") {
          $debug_text .= "Doing Recursive Checks\n";
          my $gname = '';
          my @cgrp = split(/\:/,$bannermaster{'sent'});
          foreach my $cname (@cgrp) {
             $gname .= "_" if($gname);
             $gname .= $cname;
             $grplookup{$gname}++;
          }
       }


       $bannermaster{'group'} = "default";

       foreach $word (reverse sort keys %grplookup) {

          $word = IWEB::Make_Alpha($word);

          $debug_text .= "Trying: >>>$word<<<\n";

          undef $bannermaster{'count'};
          undef @accounts;

          if($global{'DB_Format'} eq "SQL") {
            $tword = $word;
            $tword =~ s/\'/\\\'/g;
            $SQL = "SELECT account FROM bm_groups WHERE group_name = '$tword'";
            $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
            $rc = $sth->execute || IWEB::SQL_ERROR($SQL);
            while (@rows = $sth->fetchrow_array) { 
                if($rows[0] && !(-e "$data_dir/bannermaster/campaigns/$rows[0].DISABLED")) { 
                   push @accounts,$rows[0]; 
                   $bannermaster{'count'}++; 
                } 
            }
            if ($bannermaster{'count'} >= 1) { 
               $bannermaster{'group'} = $word;
               last;
            }
          }
          else { 
            if (-e "$data_dir/bannermaster/groups/$word.grp") {
               open ("GRP", "$data_dir/bannermaster/groups/$word.grp");
                 foreach $acct( split(/\|/,<GRP>) ) {
                    if( $acct && !(-e "$data_dir/bannermaster/campaigns/$acct.DISABLED") ) { 
                       push @accounts,$acct; 
                       $bannermaster{'count'}++; 
                    }
                 }
               close(GRP);
            }

            if ($bannermaster{'count'} >= 1) { 
               $bannermaster{'group'} = $word;
               last;
            }
          }
       }
   }
   else {

       $bannermaster{'srch'} = $bannermaster{'group'};
       $bannermaster{'group'} = "default";

       $debug_text .= "Trying: >>>$bannermaster{'srch'}<<<<BR>\n";
       undef $bannermaster{'count'};
       undef @accounts;

       if($global{'DB_Format'} eq "SQL") {
         $tword = $bannermaster{'srch'};
         $tword =~ s/\'/\\\'/g;
         $SQL = "SELECT account FROM bm_groups WHERE group_name = '$tword'";
         $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
         $rc = $sth->execute || IWEB::SQL_ERROR($SQL);
         while (@rows = $sth->fetchrow_array) { 
           if($rows[0] && !(-e "$data_dir/bannermaster/campaigns/$rows[0].DISABLED")) { 
               push @accounts,$rows[0]; 
               $bannermaster{'count'}++; 
            } 
         }
 
       }
       else {
         $debug_text .= "Opening $data_dir/bannermaster/groups/$bannermaster{'srch'}.grp";
         if (-e "$data_dir/bannermaster/groups/$bannermaster{'srch'}.grp") {
            open ("GRP", "$data_dir/bannermaster/groups/$bannermaster{'srch'}.grp");
              foreach $acct( split(/\|/,<GRP>) ) {
                 if( $acct && !(-e "$data_dir/bannermaster/campaigns/$acct.DISABLED") ) { 
                   push @accounts,$acct; 
                   $bannermaster{'count'}++; 
                 }
              }
            close(GRP);
            $debug_text .= " ... $bannermaster{'count'}\n";
         }
         else { $debug_text .= " NOT!"; }
       }

       $bannermaster{'group'} = $bannermaster{'srch'} if($bannermaster{'count'});
   }

   $debug_text .= "Settling on $bannermaster{'group'}\n";

   # 2. Now, verify it for valid accounts, and pick one.

   if($bannermaster{'singleaccount'}) { 
      $bannermaster{'use_account'} = $bannermaster{'account'};
      $debug_text = "===== $bannermaster{'account'}\n";
   }
   else {

      $debug_text .= "Starting ... $bannermaster{'group'}\n";

      #--------------------------------------------------------------------------------#
      # If we're left with the default group, make sure it's good.                     #
      #--------------------------------------------------------------------------------#
      if($bannermaster{'group'} eq "default") { 
         undef $bannermaster{'count'};
         undef @accounts;

         if($global{'DB_Format'} eq "SQL") {
            $SQL = "SELECT account FROM bm_groups WHERE group_name = 'default'";
            $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
            $rc = $sth->execute || IWEB::SQL_ERROR($SQL);
            while (@rows = $sth->fetchrow_array) { 
               if($rows[0] && !(-e "$data_dir/bannermaster/campaigns/$rows[0].DISABLED")) { 
                  push @accounts,$rows[0]; 
                  $bannermaster{'count'}++; 
               } 
            } 
         }
         else {
            if (-e "$data_dir/bannermaster/groups/default.grp") {
               open ("GRP", "$data_dir/bannermaster/groups/default.grp");
                 foreach $acct( split(/\|/,<GRP>) ) {
                    if( $acct && !(-e "$data_dir/bannermaster/campaigns/$acct.DISABLED") ) { 
                      push @accounts,$acct; $bannermaster{'count'}++; 
                    }
                 }
               close(GRP);
            }
         }

      }

      ## See Ya, if we have nothing to show.
      if(! $bannermaster{'count'}) { IWEB::bmPANIC(); }
      else { 
         $bannermaster{'use_account'} = IWEB::bm_LoadGroup($bannermaster{'group'});
         $debug_text .= "Using: $bannermaster{'use_account'}\n";
      }

   }

   # 4. Get the account data
   # 5. Save the account changes (Impressions) and log it
   if(! $bannermaster{'PANIC'}) { 

      IWEB::bm_LoadAccount();
      $debug_text .= "Tried to load $bannermaster{'use_account'} ... found $account{'acct_name'}\n";

      $debug_text .= "In Update Account, working on $account{'acct_name'}\n";

      ## Make sure we can save.
      if($global{'DB_Format'} ne "SQL" && ! -e "$data_dir/bannermaster/campaigns/$account{'acct_name'}.dat") { $debug_text .= "Nowhere to save"; IWEB::bmPANIC(); }

      ## Continuing on ....
      my($REF, $month, $TIME, $DATE_STRING, $rtime, $RAND, $R1, $logname,$filename, $disable);      

      ## Get time for the log file...
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
         $mon++;
         if(length($mday) == 1) { $mday = "0$mday"; }
         if(length($mon) == 1) { $mon = "0$mon"; }
         $year += 1900;

         $logname = "$mon" . "_" . "$year.log";
         $logdate = "$mon" . "/" . "$mday" . "/" . $year;
   
      ## Referer for log file
      if ( $ENV{'HTTP_REFERER'} ) { $REF=$ENV{'HTTP_REFERER'}; }
      else { $REF=$SELF; }
   
      $TIME=time;
      $DATE_STRING = "$mon" . "_" . "$mday" . "_" . "$year";
   
      $filename = "$data_dir/bannermaster/logs/$account{'acct_name'}.$logname";
   
      $rtime = time;
      $RAND = "x$rtime";
      $RAND = substr($rtime,-1,1);
      $R1 = "RAND";
   
      $btext = $account{'banner_text'};
      $btext =~ s/$R1/$RAND/g;
   
      $account{'image'} = $account{'banner'};
      $account{'image'} =~ s/$R1/$RAND/g;
   
      ### Check for Disabling....
      $disable=0;
      if ($account{'expiration_type'} eq "impressions") {
          if($global{'DB_Format'} eq "IWeb" && $totals{'Impressions'} >= $account{'num_impressions'}) { $disable=1; }
          elsif($global{'DB_Format'} eq "SQL" && $account{'num_impressions'} >= $account{'imp_allowed'}) { $disable=1; }
      }
      elsif ($account{'expiration_type'} eq "date") {
   
          ($e_month, $e_day, $e_year) = split(/\//,$account{'end_date'});
          ($d_month, $d_day, $d_year) = split(/\_/,$DATE_STRING);
   
          $debug_text .= "Compared $e_month/$e_day/$e_year (expires) to $d_month/$d_day/$d_year (today)...\n";
   
          ## Date Comparisons ....
    
          ## This year less than expiration year
          if ($d_year > $e_year) 
                { $debug_text .= "Disabled due to year."; $disable=1; }
   
          ## Same year, this month later than expiration month
          elsif ($d_year == $e_year && $d_month > $e_month) 
                { $debug_text .= "Disabled due to month."; $disable=1; }
   
          ## Same year, same month, today later than expiration day
          elsif ($d_year == $e_year && $d_month == $e_month && $d_day > $e_day) 
                { $debug_text .= "Disabled due to day."; $disable=1; }
   
      }
   
      ### SAVE FILES ###
      if(! IWEB::lock($account{'acct_name'})) { IWEB::bmPANIC(); }

         if($global{'DB_Format'} eq "SQL") { 


            if($disable) { 
               $SQL = "DELETE from bm_groups WHERE account='$bannermaster{'use_account'}'";
               $dbh->do($SQL);
               open(DIS,">$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.DISABLED"); close(DIS);
            }

            ## Click Table Entry, if Necessary
            if ($BMS) { 
                $bannermaster{'who'} = $ENV{'REMOTE_ADDR'} . ":" . $input{'x-factor'};
                $SQL = "INSERT INTO bm_click VALUES ('$bannermaster{'who'}','$bannermaster{'use_account'}')";
                 $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
                 $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
            }
   
            ## Account Table Update
            $SQL = "UPDATE campaigns SET num_impressions = num_impressions+1 WHERE account = '$bannermaster{'use_account'}'";
               $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
               $rc = $sth->execute || IWEB::SQL_ERROR($SQL);
   
            ## Insert / Update into the stats table.
            $SQL = "SELECT count(*) FROM bm_stats WHERE account='$bannermaster{'use_account'}' AND stat_date='$logdate'";
                 $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
                 $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
                 while (@rows = $sth->fetchrow_array) {  $bannermaster{'exists'} = $rows[0]; }
         
            if($bannermaster{'exists'}) {
              $SQL = "UPDATE bm_stats SET impressions = impressions+1 WHERE account = '$bannermaster{'use_account'}' AND stat_date = '$logdate'";
            }
            else {
              $SQL = "INSERT INTO bm_stats VALUES('$bannermaster{'use_account'}','$logdate',0,1)";
            }
         
            $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
            $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

         }

         else {

            ### LOG ENTRY
            open("LOG",">>$filename");
               print LOG "impression|$DATE_STRING|$TIME|$REF\n";
            close(LOG);
   
            $totals{'Impressions'}++;
            $totals{'Clicks'}=0 if(!$totals{'Clicks'});
   
            if($disable) {
               open ("DIS", ">$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.DISABLED");
               close (DIS); 
            }

            if ($BMS) { 
                $bannermaster{'who'} = $ENV{'REMOTE_ADDR'};
                $bannermaster{'xf'} = $input{'x-factor'};
                $bannermaster{'clickfile'} = "$data_dir/bannermaster/rotation/$bannermaster{'who'}.$bannermaster{'xf'}.click";
                open(CLK,">$bannermaster{'clickfile'}");
                   print CLK "\$bannermaster{'use_account'} = \"$bannermaster{'use_account'}\";\n";
                   print CLK "1;\n";
                close(CLK);
            }

            $bannermaster{'afile'} = "$data_dir/bannermaster/campaigns/$account{'acct_name'}.ttl";
   
               open(NEW,">$bannermaster{'afile'}");
                 foreach $key(keys %totals) {
                    $newkey = $key;
                    $newkey=~s/^\s+//g;
                    $newkey=~s/\s+$//g;
                    $totals{$key}=~s/^\s+//g;
                    $totals{$key}=~s/\s+$//g;
                    print NEW "$newkey==$totals{$key}\n";
                    $debug_text .= "Saving: $key = $totals{$key}\n";
                 }
               close(NEW);
            
            $debug_text .= "Saved $totals{'Impressions'} Impressions and $totals{'Clicks'} Clicks to $bannermaster{'afile'}\n";
         }

      IWEB::unlock($account{'acct_name'});
   }


   # 6. Generate and Return Code
   
   # Non-SSI Banner
   if($BMS) {
     print "Location: $account{'image'}\n\n";
   }

   # SSI / PLUGIN Code
   else {

      if($account{'target'} =~ "NONE") { $bannermaster{'TARGET'}=""; }
      else { $bannermaster{'TARGET'}="TARGET=\"$account{'target'}\""; }

      if($account{'banner_type'} eq "TEXT") {
         $bannermaster{'CLICK'} = "$urls{'click_url'}?account=$account{'acct_name'}";
         $btext =~ s/CLICK/$bannermaster{'CLICK'}/g;
         my $encgroup = $hyperseek{'encoded_terms'};
         $btext =~ s/(<<KEYWORD>>)/$encgroup/g;
         $CODE = $btext;
      }

      else {
         my $utext = "";
         if($account{under_text}) { 
            $utext = qq!
                <TR><TD WIDTH="100%">
                  <CENTER>$account{'under_text'}</CENTER>
                </TD></TR>
            !;
         }

         $CODE = qq!
               <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="$account{'banner_width'}">
                <TR><TD WIDTH="100%">
                   <A HREF="$urls{'click_url'}?account=$account{'acct_name'}" $bannermaster{'TARGET'}><IMG SRC="$account{'banner'}" BORDER="0" HEIGHT="$account{'banner_height'}" WIDTH="$account{'banner_width'}" ALT="$account{'alt_text'}"></A>
                </TD></TR>
                $utext
               </TABLE>
         !;
      }
   }

   # 7. All Done
   # return("$CODE <PRE>$debug_text</PRE>");
   return("$CODE");
}


sub bmPANIC {

   ### We end up here if there is no banner to show
   ### This will happen if after we've tried everything, even the default group has no eligible
   ### accounts to show. 

    $account{'banner'} = "$global{'PANIC_IMAGE'}";
    $account{'image'} = "$global{'PANIC_IMAGE'}";
    $account{'banner_type'}="IMAGE";
    $account{'banner_height'}=60;
    $account{'banner_width'}=468;
    $bannermaster{'PANIC'}=1;

    if ($debug) { 
        $debug_text .= "\n\nPanic!\n\n";
        $debug_text .= "Showing $global{'PANIC_IMAGE'}\n";
    }
}


sub bmCLICK_PANIC {

   ### We end up here if there is a bad $ACCOUNT with click.cgi
   ### This will happen if the account is not sent via SSI, a Cookie is not there, or if there
   ### is no file in $data_dir/bannermaster/rotation/ for the users IP Address.

   $showimage{'redirect_url'} = $global{'PANIC_URL'};
}



######################################################################
# Account and Group Loading ....
#
# In non "mod_perl" systems, this happens every call to the program
# In mod_perl systems, the reading of accounts happens ONCE.
#                      Group reading is perpetual.
#
#                      To stop this, there's a "reload bm" link in
#                      the admin program to clear all this out.
######################################################################

sub bm_LoadAccount {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_LoadAccount(); }
   else { IWEB::Ascii_LoadAccount(); }
}


sub Ascii_LoadAccount {

    my $dat_file = "$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.dat";
    my $tot_file = "$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.ttl";

    # Get account info and create a new hash record for it.
    if(! -e $dat_file) { IWEB::bmPANIC(); }
    else {
       undef %account;
       open(FILE,"$dat_file");
       while(<FILE>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $account{$var}=$val;
       } 
       close(FILE);

       open(FILE,"$tot_file");
       while(<FILE>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $totals{$var}=$val;
       } 
       close(FILE);
    }

}

sub SQL_LoadAccount {

   my($afield,$field);

   $SQL = "SELECT * FROM campaigns WHERE account = '$bannermaster{'use_account'}'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while ($results = $sth->fetchrow_hashref) { 
         foreach $field (@{$sth->{NAME}} ) {
            $afield = lc($field);
            $account{$afield}=$results->{$field};
         }
      }

   ## Some cleanup work....

   $account{'acct_name'} = $account{'account'};
   $account{'acct_login'} = $account{'login'};
   $account{'acct_password'} = $account{'password'};
   $account{'banner_width'} = $account{'width'};
   $account{'banner_height'} = $account{'height'};

}



sub bm_LoadGroup {

   my($acct);      

   if(! IWEB::lock($bannermaster{'group'})) { IWEB::bmPANIC(); }

      if($global{'DB_Format'} eq "SQL") { $acct = IWEB::SQL_LoadGroup(); }
      else { $acct = IWEB::Ascii_LoadGroup(); }

   IWEB::unlock($bannermaster{'group'});

   return($acct);
}


sub Ascii_LoadGroup {

    my($last,$next,$cnt);      

    open ("GRP", "$data_dir/bannermaster/rotation/$bannermaster{'group'}.last");
       $last=<GRP>;
    close(GRP);

    chomp $last;

    if($last >= $bannermaster{'count'} -1) { $next = 0; }
    else { $next = $last + 1; }    

    open ("GRP", ">$data_dir/bannermaster/rotation/$bannermaster{'group'}.last");
       print GRP "$next";
    close(GRP);
    
    return($accounts[$next]);

}


sub SQL_LoadGroup {

    my ($last,$next,$cnt);      

    $debug_text .= "Count for Group: $bannermaster{'group'} = $bannermaster{'count'}\n";

    $SQL = "SELECT last_shown FROM bm_group_def WHERE group_name = '$bannermaster{'group'}'";
       $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR();
       $rc = $sth->execute || IWEB::SQL_ERROR();
       while (@rows = $sth->fetchrow_array) { $last = $rows[0]; $cnt++; }

    if($last >= $bannermaster{'count'} -1) { $next = 0; }
    else { $next = $last + 1; }    

    $debug_text .= "Last: $last ... Next: $next\n";

    if($cnt) { 
       $SQL = "UPDATE bm_group_def SET last_shown = $next WHERE group_name = '$bannermaster{'group'}'";
    }
    else { 
       $SQL = "INSERT INTO bm_group_def VALUES('$bannermaster{'group'}',$next)";
    }
    $dbh->do($SQL) || IWEB::SQL_ERROR($SQL);

    $debug_text .= "Accounts: @accounts\n";

    $debug_text .= "SQL: $SQL\n";

    return($accounts[$next]);
}




1;
