#!/usr/local/bin/perl


##############################################################################
# PROGRAM : Easy Upgrade to Bannermaster 4 from Bannermaster 3.0             #
# VERSION : 2.1                                                              #
#                                                                            #
# NOTES   :                                                                  #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996 -> 2014                                                 #
#           John C. Cokos, The CCS Network, The Interactive Web              #
#           All Rights Reserved.                                             #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
##############################################################################
#START#

package IWEB;

BEGIN {
   push @INC,"..";
}

  use File::Copy;
  use IWeb::iweb;

  IWEB::Read_Config();

  print "Content-Type: text/plain\n\n";

  if($input{'SQL'} || $ARGV[0] =~ /sql/i) { 
    IWEB::SQL_Connect();
    IWEB::SQL_Convert();
    IWEB::SQL_Logs();
  }
  else { 
    IWEB::Standard_Convert();
  }


sub Standard_Convert {

  print "Data: $data_dir\n";
  print "DB: $global{'bm_database'}\n";

  mkdir("$data_dir/bannermaster/campaigns",0777);

  if($global{'bm_database'} eq "DBM") { 

     $accountsdb = "$data_dir/bannermaster/accounts.db";
     $groupsdb = "$data_dir/bannermaster/groups.db";
     $lastdb = "$data_dir/bannermaster/rotation.db";
     $clickdb = "$data_dir/bannermaster/clicks.db";
     $tot_imp = "$data_dir/bannermaster/acctimp.db";
     $tot_clk = "$data_dir/bannermaster/acctclicks.db";
     $showndb =    "$data_dir/bannermaster/exshown.db";
     $creditsdb =  "$data_dir/bannermaster/excredits.db"; 

     eval("use DB_File");
        tie %timp, "DB_File", $tot_imp,O_RDONLY;
        tie %tclick, "DB_File", $tot_clk,O_RDONLY;

        print "Converting Accounts ...\n";
        tie %accounts, "DB_File", $accountsdb,O_RDONLY;
          foreach $key(keys %accounts) {
            ($acct_name,$acct_login,$acct_password,$target,$redirect_url,$alt_text,$under_text,$banner_type,$banner,$banner_width,$banner_height,$banner_text,$expiration_type,$num_clicks,$num_impressions,$start_date,$end_date) = split(/\|/,$accounts{$key});

            print "...$key ... ";
            open(ACT,">$data_dir/bannermaster/campaigns/$key.dat");
                print ACT "under_text==$under_text\n";
                print ACT "acct_login==$acct_login\n";
                print ACT "end_date==$end_date\n";
                print ACT "expiration_type==$expiration_type\n";
                print ACT "redirect_url==$redirect_url\n";
                print ACT "banner_width==$banner_width\n";
                print ACT "alt_text==$alt_text\n";
                print ACT "banner==$banner\n";
                print ACT "banner_type==$banner_type\n";
                print ACT "target==$target\n";
                print ACT "num_clicks==$num_clicks\n";
                print ACT "banner_text==$banner_text\n";
                print ACT "start_date==$start_date\n";
                print ACT "num_impressions==$num_impressions\n";
                print ACT "acct_name==$acct_name\n";
                print ACT "acct_password==$acct_password\n";
                print ACT "banner_height==$banner_height\n";
            close(ACT);

            open(TTL,">$data_dir/bannermaster/campaigns/$key.ttl");
                print TTL "Clicks==$tclick{$key}\n";
                print TTL "Impressions==$timp{$key}\n";
            close(TTL);

            unlink("$data_dir/bannermaster/accounts/$key.dat");
            unlink("$data_dir/bannermaster/accounts/$key.clk");
            unlink("$data_dir/bannermaster/accounts/$key.imp");


            print "Done\n";
          }
        untie %accounts;

        print "\nAccounts Converted\n";

        print "Converting Groups ...\n";
        tie %groups, "DB_File", $groupsdb,O_RDONLY;
           foreach $key(keys %groups) {   
              print "$key\n"; 
              $group = $key;
              $group = &Make_Alpha($key);
              open(GRP,">$data_dir/bannermaster/groups/$group.grp");
                   print GRP "$groups{$key}|";
              close(GRP);
           }
        untie %groups;
        print "\nGroups Done\n";

        untie %timp;
        untie %tclick;
  }

  else {

      print "Converting Accounts ...\n";
      opendir(ACCOUNTS,"$data_dir/bannermaster/accounts/");
         while ($file = readdir(ACCOUNTS)) {
             if($file =~ /\.dat/) { 
                $file =~ s/\.dat//g; 
                $files{$file}++;
             }
         }
      closedir(ACCOUNTS);

      foreach $key(keys %files) {

          print "... $key ... ";
          copy("$data_dir/bannermaster/accounts/$key.dat","$data_dir/bannermaster/campaigns/$key.bm3");

          open(ACT,"$data_dir/bannermaster/accounts/$key.dat");
             $LINE=<ACT>;
          close(ACT);

          unlink("$data_dir/bannermaster/accounts/$key.dat");

          ($acct_name,$acct_login,$acct_password,$target,$redirect_url,$alt_text,$under_text,$banner_type,$banner,$banner_width,$banner_height,$banner_text,$expiration_type,$num_clicks,$num_impressions,$start_date,$end_date) = split(/\|/,$LINE);

          open(ACT,">$data_dir/bannermaster/campaigns/$key.dat");
                print ACT "under_text==$under_text\n";
                print ACT "acct_login==$acct_login\n";
                print ACT "end_date==$end_date\n";
                print ACT "expiration_type==$expiration_type\n";
                print ACT "redirect_url==$redirect_url\n";
                print ACT "banner_width==$banner_width\n";
                print ACT "alt_text==$alt_text\n";
                print ACT "banner==$banner\n";
                print ACT "banner_type==$banner_type\n";
                print ACT "target==$target\n";
                print ACT "num_clicks==$num_clicks\n";
                print ACT "banner_text==$banner_text\n";
                print ACT "start_date==$start_date\n";
                print ACT "num_impressions==$num_impressions\n";
                print ACT "acct_name==$acct_name\n";
                print ACT "acct_password==$acct_password\n";
                print ACT "banner_height==$banner_height\n";
         close(ACT);

         open("CLK","$data_dir/bannermaster/accounts/$key.clk");
            $clicks = <CLK>;
         close(CLK);

         open("IMP","$data_dir/bannermaster/accounts/$key.imp");
            $impressions = <IMP>;
         close(IMP);

         chomp $impressions;
         chomp $clicks;

         open(TTL,">$data_dir/bannermaster/campaigns/$key.ttl");
             print TTL "Clicks==$clicks\n";
             print TTL "Impressions==$impressions\n";
         close(TTL);

         unlink("$data_dir/bannermaster/accounts/$key.clk");
         unlink("$data_dir/bannermaster/accounts/$key.imp");

         print "Done\n";

     }

     print "\nAccounts Converted\n";

  }


}




sub SQL_Convert {

  opendir(ACCTS,"$data_dir/bannermaster/accounts/");
    while( $file = readdir(ACCTS)) {
      if($file =~ /\.dat/) { 
         $file =~ s/\.dat//g;
         $accounts{$file}++;
      }
    }
  closedir(ACCTS);

  opendir(CAMPS,"$data_dir/bannermaster/campaigns/");
    while( $file = readdir(CAMPS)) {
      if($file =~ /\.dat/) { 
         $file =~ s/\.dat//g;
         $campaigns{$file}++;
      }
    }
  closedir(CAMPS);

  print "Wiping out old data...";
  $SQL = "DELETE from accounts";
   $dbh->do($SQL);

  $SQL = "DELETE from campaigns";
   $dbh->do($SQL);

  $SQL = "DELETE from bm_click_stats";
   $dbh->do($SQL);

  $SQL = "DELETE from bm_stats";
   $dbh->do($SQL);

  $SQL = "DELETE from bm_groups";
   $dbh->do($SQL);

  $SQL = "DELETE from bm_group_def";
   $dbh->do($SQL);

  print "Done\n\n";
  print "Starting Accounts....\n";
  foreach $acct(keys %accounts) { 

     undef %account;

     open(ACCT,"$data_dir/bannermaster/accounts/$acct.dat");
       while(<ACCT>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $account{$var}=$val;
       } 
     close(ACCT);

     $SQL = qq!
       INSERT INTO accounts values(
	      '$account{'acct_id'}',
	      '$account{'acct_password'}',
	      'bannermaster',
	      '$account{'contact_email'}',
	      '',
	      '$account{'contact_name'}',
	      '$account{'address'}',
	      '$account{'city'}',
	      '$account{'state'}',
	      '$account{'zip'}',
	      '',
	      '$account{'phone'}',
	      '$account{'fax'}',
              '',
              '',
              '',
              '',
              0,
              0,
              0,
              '',
	      '',
	      '',
	      '',
	      '',
	      0,
	      0,
	      ''
       )
     !;
     print "Inserting $acct...\n";
     $dbh->do($SQL) || print "Couldn't insert into accounts table: $acct\n";

  }

  print "Accounts Done\n\n";

  print "Starting Campaigns...\n";

  foreach $camp(keys %campaigns) { 

     undef %campaign;

     open(ACCT,"$data_dir/bannermaster/campaigns/$camp.dat");
       while(<ACCT>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $campaign{$var}=$val;
       } 
     close(ACCT);

     open(ACCT,"$data_dir/bannermaster/campaigns/$camp.ttl");
       while(<ACCT>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $campaign{$var}=$val;
       } 
     close(ACCT);

     $campaign{'imp_allowed'}=$campaign{'num_impressions'} || 0;
     $campaign{'num_impressions'} = $campaign{'Impressions'} || 0;
     $campaign{'clicks_allowed'}=$campaign{'num_clicks'} || 0;
     $campaign{'num_clicks'} = $campaign{'Clicks'} || 0;

     $SQL = qq!
       INSERT INTO campaigns values(
           '$campaign{'acct_name'}',
           '$campaign{'acct_login'}',
           '$campaign{'acct_password'}',
           '$campaign{'target'}',
           '$campaign{'redirect_url'}',
           '$campaign{'alt_text'}',
           '$campaign{'under_text'}',
           '$campaign{'banner_type'}',
           '$campaign{'banner'}',
            $campaign{'banner_width'},
            $campaign{'banner_height'},
           '$campaign{'banner_text'}',
           '$campaign{'expiration_type'}',
            $campaign{'num_clicks'},
            $campaign{'clicks_allowed'},
            $campaign{'num_impressions'},
            $campaign{'imp_allowed'},
           '$campaign{'start_date'}',
           '$campaign{'end_date'}'
       )
     !;
     print "Inserting Campaign: $camp...\n";
     $dbh->do($SQL) || print "Couldn't insert into campaign table: $camp ($SQL)\n";

  }

  print "Campaigns Done\n\n";

  print "Starting Groups\n\n";
  opendir(GROUPS,"$data_dir/bannermaster/groups/");
    while($file = readdir(GROUPS)) {
       if($file =~ /.*\.grp/) { 

          $groupname = $file;
          $groupname =~ s/\.grp//g;

          open(GRP,"$data_dir/bannermaster/groups/$file");
             while(<GRP>) {
               chomp;
               foreach $camp(split(/\|/,$_)) {
                 $SQL = "INSERT INTO bm_groups VALUES('$groupname','$camp')";
                 $dbh->do($SQL);
               }
             }
          close(GRP);
          ## Group Def Entry
          $SQL = "INSERT INTO bm_group_def VALUES('$groupname',0)";
          $dbh->do($SQL);
          print "Group: $groupname done\n";
       }
    }

  print "SQL Groups Complete.\n";
  print "SQL Convert Complete.\n";

}


sub SQL_Logs {

  print "Starting logs...\n";

  opendir(LOGS,"$data_dir/bannermaster/logs/");
    while( $file = readdir(LOGS)) {
         ($account,$date,$type) = split(/\./,$file);
         open(FILE,"$data_dir/bannermaster/logs/$file"); 
            while(<FILE>) {
              $exists=0;
              ($time,$referer,undef) = split(/\|/,$_);
              $date =~ s/\_/\//g;
              if($type =~ "click") { 
                 $SQL = "INSERT INTO bm_click_stats VALUES('$account','$date','$referer')";
                 $dbh->do($SQL) || print "Couldnt save click info for $account\n";
              }
              $SQL = "SELECT count(*) FROM bm_stats WHERE account='$account' AND stat_date = '$date'";
               $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
               $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
               while (@rows = $sth->fetchrow_array) {  $exists=$rows[0]; }

              if($exists) { 
                 if($type eq "click") { $SQL = "UPDATE bm_stats SET clicks = clicks+1 WHERE account = '$account' AND stat_date = '$date'"; }
                 elsif($type eq "impression") { $SQL = "UPDATE bm_stats SET impressions = impressions+1 WHERE account = '$account' AND stat_date = '$date'"; }
              }
              else { 
                 if($type eq "log") { $SQL = "INSERT INTO bm_stats VALUES('$account','$date',0,1)"; }
                 elsif($type eq "click") { $SQL = "INSERT INTO bm_stats VALUES('$account','$date',1,0)"; }
              }
              print "Loading Stat: $account ($exists,$date)\n";
              $dbh->do($SQL) || print "Stat Load Failure\n";
           }
         close(FILE);
    }
  closedir(LOGS);

  print "SQL Logs Complete.\n";
}



sub SQL_Logs2 {

  print "Starting logs...\n";

  opendir(LOGS,"$data_dir/bannermaster/logs/");
    while( $file = readdir(LOGS)) {
      if($file =~ /\.log/) { 
         ($account,undef,undef) = split(/\./,$file);
         open(FILE,"$data_dir/bannermaster/logs/$file"); 
            while(<FILE>) {
              ($type,$date,$time,$referer) = split(/\|/,$_);
              $date =~ s/\_/\//g;
              if($type eq "click") { 
                 $SQL = "INSERT INTO bm_click_stats VALUES('$account','$date','$referer')";
                 $dbh->do($SQL) || print "Couldnt save click info for $account\n";
              }
              $SQL = "SELECT count(*) FROM bm_stats WHERE account='$account' AND stat_date = '$date'";
               $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
               $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
               while (@rows = $sth->fetchrow_array) {  $exists=$rows[0]; }

              if($exists) { 
                 if($type eq "impression") { $SQL = "INSERT INTO bm_stats VALUES('$account','$date',0,1)"; }
                 elsif($type eq "click") { $SQL = "INSERT INTO bm_stats VALUES('$account','$date',1,0)"; }
              }
              else { 
                 if($type eq "click") { $SQL = "UPDATE bm_stats SET clicks = clicks+1 WHERE account = '$account' AND stat_date = '$date'"; }
                 elsif($type eq "impression") { $SQL = "UPDATE bm_stats SET impressions = impressions+1 WHERE account = '$account' AND stat_date = '$date'"; }
              }
              print "Loading Stat: $account / $date\n";
              $dbh->do($SQL) || print "Stat Load Failure\n";
           }
         close(FILE);
      }
    }
  closedir(LOGS);

  print "SQL Logs Complete.\n";
}
