#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Bannermaster Reporting                                           #
# VERSION : 4.06                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

package IWEB;

## These cannot be combined into a single BEGIN, as there are dependencies
## Between them ... this is, and must stay "linear"

BEGIN { 
   use Cwd;
}

BEGIN {
   $directory = cwd;
   push @INC,$directory;
   push @INC,"."; 
   push @INC,"..";
}

BEGIN { 
   use IWeb::iweb;
}


use vars qw(%campaigns %campaign);

##############################################################################
# BEGIN OF ACTUAL PROGRAM CODE
##############################################################################


  IWEB::Read_Config();
  IWEB::Read_Language("global");

  %input = IWEB::parse_form("input");

  if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Connect(); }

   if ($input{'MODE'} ne "admin") { 
      if($input{'login_id'}) { IWEB::Validate_Login(); }
      IWEB::Page_Header("adreport"); 
   }
   else { 
     print "Content-Type: text/html\n\n";
     my $back = qq! <A HREF="$urls{'bm_admin_url'}?action=List+Campaigns">Back to Campaign List</A> !;
     print IWEB::Admin_Header("Campaign Report ... $back");
     print IWEB::Do_Admin(); 
     print IWEB::Admin_Footer();
   }

   IWEB::Quit(); 


sub Do_Admin {

   my($body);

   $action = $input{'action'};
   IWEB::Get_Campaign_Info();

   $body = IWEB::Report_Header();

   if ($action eq "detail") { $body .= IWEB::Account_Detail(); }
   else { $body .= IWEB::Report_Account(); }

   return($body);

}

sub BODY {

   my $body;

   if ( ! $input{'login_id'} ) { $body = IWEB::GetLogin(); }

   else {
      $action = $input{'action'};
      IWEB::Get_Campaign_Info();
      $body = IWEB::Report_Header();
      if ($action eq "detail") { $body .= IWEB::Account_Detail(); }
      else { $body .= IWEB::Report_Account(); }
   }

   return($body);
}



##############################################################################
#  Show a banner for a specific account
##############################################################################

sub Report_Header {

   my($header,$image);

   if($input{'mon'} eq "1") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'january'}"; }
   if($input{'mon'} eq "2") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'february'}"; }
   if($input{'mon'} eq "3") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'march'}"; }
   if($input{'mon'} eq "4") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'april'}"; }
   if($input{'mon'} eq "5") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'may'}"; }
   if($input{'mon'} eq "6") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'june'}"; }
   if($input{'mon'} eq "7") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'july'}"; }
   if($input{'mon'} eq "8") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'august'}"; }
   if($input{'mon'} eq "9") { $input{'mon'}="0$input{'mon'}"; $input{'month'} = "$language{'september'}"; }
   if($input{'mon'} eq "10") { $input{'mon'}="$input{'mon'}"; $input{'month'} = "$language{'october'}"; }
   if($input{'mon'} eq "11") { $input{'mon'}="$input{'mon'}"; $input{'month'} = "$language{'november'}"; }
   if($input{'mon'} eq "12") { $input{'mon'}="$input{'mon'}"; $input{'month'} = "$language{'december'}"; }

   my( @months )= ( "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );
   
   my ($selmonth, $selyear);

   if($input{'mon'} eq "") {
      my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
      $input{'year'} = $year;
      $input{'mon'} = $mon;
      $input{'mon'}++;

      $input{'year'} += 1900;
      $selmonth = $months[$mon];      
   }
   else { 
      $selmonth = $months[$input{mon} - 1];
   }
   
   $selyear = $input{year};
   

   if($campaign{'banner'}) { $image = qq! <B>Campaign: $campaign{'acct_name'}</B><BR><IMG SRC="$campaign{'banner'}">!; }
   else { $image = ""; }

   my ($clist,@campaigns) = IWEB::Get_Campaign_List();

   $header = qq!
    <TABLE BORDER=0 WIDTH=630 BGCOLOR="black" CELLSPACING=1 CELLPADDING=0><TR><TD>
    <TABLE BORDER=0 WIDTH=100% BGCOLOR="$global{'win_color'}">
    <TR BGCOLOR="$global{'title_color'}"><TD COLSPAN=2>
       <FONT FACE="$global{'font_face'}" COLOR="$global{'ttxt_color'}">
       <H3>Advertising Report .... $input{'login_id'}</H3>$john
       </FONT>
    </TD></TR>

    <TR><TD COLSPAN=2>
       <FONT FACE="$global{'font_face'}" COLOR="$global{'text_color'}">
       <CENTER>$image</CENTER>
       </FONT>
    </TD></TR>
    <TR>
    <TD VALIGN="top">
      <FONT FACE="$global{'font_face'}" COLOR="$global{'text_color'}" SIZE="$global{'font_size'}">
      <FORM ACTION="$PROG_URL" METHOD="POST">
         Month: <SELECT NAME="mon">
           <OPTION VALUE="$input{'mon'}" SELECTED>$selmonth
                  <OPTION VALUE="1">$language{'january'}
                  <OPTION VALUE="2">$language{'february'}
                  <OPTION VALUE="3">$language{'march'}
                  <OPTION VALUE="4">$language{'april'}
                  <OPTION VALUE="5">$language{'may'}
                  <OPTION VALUE="6">$language{'june'}
                  <OPTION VALUE="7">$language{'july'}
                  <OPTION VALUE="8">$language{'august'}
                  <OPTION VALUE="9">$language{'september'}
                  <OPTION VALUE="10">$language{'october'}
                  <OPTION VALUE="11">$language{'november'}
                  <OPTION VALUE="12">$language{'december'}
         </SELECT><BR><BR>
         Year: <SELECT NAME="year">
           <OPTION VALUE="$input{'year'}" SELECTED>$input{'year'}
           <OPTION VALUE="1998">1998
           <OPTION VALUE="1999">1999
           <OPTION VALUE="2000">2000
           <OPTION VALUE="2001">2001
         </SELECT><BR><BR>

         Campaign: <SELECT NAME="campaign">
           <OPTION VALUE="$input{'campaign'}" SELECTED>$input{'campaign'}
           $clist
         </SELECT><BR><BR>

         <INPUT TYPE="hidden" NAME="login_id" VALUE="$input{'login_id'}">
         <INPUT TYPE="hidden" NAME="password" VALUE="$input{'password'}">
         <INPUT TYPE="hidden" NAME="MODE" VALUE="$input{'MODE'}">
         <INPUT TYPE="submit" VALUE="Load New Report">

      </FORM>
      </FONT>
    </TD>

   !;

   return($header);

}

sub Report_Account {

   my %count;
   my %dates;
   my $date;
   my @d;
   my $report;

   $report{'imp_referer'}={};
   $report{'clk_referer'}={};
   $report{'totals'}={};

   $report{'clk_count'} = 0;
   $report{'tot_count'} = 0;
   $report{'imp_count'} = 0;

   my ($clist,@campaigns) = IWEB::Get_Campaign_List();

   if($global{'DB_Format'} eq "SQL") {
        if ( $input{'campaign'} ) {        
            $SQL = "SELECT * FROM bm_stats WHERE account='$input{'campaign'}'";
        }
        else { 
            my $in = join("','", @campaigns);
            $SQL = "SELECT * FROM bm_stats WHERE account IN('$in')";
        }
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) { 
           $date = $rows[1];
           $totals{'Impressions'} += $rows[3];
           $totals{'Clicks'} += $rows[2];
           @d=split(/\//,$date);
           if($d[0] == $input{'mon'} && $d[2]==$input{'year'}) {
                $dates{$date}{'click'} = $rows[2];
                $report{'month_clicks'} += $rows[2];
                $dates{$date}{'impression'} = $rows[3];
                $report{'month_imp'} += $rows[3];
           }
        }
   }

   else {

      $log_dir = "$data_dir/bannermaster/logs";

      opendir(FILES, "$log_dir");
        @files=readdir(FILES);
      closedir(FILES);

       $checkdate = "$input{'mon'}" . "_" . "$input{'year'}";
       foreach $file(@files) {
           if ( $input{'campaign'} ) {           
               if ($file =~ /$input{'campaign'}/ && $file =~ $checkdate) {
                  push @filelist,$file;
               }
           }
           else { 
               foreach my $campaign ( @campaigns ) {
                   if ($file =~ /$campaign/ && $file =~ $checkdate) {
                      push @filelist,$file;
                   }
               }
           }
       }

       for $z( 0 .. $#filelist ) {
           $curr_imp = 0;
           $curr_clicks = 0;

           $file = $filelist[$z];
           $str = $filelist[$z];
           $filebase = "$data_dir/bannermaster/logs/$file";

           ### Tally the daily impressions ###
           open (LOG,"$filebase");
              while(<LOG>) {
                ($report{'type'},$report{'date'},$report{'time'},$report{'referer'}) = split(/\|/,$_);
                $count{$report{'type'}}++;
                $dates{$report{'date'}}{$report{'type'}}++;
                if($report{'type'} =~ "imp") { $report{'month_imp'}++; }
                if($report{'type'} =~ "click") { $report{'month_clicks'}++; }
              }
           close(LOG);
       }
   }

   if ( $totals{'Impressions'} >= 1 ) { 
      $report{'pct'} = $totals{'Clicks'} / $totals{'Impressions'};
      $report{'pct'} = $report{'pct'}*100;
   }
   else { $report{'pct'} = "0.00"; }

   if ( $report{'month_imp'} >= 1 ) { 
      $report{'mpct'} = $report{'month_clicks'} / $report{'month_imp'};
      $report{'mpct'} = $report{'mpct'}*100; 
   }
   else { $report{'mpct'} = "0.00"; }
        
   $report .= "<TD VALIGN=\"top\">\n";
   $report .= "<H3>Grand Total: $totals{'Impressions'} Impressions / $totals{'Clicks'} Clicks \n";
   $report .= sprintf ("( %2.2f \% )\n", $report{'pct'});
   $report .= "<BR><FONT COLOR=\"blue\">Credits: $account{'credits'}</FONT>\n" if($account{'expiration_type'} eq "exchange");
   $report .= "</H3>\n";
   $report .= "<BLOCKQUOTE>\n";
   $report .= "<H4>Totals for <B>$input{'month'} $input{'year'}</B>:<BR>Impressions: $report{'month_imp'}<BR>Clicks: $report{'month_clicks'}<BR>Rate: \n";
   $report .= sprintf ("( %2.2f \% )\n", $report{'mpct'});
   $report .= "</H4>\n";
   $report .= "<CENTER><b>$report{'EXMSG'}</b></CENTER><BR>\n";
   $report .= "<TABLE BORDER=0><TR><TD>\n";
   $report .= "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=5>\n";
   $report .= "<TR BGCOLOR=\"$global{'title_color'}\">\n";
   $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\">Date</TD>\n";
   $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\">Impressions</TD>\n";
   $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\">Clicks</TD>\n";
   $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\">PCT</TD></TR>\n";

   foreach $date ( sort keys %dates ) {
          $date1=$date;
          $date1 =~ s/_/\//g;

          if ($input{'MODE'} eq "admin") {
             $link = "$PROG_URL?campaign=$input{'campaign'}&action=detail&date=$date&MODE=admin";
          }
          else {
             $link = "$PROG_URL?campaign=$input{'campaign'}&action=detail&date=$date&login_id=$input{'login_id'}&password=$input{'password'}";
          }

          $report .= "<TR BGCOLOR=\"$global{'win_color'}\">\n";
          $report .= "<TD><center><FONT FACE=\"$global{'font_face'}\" COLOR=\"$global{'text_color'}\">\n";
 
          if ($dates{$date}{"click"} >= 1) {
             $report .= "  <a href=\"$link\"><B>$date1</B></a></center></TD>\n";
          }
          else {
             $report .= "  <B>$date1</B></center></TD>\n";
          }
 
          $report .= "<TD><FONT FACE=\"$global{'font_face'}\" COLOR=\"$global{'text_color'}\">$dates{$date}{'impression'}</TD>\n";
          $report .= "<TD><FONT FACE=\"$global{'font_face'}\" COLOR=\"$global{'text_color'}\">$dates{$date}{'click'}</TD>\n";
 
          if ( $dates{$date}{'impression'} <= 0 ) { $dates{$date}{'impression'} = 1; }
          $report{'pct'} = $dates{$date}{'click'} / $dates{$date}{'impression'};
          $report{'pct'} = $report{'pct'}*100;
          if ($report{'pct'} >= 2) { $report{'pct_color'} = "blue"; }
          elsif ($report{'pct'} >= 1 ) { $report{'pct_color'} = "black"; }
          else { $report{'pct_color'}="red"; }

          $report .= sprintf ("<TD><FONT FACE=\"$global{'font_face'}\" COLOR=\"$report{'pct_color'}\">%2.2f \%</TD></TR>\n", $report{'pct'});
   }
   $report .= "</TABLE>\n";
   $report .= "</TD></TR></TABLE><BR><BR></TD></TR></TABLE></TD></TR></TABLE>\n";

   return($report);
}

sub Account_Detail {

   my %refs;
   my $refpage;
   my $report;

   undef $report{'imp_referer'};
   undef $report{'clk_referer'};
   undef $report{'totals'};

   $report{'clk_count'} = 0;
   $report{'tot_count'} = 0;
   $report{'imp_count'} = 0;

   my @dl=split(/_/,$input{'date'});
   my $df = "$dl[0]_$dl[2]";
   my $click_file = "$data_dir/bannermaster/logs/$input{'campaign'}.$df.log";

   if($global{'DB_Format'} eq "SQL") { 
      $SQL = "SELECT referer, count(*) FROM bm_click_stats WHERE account='$input{'campaign'}' AND click_date='$input{'date'}' GROUP BY referer ORDER BY REFERER";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) { 
            $refs{$rows[0]}=$rows[1];
        }
   }
   else { 
      ### Tally the daily clicks ###
      open ("CLK","$click_file");
        while(<CLK>) {
          ($report{'type'},$report{'date'},$report{'time'},$report{'ref'}) = split(/\|/,$_);
    
          if(! $report{'ref'}) { $report{'ref'} = "NO Referring Page (Internal)"; } 
          if($report{'type'} eq "click" && $report{'date'} eq $input{'date'}) { $refs{$report{'ref'}}++ }           
        }
      close(CLK);
   }

       $input{'campaign'} =~ s/_/ /g;
  
       $report .= "<TD VALIGN=\"top\">\n";
       $report .= "<CENTER><H3>Click Report.... $input{'campaign'}</H3>\n";

       $report .= "<TABLE BORDER=1><TR><TD>\n";
       $report .= "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>\n";
       $report .= "<TR BGCOLOR=\"$global{'title_color'}\">\n";
       $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\"><CENTER><U>Page</TD>\n";
       $report .= "<TD><FONT COLOR=\"$global{'ttxt_color'}\" FACE=\"$global{'font_face'}\"><CENTER><U>Clicks</TD></TR>\n";

       foreach $refpage(keys %refs) {
          $report .= "<TR BGCOLOR=\"$global{'win_color'}\">\n";
          $report .= "<TD><center><FONT FACE=\"$global{'font_face'}\" COLOR=\"$global{'text_color'}\">\n";
          $report .= "<A HREF=\"$refpage\">$refpage</A></center></TD>\n";
          $report .= "<TD><FONT FACE=\"$global{'font_face'}\" COLOR=\"$global{'text_color'}\">$refs{$refpage}</TD></TR>\n";
 
       }

       $report .= "</TABLE>\n";
       $report .= "</TD></TR></TABLE><BR><BR></TD></TR></TABLE></TD></TR></TABLE>\n";

   return($report);


}


sub GetLogin {


    my $report .= <<DONE;

        <CENTER>
        <BR><BR><BR>
        <TABLE BORDER=2 CELLSPACING=0 CELLPADDING=0>
          <TR><TD> 

        <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
          <TR><TD> 
            <TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH="100%">
               <TR BGCOLOR="$global{'title_color'}"><TD> 
               <FONT FACE="$global{'font_face'}" COLOR="$global{'ttxt_color'}" SIZE=+1>Enter Login Information
            </TD><TR></TABLE>
          </TD></TR>

          <TR><TD> 
            <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="100%"><TR BGCOLOR="$global{'win_color'}"><TD> 
              <FONT COLOR="$global{'text_color'}"><FORM ACTION="$PROG_URL" METHOD="post">
              <PRE>
     Login Name  : <INPUT NAME="login_id">
     Password    : <INPUT TYPE="password" NAME="password"></PRE>
            <CENTER><INPUT TYPE="submit" NAME="action" VALUE="Login"></CENTER></FORM>
            </TD><TR></TABLE>

        </TD><TR></TABLE>
        </TD><TR></TABLE>
DONE

   return($report);

}




sub Validate_Login {

   my($afield);

   if($global{'DB_Format'} eq "SQL") {
      $SQL = "SELECT * FROM accounts WHERE acct_id = '$input{'login_id'}'";
         $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
         $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
         while ($results = $sth->fetchrow_hashref) { 
            foreach $field (@{$sth->{NAME}} ) {
               $afield = lc($field);
               $account{$afield}=$results->{$field};
            }
         }
   }

   else {

     $report{'afile'} = "$data_dir/bannermaster/accounts/$input{'login_id'}.dat";

     open(FILE,"$report{'afile'}");
           while(<FILE>) {
             chomp;
             ($var,$val)=split(/\=/,$_,2);
             $var=~s/^\s+//g;
             $var=~s/\s+$//g;
             $val=~s/^\s+//g;
             $val=~s/\s+$//g;
             $account{$var}=$val;
           } 
    close(FILE);
  }

  ## Bail out on a bad login.
  if ( $input{'login_id'} ne $account{'acct_id'} || $input{'password'} ne $account{'acct_password'} ) { 
      IWEB::iWeb_Header( IWEB::ERROR("Access for $input{'login_id'} denied.") );
      IWEB::Quit();
  }

}


sub Get_Campaign_List {


   my ($clist,@files,@campaigns);

   if($global{'DB_Format'} eq "SQL") { 
    
      $SQL = "SELECT account FROM campaigns WHERE login = '$input{'login_id'}'";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) {  
           $clist .= qq! <OPTION VALUE="$rows[0]">$rows[0]</OPTION> !;
           push @campaigns, $rows[0];
        }

   }

   else {
      opendir(FILES, "$data_dir/bannermaster/campaigns/");
        @files=readdir(FILES);
      closedir(FILES);

      foreach $file(@files) { 
         if($file =~ /\.dat/) { 
            $report{'afile'} = "$data_dir/bannermaster/campaigns/$file";
            open(FILE,"$report{'afile'}");
              while(<FILE>) {
                chomp;
                ($var,$val)=split(/\=\=/,$_,2);
                $var=~s/^\s+//g;
                $var=~s/\s+$//g;
                $val=~s/^\s+//g;
                $val=~s/\s+$//g;
                $account{$var}=$val;
              } 
           close(FILE);
           if($account{'acct_login'} eq $input{'login_id'}) { 
              $clist .= qq! <OPTION VALUE="$account{'acct_name'}">$account{'acct_name'}</OPTION>!;
              push @campaigns, $account{'acct_name'};
           }
         }
      }
   }


   return($clist,@campaigns);

}


sub Get_Campaign_Info {

   my($results,$field,$afield);

   undef %campaign;

   if($global{'DB_Format'} eq "SQL") { 
    
      $SQL = "SELECT * FROM campaigns WHERE account = '$input{'campaign'}'";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
         while ($results = $sth->fetchrow_hashref) { 
            foreach $field (@{$sth->{NAME}} ) {
               $afield = lc($field);
               $campaign{$afield}=$results->{$field};
            }
         }
         $campaign{'acct_name'} = $campaign{'account'};

   }

   else {
        open(FILE,"$data_dir/bannermaster/campaigns/$input{'campaign'}.dat");
          while(<FILE>) {
            chomp;
            ($var,$val)=split(/\=\=/,$_,2);
            $var=~s/^\s+//g;
            $var=~s/\s+$//g;
            $val=~s/^\s+//g;
            $val=~s/\s+$//g;
            $campaign{$var}=$val;
          } 
       close(FILE);

       open(FILE,"$data_dir/bannermaster/campaigns/$input{'campaign'}.ttl");
          while(<FILE>) {
            chomp;
            ($var,$val)=split(/\=\=/,$_,2);
            $var=~s/^\s+//g;
            $var=~s/\s+$//g;
            $val=~s/^\s+//g;
            $val=~s/\s+$//g;
            $totals{$var}=$val;
          } 
       close(FILE);
   }

}
