#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Bannermaster Click Through Program                               #
# VERSION : 4.00                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

package IWEB;

## These cannot be combined into a single BEGIN, as there are dependencies
## Between them ... this is, and must stay "linear"


BEGIN { 
   use Cwd;
}

BEGIN {
   $directory = cwd;
   push @INC,$directory;
   push @INC,"."; 
   push @INC,"..";
}


BEGIN { 
   use IWeb::iweb;
}


##############################################################################
# BEGIN OF ACTUAL PROGRAM CODE
##############################################################################


  # $debug=1;

  my $CODE;

  IWEB::Read_Config();

  %input = IWEB::parse_form("input");

   if ($global{'DB_Format'} eq "SQL") { IWEB::Click_SQL(); }
   else { IWEB::Click_Ascii(); }

   IWEB::Quit();



sub Click_Ascii {

   if ( $ENV{'HTTP_REFERER'} ) { $bannermaster{'ref'}=$ENV{'HTTP_REFERER'}; }
   else { $bannermaster{'ref'}="No Referrer"; }

   $debug_text = "Referer: $bannermaster{'ref'}<BR>\n";

   $bannermaster{'use_account'} = $input{'account'};
   if($input{'x-factor'}) {
      $bannermaster{'who'} = $ENV{'REMOTE_ADDR'};
       $bannermaster{'xfactor'} = $input{'x-factor'};
       $bannermaster{'clickfile'} = "$data_dir/bannermaster/rotation/$bannermaster{'who'}.$bannermaster{'xfactor'}.click";
       do("$bannermaster{'clickfile'}") || IWEB::bmCLICK_PANIC();
       $debug_text = "Click File: $bannermaster{'clickfile'}<BR>\n";
       $debug_text = "Account: $bannermaster{'use_account'}<BR>\n";
       unlink("$bannermaster{'clickfile'}");
   }

   if (! -e ("$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.dat") ) {
       IWEB::bmCLICK_PANIC();
   }

   if(-e "$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.dat") { 
          open(FILE,"$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.dat");
             while(<FILE>) {
               chomp;
               ($var,$val)=split(/\=\=/,$_,2);
               $var=~s/^\s+//g;
               $var=~s/\s+$//g;
               $val=~s/^\s+//g;
               $val=~s/\s+$//g;
               $bmaccount{$var}=$val;
             } 
          close(FILE);

          open(FILE,"$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.ttl");
             while(<FILE>) {
               chomp;
               ($var,$val)=split(/\=\=/,$_,2);
               $var=~s/^\s+//g;
               $var=~s/\s+$//g;
               $val=~s/^\s+//g;
               $val=~s/\s+$//g;
               $totals{$var}=$val;
             } 
          close(FILE);

   }
   else { IWEB::bmCLICK_PANIC(); }


   ## Log the Click / Referring Page
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if(length($mday) == 1) { $mday = "0$mday"; }
   $month = $mon+1;
   if(length($month) == 1) { $month = "0$month"; }
   $year += 1900;

   $bannermaster{'logname'} = "$month" . "_" . "$year.log";
   $bannermaster{'date_string'} = "$month" . "_" . "$mday" . "_" . "$year";
   $bannermaster{'time'}=time;
   $bannermaster{'filename'} = "$data_dir/bannermaster/logs/$bannermaster{'use_account'}.$bannermaster{'logname'}";

   if(! IWEB::lock($bannermaster{'use_account'})) { IWEB::bmCLICK_PANIC(); }

      open("LOG",">>$bannermaster{'filename'}");
         print LOG "click|$bannermaster{'date_string'}|$bannermaster{'time'}|$bannermaster{'ref'}\n";
      close(LOG);

      $totals{'Clicks'}++;
      $totals{'Impressions'}=0 if(!$totals{'Impressions'});

      open(NEW,">$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.ttl");
        foreach $key(keys %totals) {
           $totals{$key}=~s/^\s+//g;
           $totals{$key}=~s/\s+$//g;
           $key=~s/^\s+//g;
           $key=~s/\s+$//g;
           print NEW "$key==$totals{$key}\n";
           $debug_text .= "Saving: $key=$totals{$key}\n";
        }
      close(NEW);


      if($bmaccount{'expiration_type'} eq "clicks" && $totals{'Clicks'} >= $bmaccount{'num_clicks'}) { 
          open("DIS",">$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.DISABLED");
          close(DIS);
      }

   IWEB::unlock("$bannermaster{'use_account'}");

   if ($debug) { print "Content-Type: text/plain\n\n"; print "Debug ON\n\n"; }
   if($debug) { print "$debug_text\n"; }

   print "Location: $bmaccount{'redirect_url'}\n\n";

   IWEB::Quit(); 

}



sub Click_SQL {

   if($global{'DB_Format'} eq "SQL") { IWEB::SQL_Connect(); }

   if ( $ENV{'HTTP_REFERER'} ) { $bannermaster{'ref'}=$ENV{'HTTP_REFERER'}; }
   else { $bannermaster{'ref'}="No Referrer"; }

   if($input{'x-factor'}) {
       $bannermaster{'who'} = $ENV{'REMOTE_ADDR'} . ":" . $input{'x-factor'};
       $SQL = "SELECT account FROM bm_click WHERE click_key = '$bannermaster{'who'}'";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) {  $bannermaster{'use_account'} = $rows[0]; }

        $SQL = "DELETE FROM bm_click WHERE click_key = '$bannermaster{'who'}'";
        $dbh->do($SQL);
   }
   else {
      $bannermaster{'use_account'} = $input{'account'};
   }


   if (! $bannermaster{'use_account'} ) {
       IWEB::bmCLICK_PANIC();
   }


   ## Log the Click / Referring Page
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if(length($mday) == 1) { $mday = "0$mday"; }
   $month = $mon+1;
   if(length($month) == 1) { $month = "0$month"; }
   $year += 1900;

   $bannermaster{'date_string'} = "$month" . "/" . "$mday" . "/" . "$year";


   ## Insert / Update into the stats table.
   $SQL = "SELECT count(*) FROM bm_stats WHERE account='$bannermaster{'use_account'}' AND stat_date='$bannermaster{'date_string'}'";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) {  $bannermaster{'exists'} = $rows[0]; }

   if($bannermaster{'exists'}) {
     $SQL = "UPDATE bm_stats SET clicks = clicks+1 WHERE account = '$bannermaster{'use_account'}' AND stat_date = '$bannermaster{'date_string'}'";
   }
   else {
     $SQL = "INSERT INTO bm_stats VALUES('$bannermaster{'use_account'}','$bannermaster{'date_string'}',1,0)";
   }
   $dbh->do($SQL);

   ## Log the referer.
   $SQL = "INSERT INTO bm_click_stats VALUES('$bannermaster{'use_account'}','$bannermaster{'date_string'}','$ENV{'HTTP_REFERER'}')";
   $dbh->do($SQL);

   ## Find out where we're going ##
   $SQL = "SELECT clicks_allowed,num_clicks,expiration_type, redirect_url FROM campaigns WHERE account = '$bannermaster{'use_account'}'";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
        while (@rows = $sth->fetchrow_array) {  ($bannermaster{'clicks_allowed'},$bannermaster{'num_clicks'},$bannermaster{'expiration'}, $bannermaster{'location'}) = @rows; }

   ## Disable if need be.
   if ($bannermaster{'expiration'} eq "clicks") {
       $SQL = "UPDATE campaigns SET num_clicks = num_clicks+1 WHERE account = '$bannermaster{'use_account'}'";
       $dbh->do($SQL);
       if( ($bannermaster{'num_clicks'} + 1) >= $bannermaster{'clicks_allowed'}) { 
          $SQL = "DELETE from bm_groups WHERE account='$bannermaster{'use_account'}'";
          $dbh->do($SQL);

          open(DIS,">$data_dir/bannermaster/campaigns/$bannermaster{'use_account'}.DISABLED"); print DIS "$SQL"; close(DIS); 
       }
   }

   if ($debug) { print "Content-Type: text/plain\n\n"; print "Debug ON (SQL)\n\n"; }
   if($debug) { print "$debug_text\n"; }

   print "Location: $bannermaster{'location'}\n\n";

   IWEB::Quit(); 

}


sub bmCLICK_PANIC {

   ### We end up here if there is a bad $ACCOUNT with click.cgi
   ### This will happen if the account is not sent via SSI, a Cookie is not there, or if there
   ### is no file in $data_dir/bannermaster/rotation/ for the users IP Address.

   print "Location: $global{'PANIC_URL'}\n\n";

   IWEB::Quit();
}

