#!/usr/local/bin/perl

##############################################################################
# PROGRAM : iWeb Program Setup.                                              #
# VERSION : 1.00                                                             #
#                                                                            #
##############################################################################
#      ______       __                                                       #
#     /\  _  \     /\ \                __                                    #
#     \ \ \L\ \    \_\ \     ___ ___  /\_\     ___                           #
#      \ \  __ \   /'_` \  /' __` __`\\/\ \  /' _ `\                         #
#       \ \ \/\ \ /\ \L\ \ /\ \/\ \/\ \\ \ \ /\ \/\ \                        #
#        \ \_\ \_\\ \___,_\\ \_\ \_\ \_\\ \_\\ \_\ \_\                       #
#         \/_/\/_/ \/__,_ / \/_/\/_/\/_/ \/_/ \/_/\/_/                       #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

BEGIN { push @INC,"."; }
BEGIN { push @INC,".."; }


   use strict;
   no strict "subs";
   no strict "refs";

   use vars qw (%vars $ISP $helpicon $PROG_URL %global %settings $local_dir $fh %programs %urls %admins $cext $admin $password $key $val $var @dir $directory %input @Fields %ENCODED $action $password %admincookie $temp $temp2 $tester $x $y $data_dir $datapath $ERROR %language %statements);

   use Cwd;
   use File::Copy;

   &parse_form;
   &Var_Setup;

   $helpicon = "$global{'button_dir'}/help-icon.gif";
   $PROG_URL = $ENV{'SCRIPT_NAME'};

   $action = $input{'action'};

   $directory = cwd || ".";

   &Var_Setup;

   if( -e "$data_dir/.complete") {  &setup_complete; }
   else {

      if ($action eq "admin") {&Load_Admin;}
      elsif ($action eq "step2") {&step_2;}
      elsif ($action eq "step3") {&step_3;}
      elsif ($action eq "step4") {&step_4;}
      elsif ($action eq "step5") {&step_5;}
      elsif ($action eq "step6") {&step_6;}
      elsif ($action eq "step7") {&step_7;}
      elsif ($action eq "step8") {&step_8;}
      elsif ($action eq "step9") {&step_9;}
      else { &step_1; }

   }

   exit 0;


sub Load_Admin {

   open("DONE", ">$data_dir/.complete");
     print DONE localtime, "\n";
     print DONE $ENV{'REMOTE_ADDR'};
   close(DONE);

   my $err = $!;

   if(-e "$data_dir/.complete") { 
      print "Location: admin.cgi?action=login&password=$global{'admin_pw'}\n\n";
   }
   else {
      &setup_error( "There was an error creating the setup status file: <BLOCKQUOTE>$err</BLOCKQUOTE>" );
   }

   exit 0;

}

sub setup_complete {

    print "Content-Type: text/html\n\n";
    print &setup_header("Setup Message");

    print qq~
       It appears that you have already run the setup program. <BR><BR>

       There is no need to run it a second time, once completed.  All functionality
       provided here is now available to you from the admin center.

    ~;

    print &setup_footer;

    exit 0;

}

sub setup_error {

    my $output = shift;

    print "Content-Type: text/html\n\n";
    print &setup_header("ERROR");
    print $output;
    print &setup_footer;

    exit 0;

}


## Check for proper modules and server compatibility
sub step_1 {

   my $errors = 0;

   my $output = qq!
      The first step in setting up your system is to ensure that your
      server is compatible with the needs of the program...<BR><BR>
      <TABLE BORDER=0 WIDTH=90% ALIGN="CENTER" CELLSPACING=5>
        
   !;

   ## Perl 5
   if ($] < 5) {
       $output .= "<TR><TD VALIGN=top><LI>Perl 5</TD><TD><font color=red>You must be running Perl, version 5 or higher.</font>  A possible cause for this error is that the !# line at the top of this program is not properly pointing to the perl 5 interpreter on your server.  Try changing it to one of the following: <B>#!/usr/local/bin/perl #!/usr/bin/perl or #!/usr/bin/perl5.  If you still have problems, contact your ISP for assistance in finding the correct path.</TD></TR>";
       $errors = 1;
   }
   else { $output .= "<TR><TD VALIGN=top><LI>Perl 5</TD><TD><font color=blue>present</font>.</TD></TR>"; }
   
   ## File::Copy
   eval "use File::Copy";
   if ($@) {
       $output .= qq!
           <TR><TD VALIGN=top><LI>File::Copy</TD>
               <TD>
               <font color=red>not accessible</font> from this server. This can cause administrative problems.
               <BR><BR>
               File::Copy is a relatively standard perl 5 module that should have been included with your system
               by default.  We make use of it to assist the programs in making solid backups of data files as they
               are being updated.  Much of the system will not work without this module, so please ensure that it
               is installed asap.
            </TD></TR>
       !;
       $errors = 1;
   }
   else { $output .= "<TR><TD VALIGN=top><LI>File::Copy</TD><TD><font color=blue>present</font>.</TD></TR>"; }

   ## cwd
   eval "use Cwd";
   if ($@) {
       $output .= qq!
           <TR><TD VALIGN=top><LI>Cwd</TD>
               <TD>
               <font color=red>not accessible</font> from this server. This can cause directory lookup problems.
               <BR><BR> 
               We use the "cwd" perl library to determine system pathnames.  This enables the programs to feel their
               environment,and use the local filesystem natively.  This module ships standard with Perl 5, so the
               fact that it's comming up as missing points to a possibly larger problem, such as an incomplete installation
               of perl and it's default libraries.  We recommend that you contact your system administrator as soon as possible.
           </TD></TR>
       !;
       $errors = 1;
   }
   else {
       my $pathname = cwd;
       $output .= "<TR><TD VALIGN=top><LI>Cwd</TD><TD><font color=blue>present</font>. (Feels like current path is $pathname ???)</TD></TR>";
   }


   ## DB_File
   eval "use DB_File";
   if ($@) {
       $output .= qq!
           <TR><TD VALIGN=top><LI>DB_File</TD>
               <TD>
               <font color=red>not accessible</font> from this server.<BR><BR>
               There are a few pieces of data that the system will store on your server in "DBM" format.   DBM is a 
               method that perl (via the DB_File module) uses to store large data structures to the hard drive in a 
               binary format, making them quickly and natively accessible.   DB_File is available free from CPAN (Link below)
               and is quite easy to install, assuming that your server is setup with the "Berkley DB" database, which you
               can obtain from <A HREF="http://www.sleepycat.com" TARGET="new">http://www.sleepycat.com</A>
           </TD></TR>
       !;
       $errors = 1;
   }
   else { $output .= "<TR><TD VALIGN=top><LI>DB_File</TD><TD><font color=blue>present</font>, you may use the binary database format.</TD></TR>"; }

   
   ## If they have SQL Manager, then we need to run the SQL tests ..... 
   if( $programs{'SQL'} ) {
      ## DBI
      eval "use DBI";
      if ($@) {
          $output .= qq!
            <TR><TD VALIGN=top><LI>DBI</TD>
                <TD><font color=red>not accessible</font> from this server. <BR>
                DBI is the perl equivalent of Windows' ODBC.  It allows the programs to "talk" to SQL databases
                without it, you will be unable to use an SQL database with your program.  For more information
                about DBI or to obtain drivers, 

            </TD></TR>
          !;
          $errors = 1;
      }
      else { $output .= "<TR><TD VALIGN=top><LI>DBI</TD><TD><font color=blue>present</font>.... SQL OK</TD></TR>"; }


      if($input{'driver'}) { 
         ## DBD::driver
         eval "use DBD::$input{'driver'}";
         if ($@) {
             $output .= qq!
                <TR><TD VALIGN=top><LI>DBD::$input{'driver'}</TD>
                   <TD> 
                   <font color=red>not accessible</font> from this server. You may not use the $input{'driver'} Database
                   DBD is the sister library to DBI.  Perl uses DBD Drivers to talk to the SQL Database through DBI.
                   without it, you will be unable to use an SQL database with your program.  For more information
                   about DBD drivers, and to download them, 
                   please visit <A HREF="http://www.symbolstone.org/technology/perl/DBI" TARGET="new">http://www.symbolstone.org/technology/perl/DBI</A>
                </TD></TR>
             !;
             $errors = 1;
         }
         else { $output .= "<TR><TD VALIGN=top><LI>DBD::$input{'driver'}</TD><TD><font color=blue>present</font>.... $input{'driver'} OK</TD></TR>"; }
      }
      else { 
         $output .= qq!
            <FORM ACTION="$PROG_URL">
            <TR><TD COLSPAN=2><HR>Please select the appropriate database driver that the program will use to connect to the your SQL database<P></TD></TR>
            <TR><TD VALIGN="top"><LI>Database</TD>
                <TD>
                  <SELECT NAME="driver">
                      <OPTION VALUE="mysql">mysql</OPTION>
                      <OPTION VALUE="Informix">Informix</OPTION>
                      <OPTION VALUE="oracle">oracle</OPTION>
                      <OPTION VALUE="Pg">Pg</OPTION>
                      <OPTION VALUE="sybase">sybase</OPTION>
                      <OPTION VALUE="ODBC">ODBC</OPTION>
                      <OPTION VALUE="InterBase">InterBase</OPTION>
                  </SELECT>
                  <INPUT TYPE="hidden" NAME="action" VALUE="step1">
                  <INPUT TYPE="submit" VALUE="Validate">
                </TD>
             </TR>
             </FORM>
         !;
         $errors = 2;
      }

   }

   if($errors == 1) { 
      $output .= qq!
         <TR><TD COLSPAN=2><BR><BR><B>There were errors encountered in validating your server setup.  Please correct them, and then try running setup again<BR><BR>
             If you are missing any of the required modules, you can obtain them at a number of locations on the internet.
                If your webserver is Unix/Linux based, then visit the Perl CPAN Archive directly at
                <A HREF="http://search.cpan.org" TARGET="new">http://search.cpan.org</A><BR><BR>
                If you are planning to run the programs on an NT server, you should vist the
                <A HREF="http://www.activestate.com/PPMPackages/" TARGET="new">Active State PPM Repository</a>
                to obtain easy to install verisons of all perl modules specifically for NT Servers.
           <BR><BR></B></TD></TR>
      !;
   }
   elsif ($errors == 2) { }
   else {
      $output .= "<TR><TD COLSPAN=2><BR><BR><B>Everything looks good.....<BR><BR><CENTER><A HREF='setup.cgi?action=step2&driver=$input{'driver'}'>Move On to Step 2</A><BR><BR><B/></TD></TR>";
   }

   $output .= "</TABLE>";

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 1");
    print $output;
    print &setup_footer;

    exit 0;

}


sub step_2 {

    my $output = "";

    if( $programs{'SQL'} ) {  $output = &sql_setup; }
    else { $output = &basic_options; }

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 2");
    print $output;
    print &setup_footer;

    exit 0;

}

sub step_3 {

    my $output = "";

    if( $programs{'SQL'} ) {  $output = &sql_test; }
    else { $output = &admin_password; }

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 3");
    print $output;
    print &setup_footer;

    exit 0;

}



sub step_4 {

    my $output = "";

    if( $programs{'SQL'} ) {  $output = &sql_finish; }
    else { $output = &save_config; }

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 4");
    print $output;
    print &setup_footer;

    exit 0;

}



sub step_5 {

    my $output = &basic_options;

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 5");
    print $output;
    print &setup_footer;

    exit 0;

}


sub step_6 {

    my $output = &admin_password; 

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 6");
    print $output;
    print &setup_footer;

    exit 0;

}

sub step_7 {

    my $output = &save_config;

    print "Content-Type: text/html\n\n";
    print &setup_header("Step 6");
    print $output;
    print &setup_footer;

    exit 0;

}




sub basic_options {

    ## Detect Sendmail, setup the CGI Directory, find Images Directory

    my $sendmail = "";

    if( ! $input{'to'} ) { 
       return qq!
        This step of the setup program will configure and test the email
        capabilities of your server.  Please enter your email address in
        the space provided below.<HR>
        <FORM ACTION="$PROG_URL" METHOD="POST">
           <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
           <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
           <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
           <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
           <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
           <INPUT TYPE="hidden" NAME="action" VALUE="$action">
           Email Address: <INPUT NAME="to">
           <CENTER> 
           <INPUT TYPE="submit" VALUE="Test Sendmail">
           </CENTER> 
        </FORM>
       !;
    }


    if( $input{'sendmailok'} != 1) { 

       my $sbin = `ls /usr/sbin/sendmail`;
       my $lib = `ls /usr/lib/sendmail`;
       my $bin = `ls /bin/sendmail`;
       my $in = `ls $input{'sendmailpath'}` if($input{'sendmailpath'});

       if($input{'sendmailok'} == 2) { $sendmail = "FAILURE"; }
       elsif($input{'sendmailpath'} && $in =~ "$input{'sendmailpath'}")  { $sendmail = "$input{'sendmailpath'}"; }
       elsif($sbin   =~ "/usr/sbin/sendmail") { $sendmail = "/usr/sbin/sendmail"; }
       elsif($lib =~ "/usr/lib/sendmail")  { $sendmail = "/usr/lib/sendmail"; }
       elsif($bin =~ "/bin/sendmail")      { $sendmail = "/bin/sendmail"; }
       else { $sendmail = "FAILURE"; }
   
       if($sendmail ne "FAILURE") { 
          open(MAIL, "| $sendmail -t"); 
             print MAIL "To: $input{'to'}\n";
             print MAIL "From: $input{'to'}\n";
             print MAIL "Subject: Testing Sendmail\n\n";
             print MAIL "Test successful, using $sendmail as our sendmail program\n";
          close(MAIL);

          my $newaction = "";
          if( $programs{'SQL'} ) {  $newaction = "step6"; }
          else { $newaction = "step3"; }
   
          return qq!
             Wait about 5 minutes and Check your email.  You should receive an email
             from your server, which will indicate if our test was successful.  Please click
             the appropriate button below to tell the setup program whether or not it can
             continue.
             <HR>
             <TABLE BORDER=0 ALIGN="CENTER">
             <TR>
               <FORM ACTION="$PROG_URL" METHOD="POST">
               <TD>
                   <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
                   <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
                   <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
                   <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
                   <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
                   <INPUT TYPE="hidden" NAME="action" VALUE="$newaction">
                   <INPUT TYPE="hidden" NAME="to" VALUE="$input{'to'}">
                   <INPUT TYPE="hidden" NAME="sendmailpath" VALUE="$sendmail">
                   <INPUT TYPE="hidden" NAME="sendmailok" VALUE="1">
                   <CENTER> 
                   <INPUT TYPE="submit" VALUE="Mail was sent OK">
                   </CENTER> 
               </TD>
               </FORM>
               <FORM ACTION="$PROG_URL" METHOD="POST">
               <TD>
                   <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
                   <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
                   <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
                   <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
                   <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
                   <INPUT TYPE="hidden" NAME="action" VALUE="$action">
                   <INPUT TYPE="hidden" NAME="to" VALUE="$input{'to'}">
                   <INPUT TYPE="hidden" NAME="sendmailpath" VALUE="">
                   <INPUT TYPE="hidden" NAME="sendmailok" VALUE="2">
                   <CENTER> 
                   <INPUT TYPE="submit" VALUE="Mail was not sent">
                   </CENTER> 
               </TD>
               </FORM>
             </TR>
             </TABLE>
          !;
       }
       else { 
          return qq!
           There was an error in detecting the sendmail program on your server.
           Please enter the path to sendmail in the space provided below:
           <HR>
           <FORM ACTION="$PROG_URL" METHOD="POST">
              <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
              <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
              <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
              <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
              <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
              <INPUT TYPE="hidden" NAME="action" VALUE="$action">
              <INPUT TYPE="hidden" NAME="to" VALUE="$input{'to'}">
              Sendmail Location: <INPUT NAME="sendmailpath">
              <CENTER> 
              <INPUT TYPE="submit" VALUE="Test Sendmail">
              </CENTER> 
           </FORM>
          !;
       }

    }

}



sub admin_password {


   my(@chars,$change_password,$i,$newaction);

   @chars=("a".."n","p".."z",1..9);
   srand( time() ^ ($$ + ($$ << 15)) );
   $change_password="";
   for ($i=1;$i<=12;$i++){
        $change_password .= $chars[rand(@chars)];
   }

   if( $programs{'SQL'} ) {  $newaction = "step7"; }
   else { $newaction = "step4"; }
   
   return qq!
      The main admin center requires a password for access.  Setup has
      generated one for you, which is presented in the input field below.
      You may accept this random password, or pick your own at this time.
      Each time you reload this screen a new random password will be generated.
      <BR><BR>
      Regardless of which password you choose, it's important that you 
      write it down, and do not forget it, otherwise, you'll not be able
      to login to the administrative programs.
      <HR>
        <FORM ACTION="$PROG_URL" METHOD="POST">
            <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
            <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
            <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
            <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
            <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
            <INPUT TYPE="hidden" NAME="action" VALUE="$newaction">
            <INPUT TYPE="hidden" NAME="to" VALUE="$input{'to'}">
            <INPUT TYPE="hidden" NAME="sendmailpath" VALUE="$input{'sendmailpath'}">
            <CENTER> 
            Admin Password: <INPUT NAME="admin_pw" VALUE="$change_password">
            <INPUT TYPE="submit" VALUE="Set Password">
            </CENTER> 
        </FORM>
   !;

}


sub save_config {


   $global{'email'} = $input{'to'};
   $global{'mail_cmd'} = "$input{'sendmailpath'} -t";
   $global{'admin_pw'} = $input{'admin_pw'};
   $global{'dbusername'} = $input{'dbuser'};
   $global{'dbname'} = $input{'dbname'};
   $global{'dbhost'} = $input{'dbhost'};
   $global{'dbpassword'} = $input{'dbpass'};
   $global{'sql_driver'} = $input{'driver'};
   if($programs{'SQL'}) { $global{'DB_Format'} = "SQL"; }
   else { $global{'DB_Format'} = "IWeb"; }

   open (FILE, "> $data_dir/global.config") || return("There was an error in saving your configuration to $data_dir/global.config: <BLOCKQUOTE><FONT COLOR=red>$!</FONT></BLOCKQUOTE>  Please rectify the problem, and reload this screen.  Do  not close this browser window, or all of the setup settings to this point will be lost.<BR><BR>Most likely, you have a permissions problem, in which case we recommend that you ensure that your data directory and global.config file (given above) have full (777) permissions.");
       foreach my $value(keys %global) {
           print FILE "$value=$global{$value}\n" if($value);
       }
   close(FILE);


   return qq!
     <B>Options Saved in $data_dir/global.config</B><BR><BR>
     Setup is now complete.  Please click the link below to login to your administrative program.
     <BR><BR>
     <CENTER>
      <A HREF="$PROG_URL?action=admin">Admin Center</A>
     </CENTER>
   !;

}

sub sql_setup {

    return qq!

        Next, we must ensure that the program is able to connect to the database, and
        perform basic operations on it.   Please enter the requested information below.<HR>
        <FORM ACTION="$PROG_URL" METHOD="POST">
        <TABLE WIDTH=90% ALIGN="CENTER">
               <TR><TD>Database Hostname: </TD><TD><INPUT NAME="dbhost" VALUE="localhost"SIZE=15></TD></TR>
               <TR><TD>Database Name:     </TD><TD><INPUT NAME="dbname" SIZE=15></TD></TR>
               <TR><TD>Database Userid:   </TD><TD><INPUT NAME="dbuser" SIZE=15></TD></TR>
               <TR><TD>Database Password: </TD><TD><INPUT NAME="dbpass" SIZE=15></TD></TR>
        </TABLE> 
        <CENTER>
            <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
            <INPUT TYPE="hidden" NAME="action" VALUE="step3">
            <INPUT TYPE="submit" VALUE="Perform SQL Validation">
        </CENTER>
        </FORM> 
    !;

}


sub sql_test {

   my($driver_string,$user,$dbh,$sth,$rc,$SQL);      

   eval("use DBI");

   if($input{'dbhost'} && $input{'dbhost'} ne "localhost") {  
      $driver_string = "dbi:$input{'driver'}:$input{'dbname'}:$input{'dbhost'}";
   }
   else {
      $driver_string = "dbi:$input{'driver'}:$input{'dbname'}";
   }

   if($input{'driver'} eq "InterBase") { $driver_string .= ";ib_dialect=3"; }

   my $totalfailure = 0;
   my $errors = 0;

   my $SQLTEST = '';
   $dbh = DBI->connect($driver_string,"$input{'dbuser'}","$input{'dbpass'}") || return( &setup_error( "There was an error connecting to your database: <BLOCKQUOTE><FONT COLOR=red>$DBI::errstr ($DBI::err)</FONT></BLOCKQUOTE>Please correct the error, and rerun the setup program" ) );

   # $dbh->{AutoCommit} = 0;
   unlink("./dbi.trace");
   DBI->trace(2, "./dbi.trace");


      ### CREATE TABLE
        $SQL = qq! CREATE TABLE dummy (testfield CHAR(5) NOT NULL, dummyfield CHAR(10)) !;
        unless ( $dbh->do($SQL) ) { 
           my $err =  qq!
              There was an error in creating a new table in this database
              <BR><BR>
              The SQL Server returned the following error:
              <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
              Please correct the error, and rerun the setup program.
           !;
           return( &setup_error($err) );
        }
      
      ### CREATE INDEX (1) 
        $SQL = qq! CREATE INDEX tdx1 ON dummy(testfield) !;
        unless ( $dbh->do($SQL) ) { 
           my $err =  qq!
              There was an error in creating a new index in this database
              <BR><BR>
              The SQL Server returned the following error:
              <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
              Please correct the error, and rerun the setup program.
           !;
           return( &setup_error($err) );
        } 

      ### CREATE INDEX (2) 
        $SQL = qq! CREATE INDEX tdx1 ON dummy(testfield) !;
        if ( $dbh->do($SQL) ) { 
           my $err = qq!
               As a part of the SQL Validation, we attempt to create duplicate indexes
               in the database, in an attempt to see whether or not your database user
               has the permimssion to create indexes at all.  Under normal circumstances,
               creation of a duplicate index would result in an "Index already exists" error.
               However, in your case, it appears that no error was generated, which indicates 
               the possibiilty that your database userid may not have "index" permissions.<BR><BR>
               We highly recommend that your sysadmin or ISP add "Index, Drop, Delete" permissions
               to your userid, so that the programs will have full control over their own data.
               <BR><BR>
               Once this situation has been rectified, rerun the setup program.
           !;
           return( &setup_error($err) );
        }

   
      ## INSERT ROW
        $SQL = qq! INSERT INTO dummy VALUES('test','123') !;
        unless ( $dbh->do($SQL) ) { 
           my $err =  qq!
              There was an error inserting a record into the datbase....
              <BR><BR>
              The SQL Server returned the following error:
              <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
              Please correct the error, and rerun the setup program.
           !;
           return( &setup_error($err) );
        }
   
      ## SELECT ROW
        $SQL = qq! SELECT * FROM dummy !;
           $sth = $dbh->prepare($SQL);
           $rc = $sth->execute;
           while ( my($f1,$f2) = $sth->fetchrow_array ) {
              unless ($f1 =~ /test/i) { 
                 my $err =  qq!
                    There was an error retrieving a record from the datbase.  This could
                    be a result of it not being properly inserted, or some other SQL sysme flaw.
                    <BR><BR>
                    The SQL Server returned the following error:
                    <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
                    Please correct the error, and rerun the setup program. ($f1)
                 !;
                 return( &setup_error($err) );
              }
              last;
           }
   
   
      ## DELETE ROW
        $SQL = qq! DELETE FROM dummy !;
        unless ( $dbh->do($SQL) ) { 
           my $err =  qq!
              There was an error deleting a record from the datbase....
              <BR><BR>
              The SQL Server returned the following error:
              <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
              Please correct the error, and rerun the setup program.
           !;
           return( &setup_error($err) );
        }
   
        $SQL = qq! SELECT * FROM dummy !;
           $sth = $dbh->prepare($SQL);
           $rc = $sth->execute;
           while ( my($f1,$f2) = $sth->fetchrow_array ) {
             if ($f1 =~ /test/i) { 
              my $err =  qq!
                 There was an error deleting a record from the datbase.  We attempted to delete
                 a known entry, and discovered that the entry was still there.  It's possible
                 that your database user does not have "DELETE" permissions.
                 We highly recommend that your sysadmin or ISP add "Index, Drop, Delete" permissions
                 to your userid, so that the programs will have full control over their own data.
                 <BR><BR>
                 The SQL Server returned the following error:
                 <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
                 Please correct the error, and rerun the setup program.
              !;
              return( &setup_error($err) );
             }
             last;
           }
   
   
   
      ## DROP TABLE
        $SQL = qq! DROP TABLE dummy !;
        unless ( $dbh->do($SQL) ) { 
           my $err = qq!
               As a part of the SQL Validation, we attempt to drop a table that we've created
               in the database.
               It is possible that your database userid may not have "index" permissions.<BR><BR>
               We highly recommend that your sysadmin or ISP add "Index, Drop, Delete" permissions
               to your userid, so that the programs will have full control over their own data.
               <BR><BR>
               The SQL Server returned the following error:
               <BLOCKQUOTE><FONT COLOR=red><B>Failure: $DBI::errstr ($DBI::err)</B></FONT></BLOCKQUOTE>
               Please correct the error, and rerun the setup program.
           !;
           return( &setup_error($err) );
        }
   
   

      $dbh->disconnect;

      return qq!
        <B>Everything seems to checkout with your SQL Database.</b>  We were able to create a table with an index,
        insert a record, select that record from the database, delete the record, and also drop the table. 
        At this point, you may continue the setup of your system.<HR>

        <FORM ACTION="$PROG_URL" METHOD="POST">
           <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
           <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
           <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
           <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
           <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
           <INPUT TYPE="hidden" NAME="action" VALUE="step4">
           <CENTER> 
           <INPUT TYPE="submit" VALUE="Continue to Step 4">
           </CENTER> 
        </FORM>
      !;

}

sub sql_finish {

   my($driver_string,$user,$dbh,$sth,$rc,$SQL);      

   eval("use DBI");

   if($input{'dbhost'} && $input{'dbhost'} ne "localhost") {  
      $driver_string = "dbi:$input{'driver'}:$input{'dbname'}:$input{'dbhost'}";
   }
   else {
      $driver_string = "dbi:$input{'driver'}:$input{'dbname'}";
   }

   if($input{'driver'} eq "InterBase") { $driver_string .= ";ib_dialect=3"; }

   my $totalfailure = 0;
   my $errors = 0;

   my $SQLTEST = '';
   $dbh = DBI->connect($driver_string,"$input{'dbuser'}","$input{'dbpass'}") || return( &setup_error( "There was an error connecting to your database: <BLOCKQUOTE><FONT COLOR=red>$DBI::errstr ($DBI::err)</FONT></BLOCKQUOTE>Please correct the error, and rerun the setup program" ) );

   # $dbh->{AutoCommit} = 0;
   unlink("./dbi.trace");
   DBI->trace(2, "./dbi.trace");

      ## Build the tables ##
      &SQL_STATEMENTS;
      my $create_log = "";
      foreach my $key(sort keys %statements) {
          $create_log .= qq! <LI><FONT COLOR="black">$key ... </FONT> !;
          if ( $dbh->do($statements{$key}) ) { 
               $create_log .= qq! <FONT COLOR="blue">OK</FONT> !;
          }
          else { $create_log .= "<FONT COLOR=red>Failure: $DBI::errstr ($DBI::err)</FONT>\n"; }
          $create_log .= "<P>";
      }


      $dbh->disconnect;

      return qq!
        <B>Setup has attempted to creae the tables in your SQL Database.</B>   Please review the below output
        to see the results.  Report any errors to iWeb Support before continuing.
        <BLOCKQUOTE>
          $create_log
        </BLOCKQUOTE>

        <FORM ACTION="$PROG_URL" METHOD="POST">
           <INPUT TYPE="hidden" NAME="driver" VALUE="$input{'driver'}">
           <INPUT TYPE="hidden" NAME="dbhost" VALUE="$input{'dbhost'}">
           <INPUT TYPE="hidden" NAME="dbname" VALUE="$input{'dbname'}">
           <INPUT TYPE="hidden" NAME="dbuser" VALUE="$input{'dbuser'}">
           <INPUT TYPE="hidden" NAME="dbpass" VALUE="$input{'dbpass'}">
           <INPUT TYPE="hidden" NAME="action" VALUE="step5">
           <CENTER> 
           <INPUT TYPE="submit" VALUE="Continue to Step 5">
           </CENTER> 
        </FORM>
      !;



}


sub setup_header {

   my $title = shift;

   return qq!
           <HTML>
           <HEAD>
              <TITLE>$title</TITLE>
              <style type="text/css">A:hover {text-decoration: on; background-color: #DBDBDB; color: #000000;}</style>
              <style>
                 table        { font-family: Arial; font-size: 10pt }
                 td           { font-family: Arial; font-size: 10pt }
                 tr           { font-family: Arial; font-size: 10pt }
              </style>
           </HEAD>
           <BODY BGCOLOR="white" TEXT="#000000" LINK="#0000FF" VLINK="#0000FF">
             <CENTER>
             <TABLE width=500 border=1 cellspacing=0 cellpadding=0 bgcolor="#C0C0C0">
               <TR>
               <TD>
        
                 <TABLE width="100%" border=0 cellpadding=0>
                 <TR>
                   <TD bgcolor="#00007F" colspan=2 height=20>
                     <FONT SIZE=-1 COLOR="FFFFFF" FACE="MS Sans Serif"><B>&#160;$title</B></FONT>
                   </TD>
                 </TR>
        
                 <TR>
                      <TD COLSPAN=2>
                        <FONT FACE="verdana" SIZE=-1>
                        <BR>
    !;



}


sub setup_footer {

    return qq!
                        <BR><BR>
                        </FONT>
                      </TD>
                 </TR>
        
 
               </TABLE>
        
               <TABLE BORDER=1 WIDTH=100% BGCOlOR="#efefef">
               <TR><TD ALIGN="CENTER">
                 <A HREF="http://www.iwebsys.com">iWeb</A> Setup. &copy;2000, iWeb, Inc. 
                 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                 <A HREF="http://www.iwebsupport.com">Technical Support</A>
 
               </TD></TR>
               </TABLE>
           </TD></TR></TABLE>
        
           </BODY>
           </HTML>

    !;

}




sub Var_Setup {

   require("IWeb/data.path");

   open(FILE,"$data_dir/global.config");
      while(<FILE>) {
        chomp;
        ($var,$val)=split(/\=/,$_,2);
        $global{$var}=$val;
      } 
   close(FILE);

   ############################################
   ## What Programs does this user have?
   ############################################

   if ($global{'cgi_extension'} eq "pl") { $cext = "pl"; }
   elsif ($global{'cgi_extension'} eq "exe") { $cext = "exe"; }
   elsif ($global{'cgi_extension'} eq "plx") { $cext = "plx"; }
   else { $cext="cgi"; }
   
   if (-e "$directory/bbs_admin.$cext")   { $programs{'BBS'}++; }
   if (-e "$directory/hf_admin.$cext")    { $programs{'HF'}++; }
   if (-e "$directory/gb_admin.$cext")    { $programs{'GBOOK'}++; }
   if (-e "$directory/cmt_admin.$cext")   { $programs{'COMMENTS'}++; }
   if (-e "$directory/survey_admin.$cext"){ $programs{'SURVEY'}++; }
   if (-e "$directory/builder.$cext")     { $programs{'BUILDER'}++; }
   if (-e "$directory/filex_admin.$cext") { $programs{'FILES'}++; }
   if (-e "$directory/splat_admin.$cext") { $programs{'SPLAT'}++; }
   if (-e "$directory/users.$cext")       { $programs{'USERS'}++; }
   if (-e "$directory/class_admin.$cext") { $programs{'CLASS'}++; }
   if (-e "$directory/mailman.$cext")     { $programs{'MAIL'}++; }
   if (-e "$directory/hs_admin.$cext")    { $programs{'HYPERSEEK'}++; }
   if (-e "$directory/survey_admin.$cext"){ $programs{'SURVEYS'}++; }
   if (-e "$directory/ilink_admin.$cext") { $programs{'ILINK'}++; }
   if (-e "$directory/iseek_admin.$cext") { $programs{'ISEEK'}++; }
   if (-e "$directory/bm_admin.$cext")    { $programs{'BANNERS'}++; }
   if (-e "$directory/ishop_admin.$cext") { $programs{'ISHOP'}++; }
   if (-e "$directory/ring_admin.$cext")  { $programs{'WEBRING'}++; }
   if (-e "$directory/new_admin.$cext")   { $programs{'WHATSNEW'}++; }
   if (-e "$directory/password_admin.$cext")   { $programs{'PASSWORD'}++; }
   if (-e "$directory/jackhammer_admin.$cext")   { $programs{'JACKHAMMER'}++; }
   if (-e "$directory/support_admin.$cext")   { $programs{'SUPPORT'}++; }
   if (-e "$directory/sqlmanager.$cext" && $global{'DB_Format'} eq "SQL")   { $programs{'SQL'}++; }


}


##############################################################################
#                    ____                      _
#                   / __ \ ____ _ _____ _____ (_)____   ____ _
#                  / /_/ // __ `// ___// ___// // __ \ / __ `/
#                 / ____// /_/ // /   (__  )/ // / / // /_/ /
#                /_/     \__,_//_/   /____//_//_/ /_/ \__, /
#                                                    /____/
#
##############################################################################
sub parse_form{

  my($buffer,$name,$value,$encoded_value,$pair);

  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  if (length($buffer) < 5) {
     $buffer = $ENV{QUERY_STRING};
  }
  my @pairs=split(/&/,$buffer);
  foreach $pair(@pairs) {
     ($name, $value)=split(/=/,$pair);
     $encoded_value = $value;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][A-F0-9])/pack("C",hex($1))/eg;
     if($input{$name} eq "") {
	$input{$name} = $value;
	$ENCODED{$name} = $encoded_value;
        push (@Fields,$name);
     }
     else {
  	$input{$name} = $input{$name}." ".$value;
     }
  }

}



sub SQL_STATEMENTS {

   my $x = 100;

   my ($TEXT,$INT);


    if($input{'driver'} eq "Informix") { 
      $TEXT = "CHAR(2000)";
      $INT = "INTEGER";   
    }
    if($input{'driver'} eq "oracle") { 
      $TEXT = "VARCHAR(2000)";
      $INT = "NUMBER";    
    } 
    if($input{'driver'} eq "InterBase") { 
      $TEXT = "VARCHAR(2000)";
      $INT = "INT";
    }
    else {
      $TEXT = "TEXT";
      $INT = "INT";
    }

   ## GENERIC TABLES (All Programs)

   $statements{'Accounts Table'} = qq!
      CREATE TABLE accounts (
        acct_id varchar(80) NOT NULL PRIMARY KEY,
        acct_password varchar(20) NOT NULL,
        acct_type varchar(20),
        contact_email varchar(100),
        url varchar(200),
        contact_name varchar(50),
        address varchar(75),
        city varchar(50),
        state varchar(5),
        zip varchar(10),
        country varchar(30),
        phone varchar(20),
        fax varchar(20),
        sub_threads $TEXT,
        sub_topics $TEXT,
        theme varchar(50),
        days_to_show varchar(5),
        num_posts $INT,    
        num_visits $INT,    
        last_visit $INT,    
        comments $TEXT,
        cc_number varchar(20),
        cc_date varchar(7),
        cc_type varchar(20),
        cc_name varchar(50),
        total_paid decimal(9,2),
        current_balance decimal(9,2),
        last_pd_date varchar(10),
        create_date varchar(10),
        user_icon varchar(128),
        field1 varchar(100),
        field2 varchar(100),
        field3 varchar(100),
        field4 varchar(100),
        field5 varchar(100)
      )
    !;

    $statements{'Accounts Table Value'} = qq!
        INSERT INTO accounts VALUES 
        ('jcokos','johnny','bannermaster','jcokos\@ccs.net','','John Cokos','','','','','','','','','','','',0,0,0,'','','','','',0.00,0.00,'','971287295','','','','','','')
    !;


    $statements{'Inbox Table'} = qq!
      CREATE TABLE acct_inbox (
        msg_id varchar(20) NOT NULL,
        acct_id varchar(20) NOT NULL,
        post_date varchar(20),
        posted_by varchar(20),
        is_read $INT,    
        subject varchar(100),
        msg_text $TEXT
      )
    !;
    $statements{'Inbox Table Index 1'} = qq! CREATE INDEX inbox1 ON acct_inbox(acct_id) !;
    $statements{'Inbox Table Index 2'} = qq! CREATE INDEX inbox2 ON acct_inbox(msg_id) !;



   ## BANNERMASTER TABLES

   $statements{'Bannermaster Click Table'} = qq!
      CREATE TABLE bm_click (
        click_key char(120) NOT NULL,
        account char(50)
      )
   ! if($programs{'BANNERS'});

   $statements{'Bannermaster Click Table Index'} = qq! CREATE INDEX bms_click ON bm_click(click_key) ! if($programs{'BANNERS'});

   $statements{'Bannermaster Click Logger Table'} = qq!
      CREATE TABLE bm_click_stats (
        account char(50) NOT NULL,
        click_date char(15) NOT NULL,
        referer char(224) NOT NULL
      )
   ! if($programs{'BANNERS'});

   $statements{'Bannermaster Click Logger Table Index'} = qq! CREATE INDEX bms_click2 ON bm_click_stats(account,click_date) ! if($programs{'BANNERS'});

   $statements{'Bannermaster Group Def Table'} = qq!
      CREATE TABLE bm_group_def (
        group_name char(120) NOT NULL,
        last_shown $INT
      )
   ! if($programs{'BANNERS'});

   $statements{'Bannermaster Group Def Table Index'} = qq! CREATE INDEX bm_grp_def ON bm_group_def(group_name) ! if($programs{'BANNERS'});


   $statements{'Bannermaster Groups Table'} = qq!
      CREATE TABLE bm_groups (
        group_name char(120) NOT NULL,
        account char(50) NOT NULL
      )
   ! if($programs{'BANNERS'});

   $statements{'Bannermaster Groups Table Index'} = qq! CREATE INDEX bm_grp_acct ON bm_groups(group_name) ! if($programs{'BANNERS'});

   $statements{'Bannermaster Stats Table'} = qq!
      CREATE TABLE bm_stats (
        account char(50) NOT NULL,
        stat_date char(15) NOT NULL,
        clicks $INT,    
        impressions $INT
      )
   ! if($programs{'BANNERS'});

   $statements{'Bannermaster Stats Table Index'} = qq! CREATE INDEX bm_st_acct ON bm_stats(account,stat_date) ! if($programs{'BANNERS'});

   $statements{'Bannermaster Campaigns Table'} = qq!
      CREATE TABLE campaigns (
        account varchar(50) NOT NULL,
        login varchar(50),
        camp_pass varchar(50),
        target varchar(50),
        redirect_url varchar(255),
        alt_text varchar(255),
        under_text varchar(255),
        banner_type varchar(50),
        banner varchar(255),
        width $INT,    
        height $INT,    
        banner_text $TEXT,
        expiration_type varchar(50),
        num_clicks $INT,    
        clicks_allowed $INT,    
        num_impressions $INT,    
        imp_allowed $INT,    
        start_date varchar(15),
        end_date varchar(15)
      )
   ! if($programs{'BANNERS'});


   $statements{'Bannermaster Campaigns Table Index'} = qq! CREATE INDEX bm_acct ON campaigns(account) ! if($programs{'BANNERS'});

   $statements{'Bannermaster Group Def Table Value'} = qq! INSERT INTO bm_group_def VALUES ('default',3) ! if($programs{'BANNERS'});
   $statements{'Bannermaster Groups Table Value 1'} = qq! INSERT INTO bm_groups VALUES ('default','text1') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Groups Table Value 2'} = qq! INSERT INTO bm_groups VALUES ('default','HS') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Groups Table Value 3'} = qq! INSERT INTO bm_groups VALUES ('default','CGIL') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Groups Table Value 4'} = qq! INSERT INTO bm_groups VALUES ('default','CCS') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Campaigns Table Value 1'} = qq! INSERT INTO campaigns VALUES ('CCS','jcokos','','NONE','http://ccs/','CCS','CCS Net','IMAGE','http://www.ccs.net/banners/ccsbanner.gif',468,60,'','clicks',1,1000000,2449,0,'','') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Campaigns Table Value 2'} = qq! INSERT INTO campaigns VALUES ('CGIL','jcokos','','NONE','http://iweb/','CGIL','CGI Local','IMAGE','http://www.ccs.net/banners/cgi_local.jpg',468,60,'','clicks',3,1000000,2449,0,'','') ! if($programs{'BANNERS'});
   $statements{'Bannermaster Campaigns Table Value 3'} = qq! INSERT INTO campaigns VALUES ('HS','jcokos','','NONE','http://hyperseek/','HS','Hyperseeek','IMAGE','http://www.ccs.net/banners/hyperseekbanner.gif',468,60,'','clicks',1,1000000,2458,0,'','') ! if($programs{'BANNERS'});



   ## JACKHAMMER TABLES
      
   $statements{'Jackhammer Deposits Table'} = qq!
      CREATE TABLE acct_deposits (
        acct_id char(20) NOT NULL,
        amount decimal(9,2) NOT NULL,
        tax decimal(9,2)
      )
   ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Deposits Table Index'} = qq! CREATE INDEX hsl_gdep ON acct_deposits(acct_id) ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Finances Table'} = qq!
      CREATE TABLE acct_finances (
        acct_id char(20) NOT NULL,
        deposit_date $INT NOT NULL,
        amount decimal(9,2) NOT NULL,
        tax_amount decimal(9,2),
        source char(50)
      )
   ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Finances Table Index'} = qq! CREATE INDEX hsl_finance ON acct_finances(acct_id,deposit_date) ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Bids Table'} = qq!
      CREATE TABLE jh_bids_pending (
        account char(20) NOT NULL,
        linkid char(20) NOT NULL,
        num_words $INT
      )
   ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Bids Table Index'} = qq! CREATE INDEX jh_bids ON jh_bids_pending(account,linkid) ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Stats Table'} = qq!
      CREATE TABLE go_hits (
        link_id $INT NOT NULL,
        word char(225) NOT NULL,
        price decimal(4,2) NOT NULL,
        hit_date $INT NOT NULL,
        num_hits $INT,    
        affiliate char(50) NOT NULL,
        commission char(10),
        paid_flag char(3)
      )
   ! if($programs{'JACKHAMMER'});

   $statements{'Jackhammer Stats Table Index 1'} = qq! CREATE INDEX hsl_ghits ON go_hits(link_id,hit_date) ! if($programs{'JACKHAMMER'});
   $statements{'Jackhammer Stats Table Index 2'} = qq! CREATE INDEX hsl_ghits2 ON go_hits(affiliate,hit_date) ! if($programs{'JACKHAMMER'});




   ## AFFILIATE TABLES 

   $statements{'Affiliate Access Table'} = qq!
      CREATE TABLE affiliate_access (
        affiliate char(80),
        ip_number char(30) NOT NULL,
        link_id $INT NOT NULL,
        link_id_count $INT,    
        search_terms char(150) NOT NULL,
        num_searches $INT
      )
   ! if($programs{'AFFILIATES'});

   $statements{'Affilate Access Table Index 1'} = qq! CREATE INDEX hsl_access1 ON affiliate_access(ip_number,link_id) ! if($programs{'AFFILIATES'});
   $statements{'Affilate Access Table Index 2'} = qq! CREATE INDEX hsl_access2 ON affiliate_access(ip_number,search_terms) ! if($programs{'AFFILIATES'});

   $statements{'Affiliate Info Table'} = qq!
      CREATE TABLE affiliate_info (
        affiliate varchar(80) NOT NULL PRIMARY KEY,
        payment_type varchar(20),
        payment_trigger varchar(20),
        search_amount decimal(9,2),
        click_amount varchar(20),
        allowed_referers $TEXT,
        minimum_payment decimal(9,2),
        application_date varchar(20),
        approval_date varchar(20),
        notes $TEXT
      )
   ! if($programs{'AFFILIATES'});


   $statements{'Affiliate Payments Table'} = qq!
      CREATE TABLE affiliate_payments (
        affiliate varchar(80) NOT NULL,
        paid_date varchar(20) NOT NULL,
        paid_amount decimal(9,2),
        due_amount decimal(9,2),
        balance decimal(9,2),
        period_start varchar(20),
        period_end varchar(20),
        tstamp $INT NOT NULL,
        comments $TEXT
      )
   ! if($programs{'AFFILIATES'});

   $statements{'Affiliate Payments Table Index 1'} = qq! CREATE INDEX hsl_pay1 ON affiliate_payments(affiliate,paid_date) ! if($programs{'AFFILIATES'});
   $statements{'Affiliate Payments Table Index 2'} = qq! CREATE INDEX hsl_pay2 ON affiliate_payments(affiliate,tstamp) ! if($programs{'AFFILIATES'});

   $statements{'Affiliate Search Logger Table'} = qq!
      CREATE TABLE affiliate_searches (
        affiliate char(80) NOT NULL,
        search_date char(8) NOT NULL,
        commission char(10),
        search_count $INT,    
        paid_flag char(3)
      )
   ! if($programs{'AFFILIATES'});

   $statements{'Affiliate Search Logger Table Index'} = qq! CREATE INDEX hsl_affs1 ON affiliate_searches(affiliate,search_date) ! if($programs{'AFFILIATES'});




   ## FORUM TABLES
   $statements{'Forum Category Definition Table'} = qq!
      CREATE TABLE forum_cat_def (
        category char(200) NOT NULL
      )
   ! if($programs{'BBS'});



   $statements{'Forum Categories Table'} = qq!
      CREATE TABLE forum_cats (
        category char(120) NOT NULL,
        forum char(50) NOT NULL
      )
   ! if($programs{'BBS'});

   $statements{'Forum Categories Table Index'} = qq! CREATE INDEX forum7 ON forum_cats(category) ! if($programs{'BBS'});


   $statements{'Forum Groups Table'} = qq!
      CREATE TABLE forum_groups (
        forum_group char(50) NOT NULL
      )
   ! if($programs{'BBS'});



   $statements{'Forum Keywords Table'} = qq!
      CREATE TABLE forum_keys (
        forum char(50) NOT NULL,
        message_no $INT NOT NULL,
        keyword char(20) NOT NULL
      )
   ! if($programs{'BBS'});

   $statements{'Forum Keywords Table Index'} = qq! CREATE INDEX forum2 ON forum_keys(forum,message_no,keyword) ! if($programs{'BBS'});


   $statements{'Forum Stats Table'} = qq!
      CREATE TABLE forum_stats (
        forum char(50) NOT NULL,
        thread $INT NOT NULL,
        subject char(255),
        name char(50),
        teaser char(50),
        num_posts $INT,    
        last_post $INT,    
        wants_email char(100)
      )
   ! if($programs{'BBS'});

   $statements{'Forum Stats Table Index'} = qq! CREATE INDEX forum6 ON forum_stats(forum,thread) ! if($programs{'BBS'});


   $statements{'Forums Main Table'} = qq!
      CREATE TABLE forums (
        forum varchar(50) NOT NULL,
        category varchar(120) NOT NULL,
        forum_name varchar(100),
        moderators varchar(120),
        private varchar(20),
        private_password varchar(20),
        num_posts $INT,    
        description $TEXT
      )
   ! if($programs{'BBS'});

   $statements{'Forums Main Table Index 1'} = qq! CREATE UNIQUE INDEX forum1 ON forums(forum) ! if($programs{'BBS'});
   $statements{'Forums Main Table Index 2'} = qq! CREATE INDEX forum5 ON forums(category) ! if($programs{'BBS'});

   $statements{'Forum Messages Table'} = qq!
      CREATE TABLE messages (
        forum varchar(50) NOT NULL,
        thread $INT NOT NULL,
        message_no $INT NOT NULL,
        subject varchar(255),
        author_name varchar(50),
        author_email varchar(100),
        msg_date varchar(15),
        message_text $TEXT,
        thread_index varchar(100)
      )
   ! if($programs{'BBS'});

   $statements{'Forum Messages Table Index'} = qq! CREATE INDEX forum3 ON messages(forum,thread,message_no) ! if($programs{'BBS'});

   $statements{'Threads Read Table'} = qq!
      CREATE TABLE threads_read (
        userid char(20) NOT NULL,
        thread_id $INT NOT NULL
      )
   ! if($programs{'BBS'});

   $statements{'Threads Read Table Index 1'} = qq! CREATE INDEX forum8 ON threads_read(userid) ! if($programs{'BBS'});
   $statements{'Threads Read Table Index 2'} = qq! CREATE INDEX forum9 ON threads_read(thread_id) ! if($programs{'BBS'});

   $statements{'User Groups Table'} = qq!
      CREATE TABLE user_groups (
        forum_group char(50) NOT NULL,
        userid char(50) NOT NULL
      )
   ! if($programs{'BBS'});


   ## HYPERSEEK TABLES


   $statements{'Hyperseek Related Categories'} = qq!
      CREATE TABLE hs_related (
        category_id $INT NOT NULL PRIMARY KEY,
        related_id $INT NOT NULL
      )
   ! if($programs{'HYPERSEEK'});


   $statements{'Hyperseek Results Table'} = qq!
      CREATE TABLE hyperseek_results (
         cookie_id INT NOT NULL PRIMARY KEY,
         id_set TEXT
      )
   ! if($programs{'HYPERSEEK'});


   $statements{'Hyperseek Category Table'} = qq!
      CREATE TABLE hyperseek_cats (
        category char(120) NOT NULL,
        id $INT NOT NULL,
        price decimal(9,2)
      )
   ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Category Table Index 1'} = qq! CREATE INDEX hsl_cats1 ON hyperseek_cats(category) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Category Table Index 2'} = qq! CREATE INDEX hsl_cats2 ON hyperseek_cats(id) ! if($programs{'HYPERSEEK'});


   $statements{'Hyperseek Forbidden Table'} = qq!
      CREATE TABLE hyperseek_forbid (
        id char(20) NOT NULL,
        word char(50) NOT NULL
      )
   ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Forbidden Table Index'} = qq! CREATE INDEX hsl_forbid ON hyperseek_forbid(id) ! if($programs{'HYPERSEEK'});


   $statements{'Hyperseek Keywords Table'} = qq!
      CREATE TABLE hyperseek_keys (
        keyword char(50) NOT NULL,
        id $INT NOT NULL,
        price decimal(9,2) NOT NULL,
        xfactor $INT NOT NULL
      )
   ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Keywords Table Index 1'} = qq! CREATE INDEX hsl_keys1 ON hyperseek_keys(keyword) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Keywords Table Index 2'} = qq! CREATE INDEX hsl_keys2 ON hyperseek_keys(price,xfactor) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Keywords Table Index 3'} = qq! CREATE INDEX hsl_keys3 ON hyperseek_keys(id) ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Links Table'} = qq!
      CREATE TABLE hyperseek_links (
        id $INT NOT NULL PRIMARY KEY,
        category $TEXT,
        extra_link varchar(120),
        rank decimal(15,5) NOT NULL,
        qualifier varchar(120),
        email varchar(100) NOT NULL,
        title varchar(80),
        url varchar(120) NOT NULL,
        description $TEXT,
        keywords $TEXT,
        desc_image varchar(120),
        title_tag varchar(120),
        site_icon varchar(120),
        name varchar(50),
        address varchar(75),
        city varchar(50),
        state varchar(5),
        zip varchar(10),
        country varchar(30),
        phone varchar(20),
        fax varchar(20),
        startdate varchar(20),
        enddate varchar(20),
        price varchar(20),
        account varchar(30) NOT NULL,
        xfactor varchar(20),
        field1 varchar(255),
        field2 varchar(255),
        field3 varchar(255),
        field4 varchar(255),
        field5 varchar(255),
        field6 varchar(255),
        field7 varchar(255),
        field8 varchar(255),
        field9 varchar(255),
        field10 varchar(255)
      )
   ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Links Table Index 1'} = qq! CREATE INDEX hsl_email ON hyperseek_links(email) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Links Table Index 2'} = qq! CREATE INDEX hsl_url ON hyperseek_links(url) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Links Table Index 3'} = qq! CREATE INDEX hsl_acct1 ON hyperseek_links(account) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Links Table Index 4'} = qq! CREATE INDEX hsl_pos1 ON hyperseek_links(rank) ! if($programs{'HYPERSEEK'});


   $statements{'Hyperseek Stats Table'} = qq!
      CREATE TABLE hyperseek_stats (
        id $INT NOT NULL,
        category char(120) NOT NULL,
        hits $INT,    
        top_votes $INT,    
        rate_votes $INT,    
        rate_score $INT,    
        av_links $INT
      )
   ! if($programs{'HYPERSEEK'});

   $statements{'Hyperseek Stats Table Index 1'} = qq! CREATE INDEX hsl_stat ON hyperseek_stats(id) ! if($programs{'HYPERSEEK'});
   $statements{'Hyperseek Stats Table Index 2'} = qq! CREATE INDEX hsl_stat2 ON hyperseek_stats(category) ! if($programs{'HYPERSEEK'});


   ## Survey Tables.
   $statements{'iSurvey Main Table'} = qq!
      CREATE TABLE surveys (
         survey_id INT NOT NULL PRIMARY KEY,
         survey_name CHAR(50) NOT NULL,
         description TEXT,
         start_date CHAR(11),
         end_date CHAR(11),
         public CHAR(1),
         maillist CHAR(1),
         result_mail CHAR(1),
         minimum_votes INT,
         redirect_url CHAR(255),
         allow_anonymous CHAR(1),
         num_questions INT,
         template CHAR(100),
         status CHAR(20)
      )
	 ! if($programs{SURVEYS});

   $statements{'iSurvey Questions Table'} = qq!
      CREATE TABLE survey_questions (
         survey_id INT NOT NULL,
         question_id INT NOT NULL,
         question TEXT,
         response_type CHAR(10),
         input_type CHAR(20),
         input_values TEXT,
         required CHAR(1),
         dependancy INT,
         dependancy_value CHAR(200)
      )
	 ! if($programs{SURVEYS});


   $statements{'iSurvey Results Table'} = qq! 
      CREATE TABLE survey_results (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         question_id INT NOT NULL,
         rcount INT,
         answer CHAR(255)
      )
	 ! if($programs{SURVEYS});

   $statements{'iSurvey Detail Table'} = qq! 
      CREATE TABLE survey_detail (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         session_id INT NOT NULL,
         question_id INT NOT NULL,
         answer CHAR(255)
      )
	 ! if($programs{SURVEYS});


   ## ARCHIVE TABLES ##
   $statements{'iSurvey Archive Main Table'} = qq! 
      CREATE TABLE a_surveys (
         survey_id INT NOT NULL PRIMARY KEY,
         survey_name CHAR(50) NOT NULL,
         description TEXT,
         start_date CHAR(11),
         end_date CHAR(11),
         public CHAR(1),
         maillist CHAR(1),
         result_mail CHAR(1),
         minimum_votes INT,
         redirect_url CHAR(255),
         allow_anonymous CHAR(1),
         num_questions INT,
         status CHAR(20)
      )
	 ! if($programs{SURVEYS});

   $statements{'iSurvey Questions Archive Table'} = qq! 
      CREATE TABLE a_survey_questions (
         survey_id INT NOT NULL,
         question_id INT NOT NULL,
         question TEXT,
         response_type CHAR(10),
         input_type CHAR(20),
         input_values TEXT,
         required CHAR(1),
         dependancy INT,
         dependancy_value CHAR(200)
      )
	 ! if($programs{SURVEYS});

   $statements{'iSurvey Archive Results Table'} = qq! 
      CREATE TABLE a_survey_results (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         question_id INT NOT NULL,
         rcount INT,
         answer CHAR(255)
      )
	 ! if($programs{SURVEYS});

   $statements{'iSurvey Detail Archive Table'} = qq! 
      CREATE TABLE a_survey_detail (
         survey_id INT NOT NULL,
         join_id INT NOT NULL,
         session_id INT NOT NULL,
         question_id INT NOT NULL,
         answer CHAR(255)
      )
	 ! if($programs{SURVEYS});


   $statements{'iSurvey Access Table'} = qq! 
     CREATE TABLE survey_access (
       survey_id INT NOT NULL,
        ip_number CHAR(15) NOT NULL
     )
   ! if($programs{SURVEYS});


   $statements{'iSurvey Questions Table Index'} = qq! CREATE INDEX sv1 ON survey_questions(survey_id,question_id) ! if($programs{SURVEYS});
   $statements{'iSurvey Questions Archive Table Index'} = qq! CREATE INDEX a_sv1 ON a_survey_questions(survey_id,question_id) ! if($programs{SURVEYS});

   $statements{'iSurvey Results Table Index'} = qq! CREATE INDEX sv2 ON survey_results(survey_id,join_id,question_id) ! if($programs{SURVEYS});
   $statements{'iSurvey Results Archive Table Index'} = qq! CREATE INDEX a_sv2 ON a_survey_results(survey_id,join_id,question_id) ! if($programs{SURVEYS});

   $statements{'iSurvey Access Table Index'} = qq! CREATE INDEX svacc ON survey_access(survey_id,ip_number) ! if($programs{SURVEYS});

   $statements{'iSurvey Detail Table Index 1'} = qq! CREATE INDEX svd1 ON survey_detail(survey_id,join_id,question_id) ! if($programs{SURVEYS});
   $statements{'iSurvey Detail Table Index 2'} = qq! CREATE INDEX svd2 ON survey_detail(session_id) ! if($programs{SURVEYS});
   $statements{'iSurvey Detail Table Archive Index 1'} = qq! CREATE INDEX a_svd1 ON a_survey_detail(survey_id,join_id,question_id) ! if($programs{SURVEYS});
   $statements{'iSurvey Detail Table Archive Index 2'} = qq! CREATE INDEX a_svd2 ON a_survey_detail(session_id) ! if($programs{SURVEYS});


}
