##############################################################################
# PROGRAM : iWeb Plugin Parser                                               #
# VERSION : 4.08                                                             #
#                                                                            #
##############################################################################
#    ____     ___                                                            #
#   /\  _`\  /\_ \                     __                                    #
#   \ \ \L\ \\//\ \    __  __     __  /\_\     ___      ____                 #
#    \ \ ,__/  \ \ \  /\ \/\ \  /'_ `\\/\ \  /' _ `\   /',__\                #
#     \ \ \/    \_\ \_\ \ \_\ \/\ \L\ \\ \ \ /\ \/\ \ /\__, `\               #
#      \ \_\    /\____\\ \____/\ \____ \\ \_\\ \_\ \_\\/\____/               #
#       \/_/    \/____/ \/___/  \/___L\ \\/_/ \/_/\/_/ \/___/                #
#                                 /\____/                                    #
#                                 \_/__/                                     #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw(Page_Header iWeb_Header BANNER); 

sub Page_Header {

    my $GROUP = $_[0];
    my $SEARCH = $_[1];
    my ($subroutine,$result,$default,$FILENAME);      
    my ($cfile,$cat,@cgroup,@sgroup,$string,$params,$qstring,$dbug);      

    $OUT=undef;

    # $bannermaster{'group'}=$GROUP;

    ### CUSTOM ###
    $global{'template_dir'}="$data_dir/templates" if(! $global{'template_dir'});

    ## First, Determine which template to use, either the 
    ## current Search Term or Category, if it's defined.

    if ($SEARCH) {
       $FILENAME="$global{'template_dir'}/search.txt";
    }
    elsif($global{'yh_cat_templ'} eq "YES") {

       ## Find a file, matching either the current category,
       ## or work up the ladder to the default.

       $FILENAME="$global{'template_dir'}/$GROUP.txt";

       $dbug .= "Tried: $FILENAME ... ";
       if(! -e $FILENAME) {
          @sgroup = split(/_/,$GROUP);
          @cgroup = reverse @sgroup;
          $cat=$GROUP;
          foreach $cfile(@cgroup) {
            $cat =~ s/_$cfile$//g;
            $FILENAME="$global{'template_dir'}/$cat.txt";
            $dbug .= "Tried: $FILENAME ... ";
            last if(-e $FILENAME);
          }
       }

       # print "[[ $dbug ]]\n";
    }
    else { $FILENAME="$global{'template_dir'}/$GROUP.txt"; }

    if ($ENV{'SCRIPT_NAME'} =~ "ilink") { $default = "ilink"; }
    else { $default = "default"; }

    if (! -e $FILENAME) {
       $FILENAME = "$global{'template_dir'}/$default.txt";
    }

    if (-e "$FILENAME") {
      open(HDR,"$FILENAME");
         while ($cline = <HDR>) {
             ## If there is a PLUGIN: call on this line, do it, otherwise
             ## Just increment $OUT....

             if ($cline =~ /(<!-- )(PLUGIN:CUSTOM)(:)(.*?)( -->)/ ||
                 $cline =~ /(<!-- )(PLUGIN:BANNER)(:)(.*?)( -->)/ ||
                 $cline =~ /(<!-- )(PLUGIN)(:)(.*?)( -->)/ ) { 
                 $string = $1 . $2 . $3 . $4 . $5;
                 $subroutine = $4;
                 if($2 =~ "CUSTOM") { 
                    if($subroutine =~ /(.*)(\(.*\))(.*)/) {
                       $subroutine = $1;
                       $params = $2;
                       $params =~ s/\)//g;
                       $params =~ s/\(//g;
                       @_ = split(/\,/,$params);
                    }
                    if($BUILDING || $hyperseek{'branded'} || $hyperseek{'account'} || $hyperseek{'moderator'} ) { require("../custom/$subroutine.pm"); }
                    else { require("./custom/$subroutine.pm"); }
                 }
                 elsif($2 =~ "BANNER") { 
                    $bannermaster{'group'} = $subroutine;
                    $subroutine = "BANNER";
                 }

                 $result = &$subroutine($params);
                 # $result = ${"IWEB::$subroutine"};
                 $qstring = quotemeta($string);
                 $cline =~ s/$qstring/$result/;

                 $OUT .= "$string\n";
                 $OUT .= $cline;
             }
             else { $OUT .= $cline; }
         }
      close(HDR);
    }

    else {
       ## If all else fails (Ie: We didn't have a matching template for
       ## *ANYTHING* then just do the minimum and send the BODY to the user
       $OUT .= IWEB::BODY();
    }

    $OUT =~ s/$hyperseek{'criteria'}/$hyperseek{'results'}/g if( ($input{'fullselect'} || $hyperseek{'search'} eq "T") && $global{'yh_show_summary'} ne "YES");

    $OUT .= "<!-- Tmpl: $dbug ... settled on $FILENAME -->" if($input{'showtemplatetrail'} == 1);

    return($OUT) if ( $FCGI == 2 );
    IWEB::iWeb_Header($OUT);

}


sub iWeb_Header {

    my $content = $_[0];
    my $header;      

    $OUT = $content;

    ## Send the HTML Header, and the contents...
    if($COOKIE) { $header=$COOKIE; }
    $header .= "Content-Type: text/html\n\n";


    if($BUILDING) {
      open(BF,">$out_file");
         print BF $OUT;
      close(BF);
    }

    elsif (! $SERVER) { print $header; print $OUT; }

    else { $OUT = $header . $OUT . " ";} 
 
    return();

}


sub BANNER {

   my($banner);      

   if($bannermaster{'group'}) { 
      $bannermaster{'targeted'} = 1;
   }
   else { 
      if($input{'Category'}) { 
         $bannermaster{'group'} = $input{'Category'};
         $bannermaster{'group'} = IWEB::Make_Alpha($bannermaster{'group'});
      }
      $bannermaster{'group'} = $input{'forum'} if($input{'forum'});
   }

   if($BUILDING) { 
      $hyperseek{'x'}++;
      if($global{'BANNER_CALL'} eq "Normal HTML") { 
         $banner = qq!
           <A HREF="$urls{'click_url'}?x-factor=$hyperseek{'x'}"><IMG SRC="$urls{'bms_url'}?group=$bannermaster{'group'}&x-factor=$hyperseek{'x'}"></A>
         !
      }
      elsif($global{'BANNER_CALL'} eq "SSI Exec") { 
         $banner = qq^ <!--#exec cgi="$urls{'bm_url'}?group=$bannermaster{'group'}"--> ^;
      }
      elsif($global{'BANNER_CALL'} eq "SSI Include") { 
         $banner = qq^ <!--#include virtual="$urls{'bm_url'}?group=$bannermaster{'group'}"--> ^;
      }
   }
   else { 
      $banner=IWEB::Group_Banner();
   }

   $bannermaster{'group'}='';
   $bannermaster{'targeted'}='';
   $debug = $debug_text;
   $debug_text='';

   return($banner);
}

1;
