##############################################################################
# PROGRAM : Hyperseek Search Engine: HTTP client                             #
# VERSION : 2000.01                                                          #
#                                                                            #
##############################################################################
#                                                                            #
#  __  __                                                  __                #
# /\ \/\ \                                                /\ \               #
# \ \ \_\ \  __  __  _____     __  _ __  ____    __     __\ \ \/'\           #
#  \ \  _  \/\ \/\ \/\ '__`\ /'__`Y\`'__Y',__\ /'__`\ /'__`\ \ , <           #
#   \ \ \ \ \ \ \_\ \ \ \L\ Y\  __| \ \/\__, `Y\  __//\  __/\ \ \\`\         #
#    \ \_\ \_\/`____ \ \ ,__| \____\ \_\/\____| \____\ \____\\ \_\ \_\       #
#     \/_/\/_/`/___/> \ \ \/ \/____/\/_/\/___/ \/____/\/____/ \/_/\/_/       #
#                /\___/\ \_\                                                 #
#                \/__/  \/_/                                                 #
#                                     ___      __      __      __            #
#                                   /'___`\  /'__`\  /'__`\  /'__`\          #
#                                  /\_\ /\ \/\ \/\ \/\ \/\ \/\ \/\ \         #
#                                  \/_/// /_\ \ \ \ \ \ \ \ \ \ \ \ \        #
#                                     // /_\ \ \ \_\ \ \ \_\ \ \ \_\ \       #
#                                    /\______/\ \____/\ \____/\ \____/       #
#                                    \/_____/  \/___/  \/___/  \/___/        #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw(Get);

use Socket;

## SAMPLE USAGE:
## ($status,$message,$contents) = Get($URL);
##

sub Get {

    my ($url,$range) = @_;
    my ($content,$content_type,$header,$nethost,$request,$data,$doc_body,$diff);      
    my ($status,$status_line,%fields,$h,$message,$irs,$iaddr,$paddr,$proto,$size);      

    my $timeout=10;
    my $start=time;

    $content_type = 'application/octet-stream';

    # parse out the URL in a simple fashion
    ($nethost,$request) = $url =~ m!^http://([^/]+)(.*)!;
    $request ||= '/';

    # try to make connection with remote host
    socket(SERVER,PF_INET,SOCK_STREAM,getprotobyname('tcp'));

    $iaddr   = inet_aton($nethost) || return(700,"Invalid Host: $nethost");
    $paddr   = sockaddr_in(80, $iaddr) || return(700,"Invalid paddr: $nethost");

    socket(SOCK, PF_INET, SOCK_STREAM, $proto) || return (700,"socket error: $!");
    connect(SOCK, $paddr) || return (400,"connect error: $!");
    select(SOCK);$|=1;
    select(STDOUT);

    $range = "GET" unless($range);

    print SOCK "$range $request HTTP/1.0\n",'Host: ',$nethost,"\n";
    print SOCK "User-Agent: $ENV{HTTP_USER_AGENT}\n"
        if $ENV{HTTP_USER_AGENT};
    print SOCK "\n";
    while (defined($line = <SOCK>)) { 
       my $now = time;
       $diff = ($now-$start);
       if( $diff >= $timeout ) { return(600,"iWeb Client Timeout"); }
       $header .= $line; 
    }
    return(500,"Connection refused!") unless $header;
    close (SOCK)  || return( 700,"close error: $!" );

    # ($status_line,%fields) = split(/^([-\w]+):/m,$header) if($header);
    ($status_line,undef) = split(/\n/,$header);
    ($status,$message) = $status_line =~ m!http/1\.\d+\s+(\d+)\s+(.*)$!i;

    if($header =~ m/(content-length:)(\s+)(\d+)(\s+)(\n)/i) { $size = $3; }


    return (400,"malformed header") unless $status;

    return ($status,$message,$header,$size);
}


sub Post {

    my ($url,$range,$vars) = @_;
    my ($content,$content_type,$header,$nethost,$request,$data,$doc_body,$diff);      
    my ($status,$status_line,%fields,$h,$message,$irs,$iaddr,$paddr,$proto,$size);      

    my $timeout=10;
    my $start=time;

    my $len = length($vars);

    $content_type = 'application/octet-stream';

    # parse out the URL in a simple fashion
    ($nethost,$request) = $url =~ m!^http://([^/]+)(.*)!;
    $request ||= '/';

    # try to make connection with remote host
    socket(SERVER,PF_INET,SOCK_STREAM,getprotobyname('tcp'));

    $iaddr   = inet_aton($nethost) || return(700,"Invalid Host: $nethost");
    $paddr   = sockaddr_in(80, $iaddr) || return(700,"Invalid paddr: $nethost");

    socket(SOCK, PF_INET, SOCK_STREAM, $proto) || return (700,"socket error: $!");
    connect(SOCK, $paddr) || return (400,"connect error: $!");
    select(SOCK);$|=1;
    select(STDOUT);

    $range = "POST" unless($range);

    print SOCK "$range $request HTTP/1.0\n",'Host: ',$nethost,"\n";
    print SOCK "Content-Type: application/x-www-form-urlencoded\n"; 
    print SOCK "Content-Length: $len\n\n";
    print SOCK "$vars\n\n";

    while (defined($line = <SOCK>)) { 
       my $now = time;
       $diff = ($now-$start);
       if( $diff >= $timeout ) { return(600,"iWeb Client Timeout"); }
       $header .= $line; 
    }
    return(500,"Connection refused!") unless $header;
    close (SOCK)  || return( 700,"close error: $!" );

    ($status_line,undef) = split(/\n/,$header);
    ($status,$message) = $status_line =~ m!http/1\.\d+\s+(\d+)\s+(.*)$!i;

    if($header =~ m/(content-length:)(\s+)(\d+)(\s+)(\n)/i) { $size = $3; }

    return (400,"malformed header") unless $status;

    return ($status,$message,$header,$size);
}

1;
