#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Bannermaster SQL Admin Module                                    #
# VERSION : 4.10                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#

   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw( SQL_Save_Groups  SQL_Update_Group_Record  SQL_Get_Group_Data  
                 SQL_Get_Account  SQL_Save_Account  SQL_Account_to_BM  
                 SQL_Delete_Account  SQL_Get_Account_List  SQL_Account_Option_List  
                 SQL_Get_Campaign  SQL_Save_Campaign  SQL_Get_Campaign_List  
                 SQL_Delete_Campaign  SQL_Init_Campaign  SQL_Assign_Groups  
                 SQL_Save_Group_Assignment  SQL_Get_Campaign_Totals  
                 SQL_Get_Grand_Totals  Create_Hyperseek_Banner_Groups  
                 SQL_Group_List  SQL_Group_Option_List  
             );

sub SQL_Save_Groups {

    my $group_list = $input{'delete'};
    my $addme = $input{'add'};
    my @delete_us = split(/ /,$group_list);
    my ($in,$message);      

    if( $addme ) { 
      $addme =~ s/ /_/g;
        $SQL = "INSERT INTO bm_group_def VALUES('$addme',0)";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
    }

    if($group_list) {
      foreach $group(@delete_us) { 
         if ($in) { $in .= ",'$group'"; }
         else { $in = "('$group'"; }
      }
      $in .= ")";

        $SQL = "DELETE FROM bm_group_def WHERE group_name in $in";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
    }

}




sub SQL_Update_Group_Record {

   my $AccountList = $input{'account'};
   my @accounts = split(/ /,$AccountList);
   my $group = $input{'group'};
   my $account;      

     ## First, Delete old group records
     $SQL = "DELETE FROM bm_groups WHERE group_name = '$group'";
     $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
     $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

     ## Now, add all the selected ones in...
     foreach $account(@accounts) { 
       $SQL = "INSERT INTO bm_groups VALUES('$group','$account')";
       $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
       $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
     }


}



sub SQL_Get_Group_Data {

   $bannermaster{'group'} = $input{'group'};

      $SQL = "SELECT * FROM bm_groups WHERE group_name = '$bannermaster{'group'}'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { $groups{$rows[1]} = 1; }

      $SQL = "SELECT * FROM campaigns"; 
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { $accounts{$rows[0]} = 1; }

}

sub SQL_Get_Account {

   my $acct = $input{'account'};
   my ($afield,$field,%results);      

   $SQL = "SELECT * FROM accounts WHERE acct_id = '$acct'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while ($results = $sth->fetchrow_hashref) { 
         foreach $field (@{$sth->{NAME}} ) {
            $afield = lc($field);
            $account{$afield}=$results->{$field};
         }
      }



}

sub SQL_Save_Account {

    my $newacct = $_[0];

    my($message,$results,$field,$exists,$afield);      

    $input{'acct_name'} =~ s/ /_/g;
    $input{comments} =~ s/\'/\'\'/g;

      if($newacct) {

         $SQL = "SELECT * FROM accounts WHERE acct_id='$input{'acct_id'}'";
           $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
           $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
           while ($results = $sth->fetchrow_hashref) { 
              $exists++;
              foreach $field (@{$sth->{NAME}} ) {
                if($results->{$field}) { 
                 $afield = lc($field);
                 $message .= "<TR><TD>$afield:</TD><TD>&nbsp;";
                 $message .=  $results->{$field};
                 $message .= "</TD></TR>\n";
                }
              }
           }
 
         if($exists) { 
            print "Content-Type: text/html\n\n";
            print IWEB::Admin_Header("Account Exists");
            print qq!
               <CENTER><TABLE BGCOLOR="white" BORDER=1 WIDTH=80%>
                  $message
               </TABLE><BR><BR>
               <A HREF="$PROG_URL?action=Account_to_BM&acct_id=$input{'acct_id'}">Change this to a bannermaster account</A> ...
               <A HREF="javascript:history.go(-1)">Return to add form</A><BR><BR>
               </CENTER>
            !;
            print IWEB::Admin_Footer();
            IWEB::Quit();
         }
         my $now = time;
         $SQL = qq!

             INSERT INTO accounts VALUES (
	      '$input{'acct_id'}',
	      '$input{'acct_password'}',
	      'bannermaster',
	      '$input{'contact_email'}',
	      '',
	      '$input{'contact_name'}',
	      '$input{'address'}',
	      '$input{'city'}',
	      '$input{'state'}',
	      '$input{'zip'}',
	      '',
	      '$input{'phone'}',
	      '$input{'fax'}',
              '',
              '',
              '',
              '',
              0,
              0,
              0,
              '$input{comments}',
	      '',
	      '',
	      '',
	      '',
	      0,
	      0,
	      '',
              '$now',
              '',
              '',
              '',
              '',
              '',
              ''
	     )
         !;

      }

      else {
         $SQL = qq!
         UPDATE accounts SET
           acct_password = '$input{'acct_password'}',
           contact_email = '$input{'contact_email'}',
           contact_name = '$input{'contact_name'}',
           address = '$input{'address'}',
           city = '$input{'city'}',
           zip = '$input{'zip'}',
           state = '$input{'state'}',
           phone = '$input{'phone'}',
           fax = '$input{'fax'}',
           comments = '$input{comments}'
         WHERE acct_id = '$input{'acct_id'}'
         !;
      }

      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
}

sub SQL_Account_to_BM {

    $SQL = qq!
      UPDATE accounts SET
      acct_type = 'bannermaster'
      WHERE acct_id = '$input{'acct_id'}'
    !;

    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

    print "Content-Type: text/html\n\n";
    print IWEB::Admin_Header("Account updated");
    print qq!
       <BR><BR><B>Account has been updated to "Bannermaster" status.
    !;
    print IWEB::Admin_Footer();
    IWEB::Quit();

}

sub SQL_Delete_Account {

   my $acct_name = $input{'account'};

      $SQL = "DELETE FROM accounts WHERE acct_id = '$acct_name'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

      $SQL = "DELETE FROM campaigns WHERE login = '$acct_name'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");


   print "Content-Type: text/html\n\n";
   print "Account $acct_name Deleted.<HR><BLOCKQUOTE>\n";
   print "All associated files are gone and the database has been updated.\n";
   print "However, we recommend that you check the directories via FTP or telnet to ensure that.\n";
   print "they were all properly removed.  If not, you will need to remove them by hand.\n";

}


sub SQL_Get_Account_List {

   my $list;      

   my $start = $input{'start'};
   my $found = 0;
   my $shown = 0;

   $SQL = "SELECT acct_id FROM accounts ORDER BY acct_id";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { 

         $found++;
         next if($start > 1 && $found <= $start);
         $shown++;

         $list .= qq!
            ($found) $rows[0]: <A HREF="$PROG_URL?action=Edit+Account&account=$rows[0]">Edit</A> ... 
            <A HREF="$PROG_URL?action=DeleteAccount&account=$rows[0]">Delete</A><BR>
         !;

         last if($shown >= 20);
      }

    my $total = $sth->rows;

    my $nlink = "$total Accounts ... ";
       if($start) { 
          my $prevstart = $start-20;
          $nlink .= qq! <A HREF="$PROG_URL?action=List+Accounts&start=$prevstart">Previous 20</A> !; 
       }
       if($found < $total) { 
          my $nextstart = $start+20;
          $nlink .= qq! <A HREF="$PROG_URL?action=List+Accounts&start=$nextstart">Next 20</A> !; 
       }

    $list .= "<CENTER>$nlink</CENTER>";

   return($list);
}

sub SQL_Account_Option_List {

   my $list;      

   $SQL = "SELECT acct_id FROM accounts WHERE acct_type = 'bannermaster'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { 
         $list .= qq!
            <OPTION VALUE="$rows[0]">$rows[0]</OPTION>
         !
      }

   return($list);

}


sub SQL_Get_Campaign {

   my $acct = $input{'account'};
   my ($afield,$field,%results);      

   $SQL = "SELECT * FROM campaigns WHERE account = '$acct'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while ($results = $sth->fetchrow_hashref) { 
         foreach $field (@{$sth->{NAME}} ) {
            $afield = lc($field);
            $account{$afield}=$results->{$field};
         }
      }


   ## Some cleanup work....

   $account{'acct_name'} = $account{'account'};
   $account{'acct_login'} = $account{'login'};
   $account{'acct_password'} = $account{'password'};
   $account{'banner_width'} = $account{'width'};
   $account{'banner_height'} = $account{'height'};

   $totals{'Impressions'} = $account{'num_impressions'};
   $totals{'Clicks'} = $account{'num_clicks'};
   $account{'num_impressions'} = $account{'imp_allowed'};
   $account{'num_clicks'} = $account{'clicks_allowed'};

}

sub SQL_Save_Campaign {

    my $newacct = $_[0];

    my (%ttl,%save,$newkey,$key);      

    $input{'num_impressions'}=0 if(! $input{'num_impressions'});
    $input{'num_clicks'}=0 if(! $input{'num_clicks'});

    ### Values from input...
    $save{'acct_name'}       = $input{'acct_name'};
       $save{'acct_name'} =~ s/ /_/g;

    $save{'acct_login'}      = $input{'acct_login'};
    $save{'acct_password'}   = $input{'acct_password'};
    $save{'target'}          = $input{'target'};
    $save{'redirect_url'}    = $input{'redirect_url'};
    $save{'alt_text'}        = $input{'alt_text'};
    $save{'under_text'}      = $input{'under_text'};
    $save{'banner_type'}    = $input{'banner_type'};
    $save{'banner'}         = $input{'banner'};
    $save{'banner_width'}   = $input{'banner_width'};
    $save{'banner_height'}  = $input{'banner_height'};
    $save{'banner_text'}  = $input{'banner_text'};
      $save{'banner_text'} =~ s/\cM//g;
      $save{'banner_text'} =~ s/\n//g;
      $save{'banner_text'} =~ s/\r//g;
      $save{'banner_text'} =~ s/\'/\'\'/g;
    $save{'expiration_type'} = $input{'expiration_type'};
    $save{'num_clicks'}      = $input{'Clicks'} || $input{'clicks_allowed'} || 0;
    $save{'num_impressions'} = $input{'Impressions'} || 0;
    $save{'imp_allowed'} = $input{'num_impressions'} || 0;
    $save{'clicks_allowed'} = $input{'num_clicks'} || 0;
    $save{'start_date'}      = $input{'start_date'};
    $save{'end_date'}        = $input{'end_date'};

      if($newacct) {
         $SQL = qq!
         INSERT INTO campaigns VALUES(
           '$save{'acct_name'}',
           '$save{'acct_login'}',
           '$save{'acct_password'}',
           '$save{'target'}',
           '$save{'redirect_url'}',
           '$save{'alt_text'}',
           '$save{'under_text'}',
           '$save{'banner_type'}',
           '$save{'banner'}',
            $save{'banner_width'},
            $save{'banner_height'},
           '$save{'banner_text'}',
           '$save{'expiration_type'}',
            $save{'num_clicks'},
            $save{'clicks_allowed'},
            $save{'num_impressions'},
            $save{'imp_allowed'},
           '$save{'start_date'}',
           '$save{'end_date'}'
         )
         !;

      }

      else {
         $SQL = qq!
         UPDATE campaigns SET
           account = '$save{'acct_name'}',
           login = '$save{'acct_login'}',
           camp_pass = '$save{'acct_password'}',
           target = '$save{'target'}',
           redirect_url = '$save{'redirect_url'}',
           alt_text = '$save{'alt_text'}',
           under_text = '$save{'under_text'}',
           banner_type = '$save{'banner_type'}',
           banner = '$save{'banner'}',
           width =  $save{'banner_width'},
           height =  $save{'banner_height'},
           banner_text = '$save{'banner_text'}',
           expiration_type = '$save{'expiration_type'}',
           num_clicks =  $save{'num_clicks'},
           clicks_allowed =  $save{'clicks_allowed'},
           num_impressions =  $save{'num_impressions'},
           imp_allowed =  $save{'imp_allowed'},
           start_date = '$save{'start_date'}',
           end_date = '$save{'end_date'}'
         WHERE account = '$save{'acct_name'}'
         !;
      }

      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
}


##############################################################################
# List the categories and sub categories
##############################################################################
sub SQL_Get_Campaign_List {

    my ($acct_name,$acct_login,$acct_password,$target,$redirect_url,$alt_text,$under_text,$banner_type,$banner,$banner_width,$banner_height,$banner_text,$expiration_type,$num_clicks,$num_impressions,$start_date,$end_date,$pct,$clicks_allowed,$imp_allowed);      

    my $start = $input{'start'};
    my $shown = 0;
    my $found = 0;

      $SQL = "SELECT * FROM campaigns ORDER BY account"; 
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { 

         $found++;
         next if($start > 1 && $found <= $start);
         $shown++;

         ($acct_name,$acct_login,$acct_password,$target,$redirect_url,$alt_text,$under_text,$banner_type,$banner,$banner_width,$banner_height,$banner_text,$expiration_type,$num_clicks,$clicks_allowed,$num_impressions,$imp_allowed,$start_date,$end_date) = @rows;

         next if ($expiration_type eq "exchange" && $exchange ne "T");
         next if ($expiration_type ne "exchange" && $exchange eq "T");

        ($impressions, $clicks) = IWEB::SQL_Get_Campaign_Totals($acct_name);

        if ($expiration_type eq "impressions") {
            $ri = ($imp_allowed - $num_impressions);
            $info = "$ri of $imp_allowed Impressions Remaining";
        }
        elsif ($expiration_type eq "clicks") {
            $rc = ($clicks_allowed - $num_clicks);
            $info = "$rc of $clicks_allowed Clicks Remaining";
        }
        elsif ($expiration_type eq "date") {

            $info = "Account Expires on $end_date.";
        }

        if ( $impressions >= 1 ) { 
          $pct = $clicks / $impressions;
          $pct = $pct*100;
        }
        else  { $pct = 0; }

        ####################
        $bannermaster{'tablerows'} .= "<TR BGCOLOR=\"#e0e0e0\">\n";
        $bannermaster{'tablerows'} .= "<TD>$found <B>$acct_name</B></TD>\n";
        $bannermaster{'tablerows'} .= "<TD><CENTER><B>$impressions</B></CENTER></TD>\n";
        $bannermaster{'tablerows'} .= "<TD><CENTER><B>$clicks</B></CENTER></TD>\n";
        $bannermaster{'tablerows'} .= "<TD><CENTER><B>\n";

        $bannermaster{'tablerows'} .= sprintf ("( %2.2f \% )\n", $pct);
 
        $bannermaster{'tablerows'} .= "</B></CENTER></TD>\n";

        $bannermaster{'tablerows'} .= "<TD>$info</TD>\n";;

        my $tacct = IWEB::urlencode($acct_name);
        $bannermaster{'tablerows'} .= qq!
                     <TD>
                     <A HREF="$PROG_URL?account=$tacct&action=Edit+Campaign">Edit</A> / 
                     <A HREF="$PROG_URL?account=$tacct&action=Delete+Campaign">Delete</A> / 
                     <A HREF="$PROG_URL?account=$tacct&action=Assign+Groups">Groups</A> / 
                     <A HREF="$urls{'report_url'}?campaign=$tacct&MODE=admin">Stats</A> / 
        !;

        if (-e "$data_dir/bannermaster/campaigns/$acct_name.DISABLED") {
           $bannermaster{'tablerows'} .= "<A HREF=\"$PROG_URL?action=Re-Enable&account=$tacct\">Re-Enable</A> / \n";
        }
        else {
           $bannermaster{'tablerows'} .= "<A HREF=\"$PROG_URL?action=Disable&account=$tacct\">Disable</A> / \n";
        }

        $bannermaster{'tablerows'} .= qq! <A HREF="$PROG_URL?account=$tacct&action=Re-Initialize">Re-Init</A>\n !;

        $bannermaster{'tablerows'} .= "</TD></TR>\n";

        last if($shown >= 20);
    }

    my $total = $sth->rows;

    my $nlink = "$total Campaigns ... ";
       if($start) { 
          my $prevstart = $start-20;
          $nlink .= qq! <A HREF="$PROG_URL?action=List+Campaigns&start=$prevstart">Previous 20</A> !; 
       }
       if($found < $total) { 
          my $nextstart = $start+20;
          $nlink .= qq! <A HREF="$PROG_URL?action=List+Campaigns&start=$nextstart">Next 20</A> !; 
       }
 
    $bannermaster{'tablerows'} .= "<TR><TD COLSPAN=6 ALIGN=CENTER>$nlink</TD></TR>";


}


sub SQL_Delete_Campaign {

   my $acct_name = $input{'account'};

      $SQL = "DELETE FROM campaigns WHERE account = '$acct_name'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

      $SQL = "DELETE FROM bm_groups WHERE account = '$acct_name'";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");


   print "Content-Type: text/html\n\n";
   print "Account $acct_name Deleted.<HR><BLOCKQUOTE>\n";
   print "All associated files are gone and the database has been updated.\n";
   print "However, we recommend that you check the directories via FTP or telnet to ensure that.\n";
   print "they were all properly removed.  If not, you will need to remove them by hand.\n";

}


sub SQL_Init_Campaign {

   my $acct_name = $input{'account'};

      $SQL = "DELETE FROM  bm_stats WHERE account='$acct_name'";
      $dbh->do($SQL) || IWEB::SQL_ERROR($SQL);

      $SQL = "UPDATE campaigns SET num_clicks=0,num_impressions=0 WHERE account='$acct_name'";
      $dbh->do($SQL) || IWEB::SQL_ERROR($SQL);
}



sub SQL_Assign_Groups {


   $SQL = "SELECT group_name FROM bm_group_def";
    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

   while (@rows = $sth->fetchrow_array) {
        $groups{$rows[0]}++;
   }

   $groups{'default'}++;
   $groups{'exchange'}++;

   $SQL = "SELECT group_name FROM bm_groups WHERE account='$input{'account'}'";
    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

   while (@rows = $sth->fetchrow_array) {
        $account{$rows[0]}++;
   }


    foreach $key (sort keys %groups) {
         if($account{$key}) {
           $bannermaster{'grplisting'} .= "        <INPUT TYPE=\"checkbox\" NAME=\"group\" VALUE=\"$key\" CHECKED>$key\n";
         } 
         else {
           $bannermaster{'grplisting'} .= "        <INPUT TYPE=\"checkbox\" NAME=\"group\" VALUE=\"$key\">$key\n";
         } 
    }


}


sub SQL_Save_Group_Assignment {

   my($grp);      


   $SQL = "DELETE FROM bm_groups WHERE account='$input{'account'}'";
    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

    foreach $grp( split(/\s+/,$input{'group'}) ){
       $SQL = "INSERT INTO bm_groups VALUES('$grp','$input{'account'}')";
        $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
        $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
    }

}

sub SQL_Get_Campaign_Totals {

   my($acct) = @_;

   my $impressions = 0;
   my $clicks = 0;

   my(@trows,$SQL,$sth2,$rc2);      

   $SQL = "SELECT sum(impressions),sum(clicks) FROM bm_stats WHERE account = '$acct'";
    $sth2 = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc2 = $sth2->execute || IWEB::SQL_ERROR("SQL: $SQL");

   while (@trows = $sth2->fetchrow_array) {
     $impressions = $trows[0];
     $clicks = $trows[1];
   }

   $impressions = 0 if(! $impressions); 
   $clicks = 0 if(! $clicks); 

   return($impressions,$clicks);

}

sub SQL_Get_Grand_Totals {


   $SQL = "SELECT sum(impressions),sum(clicks) FROM bm_stats";
    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

   while (@trows = $sth->fetchrow_array) {
     $bannermaster{'gt_impressions'} = $trows[0];
     $bannermaster{'gt_clicks'} = $trows[1];
   }

   $bannermaster{'gt_impressions'} = 0 if(! $bannermaster{'gt_impressions'}); 
   $bannermaster{'gt_clicks'} = 0 if(! $bannermaster{'gt_clicks'}); 

}


sub Create_Hyperseek_Banner_Groups {
                                                                                
   my(%groups,%categories,$z,$category,$done);      

   eval("use DB_File");

   if($@) { IWEB::iWeb_Header( IWEB::ERROR("Cannot Create, DB_File not able to load") ); IWEB::Quit(); }

   tie %categories, "DB_File", "$data_dir/hyperseek/categories/master.db", O_RDONLY;

   foreach $category(sort keys %categories) {
       $category = IWEB::Make_Alpha($category);

           $SQL = "SELECT count(*) FROM bm_group_def WHERE group_name='$category'";
            $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
            $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
            while (@rows = $sth->fetchrow_array) { $count=$rows[0]; }

        if(! $count) {
           $SQL = "INSERT INTO bm_group_def VALUES('$category',0)";
           $dbh->do($SQL);
           $done .= "$category<BR>\n";
        }
        else { 
           $done .= "Tried: $category<BR>\n";
        }
   }

   untie %categories;

   return("Used SQL Version ... <BR> $done");
}   


sub SQL_Group_List {

      $SQL = "SELECT * FROM bm_group_def order by group_name";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { $groups{$rows[0]} = 1; }

      foreach $key( sort keys %groups) { 
         $bannermaster{'group_list'} .= "<TR><TD><INPUT NAME=\"delete\" VALUE=\"$key\" TYPE=\"checkbox\"></TD><TD><B>$key</B></TD></TR>\n" if($key ne "default" && $key ne "exchange");
    }
  
    return($bannermaster{'group_list'});

}

sub SQL_Group_Option_List {

   undef $bannermaster{'group_list'};

   $SQL = "SELECT group_name FROM bm_group_def ORDER BY group_name";
      $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
      $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");
      while (@rows = $sth->fetchrow_array) { 
        $bannermaster{'group_list'} .= "<OPTION VALUE=\"$rows[0]\">$rows[0]\n";
      }

}

1;
