#!/usr/local/bin/perl

##############################################################################
# PROGRAM : Bannermaster Ascii Admin Module                                  #
# VERSION : 4.03                                                             #
#                                                                            #
##############################################################################
#    ____                         __ __                                      #
#   /\  _`\    /'\_/`\           /\ \\ \                                     #
#   \ \ \L\ \ /\      \          \ \ \\ \                                    #
#    \ \  _ <'\ \ \__\ \   _______\ \ \\ \_                                  #
#     \ \ \L\ \\ \ \_/\ \ /\______\\ \__ ,__\                                #
#      \ \____/ \ \_\\ \_\\/______/ \/_/\_\_/                                #
#       \/___/   \/_/ \/_/             \/_/                                  #
#                                                                            #
##############################################################################
# All source code, images, programs, files included in this distribution     #
# Copyright (c) 1996,1997,1998,1999,2000                                     #
#                                                                            #
#           John C. Cokos, The CCS Network, Inc.  IWeb, Inc.                 #
#           All Rights Reserved.                                             #
#                                                                            #
# Use, distibution, sale, or access to this program is forbidden without     #
# permission, except were permitted by the license agreement.                #
#                                                                            #
##############################################################################
#                                                                            #
#    ------ DO NOT MODIFY ANYTHING BELOW THIS POINT !!! -------              #
#                                                                            #
#    Modification of the souce code of this program violates the             #
#    license agreement, and terminates your right to technical support.      #
#                                                                            #
##############################################################################
#START#


   package IWEB;
   require Exporter;
   @ISA = qw(Exporter);
   @EXPORT = qw( Ascii_Save_Groups  Ascii_Update_Group_Record  Ascii_Get_Group_Data  
                 Ascii_Get_Account  Ascii_Save_Account  Ascii_Delete_Account  
                 Ascii_Get_Account_List  Ascii_Account_Option_List  Ascii_Account_to_BM  
                 Ascii_Get_Campaign  Ascii_Save_Campaign  Ascii_Delete_Campaign  
                 Ascii_Get_Campaign_List  Ascii_Init_Campaign  Ascii_Assign_Groups  
                 Ascii_Save_Group_Assignment  Ascii_Get_Campaign_Info  Ascii_Get_Grand_Totals  
                 Create_Hyperseek_Banner_Groups  Ascii_Group_Option_List  Ascii_Group_List  
             );

sub Ascii_Save_Groups {

    my $group_list = $input{'delete'};
    my $addme = $input{'add'};
    my @delete_us = split(/ /,$group_list);
    my ($group);      

      open("GRP","$data_dir/bannermaster/groups/groups.def");
        while(<GRP>) { chomp; $groups{$_}++; }
      close(GRP);

      if( $addme ) { 
        $addme =~ s/ /_/g;
        $groups{$addme}++;
        if (! -e "$data_dir/bannermaster/groups/$addme.grp") {
           open("FILE","> $data_dir/bannermaster/groups/$addme.grp");
           close(FILE);
        }
      }

      if($group_list) {
        foreach $group(@delete_us) { 
           delete $groups{$group};
           if (-e "$data_dir/bannermaster/groups/$group.grp") {
              unlink "$data_dir/bannermaster/groups/$group.grp";
           }
        }
      }

      open("GRP",">$data_dir/bannermaster/groups/groups.def");
         foreach $key(keys %groups) { print GRP "$key\n"; }
      close(GRP);

}



sub Ascii_Update_Group_Record {

   $bannermaster{'acctlist'} = $input{'account'};
   $bannermaster{'acctlist'} =~ s/ /\|/g;
   $bannermaster{'group'} = $input{'group'};

   open("FILE","> $data_dir/bannermaster/groups/$bannermaster{'group'}.grp");
     print FILE "$bannermaster{'acctlist'}";
   close(FILE);

}


sub Ascii_Get_Group_Data {

   $bannermaster{'group'} = $input{'group'};
   undef %accounts;

   opendir(ACTS,"$data_dir/bannermaster/campaigns/");
       while ($bannermaster{'file'} = readdir(ACTS)) {
          if ($bannermaster{'file'} =~ /.*\.dat/) { 
              $bannermaster{'file'} =~ s/\.dat//g;
              $accounts{$bannermaster{'file'}}++; 
          }
       }
   closedir(ACTS);

   open("GRPFILE","$data_dir/bannermaster/groups/$bannermaster{'group'}.grp");
      while(<GRPFILE>) {
        foreach $entry(split(/\|/,$_)) { $groups{$entry}++; }
      }
   close(GRPFILE);

}


sub Ascii_Get_Account {

   my $acct = $input{'account'};
   my ($var,$val);      

   open(FILE,"$data_dir/bannermaster/accounts/$acct.dat");
       while(<FILE>) {
         chomp;
         ($var,$val)=split(/\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $account{$var}=$val;
       } 
   close(FILE);

}

sub Ascii_Save_Account {

    my($new)=$_[0];

    $input{'acct_id'} =~ s/ /_/g;

    if(-e "$data_dir/bannermaster/accounts/$input{'acct_id'}.dat" && $new) {
       print "Content-Type: text/html\n\n";
       print IWEB::Admin_Header("Account Exists");
       print qq!
           The account: $input{'acct_id'} exists, please enter a new account id
           and resubmit the addition.<BR><BR>
           <CENTER><A HREF="javascript:history.go(-1)">Return to add form</A></CENTER>
       !;
       print IWEB::Admin_Footer();
       IWEB::Quit();
    }

    $LINE = "acct_id=$input{'acct_id'}\n";
    $LINE .= "acct_password=$input{'acct_password'}\n";
    $LINE .= "contact_email=$input{'contact_email'}\n";
    $LINE .= "contact_name=$input{'contact_name'}\n";
    $LINE .= "address=$input{'address'}\n";
    $LINE .= "city=$input{'city'}\n";
    $LINE .= "state=$input{'state'}\n";
    $LINE .= "zip=$input{'zip'}\n";
    $LINE .= "phone=$input{'phone'}\n";
    $LINE .= "fax=$input{'fax'}";

    copy ("$data_dir/bannermaster/accounts/$input{'acct_id'}.dat", "$data_dir/bannermaster/accounts/$input{'acct_id'}.bak");
    open(ACT,">$data_dir/bannermaster/accounts/$input{'acct_id'}.dat");
      print ACT $LINE;
    close(ACT);


}

sub Ascii_Delete_Account {

   my $acct_name = $input{'account'};

   copy ("$data_dir/bannermaster/accounts/$acct_name.dat", "$data_dir/bannermaster/accounts/$acct_name.bak");
   unlink("$data_dir/bannermaster/accounts/$acct_name.dat");

   print "Content-Type: text/html\n\n";
   print "Account $acct_name Deleted.<HR><BLOCKQUOTE>\n";
   print "However, all current campaigns for this account are NOT, they must be deleted manually.\n";

}


sub Ascii_Get_Account_List {

   my $list;      

   opendir(FILES, "$data_dir/bannermaster/accounts");

    while($bannermaster{'file'} = readdir(FILES)) {
        if($bannermaster{'file'} =~ /.*\.dat/ && $bannermaster{'file'} !~ /.*\.bak/ ) {
           $bannermaster{'file'} =~ s/.dat//g;
           $list .= qq!
            $bannermaster{'file'}: <A HREF="$PROG_URL?action=Edit+Account&account=$bannermaster{'file'}">Edit</A> ... 
            <A HREF="$PROG_URL?action=DeleteAccount&account=$bannermaster{'file'}">Delete</A><BR>
           !;
        }
    }
   closedir(FILES);

   return($list);

}

sub Ascii_Account_Option_List {

   my $list;      

   opendir(FILES, "$data_dir/bannermaster/accounts");

    while($bannermaster{'file'} = readdir(FILES)) {
        if($bannermaster{'file'} =~ /.*\.dat/ && $bannermaster{'file'} !~ /.*\.bak/ ) {
           $bannermaster{'file'} =~ s/.dat//g;
           $list .= qq!
            <OPTION VALUE="$bannermaster{'file'}">$bannermaster{'file'}</OPTION>
           !;
        }
    }
   closedir(FILES);

   return($list);

}

sub Ascii_Account_to_BM {

    $SQL = qq!
      UPDATE accounts SET
      acct_type = 'bannermaster'
      WHERE acct_id = '$input{'acct_id'}'
    !;

    $sth = $dbh->prepare($SQL) || IWEB::SQL_ERROR($SQL);
    $rc = $sth->execute || IWEB::SQL_ERROR("SQL: $SQL");

    print "Content-Type: text/html\n\n";
    print IWEB::Admin_Header("Account updated");
    print qq!
       <BR><BR><B>Account has been updated to "Bannermaster" status.
    !;
    print IWEB::Admin_Footer();
    IWEB::Quit();

}


sub Ascii_Get_Campaign {

   my $account = $input{'account'};
   my ($var,$val);      

   my $totfile = "$data_dir/bannermaster/campaigns/$account.ttl";

   open(FILE,"$data_dir/bannermaster/campaigns/$account.dat");
       while(<FILE>) {
         chomp;
         ($var,$val)=split(/\=\=/,$_,2);
         $var=~s/^\s+//g;
         $var=~s/\s+$//g;
         $val=~s/^\s+//g;
         $val=~s/\s+$//g;
         $account{$var}=$val;
       } 
   close(FILE);

   open(FILE,"$totfile");
       undef %temp;
       while(<FILE>) {
          chomp;
          ($var,$val)=split(/\=\=/,$_,2);
          $var=~s/^\s+//g;
          $var=~s/\s+$//g;
          $val=~s/^\s+//g;
          $val=~s/\s+$//g;
          $totals{$var}=$val;
       } 
   close(FILE);

}

sub Ascii_Save_Campaign {

    my $newacct = $_[0];

    my (%ttl,%save,$newkey,$key);      

    ### Values from input...
    $save{'acct_name'}       = $input{'acct_name'};
       $save{'acct_name'} =~ s/ /_/g;

    $save{'acct_login'}      = $input{'acct_login'};
    $save{'target'}          = $input{'target'};
    $save{'redirect_url'}    = $input{'redirect_url'};
    $save{'alt_text'}        = $input{'alt_text'};
    $save{'under_text'}      = $input{'under_text'};
    $save{'banner_type'}    = $input{'banner_type'};
    $save{'banner'}         = $input{'banner'};
    $save{'banner_width'}   = $input{'banner_width'};
    $save{'banner_height'}  = $input{'banner_height'};
    $save{'banner_text'}  = $input{'banner_text'};
      $save{'banner_text'} =~ s/\cM//g;
      $save{'banner_text'} =~ s/\n//g;
      $save{'banner_text'} =~ s/\r//g;
    $save{'expiration_type'} = $input{'expiration_type'};
    $save{'num_clicks'}      = $input{'num_clicks'};
    $save{'num_impressions'} = $input{'num_impressions'};
    $save{'start_date'}      = $input{'start_date'};
    $save{'end_date'}        = $input{'end_date'};

    $ttl{'Impressions'}        = $input{'Impressions'};
    $ttl{'Clicks'}        = $input{'Clicks'};
    $ttl{'credits'}        = $input{'credits'};
    $ttl{'shown'}        = $input{'shown'};


    ## Create the account data file
    # Backup 1;
    if(-e "$data_dir/bannermaster/campaigns/$save{'acct_name'}.dat") {
       copy ("$data_dir/bannermaster/campaigns/$save{'acct_name'}.dat", "$data_dir/bannermaster/campaigns/$save{'acct_name'}.edit");
    }

    open(NEW,">$data_dir/bannermaster/campaigns/$save{'acct_name'}.dat");
       foreach $key(keys %save) {
          $newkey = $key;
          $newkey=~s/^\s+//g;
          $newkey=~s/\s+$//g;
          $save{$key}=~s/^\s+//g;
          $save{$key}=~s/\s+$//g;
          print NEW "$newkey==$save{$key}\n";
       }
    close(NEW);

    if(! -e "$data_dir/bannermaster/campaigns/$save{'acct_name'}.orig") {
       copy("$data_dir/bannermaster/campaigns/$save{'acct_name'}.dat","$data_dir/bannermaster/campaigns/$save{'acct_name'}.orig");
    }


    if($newacct) {
       if ($save{'expiration_type'} eq "exchange") {
          open ("DEF", ">>$data_dir/bannermaster/groups/exchange.grp");
            print DEF "|$save{'acct_name'}";
          close(DEF);

          IWEB::Email_Pending();
       }
    }

}


sub Ascii_Delete_Campaign {

   $acct_name = $input{'account'};

   print "Content-Type: text/html\n\n";

   if($windows eq "YES") { opendir(FILES, "$base_path\\bannermaster\\logs"); }
   else { opendir(FILES, "$data_dir/bannermaster/logs"); }
     @allfiles=readdir(FILES);
   closedir(FILES);   

   for $x ( 0 .. $#allfiles ) {
      if ($allfiles[$x] =~ "$acct_name") {
        unlink "$data_dir/bannermaster/logs/$allfiles[$x]";
      }
   }

   unlink "$data_dir/bannermaster/campaigns/$acct_name.dat";
   unlink "$data_dir/bannermaster/campaigns/$acct_name.DISABLED";

   undef %groups;
    open("GRP","$data_dir/bannermaster/groups/groups.def");
      while(<GRP>) { 
        chomp;
        $groups{$_}++;
      }
    close(GRP);   

    $groups{"default"}++;
    $groups{"exchange"}++;
    foreach $group(keys %groups) {

       $xxx .= "Working on $group<BR>\n";

       undef %grp;
       open ("NEW", ">$data_dir/bannermaster/groups/$group.new");
       open ("DAT", "$data_dir/bannermaster/groups/$group.grp");
          foreach $act(split(/\|/,<DAT>)) { $grp{$act}++ if($act ne $acct_name); }
       close(DAT);

       foreach $act(keys %grp) {
          $xxx .= " ...Saving $act<BR>\n";
          print NEW "$act|";    
       }

       close(NEW);
       rename "$data_dir/bannermaster/groups/$group.new", "$data_dir/bannermaster/groups/$group.grp"; 

    }

   print "Campaign Deleted.<HR><BLOCKQUOTE>\n";
   print "All associated files are gone and the database has been updated.\n";
   print "However, we recommend that you check the directories via FTP or telnet to ensure that.\n";
   print "they were all properly removed.  If not, you will need to remove them by hand.\n";
   print "<BR><BR>$xxx";

}


##############################################################################
# List the categories and sub categories
##############################################################################
sub Ascii_Get_Campaign_List {

    opendir(FILES, "$data_dir/bannermaster/campaigns");

    while($bannermaster{'file'} = readdir(FILES)) {
        if($bannermaster{'file'} =~ /.*\.dat/ && $bannermaster{'file'} !~ /.*\.bak/ ) {
           $bannermaster{'file'} =~ s/.dat//g;
           IWEB::Ascii_Get_Campaign_Info();
        }
    }

    closedir(FILES);

    foreach $key(sort keys %accounts) {
       if($key) {
               if(-e "$data_dir/bannermaster/campaigns/$key.DISABLED") { $accounts{$key}{'action'} = "Re-Enable"; }
               else { $accounts{$key}{'action'} = "Disable"; }

               if ( $accounts{$key}{'Impressions'} >= 1 ) { 
                 $accounts{$key}{'pct'} = $accounts{$key}{'Clicks'} / $accounts{$key}{'Impressions'};
                 $accounts{$key}{'pct'} = $accounts{$key}{'pct'}*100;
               }
               else  { $accounts{$key}{'pct'} = 0; }
               $accounts{$key}{'pct'} = sprintf ("( %2.2f \% )\n", $accounts{$key}{'pct'});
   
               if ($accounts{$key}{'expiration_type'} eq "impressions") {
                   $accounts{$key}{'ri'} = ($accounts{$key}{'num_impressions'} - $accounts{$key}{'Impressions'});
                   $accounts{$key}{'expiremessage'} = "$accounts{$key}{'num_impressions'} Total impressions .... $accounts{$key}{'ri'} Remaining";
               }
               elsif ($accounts{$key}{'expiration_type'} eq "clicks") {
                   $accounts{$key}{'ri'} = ($accounts{$key}{'num_clicks'} - $accounts{$key}{'Clicks'});
                   $accounts{$key}{'expiremessage'} = "$accounts{$key}{'num_clicks'} Total clicks .... $accounts{$key}{'ri'} Remaining";
               }
               elsif ($accounts{$key}{'expiration_type'} eq "date") {
                   $accounts{$key}{'expiremessage'} = "Account Expires on $accounts{$key}{'end_date'}.";
               }
               elsif ($accounts{$key}{'expiration_type'} eq "exchange") {
                   $accounts{$key}{'expiremessage'} = "Exchange Credits: $accounts{$key}{'credits'}.";
               }
           
               my $tkey = IWEB::urlencode($key);

               $bannermaster{'tablerows'} .= qq!
               <TR>
                 <TD><B>$accounts{$key}{'acct_name'}</B></TD>
                 <TD><B>$accounts{$key}{'Impressions'}</B></TD>
                 <TD><B>$accounts{$key}{'Clicks'}</B></TD>
                 <TD><B>$accounts{$key}{'pct'}</B></TD>
                 <TD><I>$accounts{$key}{'expiremessage'}</I></TD>
                 <TD>
                     <A HREF="$PROG_URL?account=$tkey&action=Edit+Campaign">Edit</A> / 
                     <A HREF="$PROG_URL?account=$tkey&action=Delete+Campaign">Delete</A> / 
                     <A HREF="$PROG_URL?account=$tkey&action=Assign+Groups">Groups</A> / 
                     <A HREF="$PROG_URL?account=$tkey&action=$accounts{$key}{'action'}">$accounts{$key}{'action'}</A> / 
                     <A HREF="$urls{'report_url'}?campaign=$tkey&MODE=admin">Stats</A> / 
                     <A HREF="$PROG_URL?account=$tkey&action=Re-Initialize">Re-Init</A>
                 </TD>
               </TR>
               !;
       }
    }

}




sub Ascii_Init_Campaign {

   my($acct_name,@allfiles);

   $acct_name = $input{'account'};

   opendir(FILES, "$data_dir/bannermaster/logs");
     @allfiles=readdir(FILES);
   closedir(FILES);           

   for $x ( 0 .. $#allfiles ) {
      if ($allfiles[$x] =~ "$acct_name") {
        unlink "$data_dir/bannermaster/logs/$allfiles[$x]";
      }
   }

   open(TTL,">$data_dir/bannermaster/campaigns/$acct_name.ttl");
     print TTL "Impressions==0\nClicks==0\n";
   close(TTL);

}



sub Ascii_Assign_Groups {

    open("GRP","$data_dir/bannermaster/groups/groups.def");
      @groups=<GRP>;
    close(GRP);   

    push @groups,"default";
    push @groups,"exchange";

    @groups = sort @groups;

    for $x (0 .. $#groups) {
       $groups[$x] =~ s/\n//g;
       $groups[$x] =~ s/\cM//g;
       open(G,"$data_dir/bannermaster/groups/$groups[$x].grp");
         if(<G>=~$input{'account'}) {
           $bannermaster{'grplisting'} .= "        <INPUT TYPE=\"checkbox\" NAME=\"group\" VALUE=\"$groups[$x]\" CHECKED>$groups[$x]\n";
         } 
         else {
           $bannermaster{'grplisting'} .= "        <INPUT TYPE=\"checkbox\" NAME=\"group\" VALUE=\"$groups[$x]\">$groups[$x]\n";
         } 
       close(G);
    }

}


sub Ascii_Save_Group_Assignment {

    my %accounts;      
    my %ingrp;      
    my @groups;      
    my ($acct,$grp);      

    open("GRP","$data_dir/bannermaster/groups/groups.def");
      @groups=<GRP>;
    close(GRP);   

    push @groups,"default";
    push @groups,"exchange";

    foreach $grp( split(/\s+/,$input{'group'}) ){
        $ingrp{$grp}++;
    }

    ## Update the relevant group files
    for $x( 0 .. $#groups ) {
       chomp($groups[$x]);
       $bannermaster{'file'} = "$data_dir/bannermaster/groups/$groups[$x].grp";
          undef %accounts;
          open ("DAT", "$bannermaster{'file'}");
              while(<DAT>) { 
                chomp;
                foreach $acct( split(/\|/,$_) ) { $accounts{$acct}++; }
              }
          close(DAT);
          if($ingrp{$groups[$x]}) {
             $accounts{$input{'account'}}++;
             $bannermaster{'added'} .= "$groups[$x]<BR>";
          }
          elsif($accounts{$input{'account'}}) {
             delete $accounts{$input{'account'}};
             $bannermaster{'deleted'} .= "$groups[$x]<BR>";
          }

          open ("GRP", ">$bannermaster{'file'}");
          foreach $acct(keys %accounts) { 
             print GRP "$acct|";
          }
          close(GRP);
    }

}



sub Ascii_Get_Campaign_Info {

   my $actfile = "$data_dir/bannermaster/campaigns/$bannermaster{'file'}.dat";
   my $totfile = "$data_dir/bannermaster/campaigns/$bannermaster{'file'}.ttl";
   if(-e $actfile) { 
           open(FILE,"$actfile");
             undef %temp;
             while(<FILE>) {
               chomp;
               ($var,$val)=split(/\=\=/,$_,2);
               $var=~s/^\s+//g;
               $var=~s/\s+$//g;
               $val=~s/^\s+//g;
               $val=~s/\s+$//g;
               $accounts{$bannermaster{'file'}}{$var}=$val;
             } 
          close(FILE);

           open(FILE,"$totfile");
             undef %temp;
             while(<FILE>) {
               chomp;
               ($var,$val)=split(/\=\=/,$_,2);
               $var=~s/^\s+//g;
               $var=~s/\s+$//g;
               $val=~s/^\s+//g;
               $val=~s/\s+$//g;
               $accounts{$bannermaster{'file'}}{$var}=$val;
             } 
          close(FILE);
   }

}

sub Ascii_Get_Grand_Totals {

   my($acct,$file,@account,$totfile,%temp,$val,$var,$pct);      

   $bannermaster{'gt_impressions'} = 0;
   $bannermaster{'gt_clicks'} = 0;

   opendir(FILES, "$data_dir/bannermaster/campaigns");
    while($file = readdir(FILES)) {
        if($file =~ /.*\.ttl/ && $file !~ /.*\.bak/ ) {
           $totfile = "$data_dir/bannermaster/campaigns/$file";
           open(FILE,"$totfile");
             undef %temp;
             while(<FILE>) {
               chomp;
               ($var,$val)=split(/\=\=/,$_,2);
               $var=~s/^\s+//g;
               $var=~s/\s+$//g;
               $val=~s/^\s+//g;
               $val=~s/\s+$//g;
               $temp{$var}=$val;
             } 
          close(FILE);
          $bannermaster{'gt_clicks'} += $temp{'Clicks'};
          $bannermaster{'gt_impressions'} += $temp{'Impressions'};

        }
    }
   closedir(FILES);

   if ( $bannermaster{'gt_impressions'} >= 1 ) { 
      $pct = $bannermaster{'gt_clicks'} / $bannermaster{'gt_impressions'};
      $pct = $pct*100;
   }
   else { $pct = "0.00"; }

   $bannermaster{'gt_ratio'} .= sprintf ("( %2.2f \% )\n", $pct);

}

sub Create_Hyperseek_Banner_Groups {
                                                                                
   my(%groups,%categories,$z,$category,$done,%glist);      

   eval("use DB_File");

   if($@) { IWEB::iWeb_Header( IWEB::ERROR("Cannot Create, DB_File not able to load") ); IWEB::Quit(); }

   tie %categories, "DB_File", "$data_dir/hyperseek/categories/master.db", O_RDONLY;

   open("GRP","$data_dir/bannermaster/groups/groups.def");
      while(<GRP>) {
        chomp;
        $glist{$_}++;
      }
   close(GRP);

   foreach $category(sort keys %categories) {
       $category = IWEB::Make_Alpha($category);
       open(CAT,">>$data_dir/bannermaster/groups/$category.grp");
       close(CAT);
       $glist{$category}++;
   }

   open(DEF,">$data_dir/bannermaster/groups/groups.def");
     foreach $key(keys %glist) {
       print DEF "$key\n";
       $done .= "$key<BR>";
     }
   close(DEF);

   untie %categories;

   return("Used Ascii Version ... <BR> $done");

}                                                                               


sub Ascii_Group_Option_List {

   my(@groups,$x);      

   undef $bannermaster{'group_list'};

   open("GRP","$data_dir/bannermaster/groups/groups.def");
      @groups=<GRP>;
   close(GRP);   
   @groups = sort(@groups);
      for $x (0 .. $#groups) {
        $groups[$x] =~ s/\n//g;
        $bannermaster{'group_list'} .= "<OPTION VALUE=\"$groups[$x]\">$groups[$x]\n";
      }

}

1;



sub Ascii_Group_List {

    my($glist);

    open("GRP","$data_dir/bannermaster/groups/groups.def");
      @groups=<GRP>;
    close(GRP);

    @groups = sort @groups;

    for $x (0 .. $#groups) {
       chomp ($groups[$x]);
       $glist .= "<TR><TD><INPUT NAME=\"delete\" VALUE=\"$groups[$x]\" TYPE=\"checkbox\"></TD><TD><B>$groups[$x]</B></TD></TR>\n" if($groups[$x] ne "default" && $groups[$x] ne "exchange");
    }

    return($glist);
}



