<?php

//******************************************************************************
// 9/27/2001  rachael@kreisler.org  version .07
//
// This example is released without any warranty, even the implied warranty of 
// fitness for a particular purpose.  It is not warranted to be good code :)  It 
// is for example purposes only.  To use it, you MUST compile PHP with cURL 
// (http://curl.haxx.se) support, and cURL must be compiled with SSL support.  
// While I cannot support this code snippet, I may answer questions about it 
// addressed to rachael@kreisler.org.  You should always be able to find the 
// latest version at http://www.kreisler.org/surepay/index.php.  Suggestions, 
// comments and patches are all welcome.

// The function for parsing the XML result was submitted by Dave Whitinger 
// (email dave@whitinger.net).

// Please see my notes at http://www.kreisler.org/surepay/index.php about 
// adapting this for a production environment.
//******************************************************************************

echo '
<html>
<head>
<title>Testing cURL with SurePay</title>
</head>

<body bgcolor="ffffff">';

//******************************************************************************
// BUILD REQUEST DOCUMENT TO BE POSTED TO SUREPAY
//******************************************************************************

/* I have added the minimum information necessary to authorize a credit card, 
with a few optional attributes marked "optional".  The variables marked as 
"from form" should be replaced with variables sumitted from the form you 
build.  They should be verified before they're added to the request variable. */


// INFORMATION REQUIRED TO BEGIN THE REQUEST.  
// THIS DEFINES THE VARIABLE NAME FOR POSTING AND THE DOC TYPE

$reqheader = 'xml=<!DOCTYPE pp.request PUBLIC "-//IMALL//DTD PUREPAYMENTS 1.0//EN" "http://www.purepayments.com/dtd/purepayments.dtd">';

// BUILD PP.REQUEST TAG

$merchantid = '1001';
$password = 'password'; 

$start = '<pp.request merchant="' . $merchantid . '" password="' . $password . '">';

// BUILD PP.AUTH TAG

$orderid = '1';
$shippingcost = '0.00';        // optional
$auth = '<pp.auth ordernumber="' . $orderid . '" shippingcost="' . $shippingcost . 'USD" >';

// BUILD CREDITCARD TAG

$ccno = '4012000033330026';
$expiration = '10/08';

$creditcard = '<pp.creditcard number="' . $ccno . '" expiration="' . $expiration . '">';

// BUILD ADDRESS TYPE=BILLING TAG (OPTIONAL IF SHIPPING IS SAME AS BILLING)

$billfname = 'Bob';
$billlname = 'Smith';
$billaddress1 = '1 Bobsmith Dr';
$billaddress2 = "";    // optional
$billcity = 'Smithtown';
$billstate = 'NJ';
$billzip = '55555';
$billphone = '1112223333';    // optional
$billemail = 'bob@kreisler.org';    // optional

$billaddress = '<pp.address type="billing" firstname="' . $billfname . '" lastname="' . $billlname . '" address1="' . $billaddress1 . '" address2="' . $billaddress2 . '" city="' . $billcity . '" state="' . $billstate . '" zip="' . $billzip . '" country="US" phone="' . $billphone . '" email="' . $billemail . '"/>';

// BUILD ADDRESS TYPE=SHIPPING TAG

$shipfname = 'Bob';
$shiplname = 'Smith';
$shipaddress1 = '14 Bobsmith Dr';
$shipaddress2 = "";    // optional
$shipcity = 'Smithtown';
$shipstate = 'NJ';
$shipzip = '55555';
$shipphone = '1112223333';    // optional
$shipemail = 'bob@kreisler.org';    // optional

$shipaddress = '<pp.address type="shipping" firstname="' . $shipfname . '" lastname="' . $shiplname . '" address1="' . $shipaddress1 . '" address2="' . $shipaddress2 . '" city="' . $shipcity . '" state="' . $shipstate . '" zip="' . $shipzip . '" country="US" phone="' . $shipphone . '" email="' . $shipemail . '"/>';

// BUILD LINEITEM TAG

$sku = '3';
$description = 'Perfume';
$quantity = '1';
$unitprice = '11.00';

$lineitem = '<pp.lineitem sku="' . $sku . '" description="' . $description . '" quantity="' . $quantity . '" taxrate="0" unitprice="' . $unitprice . 'USD"/>';

// CONCATENATE TAGS AND TAG CLOSURES TO CREATE XML REQUEST

$request = $reqheader . $start . $auth . $creditcard . $billaddress . '</pp.creditcard>' . $shipaddress . $lineitem . '</pp.auth></pp.request>';


//******************************************************************************
// INITIALIZE cURL SESSION AND SET OPTIONS.  SEE PHP MANUAL FOR MORE DETAILS.
// http://www.php.net/manual/en/ref.curl.php
//******************************************************************************

// INITIALIZE 

$ch = curl_init ();

// TELL cURL WHERE TO POST THE REQUEST.  UNCOMMENT THE SECOND URL TO SEND A LIVE POST.

curl_setopt ($ch, CURLOPT_URL, "https://xml.test.surepay.com");
//curl_setopt ($ch, CURLOPT_URL, "https://xml.surepay.com");

// TELL cURL TO DO A REGULAR HTTP POST.

curl_setopt ($ch, CURLOPT_POST, 1);

// PASS THE REQUEST STRING THAT WE BUILD ABOVE

curl_setopt ($ch, CURLOPT_POSTFIELDS, $request);

// TELL cURL TO USE strlen()  TO GET THE DATA SIZE.

curl_setopt ($ch, CURLOPT_POSTFIELDSIZE, 0);

// TELL cURL WHEN TO TIME OUT 
//IF YOU'RE TIMING OUT BEFORE GETTING A RESPONSE FROM SUREPAY, INCREASE THIS NUMBER 

curl_setopt ($ch, CURLOPT_TIMEOUT, 360); 
                                  
// TELL cURL TO INCLUDE THE HEADER IN THE OUTPUT 

curl_setopt ($ch, CURLOPT_HEADER, 0);

// TELL cURL TO USE SSL VERSION 3.

curl_setopt ($ch, CURLOPT_SSLVERSION, 3);

// TRANSFER THE SUREPAY RESPONSE INTO A VARIABLE.

curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);


//******************************************************************************
// EXECUTE THE REQUEST
//******************************************************************************

$result = curl_exec ($ch);

// COMMENT OUT THE FOLLOWING LINE TO HIDE THE XML REQUEST

echo '<b>Request to Surepay:</b><br>' . htmlspecialchars($request) . '<br><br>';

// COMMENT OUT THE FOLLOWING LINE TO HIDE THE XML RESULT

echo '<b>Response from Surepay:</b><br>' . htmlspecialchars($result) . '<br><br>';

// COMMENT OUT THE FOLLOWING LINE TO HIDE ANY CURL ERRORS

$curl_array = curl_getinfo($ch);
echo '<b>Curl Info:</b><br>';
while (list ($key, $val) = each ($curl_array)) {
    echo '<b>key</b> = ' . $key . ' <b>val</b> = ' . $val . '<br>';
}
echo '<br><br>'; 
        

//******************************************************************************
// PARSE RESPONSE
//******************************************************************************

/* When you're testing, the XML string indicates that a card is authorized (AUTH), 
declined (DCL) or referred (REF), according to the credit card number (you must use 
Visa 4012000033330026) and total order amount (total = the amount the customer 
would see on their charge card). 

$11 = "AUTH"
$21 = "REF"
$31 = "DCL".  

Anything else should give you an error indicated by "ERR". */

// OPTION 1: PARSE RESULTING XML (SUBMITTED BY DAVE WHITIGER)

function DG_Parser($simple) 
{
    $p = xml_parser_create();
    xml_parse_into_struct($p,$simple,$vals,$index);
    xml_parser_free($p);

    return ($vals[1]["attributes"]);
}

// CALL THE XML PARSING FUNCTION TO CREATE ARRAY OF RESULT

$attributes = dg_parser($result);

// ITERATE THROUGH ALL THE KEY VALUE PAIRS OF THE ARRAY

echo '<b>XML Response Values Parsed into Array:</b><br>';

while (list ($key, $val) = each ($attributes)) {
    echo '<b>key</b> = ' . $key . ' <b>