<html><body>
<?php
 // Sauen PHP Surepay lib - version 0.1.1 Beta - 2002 March 19
 // test.php - This files contain test/samples usage of the sausp class.
 // ---------------------------------------------------------------------------
 /* Licensed under GNU General Public License (GPL) v2.0
    Code collection providing functions and classes for the Surepay.Com gateway.
    Copyright (C) 2001  J.T.Stokkeland and Sauen.Com.

    This code-collection is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 // With this file you should have received the file license.txt which contains
 // the full GNU GPL license details. Author contact information:
 //   Jon T Stokkeland aka /Stoke/  SauSurepay@Sauen.Com
 //   302 E State St, Salamanca, NY, 14779, USA
 // ---------------------------------------------------------------------------
 // For more information about versions and other helpful info, see readme.html  
 // Homepage of this PHP code collection lib: http://sausurepay.sourceforge.net
 // PS! This version is NOT a complete library of all the Surepay functions!
 // ---------------------------------------------------------------------------		

 # This version of test.php has more comments and usable samples than before,
 # two AUTH objects are created, one creditcard and one telecheck.
 # Many functions now support multiple/optional arguments, such as with 
 # add_creditcard you can now put the billing address right with it, or you can 
 # add the billing address with add_billing_address afterwards/separate.
 # The first part of this document does the creditcard request, and uses 
 # all the functions split up.
 # The second part is a Telecheck request and uses less functions with more
 # parameters, just to show the differences.
 # The third part takes care of submitting, receiving and decoding the 
 # response.
 # See the syntax specs with functions below, and the readme.html for more 
 # information.

 # NOTE:
 # Although some variables are noted as being "Object Identifiers", it may
 # not be a object type variable. In fact, in this version it is a text
 # string pointing to a a location in an array. BUT, this may change in
 # future versions, so you should not base anything on this variable other
 # than passing it on to other functions. (No typecasting)

 # If a function returns nothing it may have failed. The variable `err' contain
 # an error description if something went wrong. echo $object-->err
 # This error info is not ment for user output, it is for you to debug your
 # application, most common problem is XML-DTD violations, strings being to
 # long or data type not correct (READ THE SUREPAY SDK GUIDE!!!)

 # Another NOTE:
 # Surepay have changed their test numbers and such severald times, at the
 # moment of release of this version it is
 #
 #  Creditcard test AUTH:
 #     cc number: 4012000033330026   any future exp date
 #     $11 = AUTH     $21 = "REF"   $31 = "DCL"   any other may give "ERR"
 #     This test request uses total $1 shipping, and 1x$5 + 1x$5 goods, 
 #     total $11. Just change the item quantities to try the other status.
 #
 #  TeleCheck AUTH:
 #     Check number 1001
 #     MICR number  1234567804390850001001
 #     Any value should work, but at this very moment there are some problems
 #     with Telechecks test server, it works thru Surepay and the Telecheck
 #     server returns: General failure: com.purepayments.biz.telecheck.TeleCheckFailureException: TeleCheckProcessingError: TeleCheck returned Check Failure (807)
 #     If you get that your XML and request may be ok.
 #
 #  I have also found some bugs and weakneses in Surepays processing, here is a 
 #  couple of them:
 #
 #   - Do not add % as character data, best off staying away from it totally.
 #     This can cause surepays servlets to crash and gives a 500 server error.
 #
 #   - Do not convert < > & ' " to the correct XML entities, surepays parser or
 #     data collector rejects any characterdata like &lt; and so on.
 #
 #   - Phone numbers in address are limited length (stay 11 digits or less), they
 #     claim to be "US domestic oriented" (?)
 #
 #   - The surepayd SDK documentation is outdated and very inaccurate. Several things
 #     does not work as specified nor does the DTD specify all required fields, such
 #     as cvv2 must be specified even if not being used. Surepays own sample does not 
 #     work very well either. It has been like this for more than 6 month now, as
 #     of the date of release of this script. When will we see SDK 1.5? And a new
 #     improved DTD or Schema?
 #
 #   - What is the correct way to handle ref? Should the script handle and check
 #     avs and cvv2status responses to something automatically? If someone has 
 #     a guideline to this would be appreciated.. (sausurepay@sauen.com)



   # For this test script we'll give it a couple of minutes before php
   # times out...

     ini_set('max_execution_time','120');


   # Include the library file

     include ('sausurepay.php'); # Mandatory

   #@ sausp
   #~ Create an object of the sausp class that we will work with
   #~ This will set up and initialize the basic object/skeleton for a request
   #~ $ssp->err should be false/0/nothing after any successful function

   ## Syntax: 
   ##  vobject_identifier: sausp ( 
   ##     boolean: live?
   ##    ,string: merchant id
   ##    ,string: password
   ##   [,array: extra pp.request parameters ] 
   ##  )

     $ssp = new sausp ( false, '1001' , 'password'); # Mandatory

     /* Of course you must use your own id and pwd for a live request */


     if ($ssp->err) die($ssp->err); # Die with error description


   # Echo some heading for our test output

     echo '<h1>SauSurePay '.$ssp->version." test:</h1><PRE>\n";

   

/*****************************************************************

    ***  CREDIT CARD REQUEST ***

      add_auth
           add_shipping_address
           add_ordertext
           add_creditcard
                add_billing_address
           add_lineitem
                add_option
                add_option
           add_lineitem (incl 2 option's)
  
*****************************************************************/


   #@ add_auth
   #~ Create an AUTH object in the request
   #~ Optionally you can add shipping address and/or order text here instead
   #~ of using their own functions.

   ## Syntax:
   ##  object_identifier: add_auth (
   ##     array: auth parameters
   ##    ,[array: shipping address]
   ##    ,[array: ordertext (type and text)]
   ##  )

     $auth = $ssp->add_auth( 
        array(
         'ordernumber'     => '18140517',
         'ecommerce'       => 'true',
         'ecommercecode'   => '07',
         'ponumber'        => 'Verbal Hagar',
         'ipaddress'       => $REMOTE_ADDR,
         'shippingcost'    => '0.93USD',
         'taxamount'       => '0.07USD',
         'referringurl'    => $HTTP_REFERER,
         'browsertype'     => $HTTP_USER_AGENT,
        )
     );

     if ($ssp->err) die($ssp->err); # Die with error description


   #@ add_shipping_address
   #~ Create an ADDRESS object with type shipping. You want to attach this to 
   #~ the auth request, so use the return from that as a parent identifier here.

   ## Syntaxt:
   ##  object_identifier: add_shipping_address (
   ##      object identifier : parent object
   ##     ,array: address details
   ##  )

     $ssp->add_shipping_address(
        $auth,
        array(
          'fullname' => 'Hagar Tarball Horrible',
          'address1' => '123 Pilage street',
          'address2' => 'Suite 100',
          'city'     => 'Valhalla',
          'state'    => 'NA',
          'zip'      => '12345',
          'country'  => 'NO',
          'phone'    => '5555551234',
          'email'    => 'devnull@vikings.dot'
        )
     );

     if ($ssp->err) die($ssp->err); # Die with error description

   #@ add_ordertext
   #~ Inserts (optional) ordertext.
   #~ Remember: ordertext is very limited, check the Surepay SDK documentation,
   #~ people keep asking me about this and getting errors, my advice: Skip it!
   #~ (This could easily have been done in the add_auth function instead)

   ## Syntax:
   ##  object_identifier: add_ordertext (
   ##      object_identifier: parent object
   ##     ,string: type set (description|instructions|classification)
   ##     ,string: text (very limited length!)
   ##  )

     $ssp->add_ordertext(
        $auth,
        'instructions',
        'Mark as <urgent>'
     );

     if ($ssp->err) die($ssp->err); # Die with error description


   #@ add_creditcard
   #~ Adds a creditcard object. The cvv2 security feature should always be uses,
   #~ therefor the cvv2status is 1 by default an no need to specify it.
   #~ to turn it of, set code to 0 and status to 0. Status 9 can be 
   #~ uses optionally if the clients card has no code.

   ## Syntax:
   ##  object_identifier: add_creditcard (
   ##      object_identifier: parent object
   ##     ,string: card number
   ##     ,string: expiration (mm/yy)
   ##     ,int: cvv2 code from card
   ##    [,int: cvv2status (security mode) (0|1|9) default is 1 (In Use)]
   ##    [,array: billing address]
   ##  )
   
   # This sample does not use the cvv2 code since it is a test request
   # according to the surepay SDK specifications

     $creditcard = $ssp->add_creditcard(
        $auth,
        '4012000033330026',
        '12/05',
        '0',
        '0' 
     );


   #@ add_billing_address
   #~ Create an ADDRESS object with type billing. You want to attach this to 
   #~ the payment object, so use the return from that as a parent identifier here.

   ## Syntaxt:
   ##  object_identifier: add_billing_address (
   ##      object identifier : parent object
   ##     ,array: address details
   ##  )


     $ssp->add_billing_address(
        $creditcard,
        array(
          'fullname' => 'Hagar T Horrible',
          'address1' => '123 Pilage street',
          'address2' => 'Kitchen Delivery Door',
          'city'     => 'Valhalla',
          'state'    => 'NA',
          'zip'      => '12345',
          'country'  => 'NO',
          'phone'    => '5555551234',
          'email'    => 'devnull@vikings.dot'
        )
     );

     if ($ssp->err) die($ssp->err); # Die with error description


   #@ add_lineitem
   #~ Adds an item to the order. We recommend splitting it up and not
   #~ collect a total sum in one item. If you add only one item with the
   #~ total charge, it is between you, surepay, and your merchant account
   #~ provider to determine if it is the right way or not.
   #~ alternatively you can add option sub objects in the same function.

   ## Syntax:
   ##  object_identifier: add_lineitem (
   ##      object_identifier: parent object (The AUTH object)
   ##     ,int: quantity,
   ##     ,string: sku,
   ##     ,string: description, 
   ##     ,string: unit cost (currency) [d..d]d.ccUSD
   ##     ,real: taxrate in decimal notation (0.08 = 8%)
   ##    [,array: options ]
   ##  )

     $item = $ssp->add_lineitem (
        $auth,
        '60',
        'BEER_001',
        'Sixpack Samuel Adamas Boston Lager',
        '5.00USD',
        '0.08'
      );

     if ($ssp->err) die($ssp->err); # Die with error description


   #@ add_option
   #~ Add options to lineitem

   ## Syntax:
   ##  object_identifier: add_option (
   ##      object_identifier: parent object
   ##     ,string: option label
   ##     ,string: option value
   ##  )

      $ssp->add_option($item,'color','brown');
      if ($ssp->err) die($ssp->err); # Die with error description

      $ssp->add_option($item,'bottle','glas');
      if ($ssp->err) die($ssp->err); # Die with error description



   # Add another lineitem object (inlcuding two options) in the AUTH object

     $item = $ssp->add_lineitem (
        $auth,
        '1',
        'BEER_052',
        'Sixpack George Killians Irish Red',
        '5.00USD',
        '0.08',
        array (
           'type' => 'domestic',
           'logo' => 'horsehead'
        )
      );

     if ($ssp->err) die($ssp->err); # Die with error description


# This ends the Creditcard request, it could have been used as it is
# at this point to do a request to surepay.


/*************************************************************

    ***  TELECHECK REQUEST ***

      add_auth (inluding shipping address and ordertext)
           add_telecheck (including billing address and id)
           add_lineitem (incl option)
           add_lineitem
  
**************************************************************/
# Every function is not commented with syntax etc here,
# Only the ones not commented above.


   # First we'll add another AUTH object to our request
   # This time we'll include shipping address and ordertext in the same
   # function.

     $auth = $ssp->add_auth( 
        array(
         'ordernumber'     => '18140518',
         'ecommerce'       => 'true',
         'ecommercecode'   => '07',
         'ponumber'        => 'E-mail Hagar',
         'ipaddress'       => $REMOTE_ADDR,
         'shippingcost'    => '1.00USD',
         'taxamount'       => '0.00USD',
         'referringurl'    => $HTTP_REFERER,
         'browsertype'     => $HTTP_USER_AGENT,
        ),
        array(
          'fullname' => 'Jr. Hagar Horrible',
          'address1' => '145 Vaernes Gata',
          'address2' => 'Poelse med Lompe',
          'city'     => 'Valhalla',
          'state'    => 'NA',
          'zip'      => '12345',
          'country'  => 'NO',
          'phone'    => '+4712555554',
          'email'    => 'devnull@vikings.dot'
        ),
        array(
          'instructions' => 'Pottittstappe med saus'
        )
     );

     if ($ssp->err) die($ssp->err); # Die with error description


   #@ add_telecheck
   #~ Adds a telecheck object. See http://www.telecheck.com for info on what it is
   #~ Basically it lets people pay with a paper check, telecheck "Converts" it to
   #~ an electronic payment. You must have a TeleCheck Merchant account to use it!

   ## Syntax:
   ##  object_identifier: add_telecheck (
   ##      object_identifier: parent object
   ##     ,string: Check number
   ##     ,string: MICR number (Continous string of EVERY number on the bottom of the check)
   ##     ,boolean: isbusiness (true = business, false=persona)
   ##    [,array: identification object attributes (Dr.license)]
   ##    [,array: billing address]
   ##  )
   
   # This sample does not use the cvv2 code since it is a test request
   # according to the surepay SDK specifications

     $telecheck = $ssp->add_telecheck (
        $auth,
        '1001',
        '1234567804390850001001',
        'true',
        array (
          'type'     => 'driverslicense',
          'number'   => '123123123',
          'issuedby' => 'NY'
        ),
        array(
          'fullname' => 'Hagar Zipdrive Horrible',
          'address1' => 'PO Box 1',
          'city'     => 'Valhalla',
          'state'    => 'NA',
          'zip'      => '12345',
          'country'  => 'NO',
          'phone'    => '+4712555554',
          'email'    => 'devnull@vikings.dot'
        )      
     );

     if ($ssp->err) die($ssp->err); # Die with error description


/* Alternatively you could have used the separate functions
   add_id_driverslicense and add_billing_address instead */

   #@ add_id_driverslicense
   #~ Add a id object of type driverslicense

   ## Syntax:
   ##  object_identifier: add_id_driverslicense (
   ##      object_identifier: parent object
   ##     ,string: number (License number)
   ##     ,string: issuedby (In US use state 2 letter abreviation code)
   ##  )

/* 
   Sample of usage: 
   (Not used in test script since already included in add_telecheck sample)

   $ssp->add_id_driverslicense (
       $telecheck,
       '321321321',
       'CA'
    );

*/

   
   # Add a couple of items

     $item = $ssp->add_lineitem (
        $auth,
        '1',
        'BEER_021',
        'Heineken Dark',
        '5.00USD',
        '0.08',
        array (
           'type' => 'import',
        )
      );

     if ($ssp->err) die($ssp->err); # Die with error description

     $item = $ssp->add_lineitem (
        $auth,
        '1',
        'BEER_031',
        'Bass',
        '5.00USD',
        '0.08'
      );

     if ($ssp->err) die($ssp->err); # Die with error description


# This ends the Telecheck request


/*************************************************************

  ***  Submittal to Surepay's server and response decode ***

  
**************************************************************/



   #@ prepare_request
   #~ Takes all the added objects and creates XML data
   #~ The XML data is stored in variable xml_request as well as returned
   #~ You MUST execute this before posting a request

   ## Syntax:
   ##  string: prepare_request ()

     $ssp->prepare_request();

     if ($ssp->err) die($ssp->err); # Die with error description


   # At this point in the script you could:
   #  Use the created XML data and submit by other means
   #    or
   #  Have built the XML data your self and assign it to xml_request
   #    or
   #  Manipulate the XML data to fit spesific needs or perhaps store it
   #  in a database or file or send email (USE ENCRYPTION!!!)
 

   # Give some output for this test script
   echo "</PRE><h2>The Request we are submitting:</H2><PRE>" .
        htmlentities($ssp->xml_request,ENT_QUOTES) . "\n<hr>";



   #@ submit_request
   #~ Submits your prepared XML data to the surepay server and
   #~ awaits a response. The response is stored in xml_response,
   #~ as well as being returned.

   ## Syntax
   ##  string: submit_request (
   ##      [ integer: timeout in seconds (default 90)]
   ##      [,integer: SSL version (0|2|3)]
   ##  )

     $ssp->submit_request();

     if ($ssp->err) die($ssp->err); # Die with error description


   # Give some respons output to the test script
     echo "</PRE><h2>The response xml we got back:</H2><PRE>" . 
           htmlentities($ssp->xml_response,ENT_QUOTES) . "\n<hr>";


   #@ parse_response
   #~ Parses received response data and returns a total amount of responses

   ## Syntax:
   ##  int: parse_response ()

     $responsecount = $ssp->parse_response();

     if ($ssp->err) die($ssp->err); # Die with error description

     if (!$responsecount) {
         echo "We got 0 responses? Something must have gone wrong somewhere...\n";
         exit;          # Seems to be no real error?
     }



   #@ auths
   #~ returns an array holding the keys of all responses of type AUTH

   ## Syntax:
   ##  array: auths( )

     $auths = $ssp->auths();

     if ($ssp->err) die($ssp->err); # Die with error description


   # Output our responses and their status to the test script
   # This output is a little messy, but you get the general idea
   # from the auth_status control.
   # It is up to you and your application how to handle the
   # various states, check avs and cvv2 status and so on...

     echo "</PRE><h3>Results:</H3>\n";
     echo "<p>".$responsecount." responses was successfully parsed</p>\n";

     while (list($key,$order)=each($auths)) {
         echo "<p>Response $key - Ordernumber <b>$order</b><br>\n";
         echo "Transaction id: <b>".($ssp->auth_trans_id($order))."</b><BR>\n";
         echo "Authorization status: <b>" . $ssp->auth_status($order) . " </b> --> ";
         if ($ssp->auth_status($order) == 'AUTH') echo 'Successfull authorized';
         elseif ($ssp->auth_status($order) == 'DCL') echo 'Declined';
         elseif ($ssp->auth_status($order) == 'REF') echo 'Refered (NOT authorized!)';
         elseif ($ssp->auth_status($order) == 'ERR') echo 'An error occured while processing';
         else echo 'Unknown or no status type (probably failure)';
         echo "<br>\n";
         echo "Authcode: <b>" . $ssp->auth_authcode($order) . "</b><br>\n";
         echo "cvv2result: <b>" . $ssp->auth_cvv2result($order) . "</b><br>\n";
         echo "avs: <b>" . $ssp->auth_avs($order) . " </b><br>\n";
         echo "failure: <b>" . $ssp->auth_failure($order) . "</b><br>\n";
         echo "error text: <b>" . $ssp->auth_text($order) . "</b></p>\n";
         if ($ssp->err) die($ssp->err); # Die with error description
     }

     # For more information on the various response datam seethe surepay SDK doc (XML section).
     # Especially Security code verification status, cvv2status, and address verification
     # status, avs, may be interresting.
 

   # Do laundry
   unset($ssp);

?>
</body></html>
