<?php 
  /**
   * tReadingList v 0.03 beta
   * Copyright 2001 Stephen G. Walizer aka Technomancer all rights reserved.
   * This software is licensed under the GNU GPL. See the file GPL or
   * http://www.gnu.org for details.
   **/

  require('trl_config.inc');

  $con;

  // current version
  $version = "0.03 beta";

  // tags in list/oldlist template files
  $listloop_open_tag = '<booksloop>';
  $listloop_close_tag = '</booksloop>';
  $day_tag = '<day>';
  $month_tag = '<month>';
  $year_tag = '<year>';
  $author_tag = '<author>';
  $title_tag = '<title>';
  $comment_tag = '<comment>';
  $numeric_rating_tag = '<rating>';
  $graphic_rating_tag = '<ratingimage>';
  $subject_name_tag = '<subject>';
  $subject_icon_tag = '<subjecticon>';

  function listConnect() {
    global $host, $username, $password, $con, $database;
    $con = mysql_connect($host, $username, $password);
    mysql_select_db($database);
  }

  function listClose() {
    global $host, $username, $password, $con;
    mysql_close($con);
  }

  function updateBook($id, $day, $month, $year, $title, $author, $comments, $rating, $old, $sid) {
    global $listtable, $addescape, $max_rating;

    if(($title != "") && ($author != "")) {
      if(($rating >= 1) && ($rating <= $max_rating)) {
        if($addescape == 'Y') {
          $title = addslashes($title);
          $author = addslashes($author);
          $comments = addslashes($comments);
        }
        $date = "$year-$month-$day";
        $query = "UPDATE $listtable SET subject_id=$sid, rdate='$date', title='$title', author='$author', comments='$comments', rating=$rating WHERE id=$id";
        mysql_query($query);
        if($old == 'Y') {
          buildOldList();
        } else {
          buildList();
        }
        $retval = '';
      } else {
        $retval = "Error: Rating must be >= 1 and <= $max_rating";
      }
    } else {
      $retval = "Error: Title and Author must both be specified";
    }
    return $retval;
  }

  function addBook($date, $title, $author, $comment, $rating, $sid) {
    global $listtable, $max_list_items, $max_list_age, $max_rating;

    if(($title != "") && ($author != "")) {
      if(($rating >= 1) && ($rating <= $max_rating)) {
        if($addescape == 'Y') {
          $title = addslashes($title);
	  $author = addslashes($author);
          $comment = addslashes($comment);
        }
        $query = "INSERT INTO $listtable (id, subject_id, rdate, title, author, comments, rating, old, deleted) VALUES (NULL, $sid, '$date', '$title', '$author', '$comment', $rating, 'N', 'N')";
        mysql_query($query);

        $result = mysql_query("SELECT id, rdate FROM $listtable WHERE old='N' AND deleted='N' ORDER BY rdate DESC");
        $list_count = mysql_num_rows($result);
        if(($max_list_items != 0) || ($max_list_age > 0)) {
          if($list_count > $max_list_items) {
            for($i=0; $i<$list_count; $i++) {
              $row = mysql_fetch_row($result);
              $date = $row[1];
              $age = getAge(substr($date,8,2), substr($date,5,2), substr($date,0,4));
              if($max_list_age > 0) {
                if(($i >= $max_list_items) || ($age > $max_list_age)) {
                  mysql_query("UPDATE $listtable SET old='Y' WHERE id=$row[0]");
                }
              } else {
                if($i >= $max_list_items) {
                  mysql_query("UPDATE $listtable SET old='Y' WHERE id=$row[0]");
                }
              }
            }
            buildOldList();
          }
        }    
        mysql_free_result($result);
        buildList();
        $retval = "Book added successfully";
      } else {
        $retval = "Error: Rating must be >= 1 and <= $max_rating";
      }
    } else {
      $retval = "Error: Title and Author must both be specified";
    }
    return $retval;
  }

  function markBooksDeleted($indexes) {
    global $listtable;
    
    $length = sizeof($indexes);
    for($i=0; $i<$length; $i++) {
      $query = "UPDATE $listtable SET deleted='Y' WHERE id=$indexes[$i]";
      mysql_query($query);
    }
    buildList();
    buildOldList();
  }

  function undeleteBooks($indexes) {
    global $listtable;
    
    $length = sizeof($indexes);
    for($i=0; $i<$length; $i++) {
      $query = "UPDATE $listtable SET deleted='N' WHERE id=$indexes[$i]";
      mysql_query($query);
    }
    buildList();
    buildOldList();
  }

  function purgeBooks() {
    global $listtable;

    mysql_query("DELETE FROM $listtable WHERE deleted='Y'");
  }

  function markBooksOld($indexes) {
   global $listtable;
    
    $length = sizeof($indexes);
    for($i=0; $i<$length; $i++) {
      $query = "UPDATE $listtable SET old='Y' WHERE id=$indexes[$i]";
      mysql_query($query);
    }
    buildList();
    buildOldList();
  } 

  function addSubject($name, $icon, $iconwidth, $iconheight) {
    global $subjecttable;

    $query = "INSERT INTO $subjecttable (subject_id, name, icon_name, icon_width, icon_height, deleted) VALUES (NULL, '$name', '$icon', '$iconwidth', '$iconheight', 'N')";
    mysql_query($query);
  }

  function updateSubject($subject_id, $name, $icon, $iconwidth, $iconheight) {
    global $subjecttable;

    $query = "UPDATE $subjecttable SET name='$name', icon_name='$icon', icon_width=$iconwidth, icon_height=$iconheight WHERE subject_id=$subject_id";
    mysql_query($query);
  }

  function deleteSubject($indexes) {
    global $subjecttable;
    
    $length = sizeof($indexes);
    for($i=0; $i<$length; $i++) {
      $query = "UPDATE $subjecttable SET deleted='Y' WHERE subject_id=$indexes[$i]";
      mysql_query($query);
    }
  }

  function undeleteSubject($indexes) {
    global $subjecttable;
    
    $length = sizeof($indexes);
    for($i=0; $i<$length; $i++) {
      $query = "UPDATE $subjecttable SET deleted='N' WHERE subject_id=$indexes[$i]";
      mysql_query($query);
    }
  }

  function purgeSubjects() {
    global $subjecttable, $listtable;

    $query = "SELECT subject_id FROM $subjecttable WHERE deleted='Y'";
    $result = mysql_query($query);
    while($row = mysql_fetch_array($result)) {
      $id = $row['subject_id'];
      $uquery = "UPDATE $listtable SET subject_id=-1 WHERE subject_id=$id";
      mysql_query($uquery);
    }

    mysql_query("DELETE FROM $subjecttable WHERE deleted='Y'");
  }

  function buildList() {
    global $listtable, $subjecttable, $listtemplate, $rating_image;
    global $listloop_open_tag, $listloop_close_tag, $day_tag, $month_tag, $year_tag;
    global $title_tag, $author_tag, $comment_tag, $listfile, $numeric_rating_tag;
    global $graphic_rating_tag, $subject_name_tag, $subject_icon_tag;
   
    // grab the data from the database
    $query = "SELECT * FROM $listtable WHERE old='N' AND deleted='N' ORDER BY rdate DESC";
    $result = mysql_query($query);

    // load the template file
    $fdin = fopen($listtemplate, "r");
    $indata = fread($fdin, filesize($listtemplate));
    fclose($fdin);

    // build the string sections, startdata, loopdata, and enddata
    $strtpos = strpos($indata, $listloop_open_tag);
    $startdata = substr($indata, 0, $strtpos);
    $temp = strstr($indata, $listloop_open_tag);
    $looppos = strpos($temp, $listloop_close_tag);
    $loopdata = substr($temp, strlen($listloop_open_tag), $looppos - strlen($listloop_close_tag));
    $enddata = substr($temp, $looppos + strlen($listloop_close_tag), strlen($temp));

    $listdata .= $startdata;

    $tags = array($day_tag, $month_tag, $year_tag, $title_tag, $author_tag, $comment_tag, $numeric_rating_tag, 
                  $graphic_rating_tag, $subject_name_tag, $subject_icon_tag);

    // replace tags in loopdata for each book
    while($row = mysql_fetch_array($result)) {
      // build data for tags we could need to replace
      $sid = $row['subject_id'];
      if($sid != -1) {
        $squery = "SELECT * FROM $subjecttable WHERE subject_id=$sid";
        $sresult = mysql_query($squery);
        $srow = mysql_fetch_array($sresult);
        $sname = $srow['name'];
        $sicon = $srow['icon_name'];
        $sicon_width = $srow['icon_width'];
        $sicon_height = $srow['icon_height'];
        $subimg = "<img src=\"$iconurl$sicon\" width=\"$sicon_width\" height=\"$sicon_height\" border=\"0\" alt=\"$sname\">";
      } else {
        $sname = '';
        $subimg = '';
      }
      $datestamp = $row['rdate'];
      $rating = $row['rating'];
      if(rating != -1) {
        $ratingimg = '';
        for($i=0; $i < $rating; $i++) {
          $ratingimg = $ratingimg . "<img src=\"$rating_image\" border=\"0\">";
        }
      } else {
        $rating = 'Not Rated';
        $ratingimg = 'Not Rated';
      }
      $data = array(substr($datestamp,8,2), substr($datestamp,5,2), substr($datestamp,0,4),
                    stripslashes($row['title']), stripslashes($row['author']), stripslashes($row['comments']),
                    $rating, $ratingimg, $sname, $subimg);
      $listdata .= formatString($tags, $data, $loopdata);
      $liatdata = createurl($listdata);
    }
    mysql_free_result($result);
    $listdata .= $enddata;
    $fdout = fopen($listfile, "w");
    fwrite($fdout, $listdata);
    fclose($fdout);
  }

  function buildOldList() {
    global $listtable, $subjecttable, $oldlisttemplate, $rating_image;
    global $listloop_open_tag, $listloop_close_tag, $day_tag, $month_tag, $year_tag;
    global $title_tag, $author_tag, $comment_tag, $oldlistfile, $numeric_rating_tag; 
    global $graphic_rating_tag, $subject_name_tag, $subject_icon_tag;
   
    // grab the data from the database
    $query = "SELECT * FROM $listtable WHERE old='Y' AND deleted='N' ORDER BY rdate DESC";
    $result = mysql_query($query);

    // load the template file
    $fdin = fopen($oldlisttemplate, "r");
    $indata = fread($fdin, filesize($oldlisttemplate));
    fclose($fdin);

    // build the string sections, startdata, loopdata, and enddata
    $strtpos = strpos($indata, $listloop_open_tag);
    $startdata = substr($indata, 0, $strtpos);
    $temp = strstr($indata, $listloop_open_tag);
    $looppos = strpos($temp, $listloop_close_tag);
    $loopdata = substr($temp, strlen($listloop_open_tag), $looppos - strlen($listloop_close_tag));
    $enddata = substr($temp, $looppos + strlen($listloop_close_tag), strlen($temp));

    $listdata .= $startdata;

    $tags = array($day_tag, $month_tag, $year_tag, $title_tag, $author_tag, $comment_tag, $numeric_rating_tag, 
                  $graphic_rating_tag, $subject_name_tag, $subject_icon_tag);

    // replace tags in loopdata for each book
    while($row = mysql_fetch_array($result)) {
      // build data for tags we could need to replace
      $sid = $row['subject_id'];
      if($sid != -1) {
        $squery = "SELECT * FROM $subjecttable WHERE subject_id=$sid";
        $sresult = mysql_query($squery);
        $srow = mysql_fetch_array($sresult);
        $sname = $srow['name'];
        $sicon = $srow['icon_name'];
        $sicon_width = $srow['icon_width'];
        $sicon_height = $srow['icon_height'];
        $subimg = "<img src=\"$iconurl$sicon\" width=\"$sicon_width\" height=\"$sicon_height\" border=\"0\" alt=\"$sname\">";
      } else {
        $sname = '';
        $subimg = '';
      }
      $datestamp = $row["rdate"];
      $rating = $row['rating'];
      if(rating != -1) {
        $ratingimg = '';
        for($i=0; $i < $rating; $i++) {
          $ratingimg = $ratingimg . "<img src=\"$rating_image\" border=\"0\">";
        }
      } else {
        $rating = 'Not Rated';
        $ratingimg = 'Not Rated';
      }
      $data = array(substr($datestamp,8,2), substr($datestamp,5,2), substr($datestamp,0,4),
                    stripslashes($row['title']), stripslashes($row['author']), stripslashes($row['comments']),
                    $rating, $ratingimg, $sname, $subimg);
      $listdata .= formatString($tags, $data, $loopdata);
      $listdata = createurl($listdata);
    }
    mysql_free_result($result);	
    $listdata .= $enddata;
    $fdout = fopen($oldlistfile, "w");
    fwrite($fdout, $listdata);
    fclose($fdout);
  }

  function formatString($tags, $data, $string) {
    $size = sizeof($tags);
    $return = $string;
    for($i=0; $i<$size; $i++) {
      $return = str_replace($tags[$i], $data[$i], $return);
    }
    return $return;
  }

  function parsequoted(&$urldata) {
    $urldata = substr($urldata, 1, strlen($urldata));
    $i = strpos($urldata, "\",");
    $ret = substr($urldata, 0, $i);
    $urldata = substr($urldata, $i+2, strlen($urldata));
    return $ret;
  }

  function createurl($text) {
    global $url_start, $url_end;

    $data = $text;
    $ret = "";
    // build the string sections, startdata, loopdata, and enddata
    while ($urlpos = strpos($data, $url_start)) {
      $quoted = 0;
      // before url tag
      $pre = substr($data, 0, $urlpos);
      $ret .= $pre;
      $temp = strstr($data, $url_start);
      $endpos = strpos($temp, $url_end);

      $urldata = substr($temp, strlen($url_start), $endpos - (2 * strlen($url_end)));
      if($urldata[0] == '"') {
        $url = parsequoted($urldata);
        $quoted = 1;
      } else {
        $url = strtok($urldata, ",");
      }
      if($url) {
        if($urldata[0] == '"') {
          $name = parsequoted($urldata);
          $quoted = 2;
        } elseif($quoted) {
          $name = strtok($urldata, ",");
        } else {
          $name = strtok(",");
        }
        if($name) {
          if($urldata[0] == '"') {
            $target = parsequoted($urldata);
          } elseif($quoted == 2) {
            $name = strtok($urldata, ",");
          } else {
            $target = strtok(",");
          }
          if($target) {
            $ret .= "<a href=\"$url\" target=\"$target\">$name</a>";
          } else {
            $ret .= "<a href=\"$url\">$name</a>";
          }
        } else {
	  $ret .= substr($temp, 0, $endpos + strlen($url_end));
        }
      } else {
	$ret .= substr($temp, 0, $endpos + strlen($url_end));
      }
      $data = substr($temp, $endpos + strlen($url_end), strlen($temp));    
    }
    $ret .= $data;
    return $ret;
  }

  function getAge($day, $month, $year) {
    $now = time();
    $then = mktime(0,0,0,$month,$day,$year);
    $seconds = abs($now - $then);
    $age = round($seconds/86400);
    return $age;
  }

  function getHTMLHeader() {
    global $version;

    $hdr = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
    $hdr .= "<!- tReadingList v $version                                                 ->\n";
    $hdr .= "<!- Copyright 2001 Stephen G. Walizer aka Technomancer all rights reserved. ->\n";
    $hdr .= "<!- This software is licensed under the GNU GPL. See the file GPL or        ->\n";
    $hdr .= "<!- http://www.gnu.org for details.                                         ->\n\n";
    return $hdr;
  }

  function getPHPHeader() {
    global $version;

    $hdr = "<?php\n";
    $hdr .= "  /**\n";
    $hdr .= "   * tReadingList v $version\n";
    $hdr .= "   * Copyright 2001 Stephen G. Walizer aka Technomancer all rights reserved.\n";
    $hdr .= "   * This software is licensed under the GNU GPL. See the file GPL or\n";
    $hdr .= "   * http://www.gnu.org for details.\n";
    $hdr .= "   **/\n\n";
    return $hdr;
  }

  function updateConfig($dbhost, $dblogin, $dbpassword1, $dbpassword2, $dbname, $dblisttable, $dbsubjecttable, $maxlist, $maxlistage, $loutput,
      $ltemplate, $oloutput, $oltemplate, $maxrating, $ratingimage, $escape, $siconpath, $siconurl) {
    global $host, $username, $password, $database, $listtable, $max_list_items, $max_list_age;
    global $listfile, $listtemplate, $oldlistfile, $oldlisttemplate, $addescape;

    $pflag = 0;
    if($dbpassword1 != $password) {
      if($dbpassword1 != $dbpassword2) {
        echo "ERROR: Database Password and Database Password Verification must have the same value when changing passwords\n";
        $pflag = 1;
      }
    }

    if($escape == '') {
      $escape = 'N';
    }

    if($pflag == 0) {
      $out = getPHPHeader();
      $out .= "  // MySQL database information\n";
      $out .= "  \$host = '$dbhost';\n";
      $out .= "  \$username = '$dblogin';\n";
      $out .= "  \$password = '$dbpassword1';\n";
      $out .= "  \$database = '$dbname';\n";
      $out .= "  \$listtable = '$dblisttable';\n";
      $out .= "  \$subjecttable = '$dbsubjecttable';\n";
      $out .= "\n";
      $out .= "  // maximum number of reading list items\n"; 
      $out .= "  // items over this count will be marked old\n";
      $out .= "  \$max_list_items = $maxlist;\n";
      $out .= "\n";
      $out .= "  // maximum age in days of reading list items\n"; 
      $out .= "  // items over this age will be marked old\n";
      $out .= "  \$max_list_age = $maxlistage;\n";
      $out .= "\n";
      $out .= "  // output file for reading list\n";
      $out .= "  \$listfile = '$loutput';\n";
      $out .= "\n";
      $out .= "  // reading list template file\n";
      $out .= "  \$listtemplate = '$ltemplate';\n";
      $out .= "\n";
      $out .= "  // output file for old reading list\n";
      $out .= "  \$oldlistfile = '$oloutput';\n";
      $out .= "\n";
      $out .= "  // old reading list template file\n";
      $out .= "  \$oldlisttemplate = '$oltemplate';\n";
      $out .= "\n";
      $out .= "  // fully qualified path of where to put subject icons\n";
      $out .= "  \$iconpath = '$siconpath';\n";
      $out .= "\n";
      $out .= "  // path relative to web server root for icons\n";
      $out .= "  \$iconurl = '$siconurl';\n";
      $out .= "\n";
      $out .= "  // should special characters be escaped with slashes\n";
      $out .= "  \$addescape = '$escape';\n";
      $out .= "\n";
      $out .= "  // maximum rating value, rating will be from 1-value\n";
      $out .= "  \$max_rating = $maxrating;\n";
      $out .= "\n";
      $out .= "  // image for rating tag relative to server root\n";
      $out .= "  \$rating_image = '$ratingimage';\n";
      $out .= "?>\n";
      $cout = fopen("trl_config.inc", "w");
      fwrite($cout, $out);
      fclose($cout);

      echo getHTMLHeader();
      echo "<html>\n";
      echo "<head>\n";
      echo "</head>\n\n";
      echo "<body bgcolor=\"white\">\n";
      echo "<font size=\"+1\">Configuration updated successfully.</font>\n";
      echo "</body>\n";
      echo "</html>\n";
    }     
  }

  function export($filename) {
    global $host, $username, $password, $listtable, $subjecttable;

    $output = getPHPHeader();

    $output .= "  Header(\"Location: trl_blank.html\");\n";
    $output .= "  require('treadinglist.inc');\n";
    $output .= "  listConnect();\n";

    listConnect();

    $query = "SELECT * FROM $subjecttable ORDER BY id";
    $result = mysql_query($query);
    while($row = mysql_fetch_array($result)) {
      $subject_id = $row['subject_id'];
      $name = $row['name'];
      $icon_name = $row['icon_name'];
      $icon_width = $row['icon_width'];
      $icon_height = $row['icon_height'];
      $deleted = $row['deleted'];

      $id = $row['id'];
      $name = addslashes($row['name']);
      $deleted = $row['deleted'];

      $output .= "  mysql_query(\"INSERT INTO \$subjecttable (subject_id, name, icon_name, icon_width, icon_height, deleted) VALUES (NULL, '$name', '$icon_name', '$icon_width', '$icon_height', '$deleted')\");\n";
      $output .= "  \$sresult = mysql_query(\"SELECT subject_id FROM \$subjecttable WHERE name='$name'\");\n";
      $output .= "  \$srow = mysql_fetch_row(\$sresult);\n";
      $output .= "  \$subjids[$subject_id] = \$srow[0];\n";
      $output .= "  mysql_free_result(\$sresult);\n";
    }

    $query = "SELECT * FROM $listtable ORDER BY id";
    $result = mysql_query($query);
    while($row = mysql_fetch_array($result)) {
      $rdate = $row['rdate'];
      $sid = $row['subject_id'];
      $title = addslashes($row['title']);
      $author = addslashes($row['author']);
      $comment = addslashes($row['comments']);
      $rating = $row['rating'];
      $old = $row['old'];
      $deleted = $row['deleted'];
      $output .= "  mysql_query(\"INSERT INTO \$listtable (id, subject_id, rdate, title, author, comments, rating, old, deleted) VALUES (NULL, \$subjids[$sid], $rdate, '$title', '$author', '$comment', $rating, '$old', '$deleted')\");\n";
    }
    $output .= "  buildList();\n";
    $output .= "  buildOldList();\n";
    $output .= "  listClose();\n";
    $output .= "?>\n";
    $fdout = fopen($filename, "w");
    fwrite($fdout, $output);
    fclose($fdout);
  }
?>
